/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.services.security.userrole.ldap;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.pentaho.platform.plugin.services.messages.Messages;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.ldap.core.DirContextOperations;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.ldap.userdetails.LdapAuthoritiesPopulator;
import org.springframework.util.Assert;

public class UnionizingLdapAuthoritiesPopulator
implements LdapAuthoritiesPopulator,
InitializingBean {
    private Set<LdapAuthoritiesPopulator> populators;

    public Collection<? extends GrantedAuthority> getGrantedAuthorities(DirContextOperations userData, String username) {
        HashSet allAuthorities = new HashSet();
        for (LdapAuthoritiesPopulator populator : this.populators) {
            Collection auths = populator.getGrantedAuthorities(userData, username);
            if (null == auths || auths.size() <= 0) continue;
            allAuthorities.addAll(auths);
        }
        return allAuthorities;
    }

    public void setPopulators(Set<LdapAuthoritiesPopulator> populators) {
        this.populators = populators;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull(this.populators, (String)Messages.getInstance().getString("UnionizingLdapAuthoritiesPopulator.ERROR_0001_POPULATOR_NULL"));
    }
}

