/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.services.security.userrole;

import org.pentaho.platform.api.mt.ITenant;
import org.pentaho.platform.api.mt.ITenantedPrincipleNameResolver;
import org.pentaho.platform.plugin.services.security.userrole.NotFoundUserDetails;
import org.pentaho.platform.repository2.unified.jcr.JcrTenantUtils;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UserCache;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.core.userdetails.cache.NullUserCache;

public class PentahoCachingUserDetailsService
implements UserDetailsService {
    private UserCache userCache = new NullUserCache();
    private UserDetailsService delegate;
    private final ITenantedPrincipleNameResolver nameResolver;

    public PentahoCachingUserDetailsService(UserDetailsService delegate, ITenantedPrincipleNameResolver nameResolver) {
        this.delegate = delegate;
        this.nameResolver = nameResolver;
    }

    public UserCache getUserCache() {
        return this.userCache;
    }

    public void setUserCache(UserCache userCache) {
        this.userCache = userCache;
    }

    private String getPrincipleId(String principleName) {
        ITenant tenant = JcrTenantUtils.getCurrentTenant();
        if (tenant == null || tenant.getId() == null) {
            tenant = JcrTenantUtils.getDefaultTenant();
        }
        return this.nameResolver.getPrincipleId(tenant, principleName);
    }

    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException {
        boolean tenanted = JcrTenantUtils.isTenantedUser((String)username);
        String principleName = tenanted ? JcrTenantUtils.getPrincipalName((String)username, (boolean)true) : username;
        UserDetails user = this.userCache.getUserFromCache(principleName);
        if (user == null) {
            String principleId = tenanted ? username : this.getPrincipleId(username);
            try {
                user = this.delegate.loadUserByUsername(principleId);
            }
            catch (UsernameNotFoundException e) {
                user = new NotFoundUserDetails(principleName, e);
            }
            if (user == null) {
                user = new NotFoundUserDetails(principleName, new UsernameNotFoundException("UserDetailsService " + this.delegate + " returned null for username " + username + ". This is an interface contract violation"));
            }
            this.userCache.putUserInCache(user);
        }
        if (user instanceof NotFoundUserDetails) {
            UsernameNotFoundException e = ((NotFoundUserDetails)user).getOriginalException();
            throw new UsernameNotFoundException(e.getMessage(), (Throwable)e);
        }
        return new User(user.getUsername(), user.getPassword() == null ? "ignored" : user.getPassword(), user.isEnabled(), user.isAccountNonExpired(), user.isCredentialsNonExpired(), user.isAccountNonLocked(), user.getAuthorities());
    }
}

