/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.services.metadata;

import java.io.Serializable;
import org.pentaho.platform.api.mt.ITenant;
import org.pentaho.platform.api.mt.ITenantedPrincipleNameResolver;
import org.pentaho.platform.api.repository2.unified.RepositoryFile;
import org.pentaho.platform.api.repository2.unified.RepositoryFileAcl;
import org.pentaho.platform.api.repository2.unified.RepositoryFileSid;
import org.pentaho.platform.plugin.services.messages.Messages;
import org.pentaho.platform.repository2.unified.IRepositoryFileAclDao;
import org.pentaho.platform.repository2.unified.IRepositoryFileDao;
import org.pentaho.platform.repository2.unified.ServerRepositoryPaths;
import org.pentaho.platform.repository2.unified.jcr.IPathConversionHelper;
import org.pentaho.platform.repository2.unified.jcr.JcrTenantUtils;
import org.pentaho.platform.repository2.unified.lifecycle.AbstractBackingRepositoryLifecycleManager;
import org.springframework.extensions.jcr.JcrTemplate;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.util.Assert;

public class PentahoMetadataRepositoryLifecycleManager
extends AbstractBackingRepositoryLifecycleManager {
    private static final String FOLDER_METADATA = "metadata";
    private ITenantedPrincipleNameResolver userNameUtils;
    protected String repositoryAdminUsername;
    protected String tenantAuthenticatedAuthorityNamePattern;
    protected String singleTenantAuthenticatedAuthorityName;
    protected IRepositoryFileDao repositoryFileDao;
    protected IRepositoryFileAclDao repositoryFileAclDao;

    public PentahoMetadataRepositoryLifecycleManager(IRepositoryFileDao contentDao, IRepositoryFileAclDao repositoryFileAclDao, TransactionTemplate txnTemplate, String repositoryAdminUsername, String tenantAuthenticatedAuthorityNamePattern, ITenantedPrincipleNameResolver userNameUtils, JcrTemplate adminJcrTemplate, IPathConversionHelper pathConversionHelper) {
        super(txnTemplate, adminJcrTemplate, pathConversionHelper);
        Assert.notNull((Object)contentDao);
        Assert.notNull((Object)repositoryFileAclDao);
        Assert.hasText((String)repositoryAdminUsername);
        Assert.hasText((String)tenantAuthenticatedAuthorityNamePattern);
        this.repositoryFileDao = contentDao;
        this.repositoryFileAclDao = repositoryFileAclDao;
        this.repositoryAdminUsername = repositoryAdminUsername;
        this.userNameUtils = userNameUtils;
        this.tenantAuthenticatedAuthorityNamePattern = tenantAuthenticatedAuthorityNamePattern;
    }

    public synchronized void doNewTenant(String tenantPath) {
    }

    public void startup() {
        this.createEtcMetadaFolder(JcrTenantUtils.getDefaultTenant());
    }

    public void shutdown() {
    }

    public void newTenant(ITenant tenant) {
        if (!tenant.equals(JcrTenantUtils.getDefaultTenant())) {
            this.createEtcMetadaFolder(tenant);
        }
    }

    public void newTenant() {
        this.newTenant(JcrTenantUtils.getTenant());
    }

    public void newUser(ITenant tenant, String username) {
    }

    public void newUser() {
    }

    protected void createEtcMetadaFolder(final ITenant tenant) {
        try {
            this.txnTemplate.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

                public void doInTransactionWithoutResult(TransactionStatus status) {
                    RepositoryFileSid repositoryAdminUserSid = new RepositoryFileSid(PentahoMetadataRepositoryLifecycleManager.this.userNameUtils.getPrincipleId(tenant, PentahoMetadataRepositoryLifecycleManager.this.repositoryAdminUsername));
                    RepositoryFile tenantEtcFolder = PentahoMetadataRepositoryLifecycleManager.this.repositoryFileDao.getFileByAbsolutePath(ServerRepositoryPaths.getTenantEtcFolderPath((ITenant)tenant));
                    Assert.notNull((Object)tenantEtcFolder);
                    if (PentahoMetadataRepositoryLifecycleManager.this.repositoryFileDao.getFileByAbsolutePath(ServerRepositoryPaths.getTenantEtcFolderPath((ITenant)tenant) + "/" + PentahoMetadataRepositoryLifecycleManager.FOLDER_METADATA) == null) {
                        PentahoMetadataRepositoryLifecycleManager.this.internalCreateFolder(tenantEtcFolder.getId(), new RepositoryFile.Builder(PentahoMetadataRepositoryLifecycleManager.FOLDER_METADATA).folder(true).build(), true, repositoryAdminUserSid, Messages.getInstance().getString("PentahoMetadataRepositoryLifecycleManager.USER_0001_VER_COMMENT_METADATA"));
                    }
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected RepositoryFile internalCreateFolder(Serializable parentFolderId, RepositoryFile file, boolean inheritAces, RepositoryFileSid ownerSid, String versionMessage) {
        Assert.notNull((Object)file);
        return this.repositoryFileDao.createFolder(parentFolderId, file, this.makeAcl(inheritAces, ownerSid), versionMessage);
    }

    protected RepositoryFileAcl makeAcl(boolean inheritAces, RepositoryFileSid ownerSid) {
        return new RepositoryFileAcl.Builder(ownerSid).entriesInheriting(inheritAces).build();
    }
}

