/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.services.importexport;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.pentaho.platform.api.repository2.unified.RepositoryFile;
import org.pentaho.platform.api.repository2.unified.RepositoryFileAcl;
import org.pentaho.platform.plugin.services.importexport.ImportSource;

public class RepositoryFileBundle
implements ImportSource.IRepositoryFileBundle,
Serializable {
    private static final long serialVersionUID = 4714531660593425523L;
    private RepositoryFileAcl acl;
    private RepositoryFile file;
    private File tmpFile;
    private String path;
    private String charset;
    private String mimeType;

    public RepositoryFileBundle(RepositoryFile file, RepositoryFileAcl acl, String path, File tmpFile, String charset, String mimeType) {
        this.file = file;
        this.acl = acl;
        this.path = path;
        this.tmpFile = tmpFile;
        this.charset = charset;
        this.mimeType = mimeType;
    }

    @Override
    public RepositoryFileAcl getAcl() {
        return this.acl;
    }

    @Override
    public RepositoryFile getFile() {
        return this.file;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return new BufferedInputStream(FileUtils.openInputStream((File)this.tmpFile));
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public void setPath(String path) {
        this.path = path;
    }

    @Override
    public String getCharset() {
        return this.charset;
    }

    @Override
    public String getMimeType() {
        return this.mimeType;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof RepositoryFileBundle)) {
            return false;
        }
        RepositoryFileBundle repoObj = (RepositoryFileBundle)obj;
        if (!repoObj.getPath().equals(this.path)) {
            return false;
        }
        return repoObj.getFile().getName().equals(this.file.getName());
    }

    public int hashCode() {
        return new HashCodeBuilder(47, 53).append((Object)this.path).append((Object)this.file.getName()).toHashCode();
    }
}

