/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.action.jfreechart;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.entity.StandardEntityCollection;
import org.jfree.chart.imagemap.ImageMapUtilities;
import org.jfree.chart.imagemap.StandardToolTipTagFragmentGenerator;
import org.jfree.chart.imagemap.ToolTipTagFragmentGenerator;
import org.jfree.chart.imagemap.URLTagFragmentGenerator;
import org.jfree.data.general.Dataset;
import org.pentaho.commons.connection.IPentahoResultSet;
import org.pentaho.platform.api.engine.IActionSequenceResource;
import org.pentaho.platform.api.engine.IApplicationContext;
import org.pentaho.platform.api.engine.ILogger;
import org.pentaho.platform.api.engine.IPentahoRequestContext;
import org.pentaho.platform.api.repository.IContentItem;
import org.pentaho.platform.api.util.XmlParseException;
import org.pentaho.platform.engine.core.system.PentahoRequestContextHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.services.solution.ComponentBase;
import org.pentaho.platform.engine.services.solution.PentahoEntityResolver;
import org.pentaho.platform.plugin.action.messages.Messages;
import org.pentaho.platform.uifoundation.chart.BarLineChartDefinition;
import org.pentaho.platform.uifoundation.chart.CategoryDatasetChartDefinition;
import org.pentaho.platform.uifoundation.chart.DialWidgetDefinition;
import org.pentaho.platform.uifoundation.chart.JFreeChartEngine;
import org.pentaho.platform.uifoundation.chart.PentahoChartURLTagFragmentGenerator;
import org.pentaho.platform.uifoundation.chart.PieDatasetChartDefinition;
import org.pentaho.platform.uifoundation.chart.TimeSeriesCollectionChartDefinition;
import org.pentaho.platform.uifoundation.chart.TimeTableXYDatasetChartDefinition;
import org.pentaho.platform.uifoundation.chart.XYSeriesCollectionChartDefinition;
import org.pentaho.platform.uifoundation.chart.XYZSeriesCollectionChartDefinition;
import org.pentaho.platform.util.xml.dom4j.XmlDom4JHelper;
import org.xml.sax.EntityResolver;

public class ChartComponent
extends ComponentBase {
    private static final long serialVersionUID = 9050456842938084174L;
    private static final String CHART_NAME_PROP = "chart-name";
    private static final String CHART_OUTPUT = "chart-object";
    private static final String CHART_TYPE = "CHART-OBJECT";
    private static final String CHART_DATA_PROP = "chart-data";
    private static final String CHART_ATTRIBUTES_PROP = "chart-attributes";
    private static final String ALTERNATIVE_CHART_ATTRIBUTES_PROP = "chart";
    private static final String BY_ROW_PROP = "by-row";
    private static final String URL_TEMPLATE = "url-template";
    private static final String PARAMETER_NAME = "paramName";
    private static final String OUTER_PARAMETER_NAME = "series-name";
    private static final String OUTPUT_TYPE_PROP = "output-type";
    private static final String CHART_FILE_NAME_OUTPUT = "chart-filename";
    private static final String HTML_MAPPING_OUTPUT = "chart-mapping";
    private static final String HTML_MAPPING_HTML = "chart-map-html";
    private static final String BASE_URL_OUTPUT = "base-url";
    private static final String CONTEXT_PATH_OUTPUT = "context-path";
    private static final String FULLY_QUALIFIED_SERVER_URL_OUTPUT = "fully-qualified-server-url";
    private static final String HTML_IMG_TAG = "image-tag";
    private static final String SVG_TYPE = "SVG";
    private static final String PNG_BYTES_TYPE = "png-bytes";
    private static final String TEMP_DIRECTORY = "system/tmp/";
    private static final String FILENAME_PREFIX = "tmp_chart_";
    private static final String USE_BASE_URL_TAG = "use-base-url";
    private static final String URL_TARGET_TAG = "url-target";
    private static final String PNG_EXTENSION = ".png";
    private static final String SVG_EXTENSION = ".svg";
    private static final String MAP_EXTENSION = ".map";
    private static final String KEEP_TEMP_FILE_PROP = "keep_temp_file";
    private static final int FILE_NAME = 0;
    private static final int MAP_NAME = 1;
    public static final String FOREGROUND_ALPHA = "foreground-alpha";
    public static final String BACKGROUND_ALPHA = "background-alpha";

    public Log getLogger() {
        return LogFactory.getLog(ChartComponent.class);
    }

    protected boolean validateSystemSettings() {
        return true;
    }

    protected boolean validateAction() {
        if (!this.isDefinedInput(CHART_DATA_PROP)) {
            this.inputMissingError(CHART_DATA_PROP);
            return false;
        }
        if (!this.isDefinedInput(CHART_ATTRIBUTES_PROP) && !this.isDefinedResource(CHART_ATTRIBUTES_PROP)) {
            this.inputMissingError(CHART_ATTRIBUTES_PROP);
            return false;
        }
        return true;
    }

    public void done() {
    }

    protected boolean executeAction() {
        List subtitles;
        String titleStr;
        Node titleNode;
        Object titleObj;
        Object heightObj;
        String outerParameterName;
        String parameterName;
        int height = -1;
        int width = -1;
        String title = "";
        Document chartDocument = null;
        IPentahoResultSet data = (IPentahoResultSet)this.getInputValue(CHART_DATA_PROP);
        if (!data.isScrollable()) {
            this.getLogger().debug((Object)"ResultSet is not scrollable. Copying into memory");
            IPentahoResultSet memSet = data.memoryCopy();
            data.close();
            data = memSet;
        }
        String urlTemplate = (String)this.getInputValue(URL_TEMPLATE);
        Node chartAttributes = null;
        String chartAttributeString = null;
        if (this.getInputNames().contains(CHART_ATTRIBUTES_PROP)) {
            chartAttributeString = this.getInputStringValue(CHART_ATTRIBUTES_PROP);
        } else if (this.isDefinedResource(CHART_ATTRIBUTES_PROP)) {
            IActionSequenceResource resource = this.getResource(CHART_ATTRIBUTES_PROP);
            chartAttributeString = this.getResourceAsString(resource);
        }
        if (chartAttributeString != null) {
            try {
                chartDocument = XmlDom4JHelper.getDocFromString((String)chartAttributeString, (EntityResolver)new PentahoEntityResolver());
            }
            catch (XmlParseException e) {
                this.getLogger().error((Object)Messages.getInstance().getString("ChartComponent.ERROR_0005_CANT_DOCUMENT_FROM_STRING"), (Throwable)e);
                return false;
            }
            chartAttributes = chartDocument.selectSingleNode(CHART_ATTRIBUTES_PROP);
            if (chartAttributes == null) {
                chartAttributes = chartDocument.selectSingleNode(ALTERNATIVE_CHART_ATTRIBUTES_PROP);
            }
        }
        if (chartAttributes == null) {
            chartAttributes = this.getComponentDefinition(true).selectSingleNode(CHART_ATTRIBUTES_PROP);
        }
        if ((urlTemplate == null || urlTemplate.length() == 0) && chartAttributes.selectSingleNode(URL_TEMPLATE) != null) {
            urlTemplate = chartAttributes.selectSingleNode(URL_TEMPLATE).getText();
        }
        if (((parameterName = (String)this.getInputValue(PARAMETER_NAME)) == null || parameterName.length() == 0) && chartAttributes.selectSingleNode(PARAMETER_NAME) != null) {
            parameterName = chartAttributes.selectSingleNode(PARAMETER_NAME).getText();
        }
        if (((outerParameterName = (String)this.getInputValue(OUTER_PARAMETER_NAME)) == null || outerParameterName.length() == 0) && chartAttributes.selectSingleNode(OUTER_PARAMETER_NAME) != null) {
            outerParameterName = chartAttributes.selectSingleNode(OUTER_PARAMETER_NAME).getText();
        }
        String chartType = chartAttributes.selectSingleNode("chart-type").getText();
        Object widthObj = this.getInputValue("width");
        if (widthObj != null && (width = Integer.parseInt(widthObj.toString())) != -1) {
            if (chartAttributes.selectSingleNode("width") == null) {
                ((Element)chartAttributes).addElement("width");
            }
            chartAttributes.selectSingleNode("width").setText(Integer.toString(width));
        }
        if ((heightObj = this.getInputValue("height")) != null && (height = Integer.parseInt(heightObj.toString())) != -1) {
            if (chartAttributes.selectSingleNode("height") == null) {
                ((Element)chartAttributes).addElement("height");
            }
            chartAttributes.selectSingleNode("height").setText(Integer.toString(height));
        }
        if ((titleObj = this.getInputValue("title")) != null) {
            if (chartAttributes.selectSingleNode("title") == null) {
                ((Element)chartAttributes).addElement("title");
            }
            chartAttributes.selectSingleNode("title").setText(titleObj.toString());
        }
        if ((titleNode = chartAttributes.selectSingleNode("title")) != null && (titleStr = titleNode.getText()) != null) {
            title = titleStr;
            String newTitle = this.applyInputsToFormat(titleStr);
            titleNode.setText(newTitle);
        }
        if ((subtitles = chartAttributes.selectNodes("subtitle")) == null || subtitles.isEmpty()) {
            Node subTitlesNode = chartAttributes.selectSingleNode("subtitles");
            if (subTitlesNode != null) {
                subtitles = chartAttributes.selectNodes("subtitle");
            }
        } else {
            this.getLogger().warn((Object)Messages.getInstance().getString("CHART.WARN_DEPRECATED_CHILD", new Object[]{"subtitle", "subtitles"}));
            this.getLogger().warn((Object)Messages.getInstance().getString("CHART.WARN_PROPERTY_WILL_NOT_VALIDATE", new Object[]{"subtitle"}));
        }
        if (subtitles != null) {
            for (Node subtitleNode : subtitles) {
                String subtitleStr;
                if (subtitleNode == null || (subtitleStr = subtitleNode.getText()) == null) continue;
                String newSubtitle = this.applyInputsToFormat(subtitleStr);
                subtitleNode.setText(newSubtitle);
            }
        }
        boolean byRow = false;
        if (this.getInputStringValue(BY_ROW_PROP) != null) {
            byRow = Boolean.valueOf(this.getInputStringValue(BY_ROW_PROP));
        }
        if (height == -1) {
            height = (int)this.getInputLongValue("chart-attributes/height", 50L);
        }
        if (width == -1) {
            width = (int)this.getInputLongValue("chart-attributes/width", 100L);
        }
        if (title.length() <= 0) {
            title = this.getInputStringValue("chart-attributes/title");
        }
        String datasetType = "CategoryDataset";
        boolean isStacked = false;
        Node datasetTypeNode = chartAttributes.selectSingleNode("dataset-type");
        if (datasetTypeNode != null) {
            datasetType = datasetTypeNode.getText();
        }
        Object dataDefinition = null;
        if ("XYSeriesCollection".equalsIgnoreCase(datasetType)) {
            dataDefinition = new XYSeriesCollectionChartDefinition(data, byRow, chartAttributes, this.getSession());
        } else if ("TimeSeriesCollection".equalsIgnoreCase(datasetType)) {
            Node stackedNode = chartAttributes.selectSingleNode("is-stacked");
            if (stackedNode != null) {
                isStacked = Boolean.valueOf(stackedNode.getText());
            }
            dataDefinition = isStacked && "AreaChart".equalsIgnoreCase(chartType) ? new TimeTableXYDatasetChartDefinition(data, byRow, chartAttributes, this.getSession()) : new TimeSeriesCollectionChartDefinition(data, byRow, chartAttributes, this.getSession());
        } else {
            dataDefinition = "PieChart".equalsIgnoreCase(chartType) ? new PieDatasetChartDefinition(data, byRow, chartAttributes, this.getSession()) : ("DialChart".equalsIgnoreCase(chartType) ? new DialWidgetDefinition(data, byRow, chartAttributes, width, height, this.getSession()) : ("BarLineChart".equalsIgnoreCase(chartType) ? new BarLineChartDefinition(data, byRow, chartAttributes, this.getSession()) : ("BubbleChart".equalsIgnoreCase(chartType) ? new XYZSeriesCollectionChartDefinition(data, byRow, chartAttributes, this.getSession()) : new CategoryDatasetChartDefinition(data, byRow, chartAttributes, this.getSession()))));
        }
        int outputType = 1;
        if (this.getInputStringValue(OUTPUT_TYPE_PROP) != null) {
            if (SVG_TYPE.equalsIgnoreCase(this.getInputStringValue(OUTPUT_TYPE_PROP))) {
                outputType = 2;
            } else if (CHART_TYPE.equalsIgnoreCase(this.getInputStringValue(OUTPUT_TYPE_PROP))) {
                outputType = 3;
            } else if (PNG_BYTES_TYPE.equalsIgnoreCase(this.getInputStringValue(OUTPUT_TYPE_PROP))) {
                outputType = 4;
            }
        }
        boolean keepTempFile = false;
        if (this.isDefinedInput(KEEP_TEMP_FILE_PROP)) {
            keepTempFile = this.getInputBooleanValue(KEEP_TEMP_FILE_PROP, false);
        }
        JFreeChart chart = null;
        switch (outputType) {
            case 4: {
                chart = JFreeChartEngine.getChart((Dataset)dataDefinition, (String)title, (String)"", (int)width, (int)height, (ILogger)this);
                String mimeType = "image/png";
                IContentItem contentItem = this.getOutputItem("chartdata", mimeType, PNG_EXTENSION);
                contentItem.setMimeType(mimeType);
                try {
                    OutputStream output = contentItem.getOutputStream(this.getActionName());
                    ChartUtilities.writeChartAsPNG((OutputStream)output, (JFreeChart)chart, (int)width, (int)height);
                    break;
                }
                catch (Exception e) {
                    this.error(Messages.getInstance().getErrorString("ChartComponent.ERROR_0004_CANT_CREATE_IMAGE"), e);
                    return false;
                }
            }
            case 1: 
            case 2: {
                Set outputs;
                boolean createMapFile = !this.isDefinedOutput(HTML_MAPPING_HTML);
                boolean hasTemplate = urlTemplate != null && urlTemplate.length() > 0;
                File[] fileResults = this.createTempFile(outputType, hasTemplate, !keepTempFile);
                if (fileResults == null) {
                    this.error(Messages.getInstance().getErrorString("ChartComponent.ERROR_0003_CANT_CREATE_TEMP_FILES"));
                    return false;
                }
                String chartId = fileResults[0].getName().substring(0, fileResults[0].getName().indexOf(46));
                String filePathWithoutExtension = TEMP_DIRECTORY + chartId;
                PrintWriter printWriter = new PrintWriter(new StringWriter());
                ChartRenderingInfo info = new ChartRenderingInfo((EntityCollection)new StandardEntityCollection());
                JFreeChartEngine.saveChart((Dataset)dataDefinition, (String)title, (String)"", (String)filePathWithoutExtension, (int)width, (int)height, (int)outputType, (PrintWriter)printWriter, (ChartRenderingInfo)info, (ILogger)this);
                boolean useBaseUrl = true;
                String urlTarget = "pentaho_popup";
                if (chartAttributes.selectSingleNode(USE_BASE_URL_TAG) != null) {
                    Boolean booleanValue = new Boolean(chartAttributes.selectSingleNode(USE_BASE_URL_TAG).getText());
                    useBaseUrl = booleanValue;
                }
                if (chartAttributes.selectSingleNode(URL_TARGET_TAG) != null) {
                    urlTarget = chartAttributes.selectSingleNode(URL_TARGET_TAG).getText();
                }
                String mapString = null;
                if (hasTemplate) {
                    try {
                        String mapId = fileResults[1].getName().substring(0, fileResults[1].getName().indexOf(46));
                        mapString = ImageMapUtilities.getImageMap((String)mapId, (ChartRenderingInfo)info, (ToolTipTagFragmentGenerator)new StandardToolTipTagFragmentGenerator(), (URLTagFragmentGenerator)new PentahoChartURLTagFragmentGenerator(urlTemplate, urlTarget, useBaseUrl, (Dataset)dataDefinition, parameterName, outerParameterName));
                        if (createMapFile) {
                            BufferedWriter out = new BufferedWriter(new FileWriter(fileResults[1]));
                            out.write(mapString);
                            out.flush();
                            out.close();
                        }
                    }
                    catch (IOException e) {
                        this.error(Messages.getInstance().getErrorString("ChartComponent.ERROR_0001_CANT_WRITE_MAP", new Object[]{fileResults[1].getPath()}));
                        return false;
                    }
                    catch (Exception e) {
                        this.error(e.getLocalizedMessage(), e);
                        return false;
                    }
                }
                if ((outputs = this.getOutputNames()) == null || outputs.size() <= 0) break;
                for (String outputName : outputs) {
                    IPentahoRequestContext requestContext;
                    String outputValue = null;
                    if (outputName.equals(CHART_FILE_NAME_OUTPUT)) {
                        outputValue = fileResults[0].getName();
                    } else if (outputName.equals(HTML_MAPPING_OUTPUT)) {
                        if (hasTemplate) {
                            outputValue = fileResults[1].getName();
                        }
                    } else if (outputName.equals(HTML_MAPPING_HTML)) {
                        outputValue = mapString;
                    } else if (outputName.equals(BASE_URL_OUTPUT)) {
                        requestContext = PentahoRequestContextHolder.getRequestContext();
                        outputValue = requestContext.getContextPath();
                    } else if (outputName.equals(CONTEXT_PATH_OUTPUT)) {
                        requestContext = PentahoRequestContextHolder.getRequestContext();
                        outputValue = requestContext.getContextPath();
                    } else if (outputName.equals(FULLY_QUALIFIED_SERVER_URL_OUTPUT)) {
                        IApplicationContext applicationContext = PentahoSystem.getApplicationContext();
                        if (applicationContext != null) {
                            outputValue = applicationContext.getFullyQualifiedServerURL();
                        } else {
                            IPentahoRequestContext requestContext2 = PentahoRequestContextHolder.getRequestContext();
                            outputValue = requestContext2.getContextPath();
                        }
                    } else if (outputName.equals(HTML_IMG_TAG)) {
                        outputValue = hasTemplate ? mapString : "";
                        outputValue = outputValue + "<img border=\"0\" ";
                        outputValue = outputValue + "width=\"" + width + "\" ";
                        outputValue = outputValue + "height=\"" + height + "\" ";
                        if (hasTemplate) {
                            outputValue = outputValue + "usemap=\"#" + fileResults[1].getName().substring(0, fileResults[1].getName().indexOf(46)) + "\" ";
                        }
                        requestContext = PentahoRequestContextHolder.getRequestContext();
                        String contextPath = requestContext.getContextPath();
                        outputValue = outputValue + "src=\"" + contextPath + "getImage?image=" + fileResults[0].getName() + "\"/>";
                    }
                    if (outputValue == null) continue;
                    this.setOutputValue(outputName, outputValue);
                }
                break;
            }
            default: {
                String chartName = CHART_OUTPUT;
                if (this.isDefinedInput(CHART_NAME_PROP)) {
                    chartName = this.getInputStringValue(CHART_NAME_PROP);
                }
                chart = JFreeChartEngine.getChart((Dataset)dataDefinition, (String)title, (String)"", (int)width, (int)height, (ILogger)this);
                this.setOutputValue(chartName, chart);
            }
        }
        return true;
    }

    public boolean init() {
        return true;
    }

    protected File[] createTempFile(int outputType, boolean includeMapFile, boolean trackFile) {
        File[] results = includeMapFile ? new File[2] : new File[1];
        String extension = outputType == 2 ? SVG_EXTENSION : PNG_EXTENSION;
        try {
            File file;
            results[0] = file = PentahoSystem.getApplicationContext().createTempFile(this.getSession(), FILENAME_PREFIX, extension, trackFile);
            if (includeMapFile) {
                results[1] = file = PentahoSystem.getApplicationContext().createTempFile(this.getSession(), FILENAME_PREFIX, MAP_EXTENSION, trackFile);
            }
        }
        catch (IOException e) {
            return null;
        }
        return results;
    }
}

