/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.action.datatransforms;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.actionsequence.dom.ActionInputConstant;
import org.pentaho.actionsequence.dom.IActionOutput;
import org.pentaho.actionsequence.dom.actions.ResultSetCompareAction;
import org.pentaho.commons.connection.IPentahoResultSet;
import org.pentaho.platform.engine.services.solution.ComponentBase;
import org.pentaho.platform.plugin.action.messages.Messages;

public class ResultSetCompareComponent
extends ComponentBase {
    private static final long serialVersionUID = -1449352563247459588L;
    private static final String COMPARE_RESULT_OK = "No Mismatches";

    protected boolean validateAction() {
        boolean actionValidated = true;
        ResultSetCompareAction compareAction = null;
        if (this.getActionDefinition() instanceof ResultSetCompareAction) {
            compareAction = (ResultSetCompareAction)this.getActionDefinition();
            if (compareAction.getResultSet1() == ActionInputConstant.NULL_INPUT) {
                actionValidated = false;
                this.error(Messages.getInstance().getErrorString("ResultSetCompareComponent.ERROR_0001_INPUT_RS1_UNDEFINED"));
            }
            if (actionValidated && compareAction.getResultSet2() == ActionInputConstant.NULL_INPUT) {
                actionValidated = false;
                this.error(Messages.getInstance().getErrorString("ResultSetCompareComponent.ERROR_0002_INPUT_RS2_UNDEFINED"));
            }
            if (actionValidated && compareAction.getCompareColumnNum() == ActionInputConstant.NULL_INPUT) {
                actionValidated = false;
                this.error(Messages.getInstance().getErrorString("ResultSetCompareComponent.ERROR_0003_COLUMN_UNDEFINED"));
            }
        } else {
            actionValidated = false;
            this.error(Messages.getInstance().getErrorString("ComponentBase.ERROR_0001_UNKNOWN_ACTION_TYPE", new Object[]{this.getActionDefinition().getElement().asXML()}));
        }
        return actionValidated;
    }

    protected boolean validateSystemSettings() {
        return true;
    }

    public void done() {
    }

    protected boolean executeAction() throws Throwable {
        ResultSetCompareAction compareAction = (ResultSetCompareAction)this.getActionDefinition();
        Object obj1 = compareAction.getResultSet1().getValue();
        if (!(obj1 instanceof IPentahoResultSet)) {
            this.error(Messages.getInstance().getErrorString("ResultSetCompareComponent.ERROR_0004_INPUT_RS1_NOT_RS"));
            return false;
        }
        Object obj2 = compareAction.getResultSet2().getValue();
        if (!(obj2 instanceof IPentahoResultSet)) {
            this.error(Messages.getInstance().getErrorString("ResultSetCompareComponent.ERROR_0005_INPUT_RS2_NOT_RS"));
            return false;
        }
        IPentahoResultSet rs1 = (IPentahoResultSet)compareAction.getResultSet1().getValue();
        IPentahoResultSet rs2 = (IPentahoResultSet)compareAction.getResultSet2().getValue();
        String tempOutputMismatches = compareAction.getOutputMismatches().getStringValue();
        boolean outputMismatches = false;
        if (tempOutputMismatches != null && tempOutputMismatches.trim().toLowerCase().equals("true")) {
            outputMismatches = true;
        }
        boolean stopOnError = false;
        String tempStopOnError = compareAction.getStopOnError().getStringValue();
        if (tempStopOnError != null && tempStopOnError.trim().toLowerCase().equals("true")) {
            stopOnError = true;
        }
        int compareCol = Integer.parseInt(compareAction.getCompareColumnNum().getStringValue());
        return this.compareEquals(rs1, rs2, compareCol, outputMismatches, stopOnError);
    }

    private boolean compareEquals(IPentahoResultSet rs1, IPentahoResultSet rs2, int compareCol, boolean outputMismatches, boolean stopOnError) {
        int sourceRowCount = rs1.getRowCount();
        int sourceColCount = rs1.getColumnCount();
        int compRowCount = rs2.getRowCount();
        int compColCount = rs2.getColumnCount();
        StringBuffer outputBuf = new StringBuffer();
        if (!outputMismatches) {
            if (sourceRowCount != compRowCount) {
                this.error(Messages.getInstance().getErrorString("ResultSetCompareComponent.ERROR_0006_RESULTSETS_ROWCOUNT_WRONG"));
                return false;
            }
            if (sourceColCount != compColCount) {
                this.error(Messages.getInstance().getErrorString("ResultSetCompareComponent.ERROR_0007_RESULTSETS_COLUMNCOUNT_WRONG"));
                return false;
            }
        }
        if (compareCol > sourceColCount) {
            this.error(Messages.getInstance().getErrorString("ResultSetCompareComponent.ERROR_0008_COLUMN_NOT_FOUND") + compareCol);
            return false;
        }
        if (compareCol > compColCount) {
            this.error(Messages.getInstance().getErrorString("ResultSetCompareComponent.ERROR_0009_COMPARISON_COLUMN_NOT_FOUND") + compareCol);
            return false;
        }
        boolean anyMismatches = false;
        Object srcValue = null;
        Object compValue = null;
        ResultSetCompareAction compareAction = (ResultSetCompareAction)this.getActionDefinition();
        IActionOutput output = compareAction.getOutputCompareResult();
        for (int sourceRows = 0; sourceRows < sourceRowCount; ++sourceRows) {
            boolean foundIt = false;
            srcValue = rs1.getValueAt(sourceRows, compareCol);
            for (int compRows = 0; compRows < compRowCount; ++compRows) {
                compValue = rs2.getValueAt(compRows, compareCol);
                if (!compValue.equals(srcValue)) continue;
                foundIt = true;
                break;
            }
            if (foundIt) continue;
            if (outputBuf.length() > 0) {
                outputBuf.append(",").append(srcValue.toString().trim());
            } else {
                outputBuf.append(srcValue.toString().trim());
            }
            if (output != null) {
                output.setValue((Object)outputBuf.toString());
            }
            if (outputMismatches) {
                this.error(Messages.getInstance().getErrorString("ResultSetCompareComponent.ERROR_0010_MISMATCH_OUTPUT", new Object[]{srcValue.toString()}));
                anyMismatches = true;
                continue;
            }
            if (!stopOnError) continue;
            return false;
        }
        if (!anyMismatches && output != null) {
            output.setValue((Object)COMPARE_RESULT_OK);
        }
        return stopOnError ? !anyMismatches : true;
    }

    public boolean init() {
        return true;
    }

    public Log getLogger() {
        return LogFactory.getLog(ResultSetCompareComponent.class);
    }
}

