/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.action;

import java.io.Serializable;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.action.IAction;
import org.pentaho.platform.api.action.IActionInvokeStatus;
import org.pentaho.platform.api.scheduler2.IBackgroundExecutionStreamProvider;
import org.pentaho.platform.plugin.action.messages.Messages;
import org.pentaho.platform.scheduler2.action.DefaultActionInvoker;
import org.pentaho.platform.util.ActionUtil;
import org.pentaho.platform.web.http.api.resources.RepositoryFileStreamProvider;

public class LocalActionInvoker
extends DefaultActionInvoker {
    private static final Log logger = LogFactory.getLog(LocalActionInvoker.class);

    protected IBackgroundExecutionStreamProvider getStreamProvider(Map<String, Serializable> params) {
        if (params == null) {
            logger.warn((Object)Messages.getInstance().getMapNullCantReturnSp());
            return null;
        }
        IBackgroundExecutionStreamProvider streamProvider = null;
        Serializable objsp = params.get("streamProvider");
        if (objsp != null && IBackgroundExecutionStreamProvider.class.isAssignableFrom(objsp.getClass())) {
            streamProvider = (IBackgroundExecutionStreamProvider)objsp;
            if (streamProvider instanceof RepositoryFileStreamProvider) {
                params.put("inputFile", (Serializable)((Object)((RepositoryFileStreamProvider)streamProvider).getInputFilePath()));
                params.put("outputFilePattern", (Serializable)((Object)((RepositoryFileStreamProvider)streamProvider).getOutputFilePath()));
                params.put("autoCreateUniqueFilename", Boolean.valueOf(((RepositoryFileStreamProvider)streamProvider).autoCreateUniqueFilename()));
            }
        } else {
            boolean hasOutputPattern;
            String inputFile = params.get("inputFile") == null ? null : params.get("inputFile").toString();
            String outputFilePattern = params.get("outputFilePattern") == null ? null : params.get("outputFilePattern").toString();
            boolean hasInputFile = !StringUtils.isEmpty((String)inputFile);
            boolean bl = hasOutputPattern = !StringUtils.isEmpty((String)outputFilePattern);
            if (hasInputFile && hasOutputPattern) {
                boolean autoCreateUniqueFilename = params.get("autoCreateUniqueFilename") == null || params.get("autoCreateUniqueFilename").toString().equalsIgnoreCase("true");
                streamProvider = new RepositoryFileStreamProvider(inputFile, outputFilePattern, autoCreateUniqueFilename);
                params.put("streamProvider", (Serializable)streamProvider);
            } else if (logger.isWarnEnabled()) {
                logger.warn((Object)Messages.getInstance().getMissingParamsCantReturnSp(String.format("%s, %s", "inputFile", "outputFilePattern"), params));
            }
        }
        return streamProvider;
    }

    public IActionInvokeStatus invokeAction(IAction actionBean, String actionUser, Map<String, Serializable> params) throws Exception {
        ActionUtil.prepareMap(params);
        this.getStreamProvider(params);
        return super.invokeAction(actionBean, actionUser, params);
    }
}

