/*
 * Decompiled with CFR 0.152.
 */
package mondrian.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ServiceDiscovery<T> {
    private static final Log logger = LogFactory.getLog(ServiceDiscovery.class);
    private final Class<T> theInterface;

    public static <T> ServiceDiscovery<T> forClass(Class<T> theInterface) {
        return new ServiceDiscovery<T>(theInterface);
    }

    private ServiceDiscovery(Class<T> theInterface) {
        assert (theInterface != null);
        this.theInterface = theInterface;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Class<T>> getImplementor() {
        ClassLoader[] classLoaders;
        LinkedHashSet<Class<T>> uniqueClasses = new LinkedHashSet<Class<T>>();
        for (ClassLoader cLoader : classLoaders = new ClassLoader[]{this.getClass().getClassLoader(), Thread.currentThread().getContextClassLoader()}) {
            if (cLoader == null) continue;
            try {
                String lookupName = "META-INF/services/" + this.theInterface.getName();
                Enumeration<URL> urlEnum = cLoader.getResources(lookupName);
                while (urlEnum.hasMoreElements()) {
                    URL resourceURL = urlEnum.nextElement();
                    InputStream is = null;
                    try {
                        String clazz;
                        is = resourceURL.openStream();
                        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
                        while ((clazz = reader.readLine()) != null) {
                            this.parseImplementor(clazz, cLoader, uniqueClasses);
                        }
                    }
                    catch (IOException e) {
                        logger.warn((Object)("Error while finding service file " + resourceURL + " for " + this.theInterface), (Throwable)e);
                    }
                    finally {
                        if (is == null) continue;
                        is.close();
                    }
                }
            }
            catch (IOException e) {
                logger.warn((Object)("Error while finding service files for " + this.theInterface), (Throwable)e);
            }
        }
        ArrayList<Class<T>> rtn = new ArrayList<Class<T>>();
        rtn.addAll(uniqueClasses);
        return rtn;
    }

    protected void parseImplementor(String clazz, ClassLoader cLoader, Set<Class<T>> uniqueClasses) {
        assert (clazz != null);
        String[] classList = clazz.trim().split("#");
        String theClass = classList[0].trim();
        if (theClass.length() == 0) {
            return;
        }
        try {
            Class<?> interfaceImplementor = Class.forName(theClass, false, cLoader);
            if (this.theInterface.isAssignableFrom(interfaceImplementor)) {
                uniqueClasses.add(interfaceImplementor);
            } else {
                logger.error((Object)("Class " + interfaceImplementor + " cannot be assigned to interface " + this.theInterface));
            }
        }
        catch (ClassNotFoundException ignored) {
            ignored.printStackTrace();
        }
        catch (LinkageError ignored) {
            ignored.printStackTrace();
        }
    }
}

