/*
 * Decompiled with CFR 0.152.
 */
package mondrian.tui;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.xpath.XPathException;
import mondrian.olap.MondrianServer;
import mondrian.olap.Role;
import mondrian.olap.Util;
import mondrian.rolap.RolapConnectionProperties;
import mondrian.server.StringRepositoryContentFinder;
import mondrian.spi.CatalogLocator;
import mondrian.spi.impl.CatalogLocatorImpl;
import mondrian.tui.MockHttpServletRequest;
import mondrian.tui.MockHttpServletResponse;
import mondrian.tui.MockServletConfig;
import mondrian.tui.MockServletContext;
import mondrian.tui.XmlUtil;
import mondrian.util.LockBox;
import mondrian.xmla.DataSourcesConfig;
import mondrian.xmla.Enumeration;
import mondrian.xmla.PropertyDefinition;
import mondrian.xmla.XmlaHandler;
import mondrian.xmla.impl.DefaultXmlaRequest;
import mondrian.xmla.impl.DefaultXmlaResponse;
import mondrian.xmla.impl.MondrianXmlaServlet;
import org.apache.log4j.Logger;
import org.eigenbase.xom.DOMWrapper;
import org.eigenbase.xom.Parser;
import org.eigenbase.xom.XOMException;
import org.eigenbase.xom.XOMUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.EntityResolver;
import org.xml.sax.SAXException;

public class XmlaSupport {
    private static final Logger LOGGER = Logger.getLogger(XmlaSupport.class);
    public static final String nl = Util.nl;
    public static final String SOAP_PREFIX = "SOAP-ENV";
    private static final Util.ByteMatcher UTF8_BOM_MATCHER = new Util.ByteMatcher(new byte[]{-17, -69, -65});
    private static final Util.ByteMatcher UTF16_LE_BOM_MATCHER = new Util.ByteMatcher(new byte[]{-1, -2});
    private static final Util.ByteMatcher UTF16_BE_BOM_MATCHER = new Util.ByteMatcher(new byte[]{-2, -1});
    private static final Util.ByteMatcher UTF32_LE_BOM_MATCHER = new Util.ByteMatcher(new byte[]{-1, -2, 0, 0});
    private static final Util.ByteMatcher UTF32_BE_BOM_MATCHER = new Util.ByteMatcher(new byte[]{0, 0, -2, -1});
    public static final String CATALOG_NAME = "FoodMart";
    public static final String DATASOURCE_NAME = "FoodMart";
    public static final String DATASOURCE_DESCRIPTION = "Mondrian FoodMart data source";
    public static final String DATASOURCE_INFO = "Provider=Mondrian;DataSource=FoodMart;";
    public static final Map<String, String> ENV = new HashMap<String, String>();
    public static final String ROW_SET_PREFIX = "ROW";
    private static CatalogLocator CATALOG_LOCATOR;
    private static String soapFaultXPath;
    private static String soapHeaderAndBodyXPath;
    private static String soapBodyXPath;
    private static String soapXmlaRootXPath;
    private static String xmlaRootXPath;

    public static String getXmlaTransform(String xmlaPrefix) {
        return "<?xml version='1.0'?><xsl:stylesheet   xmlns:xsl='http://www.w3.org/1999/XSL/Transform'   xmlns:xalan='http://xml.apache.org/xslt'  xmlns:xsd='http://www.w3.org/2001/XMLSchema'  xmlns:ROW='urn:schemas-microsoft-com:xml-analysis:rowset'  xmlns:SOAP-ENV='http://schemas.xmlsoap.org/soap/envelope/'   xmlns:" + xmlaPrefix + "='urn:schemas-microsoft-com:xml-analysis'  version='1.0'><xsl:output method='xml'   encoding='UTF-8'  indent='yes'   xalan:indent-amount='2'/><xsl:param name='content'/><xsl:param name='soap'/><!-- consume '/' and apply --><xsl:template match='/'>  <xsl:apply-templates/></xsl:template><!-- copy 'Envelope' unless soap==none --> <xsl:template match='SOAP-ENV:Envelope'>   <xsl:choose>     <xsl:when test=\"$soap='none'\">       <xsl:apply-templates/>     </xsl:when>     <xsl:otherwise>       <xsl:copy>         <xsl:apply-templates select='@*|node()'/>       </xsl:copy>     </xsl:otherwise>    </xsl:choose> </xsl:template> <!-- copy 'Header' unless soap==none --> <xsl:template match='SOAP-ENV:Header'>   <xsl:choose>     <xsl:when test=\"$soap='none'\">       <xsl:apply-templates/>     </xsl:when>     <xsl:otherwise>        <xsl:copy>         <xsl:apply-templates select='@*|node()'/>       </xsl:copy>     </xsl:otherwise>    </xsl:choose> </xsl:template> <!-- copy 'Body' unless soap==none --> <xsl:template match='SOAP-ENV:Body'>   <xsl:choose>     <xsl:when test=\"$soap='none'\">       <xsl:apply-templates/>     </xsl:when>     <xsl:otherwise>        <xsl:copy>         <xsl:apply-templates select='@*|node()'/>       </xsl:copy>     </xsl:otherwise>    </xsl:choose> </xsl:template> <!-- copy 'DiscoverResponse' unless soap==none --> <xsl:template match='" + xmlaPrefix + ":DiscoverResponse'>   <xsl:choose>     <xsl:when test=\"$soap='none'\">       <xsl:apply-templates/>     </xsl:when>     <xsl:otherwise>       <xsl:copy>         <xsl:apply-templates select='@*|node()'/>       </xsl:copy>     </xsl:otherwise>    </xsl:choose> </xsl:template> <!-- copy 'return' unless soap==none --> <xsl:template match='" + xmlaPrefix + ":return'>   <xsl:choose>     <xsl:when test=\"$soap='none'\">       <xsl:apply-templates/>     </xsl:when>     <xsl:otherwise>       <xsl:copy>         <xsl:apply-templates select='@*|node()'/>       </xsl:copy>     </xsl:otherwise>    </xsl:choose> </xsl:template> <!-- copy 'root' unless soap==none --> <xsl:template match='ROW:root'>   <xsl:choose>     <xsl:when test=\"$soap='none'\">       <xsl:apply-templates/>     </xsl:when>     <xsl:otherwise>       <xsl:copy>         <xsl:apply-templates select='@*|node()'/>       </xsl:copy>     </xsl:otherwise >   </xsl:choose> </xsl:template> <!-- copy 'schema' if content==schema or schemadata --> <xsl:template match='xsd:schema'>   <xsl:choose>     <xsl:when test=\"$content='schemadata'\">       <xsl:copy>         <xsl:apply-templates select='@*|node()'/>       </xsl:copy>     </xsl:when>     <xsl:when test=\"$content='schema'\">       <xsl:copy>         <xsl:apply-templates select='@*|node()'/>       </xsl:copy>     </xsl:when>   <xsl:otherwise/>    </xsl:choose> </xsl:template> <!-- copy 'row' if content==data or schemadata --> <xsl:template match='ROW:row'>   <xsl:choose>     <xsl:when test=\"$content='schemadata'\">       <xsl:copy>         <xsl:apply-templates select='@*|node()'/>       </xsl:copy>     </xsl:when>     <xsl:when test=\"$content='data'\">       <xsl:copy>         <xsl:apply-templates select='@*|node()'/>       </xsl:copy>     </xsl:when>     <xsl:otherwise/>    </xsl:choose> </xsl:template> <!-- copy everything else --> <xsl:template match='*|@*'>   <xsl:copy>     <xsl:apply-templates select='@*|node()'/>   </xsl:copy> </xsl:template> </xsl:stylesheet>";
    }

    public static CatalogLocator getCatalogLocator() {
        if (CATALOG_LOCATOR == null) {
            CATALOG_LOCATOR = new CatalogLocatorImpl();
        }
        return CATALOG_LOCATOR;
    }

    public static DataSourcesConfig.DataSources getDataSources(String connectString, Map<String, String> catalogNameUrls) throws XOMException {
        String str = XmlaSupport.getDataSourcesText(connectString, catalogNameUrls);
        StringReader dsConfigReader = new StringReader(str);
        Parser xmlParser = XOMUtil.createDefaultParser();
        DOMWrapper def = xmlParser.parse((Reader)dsConfigReader);
        return new DataSourcesConfig.DataSources(def);
    }

    public static DataSourcesConfig.DataSources parseDataSources(String dataSourcesConfigString, Logger logger) {
        try {
            if (dataSourcesConfigString == null) {
                logger.warn((Object)"XmlaSupport.parseDataSources: null input");
                return null;
            }
            dataSourcesConfigString = Util.replaceProperties(dataSourcesConfigString, Util.toMap(System.getProperties()));
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("XmlaSupport.parseDataSources: dataSources=" + dataSourcesConfigString));
            }
            Parser parser = XOMUtil.createDefaultParser();
            DOMWrapper doc = parser.parse(dataSourcesConfigString);
            return new DataSourcesConfig.DataSources(doc);
        }
        catch (XOMException e) {
            throw Util.newError(e, "Failed to parse data sources config: " + dataSourcesConfigString);
        }
    }

    public static String getDataSourcesText(String connectString, Map<String, String> catalogNameUrls) {
        StringBuilder buf = new StringBuilder(500);
        buf.append("<?xml version=\"1.0\"?>");
        buf.append(nl);
        buf.append("<DataSources>");
        buf.append(nl);
        buf.append("   <DataSource>");
        buf.append(nl);
        buf.append("       <DataSourceName>");
        buf.append("FoodMart");
        buf.append("</DataSourceName>");
        buf.append(nl);
        buf.append("       <DataSourceDescription>");
        buf.append(DATASOURCE_DESCRIPTION);
        buf.append("</DataSourceDescription>");
        buf.append(nl);
        buf.append("       <URL>http://localhost:8080/mondrian/xmla</URL>");
        buf.append(nl);
        buf.append("       <DataSourceInfo><![CDATA[");
        buf.append(connectString);
        buf.append("]]></DataSourceInfo>");
        buf.append(nl);
        buf.append("       <ProviderName>Mondrian</ProviderName>");
        buf.append(nl);
        buf.append("       <ProviderType>MDP</ProviderType>");
        buf.append(nl);
        buf.append("       <AuthenticationMode>Unauthenticated</AuthenticationMode>");
        buf.append(nl);
        buf.append("       <Catalogs>");
        for (Map.Entry<String, String> catalogNameUrl : catalogNameUrls.entrySet()) {
            String name = catalogNameUrl.getKey();
            String url = catalogNameUrl.getValue();
            buf.append(nl);
            buf.append("           <Catalog name='");
            buf.append(name);
            buf.append("'>");
            if (url != null) {
                buf.append("<Definition>");
                buf.append(url);
                buf.append("</Definition>");
            }
            buf.append("</Catalog>");
        }
        buf.append(nl);
        buf.append("       </Catalogs>");
        buf.append(nl);
        buf.append("   </DataSource>");
        buf.append(nl);
        buf.append("</DataSources>");
        buf.append(nl);
        String datasources = buf.toString();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("XmlaSupport.getDataSources: datasources=" + datasources));
        }
        return datasources;
    }

    public static String getSoapFaultXPath() {
        if (soapFaultXPath == null) {
            String xpath;
            StringBuilder buf = new StringBuilder(100);
            buf.append('/');
            buf.append(SOAP_PREFIX);
            buf.append(":Envelope");
            buf.append('/');
            buf.append(SOAP_PREFIX);
            buf.append(":Body");
            buf.append('/');
            buf.append(SOAP_PREFIX);
            buf.append(":Fault");
            buf.append("/*");
            soapFaultXPath = xpath = buf.toString();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("XmlaSupport.getSoapFaultXPath: xpath=" + xpath));
            }
        }
        return soapFaultXPath;
    }

    public static String getSoapHeaderAndBodyXPath() {
        if (soapHeaderAndBodyXPath == null) {
            String xpath;
            StringBuilder buf = new StringBuilder(100);
            buf.append('/');
            buf.append(SOAP_PREFIX);
            buf.append(":Envelope");
            buf.append("/*");
            soapHeaderAndBodyXPath = xpath = buf.toString();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("XmlaSupport.getSoapHeaderAndBodyXPath: xpath=" + xpath));
            }
        }
        return soapHeaderAndBodyXPath;
    }

    public static String getSoapBodyXPath() {
        if (soapBodyXPath == null) {
            String xpath;
            StringBuilder buf = new StringBuilder(100);
            buf.append('/');
            buf.append(SOAP_PREFIX);
            buf.append(":Envelope");
            buf.append('/');
            buf.append(SOAP_PREFIX);
            buf.append(":Body");
            buf.append("/*");
            soapBodyXPath = xpath = buf.toString();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("XmlaSupport.getSoapBodyXPath: xpath=" + xpath));
            }
        }
        return soapBodyXPath;
    }

    public static String getSoapXmlaRootXPath(String xmlaPrefix) {
        if (soapXmlaRootXPath == null) {
            String xpath;
            StringBuilder buf = new StringBuilder(20);
            buf.append('/');
            buf.append(SOAP_PREFIX);
            buf.append(":Envelope");
            buf.append('/');
            buf.append(SOAP_PREFIX);
            buf.append(":Body");
            buf.append("/").append(xmlaPrefix).append(":DiscoverResponse");
            buf.append("/").append(xmlaPrefix).append(":return");
            buf.append('/');
            buf.append(ROW_SET_PREFIX);
            buf.append(":root");
            buf.append("/*");
            soapXmlaRootXPath = xpath = buf.toString();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("XmlaSupport.getSoapXmlaRootXPath: xpath=" + xpath));
            }
        }
        return soapXmlaRootXPath;
    }

    public static String getXmlaRootXPath(String xmlaPrefix) {
        if (xmlaRootXPath == null) {
            String xpath;
            StringBuilder buf = new StringBuilder(20);
            buf.append("/").append(xmlaPrefix).append(":DiscoverResponse");
            buf.append("/").append(xmlaPrefix).append(":return");
            buf.append('/');
            buf.append(ROW_SET_PREFIX);
            buf.append(":root");
            buf.append("/*");
            xmlaRootXPath = xpath = buf.toString();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("XmlaSupport.getXmlaRootXPath: xpath=" + xpath));
            }
        }
        return xmlaRootXPath;
    }

    public static Node[] extractNodesFromSoapXmla(byte[] bytes) throws SAXException, IOException, XPathException {
        Document doc = XmlUtil.parse(bytes);
        return XmlaSupport.extractNodesFromSoapXmla(doc);
    }

    public static Node[] extractNodesFromSoapXmla(Document doc) throws SAXException, IOException, XPathException {
        String xmlaPrefix = "xmla";
        String xpath = XmlaSupport.getSoapXmlaRootXPath("xmla");
        String[][] nsArray = new String[][]{{SOAP_PREFIX, "http://schemas.xmlsoap.org/soap/envelope/"}, {"xmla", "urn:schemas-microsoft-com:xml-analysis"}, {ROW_SET_PREFIX, "urn:schemas-microsoft-com:xml-analysis:rowset"}};
        return XmlaSupport.extractNodes(doc, xpath, nsArray);
    }

    public static Node[] extractNodesFromXmla(byte[] bytes) throws SAXException, IOException, XPathException {
        Document doc = XmlUtil.parse(bytes);
        return XmlaSupport.extractNodesFromXmla(doc);
    }

    public static Node[] extractNodesFromXmla(Document doc) throws SAXException, IOException, XPathException {
        String xmlaPrefix = "xmla";
        String xpath = XmlaSupport.getXmlaRootXPath("xmla");
        String[][] nsArray = new String[][]{{"xmla", "urn:schemas-microsoft-com:xml-analysis"}, {ROW_SET_PREFIX, "urn:schemas-microsoft-com:xml-analysis:rowset"}};
        return XmlaSupport.extractNodes(doc, xpath, nsArray);
    }

    public static Node[] extractFaultNodesFromSoap(byte[] bytes) throws SAXException, IOException, XPathException {
        Document doc = XmlUtil.parse(bytes);
        return XmlaSupport.extractFaultNodesFromSoap(doc);
    }

    public static Node[] extractFaultNodesFromSoap(Document doc) throws SAXException, IOException, XPathException {
        String xpath = XmlaSupport.getSoapFaultXPath();
        String[][] nsArray = new String[][]{{SOAP_PREFIX, "http://schemas.xmlsoap.org/soap/envelope/"}};
        return XmlaSupport.extractNodes(doc, xpath, nsArray);
    }

    public static Document extractBodyFromSoap(Document doc) throws SAXException, IOException, XPathException {
        String xpath = XmlaSupport.getSoapBodyXPath();
        String[][] nsArray = new String[][]{{SOAP_PREFIX, "http://schemas.xmlsoap.org/soap/envelope/"}};
        Node[] nodes = XmlaSupport.extractNodes(doc, xpath, nsArray);
        return nodes.length == 1 ? XmlUtil.newDocument(nodes[0], true) : null;
    }

    public static Node[] extractNodes(Node node, String xpath, String[][] nsArray) throws SAXException, IOException, XPathException {
        HashMap<String, String> nsMap = new HashMap<String, String>();
        for (int i = 0; i < nsArray.length; ++i) {
            nsMap.put(nsArray[i][0], nsArray[i][1]);
        }
        Node[] nodes = XmlUtil.selectAsNodes(node, xpath, Collections.unmodifiableMap(nsMap));
        if (LOGGER.isDebugEnabled()) {
            StringBuilder buf = new StringBuilder(1024);
            buf.append("XmlaSupport.extractNodes: ");
            buf.append("nodes.length=");
            buf.append(nodes.length);
            buf.append(nl);
            for (Node n : nodes) {
                String str = XmlUtil.toString(n, false);
                buf.append(str);
                buf.append(nl);
            }
            LOGGER.debug((Object)buf.toString());
        }
        return nodes;
    }

    public static byte[] processSoapXmla(File file, String connectString, Map<String, String> catalogNameUrls, String cbClassName) throws IOException, ServletException, SAXException {
        String requestText = XmlaSupport.readFile(file);
        return XmlaSupport.processSoapXmla(requestText, connectString, catalogNameUrls, cbClassName, null, null);
    }

    public static byte[] processSoapXmla(Document doc, String connectString, Map<String, String> catalogNameUrls, String cbClassName, Role role, Map<List<String>, Servlet> servletCache) throws IOException, ServletException, SAXException {
        String requestText = XmlUtil.toString(doc, false);
        return XmlaSupport.processSoapXmla(requestText, connectString, catalogNameUrls, cbClassName, role, servletCache);
    }

    public static byte[] processSoapXmla(String requestText, String connectString, Map<String, String> catalogNameUrls, String cbClassName, Role role, Map<List<String>, Servlet> servletCache) throws IOException, ServletException, SAXException {
        String dataSourceText = XmlaSupport.getDataSourcesText(connectString, catalogNameUrls);
        Util.PropertyList propertyList = Util.parseConnectString(connectString);
        String roleName = propertyList.get(RolapConnectionProperties.Role.name());
        LockBox.Entry entry = null;
        if (role != null) {
            MondrianServer server = MondrianServer.forId(null);
            entry = server.getLockBox().register(role);
            roleName = entry.getMoniker();
        }
        byte[] reqBytes = requestText.getBytes();
        MockHttpServletRequest req = new MockHttpServletRequest(reqBytes);
        req.setMethod("POST");
        req.setContentType("text/xml");
        if (roleName != null) {
            req.setUserInRole(roleName, true);
        }
        MockHttpServletResponse res = new MockHttpServletResponse();
        res.setCharacterEncoding("UTF-8");
        Servlet servlet = XmlaSupport.getServlet(cbClassName, dataSourceText, servletCache);
        servlet.service((ServletRequest)req, (ServletResponse)res);
        Util.discard((Object)entry);
        return res.toByteArray();
    }

    public static Servlet makeServlet(String connectString, Map<String, String> catalogNameUrls, String cbClassName, Map<List<String>, Servlet> servletCache) throws IOException, ServletException, SAXException {
        String dataSourceText = XmlaSupport.getDataSourcesText(connectString, catalogNameUrls);
        return XmlaSupport.getServlet(cbClassName, dataSourceText, servletCache);
    }

    private static Servlet getServlet(String cbClassName, String dataSourceText, Map<List<String>, Servlet> cache) throws ServletException {
        List<String> key = Collections.singletonList(dataSourceText);
        Object servlet = cache.get(key);
        if (servlet != null) {
            return servlet;
        }
        MockServletContext servletContext = new MockServletContext();
        MockServletConfig servletConfig = new MockServletConfig(servletContext);
        servletConfig.addInitParameter("Callbacks", cbClassName);
        servletConfig.addInitParameter("CharacterEncoding", "UTF-8");
        servletConfig.addInitParameter("DataSourcesConfig", "inline:" + dataSourceText);
        servlet = new MondrianXmlaServlet();
        servlet.init((ServletConfig)servletConfig);
        if (cache != null) {
            cache.put(key, (Servlet)servlet);
        }
        return servlet;
    }

    public static byte[] processSoapXmla(Document doc, Servlet servlet) throws IOException, ServletException, SAXException {
        String requestText = XmlUtil.toString(doc, false);
        return XmlaSupport.processSoapXmla(requestText, servlet);
    }

    public static byte[] processSoapXmla(String requestText, Servlet servlet) throws IOException, ServletException, SAXException {
        byte[] reqBytes = requestText.getBytes();
        MockHttpServletRequest req = new MockHttpServletRequest(reqBytes);
        req.setMethod("POST");
        req.setContentType("text/xml");
        MockHttpServletResponse res = new MockHttpServletResponse();
        res.setCharacterEncoding("UTF-8");
        servlet.service((ServletRequest)req, (ServletResponse)res);
        return res.toByteArray();
    }

    public static boolean validateSchemaSoapXmla(byte[] bytes) throws SAXException, IOException, ParserConfigurationException, TransformerException {
        return XmlaSupport.validateEmbeddedSchema(bytes, XmlUtil.getSoapXmlaXds2xs("xmla"), XmlUtil.getSoapXmlaXds2xd("xmla"));
    }

    public static byte[] processXmla(File file, String connectString, Map<String, String> catalogNameUrls) throws IOException, SAXException, XOMException {
        return XmlaSupport.processXmla(file, connectString, catalogNameUrls, null);
    }

    public static byte[] processXmla(File file, String connectString, Map<String, String> catalogNameUrls, Map<List<String>, MondrianServer> cache) throws IOException, SAXException, XOMException {
        return XmlaSupport.processXmla(file, connectString, catalogNameUrls, null, cache);
    }

    public static byte[] processXmla(File file, String connectString, Map<String, String> catalogNameUrls, Role role, Map<List<String>, MondrianServer> cache) throws IOException, SAXException, XOMException {
        String requestText = XmlaSupport.readFile(file);
        return XmlaSupport.processXmla(requestText, connectString, catalogNameUrls, cache);
    }

    public static byte[] processXmla(String requestText, String connectString, Map<String, String> catalogNameUrls, Map<List<String>, MondrianServer> cache) throws IOException, SAXException, XOMException {
        Document requestDoc = XmlUtil.parseString(requestText);
        return XmlaSupport.processXmla(requestDoc, connectString, catalogNameUrls, null, cache);
    }

    public static byte[] processXmla(Document requestDoc, String connectString, Map<String, String> catalogNameUrls, Role role, Map<List<String>, MondrianServer> cache) throws IOException, XOMException {
        Element requestElem = requestDoc.getDocumentElement();
        return XmlaSupport.processXmla(requestElem, connectString, catalogNameUrls, role, cache);
    }

    public static byte[] processXmla(Element requestElem, String connectString, Map<String, String> catalogNameUrls, Role role, Map<List<String>, MondrianServer> cache) throws IOException, XOMException {
        DefaultXmlaRequest request;
        Enumeration.ResponseMimeType responseMimeType;
        Util.PropertyList propertyList = Util.parseConnectString(connectString);
        List<String> cacheKey = Arrays.asList(propertyList.toString(), catalogNameUrls.toString());
        MondrianServer server = cache.get(cacheKey);
        if (server == null) {
            server = MondrianServer.createWithRepository(new StringRepositoryContentFinder(XmlaSupport.getDataSourcesText(connectString, catalogNameUrls)), XmlaSupport.getCatalogLocator());
        }
        if (cache != null) {
            cache.put(cacheKey, server);
        }
        XmlaHandler handler = new XmlaHandler((XmlaHandler.ConnectionFactory)((Object)server), "xmla");
        String roleName = propertyList.get(RolapConnectionProperties.Role.name());
        LockBox.Entry entry = null;
        if (role != null) {
            entry = server.getLockBox().register(role);
            roleName = entry.getMoniker();
        }
        if ((responseMimeType = Enumeration.ResponseMimeType.MAP.get((request = new DefaultXmlaRequest(requestElem, roleName, null, null, null)).getProperties().get(PropertyDefinition.ResponseMimeType.name()))) == null) {
            responseMimeType = Enumeration.ResponseMimeType.SOAP;
        }
        ByteArrayOutputStream resBuf = new ByteArrayOutputStream();
        DefaultXmlaResponse response = new DefaultXmlaResponse(resBuf, "UTF-8", responseMimeType);
        handler.process(request, response);
        Util.discard((Object)entry);
        return resBuf.toByteArray();
    }

    public static boolean validateSchemaXmla(byte[] bytes) throws SAXException, IOException, ParserConfigurationException, TransformerException {
        return XmlaSupport.validateEmbeddedSchema(bytes, XmlUtil.getXmlaXds2xs("xmla"), XmlUtil.getXmlaXds2xd("xmla"));
    }

    public static boolean validateSoapXmlaUsingXpath(byte[] bytes) throws SAXException, IOException, XPathException {
        if (!XmlUtil.supportsValidation()) {
            return false;
        }
        bytes = XmlaSupport.removeUtfBom(bytes);
        Node[] nodes = XmlaSupport.extractNodesFromSoapXmla(bytes);
        return XmlaSupport.validateNodes(nodes);
    }

    private static byte[] removeUtfBom(byte[] s) {
        byte[] response = XmlaSupport.removeUtfBom(s, UTF8_BOM_MATCHER);
        if (response != null) {
            return response;
        }
        response = XmlaSupport.removeUtfBom(s, UTF16_BE_BOM_MATCHER);
        if (response != null) {
            return response;
        }
        response = XmlaSupport.removeUtfBom(s, UTF16_LE_BOM_MATCHER);
        if (response != null) {
            return response;
        }
        response = XmlaSupport.removeUtfBom(s, UTF32_BE_BOM_MATCHER);
        if (response != null) {
            return response;
        }
        response = XmlaSupport.removeUtfBom(s, UTF32_LE_BOM_MATCHER);
        if (response != null) {
            return response;
        }
        return s;
    }

    private static byte[] removeUtfBom(byte[] s, Util.ByteMatcher matcher) {
        byte[] firstBytes = new byte[matcher.key.length];
        System.arraycopy(s, 0, firstBytes, 0, matcher.key.length);
        if (s.length >= matcher.key.length && matcher.match(firstBytes) == 0) {
            byte[] result = new byte[s.length - matcher.key.length];
            System.arraycopy(s, 0, result, 0, s.length - matcher.key.length);
            return result;
        }
        return null;
    }

    public static boolean validateXmlaUsingXpath(byte[] bytes) throws SAXException, IOException, XPathException {
        if (!XmlUtil.supportsValidation()) {
            return false;
        }
        bytes = XmlaSupport.removeUtfBom(bytes);
        Node[] nodes = XmlaSupport.extractNodesFromXmla(bytes);
        return XmlaSupport.validateNodes(nodes);
    }

    public static boolean validateNodes(Node[] nodes) throws SAXException, IOException {
        if (!XmlUtil.supportsValidation()) {
            return false;
        }
        if (nodes.length == 0) {
            return false;
        }
        if (nodes.length == 1) {
            return false;
        }
        if (nodes.length > 2) {
            return false;
        }
        Node schemaNode = nodes[0];
        Node rowNode = nodes[1];
        Node rootNode = rowNode.getParentNode();
        rootNode.removeChild(schemaNode);
        Document schemaDoc = XmlUtil.newDocument(schemaNode, true);
        Document dataDoc = XmlUtil.newDocument(rootNode, true);
        String xmlns = XmlUtil.getNamespaceAttributeValue(dataDoc);
        String schemaLocationPropertyValue = xmlns + ' ' + "xmlschema";
        XmlUtil.Resolver resolver = new XmlUtil.Resolver(schemaDoc);
        XmlUtil.validate(dataDoc, schemaLocationPropertyValue, (EntityResolver)resolver);
        return true;
    }

    public static boolean validateEmbeddedSchema(byte[] bytes, String schemaTransform, String dataTransform) throws SAXException, IOException, ParserConfigurationException, TransformerException {
        if (!XmlUtil.supportsValidation()) {
            return false;
        }
        Document doc = XmlUtil.parse(bytes);
        return XmlaSupport.validateEmbeddedSchema(doc, schemaTransform, dataTransform);
    }

    public static boolean validateEmbeddedSchema(Document doc, String schemaTransform, String dataTransform) throws SAXException, IOException, ParserConfigurationException, TransformerException {
        if (!XmlUtil.supportsValidation()) {
            return false;
        }
        Node dataDoc = XmlUtil.transform(doc, new BufferedReader(new StringReader(dataTransform)));
        if (dataDoc == null) {
            LOGGER.debug((Object)"XmlaSupport.validateEmbeddedSchema: dataDoc is null");
            return false;
        }
        if (!dataDoc.hasChildNodes()) {
            LOGGER.debug((Object)"XmlaSupport.validateEmbeddedSchema: dataDoc has no children");
            return false;
        }
        String dataStr = XmlUtil.toString(dataDoc, false);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("XmlaSupport.validateEmbeddedSchema: dataDoc:\n=" + dataStr));
        }
        if (!(dataDoc instanceof Document)) {
            LOGGER.warn((Object)"XmlaSupport.validateEmbeddedSchema: dataDoc not Document");
            return false;
        }
        Node schemaDoc = XmlUtil.transform(doc, new BufferedReader(new StringReader(schemaTransform)));
        if (schemaDoc == null) {
            LOGGER.debug((Object)"XmlaSupport.validateEmbeddedSchema: schemaDoc is null");
            return false;
        }
        if (!schemaDoc.hasChildNodes()) {
            LOGGER.debug((Object)"XmlaSupport.validateEmbeddedSchema: schemaDoc has no children");
            return false;
        }
        String schemaStr = XmlUtil.toString(schemaDoc, false);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("XmlaSupport.validateEmbeddedSchema: schemaDoc:\n=" + schemaStr));
        }
        if (!(schemaDoc instanceof Document)) {
            LOGGER.warn((Object)"XmlaSupport.validateEmbeddedSchema: schemaDoc not Document");
            return false;
        }
        String xmlns = XmlUtil.getNamespaceAttributeValue((Document)dataDoc);
        String schemaLocationPropertyValue = xmlns + ' ' + "xmlschema";
        XmlUtil.Resolver resolver = new XmlUtil.Resolver(schemaStr);
        XmlUtil.validate(dataStr, schemaLocationPropertyValue, (EntityResolver)resolver);
        return true;
    }

    public static Document transformSoapXmla(Document doc, String[][] namevalueParameters, String ns) throws SAXException, IOException, ParserConfigurationException, TransformerException {
        Node node = XmlUtil.transform(doc, new BufferedReader(new StringReader(XmlaSupport.getXmlaTransform(ns))), namevalueParameters);
        return node instanceof Document ? (Document)node : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFile(File file) throws IOException {
        StringBuilder buf = new StringBuilder(1024);
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new FileReader(file));
            while ((line = reader.readLine()) != null) {
                buf.append(line);
                buf.append('\n');
            }
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception exception) {}
            }
        }
        return buf.toString();
    }

    private XmlaSupport() {
    }

    static {
        ENV.put("catalog", "FoodMart");
        ENV.put("datasource", DATASOURCE_INFO);
        CATALOG_LOCATOR = null;
        soapFaultXPath = null;
        soapHeaderAndBodyXPath = null;
        soapBodyXPath = null;
        soapXmlaRootXPath = null;
        xmlaRootXPath = null;
    }
}

