/*
 * Decompiled with CFR 0.152.
 */
package mondrian.spi.impl;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Stream;
import mondrian.olap.Util;
import mondrian.spi.Dialect;
import mondrian.spi.DialectUtil;
import mondrian.spi.impl.JdbcDialectFactory;
import mondrian.spi.impl.JdbcDialectImpl;

public class SnowflakeDialect
extends JdbcDialectImpl {
    private final String flagsRegexp = "^(\\(\\?([a-zA-Z]+)\\)).*$";
    private final Pattern flagsPattern = Pattern.compile("^(\\(\\?([a-zA-Z]+)\\)).*$");
    public static final JdbcDialectFactory FACTORY = new JdbcDialectFactory(SnowflakeDialect.class, Dialect.DatabaseProduct.SNOWFLAKE);

    public SnowflakeDialect(Connection connection) throws SQLException {
        super(connection);
    }

    @Override
    public String getQuoteIdentifierString() {
        return "\"";
    }

    @Override
    public String generateInline(List<String> columnNames, List<String> columnTypes, List<String[]> valueList) {
        return this.generateInlineGeneric(columnNames, columnTypes, valueList, null, false);
    }

    @Override
    public void quoteStringLiteral(StringBuilder buf, String s) {
        Util.singleQuoteString(s.replaceAll("\\\\", "\\\\\\\\"), buf);
    }

    @Override
    public boolean allowsOrderByAlias() {
        return true;
    }

    @Override
    public boolean allowsSelectNotInGroupBy() {
        return false;
    }

    @Override
    public boolean requiresOrderByAlias() {
        return true;
    }

    @Override
    public boolean allowsRegularExpressionInWhereClause() {
        return true;
    }

    @Override
    public String generateRegularExpression(String source, String javaRegex) {
        try {
            Pattern.compile(javaRegex);
        }
        catch (PatternSyntaxException e) {
            return null;
        }
        javaRegex = DialectUtil.cleanUnicodeAwareCaseFlag(javaRegex);
        javaRegex = javaRegex.replace("\\Q", "");
        javaRegex = javaRegex.replace("\\E", "");
        Matcher flagsMatcher = this.flagsPattern.matcher(javaRegex);
        StringBuilder parameters = new StringBuilder();
        if (flagsMatcher.matches()) {
            String flags = flagsMatcher.group(2);
            Stream.of(RegexParameters.values()).map(rp -> rp.parameter).filter(flags::contains).forEach(parameters::append);
        }
        if (flagsMatcher.matches()) {
            javaRegex = javaRegex.substring(0, flagsMatcher.start(1)) + javaRegex.substring(flagsMatcher.end(1));
        }
        StringBuilder sb = new StringBuilder();
        sb.append(" RLIKE ( ");
        sb.append(source);
        sb.append(", ");
        this.quoteStringLiteral(sb, javaRegex);
        if (parameters.toString().length() > 0) {
            sb.append(", ");
            this.quoteStringLiteral(sb, parameters.toString());
        }
        sb.append(")");
        return sb.toString();
    }

    public static enum RegexParameters {
        CASE_SENSITIVE("c"),
        CASE_INSENSITIVE("i"),
        MULTI_LINE("m"),
        WILDCARD_MATCHES_NEWLINE("s");

        final String parameter;

        private RegexParameters(String param) {
            this.parameter = param;
        }
    }
}

