/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.sql.DataSource;
import mondrian.calc.TupleCollections;
import mondrian.calc.TupleList;
import mondrian.calc.impl.ArrayTupleList;
import mondrian.calc.impl.ListTupleList;
import mondrian.calc.impl.UnaryTupleList;
import mondrian.olap.Evaluator;
import mondrian.olap.Level;
import mondrian.olap.Member;
import mondrian.olap.MondrianDef;
import mondrian.olap.MondrianProperties;
import mondrian.olap.Query;
import mondrian.olap.Util;
import mondrian.olap.fun.CrossJoinFunDef;
import mondrian.olap.fun.FunUtil;
import mondrian.resource.MondrianResource;
import mondrian.rolap.BitKey;
import mondrian.rolap.DescendantsConstraint;
import mondrian.rolap.MemberCache;
import mondrian.rolap.RolapAggregationManager;
import mondrian.rolap.RolapBaseCubeMeasure;
import mondrian.rolap.RolapCube;
import mondrian.rolap.RolapCubeHierarchy;
import mondrian.rolap.RolapCubeLevel;
import mondrian.rolap.RolapEvaluator;
import mondrian.rolap.RolapHierarchy;
import mondrian.rolap.RolapLevel;
import mondrian.rolap.RolapMember;
import mondrian.rolap.RolapMemberBase;
import mondrian.rolap.RolapNativeCrossJoin;
import mondrian.rolap.RolapNativeFilter;
import mondrian.rolap.RolapProperty;
import mondrian.rolap.RolapStar;
import mondrian.rolap.RolapStoredMeasure;
import mondrian.rolap.RolapUtil;
import mondrian.rolap.SqlConstraintUtils;
import mondrian.rolap.SqlContextConstraint;
import mondrian.rolap.SqlMemberSource;
import mondrian.rolap.SqlStatement;
import mondrian.rolap.TargetBase;
import mondrian.rolap.TupleReader;
import mondrian.rolap.agg.AggregationManager;
import mondrian.rolap.agg.CellRequest;
import mondrian.rolap.aggmatcher.AggStar;
import mondrian.rolap.sql.CrossJoinArg;
import mondrian.rolap.sql.DescendantsCrossJoinArg;
import mondrian.rolap.sql.MemberChildrenConstraint;
import mondrian.rolap.sql.MemberListCrossJoinArg;
import mondrian.rolap.sql.SqlQuery;
import mondrian.rolap.sql.TupleConstraint;
import mondrian.server.Execution;
import mondrian.server.Locus;
import mondrian.server.monitor.SqlStatementEvent;
import mondrian.util.CancellationChecker;
import mondrian.util.Pair;
import org.apache.log4j.Logger;

public class SqlTupleReader
implements TupleReader {
    private static final Logger LOGGER = Logger.getLogger(SqlTupleReader.class);
    protected final TupleConstraint constraint;
    List<TargetBase> targets = new ArrayList<TargetBase>();
    int maxRows = 0;
    private int missedMemberCount;
    private static final String UNION = "union";
    private int emptySets = 0;
    private boolean allowHints = true;
    private HashMap<RolapMember, Object> rolapToOrdinalMap = new HashMap();

    public boolean isAllowHints() {
        return this.allowHints;
    }

    public void setAllowHints(boolean allowHints) {
        this.allowHints = allowHints;
    }

    public SqlTupleReader(TupleConstraint constraint) {
        this.constraint = constraint;
    }

    @Override
    public void incrementEmptySets() {
        ++this.emptySets;
    }

    @Override
    public void addLevelMembers(RolapLevel level, TupleReader.MemberBuilder memberBuilder, List<RolapMember> srcMembers) {
        this.targets.add(new Target(level, memberBuilder, srcMembers));
    }

    @Override
    public Object getCacheKey() {
        ArrayList<Object> key = new ArrayList<Object>();
        key.add(this.constraint.getCacheKey());
        key.add(SqlTupleReader.class);
        for (TargetBase target : this.targets) {
            if (target.srcMembers == null) continue;
            key.add(target.getLevel());
        }
        if (this.constraint.getEvaluator() != null) {
            this.addTargetGroupsToKey(key);
        }
        return key;
    }

    private void addTargetGroupsToKey(List<Object> cacheKey) {
        List<List<TargetBase>> targetGroups = this.groupTargets(this.targets, this.constraint.getEvaluator().getQuery());
        if (targetGroups.size() > 1) {
            cacheKey.add(this.targetsToLevels(targetGroups));
        }
    }

    private List<List<RolapLevel>> targetsToLevels(List<List<TargetBase>> targetGroups) {
        ArrayList<List<RolapLevel>> groupedLevelList = new ArrayList<List<RolapLevel>>();
        for (List<TargetBase> targets : targetGroups) {
            ArrayList<RolapLevel> levels = new ArrayList<RolapLevel>();
            for (TargetBase target : targets) {
                levels.add(target.getLevel());
            }
            groupedLevelList.add(levels);
        }
        return groupedLevelList;
    }

    public int getEnumTargetCount() {
        int enumTargetCount = 0;
        for (TargetBase target : this.targets) {
            if (target.getSrcMembers() == null) continue;
            ++enumTargetCount;
        }
        return enumTargetCount;
    }

    protected void prepareTuples(DataSource dataSource, TupleList partialResult, List<List<RolapMember>> newPartialResult, List<TargetBase> targetGroup) {
        String message = "Populating member cache with members for " + targetGroup;
        boolean execQuery = partialResult == null;
        try (SqlStatement stmt = null;){
            boolean moreRows;
            ResultSet resultSet;
            if (execQuery) {
                ArrayList partialTargets = new ArrayList();
                for (TargetBase target : targetGroup) {
                    if (target.srcMembers != null) continue;
                    partialTargets.add(target);
                }
                Pair<String, List<SqlStatement.Type>> pair = this.makeLevelMembersSql(dataSource, targetGroup);
                String sql = (String)pair.left;
                List types = (List)pair.right;
                assert (sql != null && !sql.equals(""));
                stmt = RolapUtil.executeQuery(dataSource, sql, types, this.maxRows, 0, new SqlStatement.StatementLocus(Locus.peek().execution, "SqlTupleReader.readTuples " + partialTargets, message, SqlStatementEvent.Purpose.TUPLES, 0), -1, -1, null);
                resultSet = stmt.getResultSet();
            } else {
                resultSet = null;
            }
            for (TargetBase target : targetGroup) {
                target.open();
            }
            int limit = MondrianProperties.instance().ResultLimit.get();
            int fetchCount = 0;
            int enumTargetCount = this.getEnumTargetCount();
            int[] srcMemberIdxes = null;
            if (enumTargetCount > 0) {
                srcMemberIdxes = new int[enumTargetCount];
            }
            int currPartialResultIdx = 0;
            if (execQuery) {
                moreRows = resultSet.next();
                if (moreRows) {
                    ++stmt.rowCount;
                }
            } else {
                moreRows = currPartialResultIdx < partialResult.size();
            }
            Execution execution = Locus.peek().execution;
            while (moreRows) {
                CancellationChecker.checkCancelOrTimeout(stmt.rowCount, execution);
                if (limit > 0 && limit < ++fetchCount) {
                    throw MondrianResource.instance().MemberFetchLimitExceeded.ex(limit);
                }
                if (enumTargetCount == 0) {
                    int column = 0;
                    for (TargetBase target : targetGroup) {
                        target.setCurrMember(null);
                        column = target.addRow(stmt, column);
                    }
                } else {
                    int firstEnumTarget;
                    for (firstEnumTarget = 0; firstEnumTarget < targetGroup.size() && targetGroup.get((int)firstEnumTarget).srcMembers == null; ++firstEnumTarget) {
                    }
                    List partialRow = execQuery ? null : Util.cast((List)partialResult.get(currPartialResultIdx));
                    this.resetCurrMembers(partialRow);
                    this.addTargets(0, firstEnumTarget, enumTargetCount, srcMemberIdxes, stmt, message);
                    if (newPartialResult != null) {
                        this.savePartialResult(newPartialResult);
                    }
                }
                if (execQuery) {
                    moreRows = resultSet.next();
                    if (!moreRows) continue;
                    ++stmt.rowCount;
                    continue;
                }
                moreRows = ++currPartialResultIdx < partialResult.size();
            }
        }
    }

    @Override
    public TupleList readMembers(DataSource dataSource, TupleList partialResult, List<List<RolapMember>> newPartialResult) {
        block2: {
            int memberCountBefore;
            int memberCount = this.countMembers();
            this.rolapToOrdinalMap = new HashMap();
            do {
                this.missedMemberCount = 0;
                memberCountBefore = memberCount;
                this.prepareTuples(dataSource, partialResult, newPartialResult, this.targets);
                memberCount = this.countMembers();
                if (this.missedMemberCount == 0) break block2;
            } while (memberCount != memberCountBefore);
            throw Util.newError("Parent-child hierarchy contains cyclic data");
        }
        assert (this.targets.size() == 1);
        return new UnaryTupleList(this.bumpNullMember(this.targets.get(0).close()));
    }

    protected List<Member> bumpNullMember(List<Member> members) {
        if (members.size() > 0 && ((RolapMemberBase)members.get(members.size() - 1)).getKey() == RolapUtil.sqlNullValue) {
            Member removed = members.remove(members.size() - 1);
            members.add(0, removed);
        }
        return members;
    }

    private int countMembers() {
        int n = 0;
        for (TargetBase target : this.targets) {
            if (target.getList() == null) continue;
            n += target.getList().size();
        }
        return n;
    }

    @Override
    public TupleList readTuples(DataSource jdbcConnection, TupleList partialResult, List<List<RolapMember>> newPartialResult) {
        int enumTargetCount;
        List<List<TargetBase>> targetGroups = this.groupTargets(this.targets, this.constraint.getEvaluator().getQuery());
        ArrayList<TupleList> tupleLists = new ArrayList<TupleList>();
        for (List<TargetBase> targetGroup : targetGroups) {
            boolean allTargetsAtAllLevel = targetGroup.stream().allMatch(t -> t.getLevel().isAll());
            if (allTargetsAtAllLevel) continue;
            this.prepareTuples(jdbcConnection, partialResult, newPartialResult, targetGroup);
            int size = targetGroup.size();
            Iterator[] iter = new Iterator[size];
            for (int i = 0; i < size; ++i) {
                TargetBase t2 = targetGroup.get(i);
                iter[i] = t2.close().iterator();
            }
            ArrayList<Member> members = new ArrayList<Member>();
            while (iter[0].hasNext()) {
                for (int i = 0; i < size; ++i) {
                    members.add((Member)iter[i].next());
                }
            }
            tupleLists.add((TupleList)((Object)(size + this.emptySets == 1 ? new UnaryTupleList(members) : new ListTupleList(size + this.emptySets, members))));
        }
        if (tupleLists.isEmpty()) {
            return TupleCollections.emptyList(this.targets.size());
        }
        TupleList tupleList = CrossJoinFunDef.mutableCrossJoin(tupleLists);
        if (!tupleList.isEmpty() && targetGroups.size() > 1) {
            tupleList = this.projectTupleList(tupleList);
        }
        if ((enumTargetCount = this.getEnumTargetCount()) > 0) {
            tupleList = FunUtil.hierarchizeTupleList(tupleList, false);
        }
        return tupleList;
    }

    private TupleList projectTupleList(TupleList tupleList) {
        tupleList = tupleList.project(this.getLevelIndices(tupleList, this.targets));
        ArrayTupleList arrayTupleList = new ArrayTupleList(tupleList.getArity(), tupleList.size());
        arrayTupleList.addAll(tupleList);
        return arrayTupleList;
    }

    private int[] getLevelIndices(TupleList tupleList, List<TargetBase> targets) {
        assert (!tupleList.isEmpty());
        assert (targets.size() == ((List)tupleList.get(0)).size());
        int[] indices = new int[targets.size()];
        List tuple = (List)tupleList.get(0);
        int i = 0;
        for (TargetBase target : targets) {
            indices[i++] = this.getIndexOfLevel(target.getLevel(), tuple);
        }
        return indices;
    }

    private int getIndexOfLevel(RolapLevel level, List<Member> tuple) {
        for (int i = 0; i < tuple.size(); ++i) {
            if (!tuple.get(i).getLevel().equals(level)) continue;
            return i;
        }
        throw MondrianResource.instance().Internal.ex("Couldn't find level " + level.getName() + " in tuple.");
    }

    private List<List<TargetBase>> groupTargets(List<TargetBase> targets, Query query) {
        ArrayList<List<TargetBase>> targetGroupList = new ArrayList<List<TargetBase>>();
        if (!((RolapCube)query.getCube()).isVirtual()) {
            targetGroupList.add(targets);
            return targetGroupList;
        }
        if (this.inapplicableTargetsPresent(this.getBaseCubeCollection(query), targets)) {
            return Collections.emptyList();
        }
        Map<TargetBase, List<RolapCube>> targetToCubeMap = this.getTargetToCubeMap(targets, query);
        ArrayList<TargetBase> addedTargets = new ArrayList<TargetBase>();
        for (TargetBase target : targets) {
            if (addedTargets.contains(target)) continue;
            addedTargets.add(target);
            ArrayList<TargetBase> groupList = new ArrayList<TargetBase>();
            targetGroupList.add(groupList);
            groupList.add(target);
            for (TargetBase compareTarget : targets) {
                if (target == compareTarget || addedTargets.contains(compareTarget) || !targetToCubeMap.get(target).equals(targetToCubeMap.get(compareTarget))) continue;
                groupList.add(compareTarget);
                addedTargets.add(compareTarget);
            }
        }
        return targetGroupList;
    }

    private Map<TargetBase, List<RolapCube>> getTargetToCubeMap(List<TargetBase> targets, Query query) {
        assert (((RolapCube)query.getCube()).isVirtual());
        List<RolapCube> cubesFromQuery = query.getBaseCubes();
        assert (cubesFromQuery != null);
        Collection<RolapCube> baseCubesAssociatedWithVirtual = this.getBaseCubeCollection(query);
        HashMap<TargetBase, List<RolapCube>> targetMap = new HashMap<TargetBase, List<RolapCube>>();
        for (TargetBase target : targets) {
            targetMap.put(target, new ArrayList());
        }
        for (TargetBase target : targets) {
            this.mapTargetToCubes(cubesFromQuery, targetMap, target);
            if (((List)targetMap.get(target)).size() != 0) continue;
            this.mapTargetToCubes(baseCubesAssociatedWithVirtual, targetMap, target);
        }
        return targetMap;
    }

    private void mapTargetToCubes(Collection<RolapCube> cubes, Map<TargetBase, List<RolapCube>> targetMap, TargetBase target) {
        for (RolapCube cube : cubes) {
            if (!this.targetIsOnBaseCube(target, cube)) continue;
            targetMap.get(target).add(cube);
        }
    }

    private void resetCurrMembers(List<RolapMember> partialRow) {
        int nativeTarget = 0;
        for (TargetBase target : this.targets) {
            if (target.srcMembers != null) continue;
            if (partialRow != null) {
                target.setCurrMember(partialRow.get(nativeTarget++));
                continue;
            }
            target.setCurrMember(null);
        }
    }

    private void addTargets(int currEnumTargetIdx, int currTargetIdx, int nEnumTargets, int[] srcMemberIdxes, SqlStatement stmt, String message) {
        TargetBase currTarget = this.targets.get(currTargetIdx);
        for (int i = 0; i < currTarget.srcMembers.size(); ++i) {
            srcMemberIdxes[currEnumTargetIdx] = i;
            if (currEnumTargetIdx < nEnumTargets - 1) {
                int nextTargetIdx;
                for (nextTargetIdx = currTargetIdx + 1; nextTargetIdx < this.targets.size() && this.targets.get((int)nextTargetIdx).srcMembers == null; ++nextTargetIdx) {
                }
                this.addTargets(currEnumTargetIdx + 1, nextTargetIdx, nEnumTargets, srcMemberIdxes, stmt, message);
                continue;
            }
            int column = 0;
            int enumTargetIdx = 0;
            for (TargetBase target : this.targets) {
                if (target.srcMembers == null) {
                    try {
                        column = target.addRow(stmt, column);
                        continue;
                    }
                    catch (Throwable e) {
                        throw Util.newError(e, message);
                    }
                }
                RolapMember member = target.srcMembers.get(srcMemberIdxes[enumTargetIdx++]);
                target.getList().add(member);
            }
        }
    }

    private void savePartialResult(List<List<RolapMember>> partialResult) {
        ArrayList<RolapMember> row = new ArrayList<RolapMember>();
        for (TargetBase target : this.targets) {
            if (target.srcMembers != null) continue;
            row.add(target.getCurrMember());
        }
        partialResult.add(row);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Pair<String, List<SqlStatement.Type>> makeLevelMembersSql(DataSource dataSource, List<TargetBase> targetGroup) {
        RolapCube cube = null;
        boolean virtualCube = false;
        if (this.constraint instanceof SqlContextConstraint) {
            SqlContextConstraint sqlConstraint = (SqlContextConstraint)this.constraint;
            Query query = this.constraint.getEvaluator().getQuery();
            cube = (RolapCube)query.getCube();
            if (sqlConstraint.isJoinRequired()) {
                virtualCube = cube.isVirtual();
            }
        }
        if (virtualCube) {
            Query query = this.constraint.getEvaluator().getQuery();
            Collection<RolapCube> baseCubes = this.getBaseCubeCollection(query);
            Collection<RolapCube> fullyJoiningBaseCubes = this.getFullyJoiningBaseCubes(baseCubes, targetGroup);
            if (fullyJoiningBaseCubes.size() == 0) {
                return this.sqlForEmptyTuple(dataSource, baseCubes);
            }
            String prependString = "";
            StringBuilder selectString = new StringBuilder();
            List types = null;
            int savepoint = this.getEvaluator(this.constraint).savepoint();
            SqlQuery unionQuery = SqlQuery.newQuery(dataSource, "");
            try {
                for (RolapCube baseCube : fullyJoiningBaseCubes) {
                    Member measureInCurrentbaseCube = null;
                    for (Member currMember : baseCube.getMeasures()) {
                        if (currMember.isCalculated()) continue;
                        measureInCurrentbaseCube = currMember;
                        break;
                    }
                    if (measureInCurrentbaseCube == null) {
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug((Object)("No non-calculated member found in cube " + baseCube.getName()));
                        }
                        measureInCurrentbaseCube = baseCube.getMeasures().get(0);
                    }
                    this.getEvaluator(this.constraint).setContext(measureInCurrentbaseCube);
                    selectString.append(prependString);
                    Pair<String, List<SqlStatement.Type>> pair = this.generateSelectForLevels(dataSource, baseCube, fullyJoiningBaseCubes.size() == 1 ? WhichSelect.ONLY : WhichSelect.NOT_LAST, targetGroup);
                    selectString.append((String)pair.left);
                    types = (List)pair.right;
                    prependString = MondrianProperties.instance().GenerateFormattedSql.get() ? Util.nl + UNION + Util.nl : " union ";
                }
            }
            finally {
                this.getEvaluator(this.constraint).restore(savepoint);
            }
            if (fullyJoiningBaseCubes.size() == 1) {
                return Pair.of(selectString.toString(), types);
            }
            unionQuery.addFromQuery(selectString.toString(), "unionQuery", true);
            unionQuery.addSelect("*", null, null);
            if (fullyJoiningBaseCubes.size() > 1) {
                for (int i = 0; i < types.size(); ++i) {
                    unionQuery.addOrderBy(i + 1 + "", null, true, false, unionQuery.getDialect().requiresUnionOrderByOrdinal(), true);
                }
            }
            return Pair.of(unionQuery.toSqlAndTypes().left, types);
        }
        return this.generateSelectForLevels(dataSource, cube, WhichSelect.ONLY, targetGroup);
    }

    private boolean inapplicableTargetsPresent(Collection<RolapCube> baseCubes, List<TargetBase> targetGroup) {
        ArrayList<TargetBase> targetListCopy = new ArrayList<TargetBase>();
        targetListCopy.addAll(targetGroup);
        for (TargetBase target : targetGroup) {
            if (!this.targetHasShiftedContext(target)) continue;
            targetListCopy.remove(target);
        }
        return this.getFullyJoiningBaseCubes(baseCubes, targetListCopy).isEmpty();
    }

    private Collection<RolapCube> getFullyJoiningBaseCubes(Collection<RolapCube> baseCubes, List<TargetBase> targetGroup) {
        ArrayList<RolapCube> fullyJoiningCubes = new ArrayList<RolapCube>();
        for (RolapCube baseCube : baseCubes) {
            boolean allTargetsJoin = true;
            for (TargetBase target : targetGroup) {
                if (this.targetIsOnBaseCube(target, baseCube)) continue;
                allTargetsJoin = false;
            }
            if (!allTargetsJoin) continue;
            fullyJoiningCubes.add(baseCube);
        }
        return fullyJoiningCubes;
    }

    private boolean targetHasShiftedContext(TargetBase target) {
        HashSet<Member> measures = new HashSet<Member>();
        measures.addAll(this.constraint.getEvaluator().getQuery().getMeasuresMembers());
        for (Member measure : measures) {
            if (!measure.isCalculated() || !SqlConstraintUtils.containsValidMeasure(measure.getExpression())) continue;
            return true;
        }
        Set<Member> membersInMeasures = SqlConstraintUtils.getMembersNestedInMeasures(measures);
        return membersInMeasures.contains(target.getLevel().getHierarchy().getAllMember());
    }

    Collection<RolapCube> getBaseCubeCollection(Query query) {
        if (!((RolapCube)query.getCube()).isVirtual()) {
            return Collections.singletonList((RolapCube)query.getCube());
        }
        TreeSet<RolapCube> cubes = new TreeSet<RolapCube>(new RolapCube.CubeComparator());
        for (Member member : this.getMeasures(query)) {
            RolapCube baseCube;
            if (member instanceof RolapStoredMeasure) {
                cubes.add(((RolapStoredMeasure)member).getCube());
                continue;
            }
            if (!(member instanceof RolapHierarchy.RolapCalculatedMeasure) || (baseCube = ((RolapHierarchy.RolapCalculatedMeasure)member).getBaseCube()) == null) continue;
            cubes.add(baseCube);
        }
        return cubes;
    }

    private List<Member> getMeasures(Query query) {
        return ((RolapCube)query.getCube()).getMeasures();
    }

    Pair<String, List<SqlStatement.Type>> sqlForEmptyTuple(DataSource dataSource, Collection<RolapCube> baseCubes) {
        SqlQuery sqlQuery = SqlQuery.newQuery(dataSource, null);
        sqlQuery.addSelect("0", null);
        sqlQuery.addFrom(baseCubes.iterator().next().getFact(), null, true);
        sqlQuery.addWhere("1 = 0");
        return sqlQuery.toSqlAndTypes();
    }

    Pair<String, List<SqlStatement.Type>> generateSelectForLevels(DataSource dataSource, RolapCube baseCube, WhichSelect whichSelect, List<TargetBase> targetGroup) {
        String s = "while generating query to retrieve members of level(s) " + this.targets;
        SqlQuery sqlQuery = SqlQuery.newQuery(dataSource, s);
        sqlQuery.setAllowHints(this.allowHints);
        Evaluator evaluator = this.getEvaluator(this.constraint);
        AggStar aggStar = this.chooseAggStar(this.constraint, evaluator, baseCube);
        for (TargetBase target : targetGroup) {
            if (target.getSrcMembers() != null) continue;
            this.addLevelMemberSql(sqlQuery, target.getLevel(), baseCube, whichSelect, aggStar);
        }
        this.constraint.addConstraint(sqlQuery, baseCube, aggStar);
        return sqlQuery.toSqlAndTypes();
    }

    private boolean targetIsOnBaseCube(TargetBase target, RolapCube baseCube) {
        return target.getLevel().isAll() || baseCube == null || baseCube.findBaseCubeHierarchy(target.getLevel().getHierarchy()) != null;
    }

    private boolean isGroupByNeeded(RolapHierarchy hierarchy, RolapLevel[] levels, int levelDepth) {
        boolean needsGroupBy = false;
        if (hierarchy.getUniqueKeyLevelName() == null) {
            needsGroupBy = true;
        } else {
            boolean foundUniqueKeyLevelName = false;
            for (int i = 0; i <= levelDepth; ++i) {
                RolapLevel lvl = levels[i];
                if (lvl.isAll()) continue;
                if (hierarchy.getUniqueKeyLevelName().equals(lvl.getName())) {
                    foundUniqueKeyLevelName = true;
                }
                for (RolapProperty p : lvl.getProperties()) {
                    if (p.dependsOnLevelValue()) continue;
                    needsGroupBy = true;
                    break;
                }
                if (needsGroupBy) break;
            }
            if (!foundUniqueKeyLevelName) {
                needsGroupBy = true;
            }
        }
        return needsGroupBy;
    }

    protected void addLevelMemberSql(SqlQuery sqlQuery, RolapLevel level, RolapCube baseCube, WhichSelect whichSelect, AggStar aggStar) {
        RolapHierarchy hierarchy = level.getHierarchy();
        if (!level.isAll() && hierarchy instanceof RolapCubeHierarchy) {
            RolapCubeHierarchy cubeHierarchy = (RolapCubeHierarchy)hierarchy;
            if (baseCube != null && !cubeHierarchy.getCube().equals(baseCube)) {
                hierarchy = baseCube.findBaseCubeHierarchy(hierarchy);
            }
        }
        RolapLevel[] levels = (RolapLevel[])hierarchy.getLevels();
        int levelDepth = level.getDepth();
        boolean needsGroupBy = this.isGroupByNeeded(hierarchy, levels, levelDepth);
        for (int i = 0; i <= levelDepth; ++i) {
            RolapProperty[] properties;
            RolapStar.Column starColumn;
            RolapLevel currLevel = levels[i];
            if (currLevel.isAll()) continue;
            boolean levelCollapsed = aggStar != null && SqlMemberSource.isLevelCollapsed(aggStar, (RolapCubeLevel)currLevel);
            boolean multipleCols = SqlMemberSource.levelContainsMultipleColumns(currLevel);
            if (levelCollapsed && !multipleCols) {
                this.addAggColumnToSql(sqlQuery, whichSelect, aggStar, (RolapCubeLevel)currLevel);
                continue;
            }
            Map<MondrianDef.Expression, MondrianDef.Expression> targetExp = this.getLevelTargetExpMap(currLevel, aggStar);
            MondrianDef.Expression keyExp = targetExp.get(currLevel.getKeyExp());
            MondrianDef.Expression ordinalExp = targetExp.get(currLevel.getOrdinalExp());
            MondrianDef.Expression captionExp = targetExp.get(currLevel.getCaptionExp());
            MondrianDef.Expression parentExp = currLevel.getParentExp();
            if (parentExp != null) {
                if (!levelCollapsed) {
                    hierarchy.addToFrom(sqlQuery, parentExp);
                }
                if (whichSelect == WhichSelect.LAST || whichSelect == WhichSelect.ONLY) {
                    String parentSql = parentExp.getExpression(sqlQuery);
                    String parentAlias = sqlQuery.addSelectGroupBy(parentSql, currLevel.getInternalType());
                    sqlQuery.addOrderBy(parentSql, parentAlias, true, false, true, false);
                }
            }
            String keySql = keyExp.getExpression(sqlQuery);
            if (!levelCollapsed) {
                hierarchy.addToFrom(sqlQuery, keyExp);
                hierarchy.addToFrom(sqlQuery, ordinalExp);
            }
            String captionSql = null;
            if (captionExp != null) {
                captionSql = captionExp.getExpression(sqlQuery);
                if (!levelCollapsed) {
                    hierarchy.addToFrom(sqlQuery, captionExp);
                }
            }
            String keyAlias = sqlQuery.addSelect(keySql, currLevel.getInternalType());
            if (needsGroupBy) {
                sqlQuery.addGroupBy(keySql, keyAlias);
            }
            if (captionSql != null) {
                String captionAlias = sqlQuery.addSelect(captionSql, null);
                if (needsGroupBy) {
                    sqlQuery.addGroupBy(captionSql, captionAlias);
                }
            }
            if (!currLevel.getKeyExp().equals(currLevel.getOrdinalExp())) {
                String ordinalSql = ordinalExp.getExpression(sqlQuery);
                String orderByAlias = sqlQuery.addSelect(ordinalSql, null);
                if (needsGroupBy) {
                    sqlQuery.addGroupBy(ordinalSql, orderByAlias);
                }
                if (whichSelect == WhichSelect.ONLY) {
                    sqlQuery.addOrderBy(ordinalSql, orderByAlias, true, false, true, true);
                }
            } else if (whichSelect == WhichSelect.ONLY) {
                sqlQuery.addOrderBy(keySql, keyAlias, true, false, true, true);
            }
            this.constraint.addLevelConstraint(sqlQuery, baseCube, aggStar, currLevel);
            if (levelCollapsed && this.requiresJoinToDim(targetExp)) {
                hierarchy.addToFromInverse(sqlQuery, currLevel.getKeyExp());
                starColumn = ((RolapCubeLevel)currLevel).getStarKeyColumn();
                int bitPos = starColumn.getBitPosition();
                AggStar.Table.Column aggColumn = aggStar.lookupColumn(bitPos);
                RolapStar.Condition condition = new RolapStar.Condition(currLevel.getKeyExp(), aggColumn.getExpression());
                sqlQuery.addWhere(condition.toString(sqlQuery));
                aggColumn.getTable().addToFrom(sqlQuery, false, true);
            } else if (levelCollapsed) {
                starColumn = ((RolapCubeLevel)currLevel).getStarKeyColumn();
                int bitPos = starColumn.getBitPosition();
                AggStar.Table.Column aggColumn = aggStar.lookupColumn(bitPos);
                aggColumn.getTable().addToFrom(sqlQuery, false, true);
            }
            for (RolapProperty property : properties = currLevel.getProperties()) {
                MondrianDef.Expression propExp = targetExp.get(property.getExp());
                String propSql = propExp instanceof MondrianDef.Column ? sqlQuery.getDialect().quoteIdentifier(propExp.getTableAlias(), ((MondrianDef.Column)propExp).name) : property.getExp().getExpression(sqlQuery);
                String propAlias = sqlQuery.addSelect(propSql, property.getType().getInternalType());
                if (!needsGroupBy || sqlQuery.getDialect().allowsSelectNotInGroupBy() && property.dependsOnLevelValue()) continue;
                sqlQuery.addGroupBy(propSql, propAlias);
            }
        }
    }

    private boolean requiresJoinToDim(Map<MondrianDef.Expression, MondrianDef.Expression> targetExp) {
        for (Map.Entry<MondrianDef.Expression, MondrianDef.Expression> entry : targetExp.entrySet()) {
            if (entry.getKey() == null || !entry.getKey().equals(entry.getValue())) continue;
            return true;
        }
        return false;
    }

    private Map<MondrianDef.Expression, MondrianDef.Expression> getLevelTargetExpMap(RolapLevel level, AggStar aggStar) {
        Map<MondrianDef.Expression, MondrianDef.Expression> map = this.initializeIdentityMap(level);
        if (aggStar == null) {
            return Collections.unmodifiableMap(map);
        }
        AggStar.Table.Level aggLevel = this.getAggLevel(aggStar, (RolapCubeLevel)level);
        if (aggLevel == null) {
            AggStar.Table.Column aggStarColumn = this.getAggColumn(aggStar, (RolapCubeLevel)level);
            assert (aggStarColumn.getExpression() != null);
            map.put(level.getKeyExp(), aggStarColumn.getExpression());
        } else {
            assert (aggLevel.getExpression() != null);
            map.put(level.getKeyExp(), aggLevel.getExpression());
            if (aggLevel.getOrdinalExp() != null) {
                map.put(level.getOrdinalExp(), aggLevel.getOrdinalExp());
            }
            if (aggLevel.getCaptionExp() != null) {
                map.put(level.getCaptionExp(), aggLevel.getCaptionExp());
            }
            for (RolapProperty prop : level.getProperties()) {
                String propName = prop.getName();
                if (!aggLevel.getProperties().containsKey(propName)) continue;
                map.put(prop.getExp(), aggLevel.getProperties().get(propName));
            }
        }
        return Collections.unmodifiableMap(map);
    }

    private Map<MondrianDef.Expression, MondrianDef.Expression> initializeIdentityMap(RolapLevel level) {
        HashMap<MondrianDef.Expression, MondrianDef.Expression> map = new HashMap<MondrianDef.Expression, MondrianDef.Expression>();
        map.put(level.getKeyExp(), level.getKeyExp());
        map.put(level.getOrdinalExp(), level.getOrdinalExp());
        map.put(level.getCaptionExp(), level.getCaptionExp());
        for (RolapProperty prop : level.getProperties()) {
            if (map.containsKey(prop.getExp())) continue;
            map.put(prop.getExp(), prop.getExp());
        }
        return map;
    }

    private void addAggColumnToSql(SqlQuery sqlQuery, WhichSelect whichSelect, AggStar aggStar, RolapCubeLevel level) {
        RolapStar.Column starColumn = level.getStarKeyColumn();
        AggStar.Table.Column aggColumn = this.getAggColumn(aggStar, level);
        String aggColExp = aggColumn.generateExprString(sqlQuery);
        String colAlias = sqlQuery.addSelectGroupBy(aggColExp, starColumn.getInternalType());
        if (whichSelect == WhichSelect.ONLY) {
            sqlQuery.addOrderBy(aggColExp, colAlias, true, false, true, true);
        }
        aggColumn.getTable().addToFrom(sqlQuery, false, true);
    }

    private AggStar.Table.Level getAggLevel(AggStar aggStar, RolapCubeLevel level) {
        RolapStar.Column starColumn = level.getStarKeyColumn();
        return aggStar.lookupLevel(starColumn.getBitPosition());
    }

    private AggStar.Table.Column getAggColumn(AggStar aggStar, RolapCubeLevel level) {
        RolapStar.Column starColumn = level.getStarKeyColumn();
        int bitPos = starColumn.getBitPosition();
        return aggStar.lookupColumn(bitPos);
    }

    protected Evaluator getEvaluator(TupleConstraint constraint) {
        DescendantsConstraint descConstraint;
        MemberChildrenConstraint mcc;
        if (constraint instanceof SqlContextConstraint) {
            return constraint.getEvaluator();
        }
        if (constraint instanceof DescendantsConstraint && (mcc = (descConstraint = (DescendantsConstraint)constraint).getMemberChildrenConstraint(null)) instanceof SqlContextConstraint) {
            SqlContextConstraint scc = (SqlContextConstraint)mcc;
            return scc.getEvaluator();
        }
        return null;
    }

    AggStar chooseAggStar(TupleConstraint constraint, Evaluator evaluator, RolapCube baseCube) {
        BitKey levelBitKey;
        BitKey measureBitKey;
        RolapStar star;
        block11: {
            RolapStar.Column column;
            block10: {
                if (!MondrianProperties.instance().UseAggregates.get()) {
                    return null;
                }
                if (evaluator == null || !constraint.supportsAggTables()) {
                    return null;
                }
                if (baseCube == null) {
                    baseCube = (RolapCube)evaluator.getCube();
                }
                if (baseCube.isVirtual()) {
                    return null;
                }
                star = baseCube.getStar();
                int starColumnCount = star.getColumnCount();
                measureBitKey = BitKey.Factory.makeBitKey(starColumnCount);
                levelBitKey = BitKey.Factory.makeBitKey(starColumnCount);
                Member[] members = SqlConstraintUtils.expandSupportedCalculatedMembers(Arrays.asList(evaluator.getNonAllMembers()), evaluator).getMembersArray();
                if (!(members[0] instanceof RolapBaseCubeMeasure)) {
                    return null;
                }
                RolapBaseCubeMeasure measure = (RolapBaseCubeMeasure)members[0];
                int bitPosition = ((RolapStar.Measure)measure.getStarMeasure()).getBitPosition();
                CellRequest request = RolapAggregationManager.makeRequest(members);
                if (request == null) {
                    return null;
                }
                RolapStar.Column[] columns = request.getConstrainedColumns();
                for (RolapStar.Column column1 : columns) {
                    levelBitKey.set(column1.getBitPosition());
                }
                for (TargetBase target : this.targets) {
                    RolapLevel level = target.level;
                    if (level.isAll() || (column = ((RolapCubeLevel)level).getBaseStarKeyColumn(baseCube)) == null) continue;
                    levelBitKey.set(column.getBitPosition());
                }
                RolapUtil.constraintBitkeyForLimitedMembers(evaluator, evaluator.getMembers(), baseCube, levelBitKey);
                measureBitKey.set(bitPosition);
                if (!(constraint instanceof RolapNativeCrossJoin.NonEmptyCrossJoinConstraint)) break block10;
                RolapNativeCrossJoin.NonEmptyCrossJoinConstraint necj = (RolapNativeCrossJoin.NonEmptyCrossJoinConstraint)constraint;
                for (CrossJoinArg arg : necj.args) {
                    RolapStar.Column column2;
                    RolapLevel level;
                    if (!(arg instanceof DescendantsCrossJoinArg) && !(arg instanceof MemberListCrossJoinArg) || (level = arg.getLevel()) == null || level.isAll() || (column2 = ((RolapCubeLevel)level).getBaseStarKeyColumn(baseCube)) == null) continue;
                    levelBitKey.set(column2.getBitPosition());
                }
                break block11;
            }
            if (!(constraint instanceof RolapNativeFilter.FilterConstraint)) break block11;
            for (Member slicer : ((RolapEvaluator)evaluator).getSlicerMembers()) {
                Level level = slicer.getLevel();
                if (level == null || level.isAll()) continue;
                column = ((RolapCubeLevel)level).getBaseStarKeyColumn(baseCube);
                levelBitKey.set(column.getBitPosition());
            }
        }
        return AggregationManager.findAgg(star, levelBitKey, measureBitKey, new boolean[]{false});
    }

    int getMaxRows() {
        return this.maxRows;
    }

    void setMaxRows(int maxRows) {
        this.maxRows = maxRows;
    }

    static enum WhichSelect {
        ONLY,
        NOT_LAST,
        LAST;

    }

    private class Target
    extends TargetBase {
        final MemberCache cache;
        RolapLevel[] levels;
        int levelDepth;
        boolean parentChild;
        List<RolapMember> members;
        final HashMap<Object, RolapMember> keyToMember;
        List<List<RolapMember>> siblings;

        public Target(RolapLevel level, TupleReader.MemberBuilder memberBuilder, List<RolapMember> srcMembers) {
            super(srcMembers, level, memberBuilder);
            this.keyToMember = new HashMap();
            this.cache = memberBuilder.getMemberCache();
        }

        @Override
        public void open() {
            this.levels = (RolapLevel[])this.level.getHierarchy().getLevels();
            this.setList(new ArrayList<RolapMember>());
            this.levelDepth = this.level.getDepth();
            this.parentChild = this.level.isParentChild();
            this.members = new ArrayList<Object>(Collections.nCopies(this.levels.length, null));
            this.siblings = new ArrayList<List<RolapMember>>();
            for (int i = 0; i < this.levels.length + 1; ++i) {
                this.siblings.add(new ArrayList());
            }
        }

        @Override
        int internalAddRow(SqlStatement stmt, int column) throws SQLException {
            RolapMember member = null;
            if (this.getCurrMember() != null) {
                this.setCurrMember(member);
            } else {
                boolean checkCacheStatus = true;
                for (int i = 0; i <= this.levelDepth; ++i) {
                    MemberChildrenConstraint mcc;
                    Comparable<?> value;
                    RolapLevel childLevel = this.levels[i];
                    if (childLevel.isAll()) {
                        member = this.memberBuilder.allMember();
                        continue;
                    }
                    RolapMember parentMember = member;
                    List<SqlStatement.Accessor> accessors = stmt.getAccessors();
                    if (this.parentChild) {
                        Comparable<?> parentValue;
                        if ((parentValue = accessors.get(column++).get()) == null || parentValue.toString().equals(childLevel.getNullParentValue())) {
                            parentValue = RolapUtil.sqlNullValue;
                        } else {
                            Object parentKey = this.cache.makeKey(member, parentValue);
                            parentMember = this.cache.getMember(parentKey);
                            if (parentMember == null) {
                                parentMember = this.keyToMember.get(parentValue);
                            }
                            if (parentMember == null) {
                                LOGGER.warn((Object)MondrianResource.instance().LevelTableParentNotFound.str(childLevel.getUniqueName(), String.valueOf(parentValue)));
                            }
                        }
                    }
                    if ((value = accessors.get(column++).get()) == null) {
                        value = RolapUtil.sqlNullValue;
                    }
                    Object captionValue = childLevel.hasCaptionColumn() ? accessors.get(column++).get() : null;
                    Object key = this.parentChild ? this.cache.makeKey(member, value) : this.cache.makeKey(parentMember, value);
                    member = this.cache.getMember(key, checkCacheStatus);
                    checkCacheStatus = false;
                    if (member == null) {
                        if (SqlTupleReader.this.constraint instanceof RolapNativeCrossJoin.NonEmptyCrossJoinConstraint && childLevel.isParentChild()) {
                            member = this.castToNonEmptyCJConstraint(SqlTupleReader.this.constraint).findMember(value);
                        }
                        if (member == null) {
                            member = this.memberBuilder.makeMember(parentMember, childLevel, value, captionValue, this.parentChild, stmt, key, column);
                        }
                    }
                    if (!childLevel.getOrdinalExp().equals(childLevel.getKeyExp())) {
                        Object ordinal = accessors.get(column++).get();
                        Object prevValue = SqlTupleReader.this.rolapToOrdinalMap.put(member, ordinal);
                        if (prevValue != null && !Util.equals(prevValue, ordinal)) {
                            LOGGER.error((Object)("Column expression for " + member.getUniqueName() + " is inconsistent with ordinal or caption expression. It should have 1:1 relationship"));
                        }
                    }
                    column += childLevel.getProperties().length;
                    this.keyToMember.put(member.getKey(), member);
                    if (member == this.members.get(i)) continue;
                    List<RolapMember> children = this.siblings.get(i + 1);
                    if (children != null && (mcc = SqlTupleReader.this.constraint.getMemberChildrenConstraint(this.members.get(i))) != null) {
                        this.cache.putChildren(this.members.get(i), mcc, children);
                    }
                    mcc = SqlTupleReader.this.constraint.getMemberChildrenConstraint(member);
                    List<RolapMember> cachedChildren = this.cache.getChildrenFromCache(member, mcc);
                    if (i < this.levelDepth && cachedChildren == null) {
                        this.siblings.set(i + 1, new ArrayList());
                    } else {
                        this.siblings.set(i + 1, null);
                    }
                    this.members.set(i, member);
                    if (this.siblings.get(i) == null) continue;
                    if (value == RolapUtil.sqlNullValue) {
                        this.addAsOldestSibling(this.siblings.get(i), member);
                        continue;
                    }
                    this.siblings.get(i).add(member);
                }
                this.setCurrMember(member);
            }
            this.getList().add(member);
            return column;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<Member> close() {
            Object object = this.cacheLock;
            synchronized (object) {
                return this.internalClose();
            }
        }

        public List<Member> internalClose() {
            for (int i = 0; i < this.members.size(); ++i) {
                MemberChildrenConstraint mcc;
                RolapMember member = this.members.get(i);
                List<RolapMember> children = this.siblings.get(i + 1);
                if (member == null || children == null || member.getDepth() < this.level.getDepth() || (mcc = SqlTupleReader.this.constraint.getMemberChildrenConstraint(member)) == null) continue;
                this.cache.putChildren(member, mcc, children);
            }
            return Util.cast(this.getList());
        }

        private void addAsOldestSibling(List<RolapMember> list, RolapMember member) {
            RolapMember sibling;
            int i = list.size();
            while (--i >= 0 && (sibling = list.get(i)).getParentMember() == member.getParentMember()) {
            }
            list.add(i + 1, member);
        }
    }
}

