/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import mondrian.olap.Exp;
import mondrian.olap.FunDef;
import mondrian.olap.NativeEvaluator;
import mondrian.rolap.RolapEvaluator;
import mondrian.rolap.RolapNative;
import mondrian.rolap.RolapNativeCrossJoin;
import mondrian.rolap.RolapNativeFilter;
import mondrian.rolap.RolapNativeSet;
import mondrian.rolap.RolapNativeTopCount;

public class RolapNativeRegistry
extends RolapNative {
    private Map<String, RolapNative> nativeEvaluatorMap = new HashMap<String, RolapNative>();
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final Lock readLock = this.readWriteLock.readLock();
    private final Lock writeLock = this.readWriteLock.writeLock();

    public RolapNativeRegistry() {
        super.setEnabled(true);
        this.register("NonEmptyCrossJoin".toUpperCase(), new RolapNativeCrossJoin());
        this.register("CrossJoin".toUpperCase(), new RolapNativeCrossJoin());
        this.register("TopCount".toUpperCase(), new RolapNativeTopCount());
        this.register("Filter".toUpperCase(), new RolapNativeFilter());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NativeEvaluator createEvaluator(RolapEvaluator evaluator, FunDef fun, Exp[] args) {
        if (!this.isEnabled()) {
            return null;
        }
        RolapNative rn = null;
        this.readLock.lock();
        try {
            rn = this.nativeEvaluatorMap.get(fun.getName().toUpperCase());
        }
        finally {
            this.readLock.unlock();
        }
        if (rn == null) {
            return null;
        }
        NativeEvaluator ne = rn.createEvaluator(evaluator, fun, args);
        if (ne != null && this.listener != null) {
            RolapNative.NativeEvent e = new RolapNative.NativeEvent(this, ne);
            this.listener.foundEvaluator(e);
        }
        return ne;
    }

    public void register(String funName, RolapNative rn) {
        this.writeLock.lock();
        try {
            this.nativeEvaluatorMap.put(funName, rn);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void setListener(RolapNative.Listener listener) {
        super.setListener(listener);
        this.readLock.lock();
        try {
            for (RolapNative rn : this.nativeEvaluatorMap.values()) {
                rn.setListener(listener);
            }
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void useHardCache(boolean hard) {
        this.readLock.lock();
        try {
            for (RolapNative rn : this.nativeEvaluatorMap.values()) {
                rn.useHardCache(hard);
            }
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void flushAllNativeSetCache() {
        this.readLock.lock();
        try {
            for (String key : this.nativeEvaluatorMap.keySet()) {
                RolapNative currentRolapNative = this.nativeEvaluatorMap.get(key);
                if (!(currentRolapNative instanceof RolapNativeSet) || currentRolapNative == null) continue;
                RolapNativeSet currentRolapNativeSet = (RolapNativeSet)currentRolapNative;
                currentRolapNativeSet.flushCache();
            }
        }
        finally {
            this.readLock.unlock();
        }
    }
}

