/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import mondrian.calc.Calc;
import mondrian.calc.CalcWriter;
import mondrian.calc.ExpCompiler;
import mondrian.calc.IterCalc;
import mondrian.calc.ListCalc;
import mondrian.calc.ResultStyle;
import mondrian.calc.TupleCollections;
import mondrian.calc.TupleIterable;
import mondrian.calc.TupleList;
import mondrian.calc.impl.AbstractListCalc;
import mondrian.calc.impl.DelegatingTupleList;
import mondrian.mdx.LevelExpr;
import mondrian.mdx.MdxVisitorImpl;
import mondrian.mdx.MemberExpr;
import mondrian.mdx.NamedSetExpr;
import mondrian.mdx.ResolvedFunCall;
import mondrian.mdx.UnresolvedFunCall;
import mondrian.olap.Annotated;
import mondrian.olap.Dimension;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.Formula;
import mondrian.olap.FunDef;
import mondrian.olap.Hierarchy;
import mondrian.olap.Id;
import mondrian.olap.Level;
import mondrian.olap.Member;
import mondrian.olap.MemberProperty;
import mondrian.olap.MondrianProperties;
import mondrian.olap.OlapElement;
import mondrian.olap.Query;
import mondrian.olap.SchemaReader;
import mondrian.olap.Syntax;
import mondrian.olap.Util;
import mondrian.olap.Validator;
import mondrian.olap.fun.CacheFunDef;
import mondrian.olap.fun.CrossJoinFunDef;
import mondrian.olap.fun.FunDefBase;
import mondrian.olap.fun.LevelMembersFunDef;
import mondrian.olap.fun.ReflectiveMultiResolver;
import mondrian.olap.fun.SetFunDef;
import mondrian.olap.type.Type;
import mondrian.resource.MondrianResource;
import org.apache.log4j.Logger;
import org.olap4j.impl.Olap4jUtil;

public class NativizeSetFunDef
extends FunDefBase {
    protected static final Logger LOGGER = Logger.getLogger(NativizeSetFunDef.class);
    private static final String SENTINEL_PREFIX = "_Nativized_Sentinel_";
    private static final String MEMBER_NAME_PREFIX = "_Nativized_Member_";
    private static final String SET_NAME_PREFIX = "_Nativized_Set_";
    private static final List<Class<? extends FunDef>> functionWhitelist = Arrays.asList(CacheFunDef.class, SetFunDef.class, CrossJoinFunDef.class, NativizeSetFunDef.class);
    static final ReflectiveMultiResolver Resolver = new ReflectiveMultiResolver("NativizeSet", "NativizeSet(<Set>)", "Tries to natively evaluate <Set>.", new String[]{"fxx"}, NativizeSetFunDef.class);
    private final SubstitutionMap substitutionMap = new SubstitutionMap();
    private final HashSet<Dimension> dimensions = new LinkedHashSet<Dimension>();
    private boolean isFirstCompileCall = true;
    private Exp originalExp;
    private static final String ESTIMATE_MESSAGE = "isHighCardinality=%b: estimate=%,d threshold=%,d";
    private static final String PARTIAL_ESTIMATE_MESSAGE = "isHighCardinality=%b: partial estimate=%,d threshold=%,d";

    public NativizeSetFunDef(FunDef dummyFunDef) {
        super(dummyFunDef);
        LOGGER.debug((Object)"---- NativizeSetFunDef constructor");
    }

    @Override
    public Exp createCall(Validator validator, Exp[] args) {
        LOGGER.debug((Object)"NativizeSetFunDef createCall");
        ResolvedFunCall call = (ResolvedFunCall)super.createCall(validator, args);
        call.accept(new FindLevelsVisitor(this.substitutionMap, this.dimensions));
        return call;
    }

    @Override
    public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
        LOGGER.debug((Object)"NativizeSetFunDef compileCall");
        Exp funArg = call.getArg(0);
        if (MondrianProperties.instance().UseAggregates.get() || MondrianProperties.instance().ReadAggregates.get()) {
            return funArg.accept(compiler);
        }
        Calc[] calcs = new Calc[]{compiler.compileList(funArg, true)};
        int arity = calcs[0].getType().getArity();
        assert (arity >= 0);
        if (arity == 1 || this.substitutionMap.isEmpty()) {
            boolean highCardinality;
            IterCalc calc = (IterCalc)funArg.accept(compiler);
            boolean bl = highCardinality = arity == 1 && this.isHighCardinality(funArg, compiler.getEvaluator());
            if (calc != null) {
                if (calc instanceof ListCalc) {
                    return new NonNativeListCalc((ListCalc)calc, highCardinality);
                }
                return new NonNativeIterCalc(calc, highCardinality);
            }
        }
        if (this.isFirstCompileCall) {
            this.isFirstCompileCall = false;
            this.originalExp = funArg.clone();
            Query query = compiler.getEvaluator().getQuery();
            call.accept(new AddFormulasVisitor(query, this.substitutionMap, this.dimensions));
            call.accept(new TransformToFormulasVisitor(query));
            query.resolve();
        }
        return new NativeListCalc(call, calcs, compiler, this.substitutionMap, this.originalExp);
    }

    private boolean isHighCardinality(Exp funArg, Evaluator evaluator) {
        Level level = this.findLevel(funArg);
        if (level != null) {
            int minThreshold;
            int cardinality = evaluator.getSchemaReader().getLevelCardinality(level, false, true);
            boolean isHighCard = cardinality > (minThreshold = MondrianProperties.instance().NativizeMinThreshold.get());
            NativizeSetFunDef.logHighCardinality(ESTIMATE_MESSAGE, minThreshold, cardinality, isHighCard);
            return isHighCard;
        }
        return false;
    }

    private Level findLevel(Exp exp) {
        exp.accept(new FindLevelsVisitor(this.substitutionMap, this.dimensions));
        Collection<Level> levels = this.substitutionMap.values();
        if (levels.size() == 1) {
            return levels.iterator().next();
        }
        return null;
    }

    private static void logHighCardinality(String estimateMessage, long nativizeMinThreshold, long estimatedCardinality, boolean highCardinality) {
        LOGGER.debug((Object)String.format(estimateMessage, highCardinality, estimatedCardinality, nativizeMinThreshold));
    }

    private static Id createSentinelId(Level level) {
        return NativizeSetFunDef.hierarchyId(level).append(NativizeSetFunDef.q(NativizeSetFunDef.createMangledName(level, SENTINEL_PREFIX)));
    }

    private static Id createMemberId(Level level) {
        return NativizeSetFunDef.hierarchyId(level).append(NativizeSetFunDef.q(NativizeSetFunDef.createMangledName(level, MEMBER_NAME_PREFIX)));
    }

    private static Id createSetId(Level level) {
        return new Id(NativizeSetFunDef.q(NativizeSetFunDef.createMangledName(level, SET_NAME_PREFIX)));
    }

    private static Id hierarchyId(Level level) {
        Id id = new Id(NativizeSetFunDef.q(level.getDimension().getName()));
        if (MondrianProperties.instance().SsasCompatibleNaming.get()) {
            id = id.append(NativizeSetFunDef.q(level.getHierarchy().getName()));
        }
        return id;
    }

    private static Id.Segment q(String s) {
        return new Id.NameSegment(s);
    }

    private static String createMangledName(Level level, String prefix) {
        return prefix + level.getUniqueName().replaceAll("[\\[\\]]", "").replaceAll("\\.", "_") + "_";
    }

    private static void dumpListToLog(String heading, TupleList list) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)String.format("%s created with %,d rows.", heading, list.size()));
            StringBuilder buf = new StringBuilder(Util.nl);
            for (List element : list) {
                buf.append(Util.nl);
                buf.append(element);
            }
            LOGGER.debug((Object)buf.toString());
        }
    }

    private static <T> String toCsv(Collection<T> list) {
        StringBuilder buf = new StringBuilder();
        String sep = "";
        for (T element : list) {
            buf.append(sep).append(element);
            sep = ", ";
        }
        return buf.toString();
    }

    private static String getLevelNameFromMemberName(String memberName) {
        String[] tokens = memberName.split("_");
        return tokens[tokens.length - 1];
    }

    static enum NativeElementType {
        LEVEL_MEMBERS(true),
        ENUMERATED_VALUE(true),
        OTHER_NATIVE(true),
        NON_NATIVE(false),
        SENTINEL(false);

        private final boolean isNativeCompatible;

        private NativeElementType(boolean isNativeCompatible) {
            this.isNativeCompatible = isNativeCompatible;
        }

        public boolean isNativeCompatible() {
            return this.isNativeCompatible;
        }
    }

    private static class ReassemblyCommand {
        private final OlapElement element;
        private final String elementName;
        private final NativeElementType memberType;
        private ReassemblyGuide nextColGuide;

        public ReassemblyCommand(Member member, NativeElementType memberType) {
            this.element = member;
            this.memberType = memberType;
            this.elementName = member.toString();
        }

        public ReassemblyCommand(Level level, NativeElementType memberType) {
            this.element = level;
            this.memberType = memberType;
            this.elementName = level.toString() + ".members";
        }

        public OlapElement getElement() {
            return this.element;
        }

        public String getElementName() {
            return this.elementName;
        }

        public Member getMember() {
            return (Member)this.element;
        }

        public Level getLevel() {
            return (Level)this.element;
        }

        public boolean hasNextGuide() {
            return this.nextColGuide != null;
        }

        public ReassemblyGuide forNextCol() {
            return this.nextColGuide;
        }

        public ReassemblyGuide forNextCol(int index) {
            if (this.nextColGuide == null) {
                this.nextColGuide = new ReassemblyGuide(index);
            }
            return this.nextColGuide;
        }

        public NativeElementType getMemberType() {
            return this.memberType;
        }

        public static Set<NativeElementType> getMemberTypes(Collection<ReassemblyCommand> commands) {
            Set types = Olap4jUtil.enumSetNoneOf(NativeElementType.class);
            for (ReassemblyCommand command : commands) {
                types.add(command.getMemberType());
            }
            return types;
        }

        public String toString() {
            return this.memberType.toString() + ": " + this.getElementName();
        }
    }

    private static class ReassemblyGuide {
        private final int index;
        private final List<ReassemblyCommand> commands = new ArrayList<ReassemblyCommand>();

        public ReassemblyGuide(int index) {
            this.index = index;
        }

        public int getIndex() {
            return this.index;
        }

        public List<ReassemblyCommand> getCommands() {
            return Collections.unmodifiableList(this.commands);
        }

        private void addCommandTuple(List<ReassemblyCommand> commandTuple) {
            ReassemblyCommand curr = this.currentCommand(commandTuple);
            if (this.index < commandTuple.size() - 1) {
                curr.forNextCol(this.index + 1).addCommandTuple(commandTuple);
            }
        }

        private ReassemblyCommand currentCommand(List<ReassemblyCommand> commandTuple) {
            ReassemblyCommand prev;
            ReassemblyCommand curr = commandTuple.get(this.index);
            ReassemblyCommand reassemblyCommand = prev = this.commands.isEmpty() ? null : this.commands.get(this.commands.size() - 1);
            if (prev != null && prev.getMemberType() == NativeElementType.SENTINEL) {
                this.commands.set(this.commands.size() - 1, curr);
            } else if (prev == null || !prev.getElement().equals(curr.getElement())) {
                this.commands.add(curr);
            } else {
                curr = prev;
            }
            return curr;
        }

        public String toString() {
            return "" + this.index + ":" + this.commands.toString().replaceAll("=null", "").replaceAll("=", " ") + " ";
        }
    }

    public static class RangeIterator
    implements Iterator<Range> {
        private final Range parent;
        private final int col;
        private Range precomputed;

        public RangeIterator(Range parent, int col) {
            this.parent = parent;
            this.col = col;
            this.precomputed = this.next(parent.from);
        }

        @Override
        public boolean hasNext() {
            return this.precomputed != null;
        }

        private Range next(int cursor) {
            return cursor >= this.parent.to ? null : this.parent.subRangeStartingAt(cursor, this.col);
        }

        @Override
        public Range next() {
            if (this.precomputed == null) {
                throw new NoSuchElementException();
            }
            Range it = this.precomputed;
            this.precomputed = this.next(this.precomputed.to);
            return it;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    static class Range {
        private final TupleList list;
        private final int from;
        private final int to;

        public Range(TupleList list) {
            this(list, 0, list.size());
        }

        private Range(TupleList list, int from, int to) {
            if (from < 0) {
                throw new IllegalArgumentException("from is must be >= 0");
            }
            if (to > list.size()) {
                throw new IllegalArgumentException("to must be <= to list size");
            }
            if (from > to) {
                throw new IllegalArgumentException("from must be <= to");
            }
            this.list = list;
            this.from = from;
            this.to = to;
        }

        public boolean isEmpty() {
            return this.size() == 0;
        }

        public int size() {
            return this.to - this.from;
        }

        public List<Member> getTuple() {
            if (this.from >= this.list.size()) {
                throw new NoSuchElementException();
            }
            return (List)this.list.get(this.from);
        }

        public List<List<Member>> getTuples() {
            if (this.from == 0 && this.to == this.list.size()) {
                return this.list;
            }
            return this.list.subList(this.from, this.to);
        }

        public Member getMember(int cursor, int col) {
            return (Member)((List)this.list.get(cursor)).get(col);
        }

        public String toString() {
            return "[" + this.from + " : " + this.to + "]";
        }

        private Range subRange(int fromRow, int toRow) {
            return new Range(this.list, fromRow, toRow);
        }

        public Range subRangeForValue(Member value, int col) {
            int startAt = this.nextMatching(value, this.from, col);
            int endAt = this.nextNonMatching(value, startAt + 1, col);
            return this.subRange(startAt, endAt);
        }

        public Range subRangeForValue(Level level, int col) {
            int startAt = this.nextMatching(level, this.from, col);
            int endAt = this.nextNonMatching(level, startAt + 1, col);
            return this.subRange(startAt, endAt);
        }

        public Range subRangeStartingAt(int startAt, int col) {
            Member value = (Member)((List)this.list.get(startAt)).get(col);
            int endAt = this.nextNonMatching(value, startAt + 1, col);
            return this.subRange(startAt, endAt);
        }

        private int nextMatching(Member value, int startAt, int col) {
            for (int cursor = startAt; cursor < this.to; ++cursor) {
                if (!value.equals(((List)this.list.get(cursor)).get(col))) continue;
                return cursor;
            }
            return this.to;
        }

        private int nextMatching(Level level, int startAt, int col) {
            for (int cursor = startAt; cursor < this.to; ++cursor) {
                if (!level.equals(((Member)((List)this.list.get(cursor)).get(col)).getLevel())) continue;
                return cursor;
            }
            return this.to;
        }

        private int nextNonMatching(Member value, int startAt, int col) {
            if (value == null) {
                return this.nextNonNull(startAt, col);
            }
            for (int cursor = startAt; cursor < this.to; ++cursor) {
                if (value.equals(((List)this.list.get(cursor)).get(col))) continue;
                return cursor;
            }
            return this.to;
        }

        private int nextNonMatching(Level level, int startAt, int col) {
            if (level == null) {
                return this.nextNonNull(startAt, col);
            }
            for (int cursor = startAt; cursor < this.to; ++cursor) {
                if (level.equals(((Member)((List)this.list.get(cursor)).get(col)).getLevel())) continue;
                return cursor;
            }
            return this.to;
        }

        private int nextNonNull(int startAt, int col) {
            for (int cursor = startAt; cursor < this.to; ++cursor) {
                if (((List)this.list.get(cursor)).get(col) == null) continue;
                return cursor;
            }
            return this.to;
        }

        public Iterable<Range> subRanges(final int col) {
            final Range parent = this;
            return new Iterable<Range>(){
                final int rangeCol;
                {
                    this.rangeCol = col;
                }

                @Override
                public Iterator<Range> iterator() {
                    return new RangeIterator(parent, this.rangeCol);
                }
            };
        }

        public Iterable<Member> getMembers(final int col) {
            return new Iterable<Member>(){

                @Override
                public Iterator<Member> iterator() {
                    return new Iterator<Member>(){
                        private int cursor;
                        {
                            this.cursor = from;
                        }

                        @Override
                        public boolean hasNext() {
                            return this.cursor < to;
                        }

                        @Override
                        public Member next() {
                            if (!this.hasNext()) {
                                throw new NoSuchElementException();
                            }
                            return this.getMember(this.cursor++, col);
                        }

                        @Override
                        public void remove() {
                            throw new UnsupportedOperationException();
                        }
                    };
                }
            };
        }
    }

    public static class CrossJoinAnalyzer {
        private final int arity;
        private final Member[] tempTuple;
        private final List<Member> tempTupleAsList;
        private final int[] nativeIndices;
        private final int resultLimit;
        private final List<Collection<String>> nativeMembers;
        private final ReassemblyGuide reassemblyGuide;
        private final TupleList resultList;

        public CrossJoinAnalyzer(TupleList simplifiedList, SubstitutionMap substitutionMap) {
            long nativizeMaxResults = MondrianProperties.instance().NativizeMaxResults.get();
            this.arity = simplifiedList.getArity();
            this.tempTuple = new Member[this.arity];
            this.tempTupleAsList = Arrays.asList(this.tempTuple);
            this.resultLimit = nativizeMaxResults <= 0L ? Integer.MAX_VALUE : (int)Math.min(nativizeMaxResults, Integer.MAX_VALUE);
            this.resultList = TupleCollections.createList(this.arity);
            this.reassemblyGuide = this.classifyMembers(simplifiedList, substitutionMap);
            this.nativeMembers = this.findNativeMembers();
            this.nativeIndices = this.findNativeIndices();
        }

        public ReassemblyGuide classifyMembers(TupleList simplifiedList, SubstitutionMap substitutionMap) {
            ReassemblyGuide guide = new ReassemblyGuide(0);
            ArrayList<ReassemblyCommand> cmdTuple = new ArrayList<ReassemblyCommand>(this.arity);
            for (List srcTuple : simplifiedList) {
                cmdTuple.clear();
                for (Member mbr : srcTuple) {
                    cmdTuple.add(this.zz(substitutionMap, mbr));
                }
                guide.addCommandTuple(cmdTuple);
            }
            return guide;
        }

        private ReassemblyCommand zz(SubstitutionMap substitutionMap, Member mbr) {
            ReassemblyCommand c;
            if (substitutionMap.contains(mbr)) {
                c = new ReassemblyCommand(substitutionMap.get(mbr), NativeElementType.LEVEL_MEMBERS);
            } else if (mbr.getName().startsWith(NativizeSetFunDef.SENTINEL_PREFIX)) {
                c = new ReassemblyCommand(mbr, NativeElementType.SENTINEL);
            } else {
                NativeElementType nativeType = !this.isNativeCompatible(mbr) ? NativeElementType.NON_NATIVE : (mbr.getMemberType() == Member.MemberType.REGULAR ? NativeElementType.ENUMERATED_VALUE : NativeElementType.OTHER_NATIVE);
                c = new ReassemblyCommand(mbr, nativeType);
            }
            return c;
        }

        private List<Collection<String>> findNativeMembers() {
            ArrayList<Collection<String>> nativeMembers = new ArrayList<Collection<String>>(this.arity);
            for (int i = 0; i < this.arity; ++i) {
                nativeMembers.add(new LinkedHashSet());
            }
            this.findNativeMembers(this.reassemblyGuide, nativeMembers);
            return nativeMembers;
        }

        private void findNativeMembers(ReassemblyGuide guide, List<Collection<String>> nativeMembers) {
            List<ReassemblyCommand> commands = guide.getCommands();
            Set<NativeElementType> typesToAdd = ReassemblyCommand.getMemberTypes(commands);
            if (typesToAdd.contains((Object)NativeElementType.LEVEL_MEMBERS)) {
                typesToAdd.remove((Object)NativeElementType.ENUMERATED_VALUE);
            }
            int index = guide.getIndex();
            for (ReassemblyCommand command : commands) {
                NativeElementType type = command.getMemberType();
                if (type.isNativeCompatible() && typesToAdd.contains((Object)type)) {
                    nativeMembers.get(index).add(command.getElementName());
                }
                if (!command.hasNextGuide()) continue;
                this.findNativeMembers(command.forNextCol(), nativeMembers);
            }
        }

        private int[] findNativeIndices() {
            int[] indices = new int[this.arity];
            int nativeColCount = 0;
            for (int i = 0; i < this.arity; ++i) {
                Collection<String> natives = this.nativeMembers.get(i);
                if (natives.isEmpty()) continue;
                indices[nativeColCount++] = i;
            }
            if (nativeColCount == this.arity) {
                return indices;
            }
            int[] result = new int[nativeColCount];
            System.arraycopy(indices, 0, result, 0, nativeColCount);
            return result;
        }

        private boolean isNativeCompatible(Member member) {
            return member.isParentChildLeaf() || !member.isMeasure() && !member.isCalculated() && !member.isAll();
        }

        private String getCrossJoinExpression() {
            return this.formatCrossJoin(this.nativeMembers);
        }

        private String formatCrossJoin(List<Collection<String>> memberLists) {
            String right;
            StringBuilder buf = new StringBuilder();
            String left = NativizeSetFunDef.toCsv(memberLists.get(0));
            String string = right = memberLists.size() == 1 ? "" : this.formatCrossJoin(memberLists.subList(1, memberLists.size()));
            if (left.length() == 0) {
                buf.append(right);
            } else if (right.length() == 0) {
                buf.append("{").append(left).append("}");
            } else {
                buf.append("CrossJoin(").append("{").append(left).append("},").append(right).append(")");
            }
            return buf.toString();
        }

        private TupleList mergeCalcMembers(TupleList nativeValues) {
            TupleList nativeList = this.adaptList(nativeValues, this.arity, this.nativeIndices);
            NativizeSetFunDef.dumpListToLog("native list", nativeList);
            this.mergeCalcMembers(this.reassemblyGuide, new Range(nativeList), null);
            NativizeSetFunDef.dumpListToLog("result list", this.resultList);
            return this.resultList;
        }

        private void mergeCalcMembers(ReassemblyGuide guide, Range range, Set<List<Member>> history) {
            int col = guide.getIndex();
            if (col == this.arity - 1) {
                if (history == null) {
                    this.appendMembers(guide, range);
                } else {
                    this.appendMembers(guide, range, history);
                }
                return;
            }
            block6: for (ReassemblyCommand command : guide.getCommands()) {
                ReassemblyGuide nextGuide = command.forNextCol();
                this.tempTuple[col] = null;
                switch (command.getMemberType()) {
                    case NON_NATIVE: {
                        this.tempTuple[col] = command.getMember();
                        this.mergeCalcMembers(nextGuide, range, (Set<List<Member>>)(history == null ? new HashSet<List<Member>>() : history));
                        break;
                    }
                    case ENUMERATED_VALUE: {
                        Member value = command.getMember();
                        Range valueRange = range.subRangeForValue(value, col);
                        if (valueRange.isEmpty()) continue block6;
                        this.mergeCalcMembers(nextGuide, valueRange, history);
                        break;
                    }
                    case LEVEL_MEMBERS: {
                        Level level = command.getLevel();
                        Range levelRange = range.subRangeForValue(level, col);
                        for (Range subRange : levelRange.subRanges(col)) {
                            this.mergeCalcMembers(nextGuide, subRange, history);
                        }
                        continue block6;
                    }
                    case OTHER_NATIVE: {
                        for (Range subRange : range.subRanges(col)) {
                            this.mergeCalcMembers(nextGuide, subRange, history);
                        }
                        continue block6;
                    }
                    default: {
                        throw Util.unexpected(command.getMemberType());
                    }
                }
            }
        }

        private void appendMembers(ReassemblyGuide guide, Range range) {
            int col = guide.getIndex();
            block5: for (ReassemblyCommand command : guide.getCommands()) {
                switch (command.getMemberType()) {
                    case NON_NATIVE: {
                        this.tempTuple[col] = command.getMember();
                        this.appendTuple(range.getTuple(), this.tempTupleAsList);
                        break;
                    }
                    case ENUMERATED_VALUE: {
                        Member value = command.getMember();
                        Range valueRange = range.subRangeForValue(value, col);
                        if (valueRange.isEmpty()) continue block5;
                        this.appendTuple(valueRange.getTuple());
                        break;
                    }
                    case LEVEL_MEMBERS: 
                    case OTHER_NATIVE: {
                        for (List<Member> tuple : range.getTuples()) {
                            this.appendTuple(tuple);
                        }
                        continue block5;
                    }
                    default: {
                        throw Util.unexpected(command.getMemberType());
                    }
                }
            }
        }

        private void appendMembers(ReassemblyGuide guide, Range range, Set<List<Member>> history) {
            int col = guide.getIndex();
            block5: for (ReassemblyCommand command : guide.getCommands()) {
                switch (command.getMemberType()) {
                    case NON_NATIVE: {
                        this.tempTuple[col] = command.getMember();
                        if (range.isEmpty()) {
                            this.appendTuple(this.tempTupleAsList, history);
                            break;
                        }
                        this.appendTuple(range.getTuple(), this.tempTupleAsList, history);
                        break;
                    }
                    case ENUMERATED_VALUE: {
                        Member value = command.getMember();
                        Range valueRange = range.subRangeForValue(value, col);
                        if (valueRange.isEmpty()) continue block5;
                        this.appendTuple(valueRange.getTuple(), this.tempTupleAsList, history);
                        break;
                    }
                    case LEVEL_MEMBERS: 
                    case OTHER_NATIVE: {
                        this.tempTuple[col] = null;
                        for (List<Member> tuple : range.getTuples()) {
                            this.appendTuple(tuple, this.tempTupleAsList, history);
                        }
                        continue block5;
                    }
                    default: {
                        throw Util.unexpected(command.getMemberType());
                    }
                }
            }
        }

        private void appendTuple(List<Member> nonNatives, Set<List<Member>> history) {
            if (history.add(nonNatives)) {
                this.appendTuple(nonNatives);
            }
        }

        private void appendTuple(List<Member> natives, List<Member> nonNatives, Set<List<Member>> history) {
            List<Member> copy = this.copyOfTuple(natives, nonNatives);
            if (history.add(copy)) {
                this.appendTuple(copy);
            }
        }

        private void appendTuple(List<Member> natives, List<Member> nonNatives) {
            this.appendTuple(this.copyOfTuple(natives, nonNatives));
        }

        private void appendTuple(List<Member> tuple) {
            this.resultList.add(tuple);
            this.checkNativeResultLimit(this.resultList.size());
        }

        private List<Member> copyOfTuple(List<Member> natives, List<Member> nonNatives) {
            Member[] copy = new Member[this.arity];
            for (int i = 0; i < this.arity; ++i) {
                copy[i] = nonNatives.get(i) == null ? natives.get(i) : nonNatives.get(i);
            }
            return Arrays.asList(copy);
        }

        private void checkNativeResultLimit(int resultSize) {
            if (this.resultLimit < resultSize) {
                throw MondrianResource.instance().LimitExceededDuringCrossjoin.ex(resultSize, this.resultLimit);
            }
        }

        public TupleList adaptList(final TupleList sourceList, final int destSize, final int[] destIndices) {
            if (sourceList.isEmpty()) {
                return TupleCollections.emptyList(destIndices.length);
            }
            this.checkNativeResultLimit(sourceList.size());
            DelegatingTupleList destList = new DelegatingTupleList(destSize, (List<List<Member>>)new AbstractList<List<Member>>(){

                @Override
                public List<Member> get(int index) {
                    List sourceTuple = (List)sourceList.get(index);
                    Member[] members = new Member[destSize];
                    for (int i = 0; i < destIndices.length; ++i) {
                        members[destIndices[i]] = (Member)sourceTuple.get(i);
                    }
                    return Arrays.asList(members);
                }

                @Override
                public int size() {
                    return sourceList.size();
                }
            });
            if (LOGGER.isDebugEnabled()) {
                String sourceListType = sourceList.getClass().getSimpleName();
                String sourceElementType = String.format("Member[%d]", destSize);
                LOGGER.debug((Object)String.format("returning native %s<%s> without copying to new list.", sourceListType, sourceElementType));
            }
            return destList;
        }
    }

    private static class SubstitutionMap {
        private final Map<String, Level> map = new HashMap<String, Level>();

        private SubstitutionMap() {
        }

        public boolean isEmpty() {
            return this.map.isEmpty();
        }

        public boolean contains(Member member) {
            return this.map.containsKey(this.toKey(member));
        }

        public Level get(Member member) {
            return this.map.get(this.toKey(member));
        }

        public Level put(Id id, Level level) {
            return this.map.put(this.toKey(id), level);
        }

        public Collection<Level> values() {
            return this.map.values();
        }

        public String toString() {
            return this.map.toString();
        }

        private String toKey(Id id) {
            return id.toString();
        }

        private String toKey(Member member) {
            return member.getUniqueName();
        }
    }

    static class TransformFromFormulasVisitor
    extends MdxVisitorImpl {
        private final Query query;
        private final ExpCompiler compiler;

        public TransformFromFormulasVisitor(Query query, ExpCompiler compiler) {
            LOGGER.debug((Object)"---- TransformFromFormulasVisitor constructor");
            this.query = query;
            this.compiler = compiler;
        }

        @Override
        public Object visit(ResolvedFunCall call) {
            LOGGER.debug((Object)("visit " + call));
            Object result = this.visitCallArguments(call);
            this.turnOffVisitChildren();
            return result;
        }

        @Override
        public Object visit(NamedSetExpr namedSetExpr) {
            Exp membersExpr;
            String exprName = namedSetExpr.getNamedSet().getName();
            if (exprName.contains(NativizeSetFunDef.SET_NAME_PREFIX)) {
                String levelMembers = exprName.replaceAll(NativizeSetFunDef.SET_NAME_PREFIX, "\\[").replaceAll("_$", "\\]").replaceAll("_", "\\]\\.\\[") + ".members";
                membersExpr = this.query.getConnection().parseExpression(levelMembers);
                membersExpr = this.compiler.getValidator().validate(membersExpr, false);
            } else {
                membersExpr = namedSetExpr.getNamedSet().getExp();
            }
            return membersExpr;
        }

        private Object visitCallArguments(ResolvedFunCall call) {
            Exp[] exps = call.getArgs();
            LOGGER.debug((Object)("visitCallArguments " + call));
            for (int i = 0; i < exps.length; ++i) {
                Exp transformedExp = (Exp)exps[i].accept(this);
                if (transformedExp == null) continue;
                exps[i] = transformedExp;
            }
            return null;
        }
    }

    static class TransformToFormulasVisitor
    extends MdxVisitorImpl {
        private final Query query;

        public TransformToFormulasVisitor(Query query) {
            LOGGER.debug((Object)"---- TransformToFormulasVisitor constructor");
            this.query = query;
        }

        @Override
        public Object visit(ResolvedFunCall call) {
            LOGGER.debug((Object)("visit " + call));
            Object result = null;
            if (call.getFunDef() instanceof LevelMembersFunDef) {
                result = this.replaceLevelMembersReferences(call);
            } else if (functionWhitelist.contains(call.getFunDef().getClass())) {
                result = this.visitCallArguments(call);
            }
            this.turnOffVisitChildren();
            return result;
        }

        private Object replaceLevelMembersReferences(ResolvedFunCall call) {
            LOGGER.debug((Object)("replaceLevelMembersReferences " + call));
            Level level = ((LevelExpr)call.getArg(0)).getLevel();
            Id setId = NativizeSetFunDef.createSetId(level);
            Formula formula = this.query.findFormula(setId.toString());
            Exp exp = Util.createExpr(formula.getNamedSet());
            return this.query.createValidator().validate(exp, false);
        }

        private Object visitCallArguments(ResolvedFunCall call) {
            Exp[] exps = call.getArgs();
            LOGGER.debug((Object)("visitCallArguments " + call));
            for (int i = 0; i < exps.length; ++i) {
                Exp transformedExp = (Exp)exps[i].accept(this);
                if (transformedExp == null) continue;
                exps[i] = transformedExp;
            }
            if (exps.length > 1 && call.getFunDef() instanceof SetFunDef) {
                return this.flattenSetFunDef(call);
            }
            return null;
        }

        private Object flattenSetFunDef(ResolvedFunCall call) {
            ArrayList<Exp> newArgs = new ArrayList<Exp>();
            this.flattenSetMembers(newArgs, call.getArgs());
            this.addSentinelMembers(newArgs);
            if (newArgs.size() != call.getArgCount()) {
                return new ResolvedFunCall(call.getFunDef(), newArgs.toArray(new Exp[newArgs.size()]), call.getType());
            }
            return null;
        }

        private void flattenSetMembers(List<Exp> result, Exp[] args) {
            for (Exp arg : args) {
                if (arg instanceof ResolvedFunCall && ((ResolvedFunCall)arg).getFunDef() instanceof SetFunDef) {
                    this.flattenSetMembers(result, ((ResolvedFunCall)arg).getArgs());
                    continue;
                }
                result.add(arg);
            }
        }

        private void addSentinelMembers(List<Exp> args) {
            Exp prev = args.get(0);
            for (int i = 1; i < args.size(); ++i) {
                Exp curr = args.get(i);
                if (prev.toString().equals(curr.toString())) {
                    Annotated element = null;
                    if (curr instanceof NamedSetExpr) {
                        element = ((NamedSetExpr)curr).getNamedSet();
                    } else if (curr instanceof MemberExpr) {
                        element = ((MemberExpr)curr).getMember();
                    }
                    if (element != null) {
                        Level level = element.getHierarchy().getLevels()[0];
                        Id memberId = NativizeSetFunDef.createSentinelId(level);
                        Formula formula = this.query.findFormula(memberId.toString());
                        args.add(i++, Util.createExpr(formula.getMdxMember()));
                    }
                }
                prev = curr;
            }
        }
    }

    static class AddFormulasVisitor
    extends MdxVisitorImpl {
        private final Query query;
        private final Collection<Level> levels;
        private final Set<Dimension> dimensions;

        public AddFormulasVisitor(Query query, SubstitutionMap substitutionMap, Set<Dimension> dimensions) {
            LOGGER.debug((Object)"---- AddFormulasVisitor constructor");
            this.query = query;
            this.levels = substitutionMap.values();
            this.dimensions = dimensions;
        }

        @Override
        public Object visit(ResolvedFunCall call) {
            if (call.getFunDef() instanceof NativizeSetFunDef) {
                this.addFormulasToQuery();
            }
            this.turnOffVisitChildren();
            return null;
        }

        private void addFormulasToQuery() {
            LOGGER.debug((Object)"FormulaResolvingVisitor addFormulas");
            ArrayList<Formula> formulas = new ArrayList<Formula>();
            for (Level level : this.levels) {
                Formula memberFormula = this.createDefaultMemberFormula(level);
                formulas.add(memberFormula);
                formulas.add(this.createNamedSetFormula(level, memberFormula));
            }
            for (Dimension dim : this.dimensions) {
                Level level = dim.getHierarchy().getLevels()[0];
                formulas.add(this.createSentinelFormula(level));
            }
            this.query.addFormulas(formulas.toArray(new Formula[formulas.size()]));
        }

        private Formula createSentinelFormula(Level level) {
            Id memberId = NativizeSetFunDef.createSentinelId(level);
            Exp memberExpr = this.query.getConnection().parseExpression("101010");
            LOGGER.debug((Object)("createSentinelFormula memberId=" + memberId + " memberExpr=" + memberExpr));
            return new Formula(memberId, memberExpr, new MemberProperty[0]);
        }

        private Formula createDefaultMemberFormula(Level level) {
            Id memberId = NativizeSetFunDef.createMemberId(level);
            UnresolvedFunCall memberExpr = new UnresolvedFunCall("DEFAULTMEMBER", Syntax.Property, new Exp[]{NativizeSetFunDef.hierarchyId(level)});
            LOGGER.debug((Object)("createLevelMembersFormulas memberId=" + memberId + " memberExpr=" + memberExpr));
            return new Formula(memberId, memberExpr, new MemberProperty[0]);
        }

        private Formula createNamedSetFormula(Level level, Formula memberFormula) {
            Id setId = NativizeSetFunDef.createSetId(level);
            Exp setExpr = this.query.getConnection().parseExpression("{" + memberFormula.getIdentifier().toString() + "}");
            LOGGER.debug((Object)("createNamedSetFormula setId=" + setId + " setExpr=" + setExpr));
            return new Formula(setId, setExpr);
        }
    }

    static class FindLevelsVisitor
    extends MdxVisitorImpl {
        private final SubstitutionMap substitutionMap;
        private final Set<Dimension> dimensions;

        public FindLevelsVisitor(SubstitutionMap substitutionMap, HashSet<Dimension> dimensions) {
            this.substitutionMap = substitutionMap;
            this.dimensions = dimensions;
        }

        @Override
        public Object visit(ResolvedFunCall call) {
            if (call.getFunDef() instanceof LevelMembersFunDef) {
                if (call.getArg(0) instanceof LevelExpr) {
                    Level level = ((LevelExpr)call.getArg(0)).getLevel();
                    this.substitutionMap.put(NativizeSetFunDef.createMemberId(level), level);
                    this.dimensions.add(level.getDimension());
                }
            } else if (functionWhitelist.contains(call.getFunDef().getClass())) {
                for (Exp arg : call.getArgs()) {
                    arg.accept(this);
                }
            }
            this.turnOffVisitChildren();
            return null;
        }

        @Override
        public Object visit(MemberExpr member) {
            this.dimensions.add(member.getMember().getDimension());
            return null;
        }
    }

    public static class NativeListCalc
    extends AbstractListCalc {
        private final SubstitutionMap substitutionMap;
        private final ListCalc simpleCalc;
        private final ExpCompiler compiler;
        private final Exp originalExp;

        protected NativeListCalc(ResolvedFunCall call, Calc[] calcs, ExpCompiler compiler, SubstitutionMap substitutionMap, Exp originalExp) {
            super(call, calcs);
            LOGGER.debug((Object)"---- NativeListCalc constructor");
            this.substitutionMap = substitutionMap;
            this.simpleCalc = (ListCalc)calcs[0];
            this.compiler = compiler;
            this.originalExp = originalExp;
        }

        @Override
        public TupleList evaluateList(Evaluator evaluator) {
            return this.computeTuples(evaluator);
        }

        public TupleList computeTuples(Evaluator evaluator) {
            TupleList simplifiedList = this.evaluateSimplifiedList(evaluator);
            if (simplifiedList.isEmpty()) {
                return simplifiedList;
            }
            if (!this.isHighCardinality(evaluator, simplifiedList)) {
                return this.evaluateNonNative(evaluator);
            }
            return this.evaluateNative(evaluator, simplifiedList);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private TupleList evaluateSimplifiedList(Evaluator evaluator) {
            int savepoint = evaluator.savepoint();
            try {
                evaluator.setNonEmpty(false);
                evaluator.setNativeEnabled(false);
                TupleList simplifiedList = this.simpleCalc.evaluateList(evaluator);
                NativizeSetFunDef.dumpListToLog("simplified list", simplifiedList);
                TupleList tupleList = simplifiedList;
                return tupleList;
            }
            finally {
                evaluator.restore(savepoint);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private TupleList evaluateNonNative(Evaluator evaluator) {
            LOGGER.debug((Object)("Disabling native evaluation. originalExp=" + this.originalExp));
            ListCalc calc = this.compiler.compileList(this.getOriginalExp(evaluator.getQuery()));
            int savepoint = evaluator.savepoint();
            try {
                TupleList members;
                evaluator.setNonEmpty(true);
                evaluator.setNativeEnabled(false);
                TupleList tupleList = members = calc.evaluateList(evaluator);
                return tupleList;
            }
            finally {
                evaluator.restore(savepoint);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private TupleList evaluateNative(Evaluator evaluator, TupleList simplifiedList) {
            CrossJoinAnalyzer analyzer = new CrossJoinAnalyzer(simplifiedList, this.substitutionMap);
            String crossJoin = analyzer.getCrossJoinExpression();
            if (crossJoin.length() == 0) {
                return simplifiedList;
            }
            LOGGER.debug((Object)("crossjoin reconstituted from simplified list: " + String.format("%n" + crossJoin.replaceAll(",", "%n, "), new Object[0])));
            int savepoint = evaluator.savepoint();
            try {
                TupleList members;
                evaluator.setNonEmpty(true);
                evaluator.setNativeEnabled(true);
                TupleList tupleList = members = analyzer.mergeCalcMembers(this.evaluateJoinExpression(evaluator, crossJoin));
                return tupleList;
            }
            finally {
                evaluator.restore(savepoint);
            }
        }

        private Exp getOriginalExp(Query query) {
            this.originalExp.accept(new TransformFromFormulasVisitor(query, this.compiler));
            if (this.originalExp instanceof NamedSetExpr) {
                return ((NamedSetExpr)this.originalExp).getNamedSet().getExp();
            }
            return this.originalExp;
        }

        private boolean isHighCardinality(Evaluator evaluator, TupleList simplifiedList) {
            Util.assertTrue(!simplifiedList.isEmpty());
            SchemaReader schema = evaluator.getSchemaReader();
            List tuple = (List)simplifiedList.get(0);
            long nativizeMinThreshold = MondrianProperties.instance().NativizeMinThreshold.get();
            long estimatedCardinality = simplifiedList.size();
            for (Member member : tuple) {
                String levelName;
                Level level;
                Dimension dimension;
                Hierarchy hierarchy;
                Level hierarchyLevel;
                long levelCardinality;
                String memberName = member.getName();
                if (!memberName.startsWith(NativizeSetFunDef.MEMBER_NAME_PREFIX) || (estimatedCardinality *= (levelCardinality = this.getLevelCardinality(schema, hierarchyLevel = Util.lookupHierarchyLevel(hierarchy = (dimension = (level = member.getLevel()).getDimension()).getHierarchy(), levelName = NativizeSetFunDef.getLevelNameFromMemberName(memberName))))) < nativizeMinThreshold) continue;
                NativizeSetFunDef.logHighCardinality(NativizeSetFunDef.PARTIAL_ESTIMATE_MESSAGE, nativizeMinThreshold, estimatedCardinality, true);
                return true;
            }
            boolean isHighCardinality = estimatedCardinality >= nativizeMinThreshold;
            NativizeSetFunDef.logHighCardinality(NativizeSetFunDef.ESTIMATE_MESSAGE, nativizeMinThreshold, estimatedCardinality, isHighCardinality);
            return isHighCardinality;
        }

        private long getLevelCardinality(SchemaReader schema, Level level) {
            if (this.cardinalityIsKnown(level)) {
                return level.getApproxRowCount();
            }
            return schema.getLevelCardinality(level, false, true);
        }

        private boolean cardinalityIsKnown(Level level) {
            return level.getApproxRowCount() > 0;
        }

        private TupleList evaluateJoinExpression(Evaluator evaluator, String crossJoinExpression) {
            Exp unresolved = evaluator.getQuery().getConnection().parseExpression(crossJoinExpression);
            Exp resolved = this.compiler.getValidator().validate(unresolved, false);
            ListCalc calc = this.compiler.compileList(resolved);
            return calc.evaluateList(evaluator);
        }
    }

    static class NonNativeListCalc
    extends NonNativeCalc
    implements ListCalc {
        protected NonNativeListCalc(ListCalc parent, boolean highCardinality) {
            super(parent, highCardinality);
        }

        ListCalc parent() {
            return (ListCalc)this.parent;
        }

        @Override
        public TupleList evaluateList(Evaluator evaluator) {
            evaluator.setNativeEnabled(this.nativeEnabled);
            return this.parent().evaluateList(evaluator);
        }

        @Override
        public TupleIterable evaluateIterable(Evaluator evaluator) {
            return this.evaluateList(evaluator);
        }
    }

    static class NonNativeIterCalc
    extends NonNativeCalc
    implements IterCalc {
        protected NonNativeIterCalc(IterCalc parent, boolean highCardinality) {
            super(parent, highCardinality);
        }

        IterCalc parent() {
            return (IterCalc)this.parent;
        }

        @Override
        public TupleIterable evaluateIterable(Evaluator evaluator) {
            evaluator.setNativeEnabled(this.nativeEnabled);
            return this.parent().evaluateIterable(evaluator);
        }
    }

    static class NonNativeCalc
    implements Calc {
        final Calc parent;
        final boolean nativeEnabled;

        protected NonNativeCalc(Calc parent, boolean nativeEnabled) {
            assert (parent != null);
            this.parent = parent;
            this.nativeEnabled = nativeEnabled;
        }

        @Override
        public Object evaluate(Evaluator evaluator) {
            evaluator.setNativeEnabled(this.nativeEnabled);
            return this.parent.evaluate(evaluator);
        }

        @Override
        public boolean dependsOn(Hierarchy hierarchy) {
            return this.parent.dependsOn(hierarchy);
        }

        @Override
        public Type getType() {
            return this.parent.getType();
        }

        @Override
        public void accept(CalcWriter calcWriter) {
            this.parent.accept(calcWriter);
        }

        @Override
        public ResultStyle getResultStyle() {
            return this.parent.getResultStyle();
        }

        @Override
        public boolean isWrapperFor(Class<?> iface) {
            return iface.isInstance(this);
        }

        @Override
        public <T> T unwrap(Class<T> iface) {
            return iface.cast(this);
        }
    }
}

