/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap;

import java.util.Iterator;
import java.util.List;
import mondrian.olap.Cube;
import mondrian.olap.Dimension;
import mondrian.olap.Formula;
import mondrian.olap.Hierarchy;
import mondrian.olap.Level;
import mondrian.olap.MatchType;
import mondrian.olap.Member;
import mondrian.olap.NamedSet;
import mondrian.olap.OlapElement;
import mondrian.olap.Util;
import org.olap4j.mdx.IdentifierNode;
import org.olap4j.mdx.IdentifierSegment;

public final class NameResolver {
    public OlapElement resolve(OlapElement parent, List<IdentifierSegment> segments, boolean failIfNotFound, int category, MatchType matchType, List<Namespace> namespaces) {
        OlapElement element = matchType == MatchType.EXACT ? this.resolveExact(parent, segments, namespaces) : this.resolveInexact(parent, segments, matchType, namespaces);
        if (element != null) {
            element = this.nullify(category, element);
        }
        if (element == null && failIfNotFound) {
            throw Util.newElementNotFoundException(category, new IdentifierNode(segments));
        }
        return element;
    }

    private OlapElement resolveInexact(OlapElement parent, List<IdentifierSegment> segments, MatchType matchType, List<Namespace> namespaces) {
        OlapElement element = parent;
        for (IdentifierSegment segment : segments) {
            assert (element != null);
            OlapElement child = null;
            for (Namespace namespace : namespaces) {
                child = namespace.lookupChild(element, segment, matchType);
                if (child == null) continue;
                switch (matchType) {
                    case EXACT: 
                    case EXACT_SCHEMA: {
                        break;
                    }
                    case BEFORE: {
                        if (Util.matches(segment, child.getName())) break;
                        matchType = MatchType.LAST;
                        break;
                    }
                    case AFTER: {
                        if (Util.matches(segment, child.getName())) break;
                        matchType = MatchType.FIRST;
                    }
                }
                break;
            }
            if (child == null) {
                return null;
            }
            element = child;
        }
        return element;
    }

    private OlapElement resolveExact(OlapElement parent, List<IdentifierSegment> segments, List<Namespace> namespaces) {
        OlapElement element = parent;
        for (IdentifierSegment segment : segments) {
            Namespace namespace;
            assert (element != null);
            OlapElement child = null;
            Iterator<Namespace> iterator = namespaces.iterator();
            while (iterator.hasNext() && (child = (namespace = iterator.next()).lookupChild(element, segment)) == null) {
            }
            if (child == null) {
                return null;
            }
            element = child;
        }
        return element;
    }

    private OlapElement nullify(int category, OlapElement element) {
        switch (category) {
            case 0: {
                return element;
            }
            case 6: {
                return element instanceof Member ? element : null;
            }
            case 4: {
                return element instanceof Level ? element : null;
            }
            case 3: {
                if (element instanceof Hierarchy) {
                    return element;
                }
                if (element instanceof Dimension) {
                    Dimension dimension = (Dimension)element;
                    Hierarchy[] hierarchies = dimension.getHierarchies();
                    if (hierarchies.length == 1) {
                        return hierarchies[0];
                    }
                    return null;
                }
                return null;
            }
            case 2: {
                return element instanceof Dimension ? element : null;
            }
            case 8: {
                return element instanceof NamedSet ? element : null;
            }
        }
        throw Util.newInternal("unexpected: " + category);
    }

    public static boolean matches(Formula formula, OlapElement parent, IdentifierSegment segment) {
        if (!Util.matches(segment, formula.getName())) {
            return false;
        }
        if (formula.isMember()) {
            Member formulaMember = formula.getMdxMember();
            if (formulaMember.getParentMember() != null) {
                if (parent instanceof Member) {
                    return formulaMember.getParentMember().isChildOrEqualTo((Member)parent);
                }
                if (parent instanceof Hierarchy) {
                    return formulaMember.getParentMember().getHierarchy().equals(parent);
                }
                return parent.getUniqueName().equals(formulaMember.getParentMember().getUniqueName());
            }
            return parent.equals(formulaMember.getHierarchy()) || parent.equals(formulaMember.getDimension());
        }
        return parent instanceof Cube;
    }

    public static interface Namespace {
        public OlapElement lookupChild(OlapElement var1, IdentifierSegment var2, MatchType var3);

        public OlapElement lookupChild(OlapElement var1, IdentifierSegment var2);
    }
}

