/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.plugin.jfreereport.reportcharts.collectors;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.TimeZone;
import org.jfree.data.general.Dataset;
import org.jfree.data.time.Day;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.time.TimeSeriesDataItem;
import org.pentaho.plugin.jfreereport.reportcharts.collectors.AbstractCollectorFunction;
import org.pentaho.reporting.engine.classic.core.event.ReportEvent;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.engine.classic.core.states.ReportStateKey;
import org.pentaho.reporting.engine.classic.core.util.Sequence;

public class TimeSeriesCollector
extends AbstractCollectorFunction {
    private Class timePeriod = Day.class;
    private ArrayList<String> valueColumns = new ArrayList();
    private ArrayList<String> timeValueColumns = new ArrayList();
    private HashMap<ReportStateKey, Sequence<HashMap<Comparable, TimeSeries>>> seriesSequenceMap = new HashMap();

    @Override
    protected Dataset createNewDataset() {
        return new FastTimeSeriesCollection();
    }

    public Class getTimePeriod() {
        return this.timePeriod;
    }

    public void setTimePeriod(Class timePeriod) {
        this.timePeriod = timePeriod;
    }

    protected HashMap<Comparable, TimeSeries> getSeriesMap() {
        HashMap map;
        ReportStateKey key = this.getStateKey();
        Sequence sequence = this.seriesSequenceMap.get(key);
        if (sequence == null) {
            sequence = new Sequence();
            this.seriesSequenceMap.put(key, (Sequence<HashMap<Comparable, TimeSeries>>)sequence);
        }
        if ((map = (HashMap)sequence.get(this.getLastGroupSequenceNumber())) == null) {
            map = new HashMap();
            sequence.set(this.getLastGroupSequenceNumber(), map);
        }
        return map;
    }

    public void setValueColumn(int index, String field) {
        if (this.valueColumns.size() == index) {
            this.valueColumns.add(field);
        } else {
            this.valueColumns.set(index, field);
        }
    }

    public void setTimeValueColumn(int index, String field) {
        if (this.timeValueColumns.size() == index) {
            this.timeValueColumns.add(field);
        } else {
            this.timeValueColumns.set(index, field);
        }
    }

    public String getValueColumn(int index) {
        return this.valueColumns.get(index);
    }

    public int getValueColumnCount() {
        return this.valueColumns.size();
    }

    public String[] getValueColumn() {
        return this.valueColumns.toArray(new String[this.valueColumns.size()]);
    }

    public void setValueColumn(String[] fields) {
        this.valueColumns.clear();
        this.valueColumns.addAll(Arrays.asList(fields));
    }

    public String getTimeValueColumn(int index) {
        return this.timeValueColumns.get(index);
    }

    public int getTimeValueColumnCount() {
        return this.timeValueColumns.size();
    }

    public String[] getTimeValueColumn() {
        return this.timeValueColumns.toArray(new String[this.timeValueColumns.size()]);
    }

    public void setTimeValueColumn(String[] fields) {
        this.timeValueColumns.clear();
        this.timeValueColumns.addAll(Arrays.asList(fields));
    }

    @Override
    protected void buildDataset() {
        Dataset o = this.getDataSet();
        if (!(o instanceof TimeSeriesCollection)) {
            return;
        }
        TimeSeriesCollection timeSeriesDataset = (TimeSeriesCollection)o;
        List seriesList = timeSeriesDataset.getSeries();
        HashMap<Comparable, TimeSeries> seriesMap = this.getSeriesMap();
        if (seriesMap.isEmpty()) {
            for (int i = 0; i < seriesList.size(); ++i) {
                TimeSeries series = (TimeSeries)seriesList.get(i);
                seriesMap.put(series.getKey(), series);
            }
        }
        int maxIndex = this.valueColumns.size();
        for (int i = 0; i < maxIndex; ++i) {
            Comparable seriesName = this.querySeriesValue(i);
            Object valueObject = this.getDataRow().get(this.valueColumns.get(i));
            Object timeValueObject = this.getDataRow().get(this.timeValueColumns.get(i));
            Number value = valueObject instanceof Number ? (Number)((Number)valueObject) : (Number)null;
            Date timeValue = this.convertToDate(timeValueObject);
            if (timeValue == null) continue;
            TimeSeries series = seriesMap.get(seriesName);
            if (series == null) {
                series = new TimeSeries(seriesName);
                timeSeriesDataset.addSeries(series);
                seriesMap.put(seriesName, series);
            }
            RegularTimePeriod regularTimePeriod = RegularTimePeriod.createInstance((Class)this.getTimePeriod(), (Date)timeValue, (TimeZone)TimeZone.getDefault());
            TimeSeriesDataItem timeSeriesDataItem = new TimeSeriesDataItem(regularTimePeriod, value);
            series.add(timeSeriesDataItem);
        }
    }

    private Date convertToDate(Object value) {
        if (value instanceof Date) {
            return (Date)value;
        }
        if (value instanceof Number) {
            Number n = (Number)value;
            return new Date(n.longValue());
        }
        return null;
    }

    public void reportDone(ReportEvent event) {
        this.seriesSequenceMap.clear();
    }

    @Override
    public Expression getInstance() {
        TimeSeriesCollector expression = (TimeSeriesCollector)super.getInstance();
        expression.valueColumns = (ArrayList)this.valueColumns.clone();
        expression.timeValueColumns = (ArrayList)this.timeValueColumns.clone();
        expression.seriesSequenceMap = new HashMap();
        return expression;
    }

    private static class FastTimeSeriesCollection
    extends TimeSeriesCollection {
        private static final long serialVersionUID = 2096209400748561882L;

        private FastTimeSeriesCollection() {
        }

        public int hashCode() {
            return this.getSeriesCount();
        }
    }
}

