/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.refinery.model;

import java.util.Dictionary;
import java.util.Hashtable;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.pentaho.agilebi.modeler.ModelerException;
import org.pentaho.agilebi.modeler.geo.GeoContextConfigProvider;

public class GeoContextBlueprintConfigProvider
implements GeoContextConfigProvider {
    private BundleContext bundleContext;
    protected Dictionary<String, Object> props = new Hashtable<String, Object>();

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        this.initProps();
    }

    protected void initProps() {
        ServiceReference serviceReference = this.getBundleContext().getServiceReference(ConfigurationAdmin.class.getName());
        if (serviceReference != null) {
            try {
                ConfigurationAdmin admin = (ConfigurationAdmin)this.getBundleContext().getService(serviceReference);
                Configuration configuration = admin.getConfiguration("pentaho.geo.roles");
                this.props = configuration.getProperties();
            }
            catch (Exception e) {
                this.props = new Hashtable<String, Object>();
            }
        }
    }

    public String getDimensionName() throws ModelerException {
        Object value = this.props.get("geo.dimension.name");
        if (value != null) {
            return value.toString();
        }
        return null;
    }

    public String getRoles() throws ModelerException {
        Object value = this.props.get("geo.roles");
        if (value != null) {
            return value.toString();
        }
        return null;
    }

    public String getRoleAliases(String roleName) throws ModelerException {
        String aliasKey = "geo." + roleName + ".aliases";
        Object aliases = this.props.get(aliasKey);
        if (aliases != null && aliases.toString().trim().length() != 0) {
            return aliases.toString();
        }
        throw new ModelerException("Error while building GeoContext from configuration: No Aliases found for role  " + roleName + ". Make sure there is a " + aliasKey + " property defined");
    }

    public String getRoleRequirements(String roleName) throws ModelerException {
        String key = "geo." + roleName + ".required-parents";
        Object value = this.props.get(key);
        if (value != null) {
            return value.toString();
        }
        return null;
    }
}

