/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.parser;

import java.io.Serializable;
import org.apache.pig.parser.PigParserNode;

public class SourceLocation
implements Serializable {
    private String file = null;
    private int line = -1;
    private int offset = -1;
    private transient PigParserNode node;

    public SourceLocation() {
    }

    public SourceLocation(String filename, int line, int offset) {
        this.file = filename;
        this.line = line;
        this.offset = offset;
    }

    public SourceLocation(PigParserNode tree) {
        this.file = tree.getFileName();
        this.line = tree.getLine();
        this.offset = tree.getCharPositionInLine();
        this.node = tree;
    }

    public SourceLocation(SourceLocation location) {
        this.file = location.file;
        this.line = location.line;
        this.offset = location.offset;
        this.node = location.node;
    }

    public String file() {
        return this.file;
    }

    public int line() {
        return this.line;
    }

    public int offset() {
        return this.offset;
    }

    public PigParserNode node() {
        return this.node;
    }

    public String toString() {
        if (this.line == -1) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        if (this.node != null) {
            PigParserNode.InvocationPoint pt = this.node.getNextInvocationPoint();
            while (pt != null) {
                sb.append("at expanding macro '" + pt.getMacro() + "' (" + pt.getFile() + ":" + pt.getLine() + ")");
                pt = this.node.getNextInvocationPoint();
                sb.append("\n");
            }
        }
        sb.append("<");
        if (this.file != null && !this.file.isEmpty()) {
            sb.append("file " + this.file + ", ");
        }
        sb.append("line " + this.line + ", column " + this.offset + "> ");
        return sb.toString();
    }
}

