/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.builtin;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.hive.ql.exec.UDAF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFBridge;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFParameterInfo;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFResolver;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFResolver2;
import org.apache.hadoop.hive.ql.udf.generic.SimpleGenericUDAFParameterInfo;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.pig.Algebraic;
import org.apache.pig.EvalFunc;
import org.apache.pig.ResourceSchema;
import org.apache.pig.builtin.HiveUDFBase;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.logicalLayer.schema.Schema;
import org.apache.pig.impl.util.hive.HiveUtils;

public class HiveUDAF
extends HiveUDFBase
implements Algebraic {
    private boolean inited = false;
    private String funcName;
    private String params;
    private GenericUDAFResolver udaf;
    SchemaAndEvaluatorInfo schemaAndEvaluatorInfo = new SchemaAndEvaluatorInfo();
    HiveUDFBase.ConstantObjectInspectInfo constantsInfo;

    public HiveUDAF(String funcName) throws IOException, InstantiationException, IllegalAccessException {
        this.funcName = funcName;
        this.udaf = HiveUDAF.instantiateUDAF(funcName);
    }

    public HiveUDAF(String funcName, String params) throws IOException, InstantiationException, IllegalAccessException {
        this(funcName);
        this.constantsInfo = HiveUDFBase.ConstantObjectInspectInfo.parse(params);
        this.params = params;
    }

    private static GenericUDAFResolver instantiateUDAF(String funcName) throws IOException, InstantiationException, IllegalAccessException {
        GenericUDAFBridge udaf;
        Class hiveUDAFClass = HiveUDAF.resolveFunc(funcName);
        if (UDAF.class.isAssignableFrom(hiveUDAFClass)) {
            udaf = new GenericUDAFBridge((UDAF)hiveUDAFClass.newInstance());
        } else if (GenericUDAFResolver.class.isAssignableFrom(hiveUDAFClass)) {
            udaf = (GenericUDAFResolver)hiveUDAFClass.newInstance();
        } else {
            throw new IOException(HiveUDAF.getErrorMessage(hiveUDAFClass));
        }
        return udaf;
    }

    @Override
    public String getInitial() {
        if (this.params == null) {
            return Initial.class.getName() + "('" + this.funcName + "')";
        }
        return Initial.class.getName() + "('" + this.funcName + "," + this.params + "')";
    }

    @Override
    public String getIntermed() {
        if (this.params == null) {
            return Intermediate.class.getName() + "('" + this.funcName + "')";
        }
        return Intermediate.class.getName() + "('" + this.funcName + "," + this.params + "')";
    }

    @Override
    public String getFinal() {
        if (this.params == null) {
            return Final.class.getName() + "('" + this.funcName + "')";
        }
        return Final.class.getName() + "('" + this.funcName + "," + this.params + "')";
    }

    @Override
    public Object exec(Tuple input) throws IOException {
        try {
            if (!this.inited) {
                this.schemaAndEvaluatorInfo.init(this.getInputSchema(), HiveUDAF.instantiateUDAF(this.funcName), GenericUDAFEvaluator.Mode.COMPLETE, this.constantsInfo);
                this.inited = true;
            }
            GenericUDAFEvaluator.AggregationBuffer agg = this.schemaAndEvaluatorInfo.evaluator.getNewAggregationBuffer();
            DataBag bg = (DataBag)input.get(0);
            Tuple tp2 = null;
            for (Tuple tp2 : bg) {
                List inputs = this.schemaAndEvaluatorInfo.inputObjectInspector.getStructFieldsDataAsList((Object)tp2);
                this.schemaAndEvaluatorInfo.evaluator.iterate(agg, inputs.toArray());
            }
            Object returnValue = this.schemaAndEvaluatorInfo.evaluator.terminate(agg);
            Object result = HiveUtils.convertHiveToPig(returnValue, this.schemaAndEvaluatorInfo.outputObjectInspector, null);
            return result;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public Schema outputSchema(Schema input) {
        try {
            if (!this.inited) {
                this.schemaAndEvaluatorInfo.init(this.getInputSchema(), HiveUDAF.instantiateUDAF(this.funcName), GenericUDAFEvaluator.Mode.COMPLETE, this.constantsInfo);
                this.inited = true;
            }
            ResourceSchema.ResourceFieldSchema rfs = HiveUtils.getResourceFieldSchema(this.schemaAndEvaluatorInfo.outputTypeInfo);
            ResourceSchema outputSchema = new ResourceSchema();
            outputSchema.setFields(new ResourceSchema.ResourceFieldSchema[]{rfs});
            return Schema.getPigSchema(outputSchema);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static class Final
    extends EvalFunc<Object> {
        private boolean inited = false;
        private String funcName;
        HiveUDFBase.ConstantObjectInspectInfo constantsInfo;
        private SchemaAndEvaluatorInfo schemaAndEvaluatorInfo = new SchemaAndEvaluatorInfo();

        public Final(String funcName) {
            this.funcName = funcName;
        }

        public Final(String funcName, String params) throws IOException {
            this.funcName = funcName;
            this.constantsInfo = HiveUDFBase.ConstantObjectInspectInfo.parse(params);
        }

        @Override
        public Object exec(Tuple input) throws IOException {
            try {
                if (!this.inited) {
                    this.schemaAndEvaluatorInfo.init(this.getInputSchema(), HiveUDAF.instantiateUDAF(this.funcName), GenericUDAFEvaluator.Mode.FINAL, this.constantsInfo);
                    this.schemaAndEvaluatorInfo.evaluator.configure(HiveUDFBase.instantiateMapredContext());
                    this.inited = true;
                }
                DataBag b = (DataBag)input.get(0);
                GenericUDAFEvaluator.AggregationBuffer agg = this.schemaAndEvaluatorInfo.evaluator.getNewAggregationBuffer();
                for (Tuple t : b) {
                    this.schemaAndEvaluatorInfo.evaluator.merge(agg, t.get(0));
                }
                Object returnValue = this.schemaAndEvaluatorInfo.evaluator.terminate(agg);
                Object result = HiveUtils.convertHiveToPig(returnValue, this.schemaAndEvaluatorInfo.outputObjectInspector, null);
                return result;
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
    }

    public static class Intermediate
    extends EvalFunc<Tuple> {
        private boolean inited = false;
        private String funcName;
        HiveUDFBase.ConstantObjectInspectInfo constantsInfo;
        private SchemaAndEvaluatorInfo schemaAndEvaluatorInfo = new SchemaAndEvaluatorInfo();
        private static TupleFactory tf = TupleFactory.getInstance();

        public Intermediate(String funcName) {
            this.funcName = funcName;
        }

        public Intermediate(String funcName, String params) throws IOException {
            this.funcName = funcName;
            this.constantsInfo = HiveUDFBase.ConstantObjectInspectInfo.parse(params);
        }

        @Override
        public Tuple exec(Tuple input) throws IOException {
            try {
                if (!this.inited) {
                    this.schemaAndEvaluatorInfo.init(this.getInputSchema(), HiveUDAF.instantiateUDAF(this.funcName), GenericUDAFEvaluator.Mode.PARTIAL2, this.constantsInfo);
                    this.inited = true;
                }
                DataBag b = (DataBag)input.get(0);
                GenericUDAFEvaluator.AggregationBuffer agg = this.schemaAndEvaluatorInfo.evaluator.getNewAggregationBuffer();
                for (Tuple t : b) {
                    this.schemaAndEvaluatorInfo.evaluator.merge(agg, t.get(0));
                }
                Object returnValue = this.schemaAndEvaluatorInfo.evaluator.terminatePartial(agg);
                Tuple result = tf.newTuple();
                result.append(HiveUtils.convertHiveToPig(returnValue, this.schemaAndEvaluatorInfo.intermediateOutputObjectInspector, null));
                return result;
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
    }

    public static class Initial
    extends EvalFunc<Tuple> {
        private boolean inited = false;
        private String funcName;
        HiveUDFBase.ConstantObjectInspectInfo constantsInfo;
        private SchemaAndEvaluatorInfo schemaAndEvaluatorInfo = new SchemaAndEvaluatorInfo();
        private static TupleFactory tf = TupleFactory.getInstance();

        public Initial(String funcName) {
            this.funcName = funcName;
        }

        public Initial(String funcName, String params) throws IOException {
            this.funcName = funcName;
            this.constantsInfo = HiveUDFBase.ConstantObjectInspectInfo.parse(params);
        }

        @Override
        public Tuple exec(Tuple input) throws IOException {
            try {
                if (!this.inited) {
                    this.schemaAndEvaluatorInfo.init(this.getInputSchema(), HiveUDAF.instantiateUDAF(this.funcName), GenericUDAFEvaluator.Mode.PARTIAL1, this.constantsInfo);
                    this.inited = true;
                }
                DataBag b = (DataBag)input.get(0);
                GenericUDAFEvaluator.AggregationBuffer agg = this.schemaAndEvaluatorInfo.evaluator.getNewAggregationBuffer();
                for (Tuple t : b) {
                    List inputs = this.schemaAndEvaluatorInfo.inputObjectInspector.getStructFieldsDataAsList((Object)t);
                    this.schemaAndEvaluatorInfo.evaluator.iterate(agg, inputs.toArray());
                }
                Object returnValue = this.schemaAndEvaluatorInfo.evaluator.terminatePartial(agg);
                Tuple result = tf.newTuple();
                result.append(HiveUtils.convertHiveToPig(returnValue, this.schemaAndEvaluatorInfo.intermediateOutputObjectInspector, null));
                return result;
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
    }

    static class SchemaAndEvaluatorInfo {
        private TypeInfo inputTypeInfo;
        private TypeInfo outputTypeInfo;
        private TypeInfo intermediateOutputTypeInfo;
        private ObjectInspector[] inputObjectInspectorAsArray;
        private ObjectInspector[] intermediateInputObjectInspectorAsArray;
        private StructObjectInspector inputObjectInspector;
        private ObjectInspector intermediateInputObjectInspector;
        private ObjectInspector intermediateOutputObjectInspector;
        private ObjectInspector outputObjectInspector;
        private GenericUDAFEvaluator evaluator;

        SchemaAndEvaluatorInfo() {
        }

        private static TypeInfo getInputTypeInfo(Schema inputSchema) throws IOException {
            Schema.FieldSchema innerFieldSchema = inputSchema.getField((int)0).schema.getField(0);
            ResourceSchema.ResourceFieldSchema rfs = new ResourceSchema.ResourceFieldSchema(innerFieldSchema);
            TypeInfo inputTypeInfo = HiveUtils.getTypeInfo(rfs);
            return inputTypeInfo;
        }

        private static ObjectInspector[] getInputObjectInspectorAsArray(TypeInfo inputTypeInfo, HiveUDFBase.ConstantObjectInspectInfo constantsInfo) throws IOException {
            StructObjectInspector inputObjectInspector = (StructObjectInspector)HiveUtils.createObjectInspector(inputTypeInfo);
            ObjectInspector[] arguments = new ObjectInspector[inputObjectInspector.getAllStructFieldRefs().size()];
            for (int i = 0; i < inputObjectInspector.getAllStructFieldRefs().size(); ++i) {
                arguments[i] = constantsInfo != null && constantsInfo.get(i) != null ? constantsInfo.get(i) : ((StructField)inputObjectInspector.getAllStructFieldRefs().get(i)).getFieldObjectInspector();
            }
            return arguments;
        }

        private static GenericUDAFEvaluator getEvaluator(TypeInfo inputTypeInfo, GenericUDAFResolver udaf, HiveUDFBase.ConstantObjectInspectInfo constantsInfo) throws IOException {
            try {
                GenericUDAFEvaluator evaluator;
                ObjectInspector[] arguments = SchemaAndEvaluatorInfo.getInputObjectInspectorAsArray(inputTypeInfo, constantsInfo);
                if (udaf instanceof GenericUDAFResolver2) {
                    SimpleGenericUDAFParameterInfo paramInfo = new SimpleGenericUDAFParameterInfo(arguments, false, false, false);
                    evaluator = ((GenericUDAFResolver2)udaf).getEvaluator((GenericUDAFParameterInfo)paramInfo);
                } else {
                    TypeInfo[] params = ((StructTypeInfo)inputTypeInfo).getAllStructFieldTypeInfos().toArray(new TypeInfo[0]);
                    evaluator = udaf.getEvaluator(params);
                }
                return evaluator;
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }

        private void init(Schema inputSchema, GenericUDAFResolver udaf, GenericUDAFEvaluator.Mode m, HiveUDFBase.ConstantObjectInspectInfo constantsInfo) throws IOException {
            try {
                this.inputTypeInfo = SchemaAndEvaluatorInfo.getInputTypeInfo(inputSchema);
                this.inputObjectInspector = (StructObjectInspector)HiveUtils.createObjectInspector(this.inputTypeInfo);
                if (constantsInfo != null) {
                    constantsInfo.injectConstantObjectInspector(this.inputObjectInspector);
                }
                this.inputObjectInspectorAsArray = SchemaAndEvaluatorInfo.getInputObjectInspectorAsArray(this.inputTypeInfo, constantsInfo);
                this.evaluator = SchemaAndEvaluatorInfo.getEvaluator(this.inputTypeInfo, udaf, constantsInfo);
                if (m == GenericUDAFEvaluator.Mode.COMPLETE) {
                    this.outputObjectInspector = this.evaluator.init(GenericUDAFEvaluator.Mode.COMPLETE, this.inputObjectInspectorAsArray);
                    this.outputTypeInfo = TypeInfoUtils.getTypeInfoFromObjectInspector((ObjectInspector)this.outputObjectInspector);
                    return;
                }
                if (m == GenericUDAFEvaluator.Mode.PARTIAL1 || m == GenericUDAFEvaluator.Mode.PARTIAL2 || m == GenericUDAFEvaluator.Mode.FINAL) {
                    this.intermediateOutputObjectInspector = this.evaluator.init(GenericUDAFEvaluator.Mode.PARTIAL1, this.inputObjectInspectorAsArray);
                    this.intermediateOutputTypeInfo = TypeInfoUtils.getTypeInfoFromObjectInspector((ObjectInspector)this.intermediateOutputObjectInspector);
                    if (m == GenericUDAFEvaluator.Mode.PARTIAL2 || m == GenericUDAFEvaluator.Mode.FINAL) {
                        this.intermediateInputObjectInspector = HiveUtils.createObjectInspector(this.intermediateOutputTypeInfo);
                        this.intermediateInputObjectInspectorAsArray = new ObjectInspector[]{this.intermediateInputObjectInspector};
                        this.outputObjectInspector = this.evaluator.init(GenericUDAFEvaluator.Mode.FINAL, this.intermediateInputObjectInspectorAsArray);
                        this.outputTypeInfo = TypeInfoUtils.getTypeInfoFromObjectInspector((ObjectInspector)this.outputObjectInspector);
                    }
                }
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
    }
}

