/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.hbase;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.BinaryComparator;
import org.apache.hadoop.hbase.filter.ByteArrayComparable;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.filter.RowFilter;
import org.apache.hadoop.hbase.mapreduce.TableInputFormat;
import org.apache.hadoop.hbase.mapreduce.TableRecordReader;
import org.apache.hadoop.hbase.mapreduce.TableSplit;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;

public class HBaseTableInputFormat
extends TableInputFormat {
    private static final Log LOG = LogFactory.getLog(HBaseTableInputFormat.class);
    protected final byte[] gt_;
    protected final byte[] gte_;
    protected final byte[] lt_;
    protected final byte[] lte_;

    public HBaseTableInputFormat() {
        this(-1L, null, null, null, null);
    }

    protected HBaseTableInputFormat(long limit, byte[] gt, byte[] gte, byte[] lt, byte[] lte) {
        this.setTableRecordReader(new HBaseTableRecordReader(limit));
        this.gt_ = gt;
        this.gte_ = gte;
        this.lt_ = lt;
        this.lte_ = lte;
    }

    public List<InputSplit> getSplits(JobContext context) throws IOException {
        List splits = super.getSplits(context);
        ListIterator splitIter = splits.listIterator();
        while (splitIter.hasNext()) {
            TableSplit split = (TableSplit)splitIter.next();
            byte[] startKey = split.getStartRow();
            byte[] endKey = split.getEndRow();
            if (!this.skipRegion(CompareFilter.CompareOp.LESS, startKey, this.lt_) && !this.skipRegion(CompareFilter.CompareOp.GREATER, endKey, this.gt_) && !this.skipRegion(CompareFilter.CompareOp.GREATER, endKey, this.gte_) && !this.skipRegion(CompareFilter.CompareOp.LESS_OR_EQUAL, startKey, this.lte_)) continue;
            splitIter.remove();
        }
        return splits;
    }

    private boolean skipRegion(CompareFilter.CompareOp op, byte[] key, byte[] option) throws IOException {
        if (key.length == 0 || option == null) {
            return false;
        }
        BinaryComparator comp = new BinaryComparator(option);
        RowFilter rowFilter = new RowFilter(op, (ByteArrayComparable)comp);
        return rowFilter.filterRowKey(key, 0, key.length);
    }

    protected class HBaseTableRecordReader
    extends TableRecordReader {
        private long recordsSeen = 0L;
        private final long limit_;
        private byte[] startRow_;
        private byte[] endRow_;
        private transient byte[] currRow_;
        private BigInteger bigStart_;
        private BigInteger bigEnd_;
        private BigDecimal bigRange_;
        private transient float progressSoFar_ = 0.0f;

        public HBaseTableRecordReader(long limit) {
            this.limit_ = limit;
        }

        public void setScan(Scan scan) {
            byte[] endPadded;
            byte[] startPadded;
            super.setScan(scan);
            this.startRow_ = scan.getStartRow();
            this.endRow_ = scan.getStopRow();
            if (this.startRow_.length < this.endRow_.length) {
                startPadded = Bytes.padTail((byte[])this.startRow_, (int)(this.endRow_.length - this.startRow_.length));
                endPadded = this.endRow_;
            } else if (this.endRow_.length < this.startRow_.length) {
                startPadded = this.startRow_;
                endPadded = Bytes.padTail((byte[])this.endRow_, (int)(this.startRow_.length - this.endRow_.length));
            } else {
                startPadded = this.startRow_;
                endPadded = this.endRow_;
            }
            this.currRow_ = this.startRow_;
            byte[] prependHeader = new byte[]{1, 0};
            this.bigStart_ = new BigInteger(Bytes.add((byte[])prependHeader, (byte[])startPadded));
            this.bigEnd_ = new BigInteger(Bytes.add((byte[])prependHeader, (byte[])endPadded));
            this.bigRange_ = new BigDecimal(this.bigEnd_.subtract(this.bigStart_));
            LOG.info((Object)("setScan with ranges: " + this.bigStart_ + " - " + this.bigEnd_ + " ( " + this.bigRange_ + ")"));
        }

        public boolean nextKeyValue() throws IOException, InterruptedException {
            if (this.limit_ > 0L && ++this.recordsSeen > this.limit_) {
                return false;
            }
            boolean hasMore = super.nextKeyValue();
            if (hasMore) {
                this.currRow_ = this.getCurrentKey().get();
            }
            return hasMore;
        }

        public float getProgress() {
            byte[] prependHeader;
            BigInteger bigLastRow;
            if (this.currRow_ == null || this.currRow_.length == 0 || this.endRow_.length == 0 || this.endRow_ == HConstants.LAST_ROW) {
                return 0.0f;
            }
            byte[] lastPadded = this.currRow_;
            if (this.currRow_.length < this.endRow_.length) {
                lastPadded = Bytes.padTail((byte[])this.currRow_, (int)(this.endRow_.length - this.currRow_.length));
            }
            if (this.currRow_.length < this.startRow_.length) {
                lastPadded = Bytes.padTail((byte[])this.currRow_, (int)(this.startRow_.length - this.currRow_.length));
            }
            if ((bigLastRow = new BigInteger(Bytes.add((byte[])(prependHeader = new byte[]{1, 0}), (byte[])lastPadded))).compareTo(this.bigEnd_) > 0) {
                return this.progressSoFar_;
            }
            BigDecimal processed = new BigDecimal(bigLastRow.subtract(this.bigStart_));
            try {
                BigDecimal progress = processed.setScale(3).divide(this.bigRange_, 5);
                this.progressSoFar_ = progress.floatValue();
                return this.progressSoFar_;
            }
            catch (ArithmeticException e) {
                return 0.0f;
            }
        }
    }

    public static class HBaseTableIFBuilder {
        protected byte[] gt_;
        protected byte[] gte_;
        protected byte[] lt_;
        protected byte[] lte_;
        protected long limit_;
        protected Configuration conf_;

        public HBaseTableIFBuilder withGt(byte[] gt) {
            this.gt_ = gt;
            return this;
        }

        public HBaseTableIFBuilder withGte(byte[] gte) {
            this.gte_ = gte;
            return this;
        }

        public HBaseTableIFBuilder withLt(byte[] lt) {
            this.lt_ = lt;
            return this;
        }

        public HBaseTableIFBuilder withLte(byte[] lte) {
            this.lte_ = lte;
            return this;
        }

        public HBaseTableIFBuilder withLimit(long limit) {
            this.limit_ = limit;
            return this;
        }

        public HBaseTableIFBuilder withConf(Configuration conf) {
            this.conf_ = conf;
            return this;
        }

        public HBaseTableInputFormat build() {
            HBaseTableInputFormat inputFormat = new HBaseTableInputFormat(this.limit_, this.gt_, this.gte_, this.lt_, this.lte_);
            if (this.conf_ != null) {
                inputFormat.setConf(this.conf_);
            }
            return inputFormat;
        }
    }
}

