/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.spark.converter;

import java.io.IOException;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.Result;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POStream;
import org.apache.pig.backend.hadoop.executionengine.spark.FlatMapFunctionAdapter;
import org.apache.pig.backend.hadoop.executionengine.spark.SparkShims;
import org.apache.pig.backend.hadoop.executionengine.spark.SparkUtil;
import org.apache.pig.backend.hadoop.executionengine.spark.converter.OutputConsumerIterator;
import org.apache.pig.backend.hadoop.executionengine.spark.converter.RDDConverter;
import org.apache.pig.data.Tuple;
import org.apache.spark.rdd.RDD;

public class StreamConverter
implements RDDConverter<Tuple, Tuple, POStream> {
    @Override
    public RDD<Tuple> convert(List<RDD<Tuple>> predecessors, POStream poStream) throws IOException {
        SparkUtil.assertPredecessorSize(predecessors, poStream, 1);
        RDD<Tuple> rdd = predecessors.get(0);
        StreamFunction streamFunction = new StreamFunction(poStream);
        return rdd.toJavaRDD().mapPartitions(SparkShims.getInstance().flatMapFunction(streamFunction), true).rdd();
    }

    private static class StreamFunction
    implements FlatMapFunctionAdapter<Iterator<Tuple>, Tuple>,
    Serializable {
        private POStream poStream;

        private StreamFunction(POStream poStream) {
            this.poStream = poStream;
        }

        @Override
        public Iterator<Tuple> call(Iterator<Tuple> input) {
            return new OutputConsumerIterator(input){

                @Override
                protected void attach(Tuple tuple) {
                    poStream.setInputs(null);
                    poStream.attachInput(tuple);
                }

                @Override
                protected Result getNextResult() throws ExecException {
                    Result result = poStream.getNextTuple();
                    return result;
                }

                @Override
                protected void endOfInput() {
                    poStream.setFetchable(true);
                }
            };
        }
    }
}

