/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.spark.converter;

import java.io.IOException;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POSort;
import org.apache.pig.backend.hadoop.executionengine.spark.FlatMapFunctionAdapter;
import org.apache.pig.backend.hadoop.executionengine.spark.SparkPigContext;
import org.apache.pig.backend.hadoop.executionengine.spark.SparkShims;
import org.apache.pig.backend.hadoop.executionengine.spark.SparkUtil;
import org.apache.pig.backend.hadoop.executionengine.spark.converter.IteratorTransform;
import org.apache.pig.backend.hadoop.executionengine.spark.converter.RDDConverter;
import org.apache.pig.data.Tuple;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.rdd.RDD;
import scala.Function1;
import scala.Tuple2;
import scala.runtime.AbstractFunction1;

public class SortConverter
implements RDDConverter<Tuple, Tuple, POSort> {
    private static final Log LOG = LogFactory.getLog(SortConverter.class);
    private static final FlatMapFunctionAdapter<Iterator<Tuple2<Tuple, Object>>, Tuple> TO_VALUE_FUNCTION = new ToValueFunction();

    @Override
    public RDD<Tuple> convert(List<RDD<Tuple>> predecessors, POSort sortOperator) throws IOException {
        SparkUtil.assertPredecessorSize(predecessors, sortOperator, 1);
        RDD<Tuple> rdd = predecessors.get(0);
        SparkPigContext.get();
        int parallelism = SparkPigContext.getParallelism(predecessors, sortOperator);
        RDD rddPair = rdd.map((Function1)new ToKeyValueFunction(), SparkUtil.getTuple2Manifest());
        JavaPairRDD r = new JavaPairRDD(rddPair, SparkUtil.getManifest(Tuple.class), SparkUtil.getManifest(Object.class));
        JavaPairRDD sorted = r.sortByKey(sortOperator.getMComparator(), true, parallelism);
        JavaRDD mapped = sorted.mapPartitions(SparkShims.getInstance().flatMapFunction(TO_VALUE_FUNCTION));
        return mapped.rdd();
    }

    private static class ToKeyValueFunction
    extends AbstractFunction1<Tuple, Tuple2<Tuple, Object>>
    implements Serializable {
        private ToKeyValueFunction() {
        }

        public Tuple2<Tuple, Object> apply(Tuple t) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Sort ToKeyValueFunction in " + t));
            }
            Tuple key = t;
            Object value = null;
            Tuple2 out = new Tuple2((Object)key, value);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Sort ToKeyValueFunction out " + out));
            }
            return out;
        }
    }

    private static class ToValueFunction
    implements FlatMapFunctionAdapter<Iterator<Tuple2<Tuple, Object>>, Tuple>,
    Serializable {
        private ToValueFunction() {
        }

        @Override
        public Iterator<Tuple> call(Iterator<Tuple2<Tuple, Object>> input) {
            return new Tuple2TransformIterable(input).iterator();
        }

        private class Tuple2TransformIterable
        implements Iterable<Tuple> {
            Iterator<Tuple2<Tuple, Object>> in;

            Tuple2TransformIterable(Iterator<Tuple2<Tuple, Object>> input) {
                this.in = input;
            }

            @Override
            public Iterator<Tuple> iterator() {
                return new IteratorTransform<Tuple2<Tuple, Object>, Tuple>(this.in){

                    @Override
                    protected Tuple transform(Tuple2<Tuple, Object> next) {
                        return (Tuple)next._1();
                    }
                };
            }
        }
    }
}

