/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.spark.converter;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.Result;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POCollectedGroup;
import org.apache.pig.backend.hadoop.executionengine.spark.FlatMapFunctionAdapter;
import org.apache.pig.backend.hadoop.executionengine.spark.SparkShims;
import org.apache.pig.backend.hadoop.executionengine.spark.SparkUtil;
import org.apache.pig.backend.hadoop.executionengine.spark.converter.OutputConsumerIterator;
import org.apache.pig.backend.hadoop.executionengine.spark.converter.RDDConverter;
import org.apache.pig.data.Tuple;
import org.apache.spark.rdd.RDD;

public class CollectedGroupConverter
implements RDDConverter<Tuple, Tuple, POCollectedGroup> {
    @Override
    public RDD<Tuple> convert(List<RDD<Tuple>> predecessors, POCollectedGroup physicalOperator) throws IOException {
        SparkUtil.assertPredecessorSize(predecessors, physicalOperator, 1);
        RDD<Tuple> rdd = predecessors.get(0);
        CollectedGroupFunction collectedGroupFunction = new CollectedGroupFunction(physicalOperator);
        return rdd.toJavaRDD().mapPartitions(SparkShims.getInstance().flatMapFunction(collectedGroupFunction), true).rdd();
    }

    private static class CollectedGroupFunction
    implements FlatMapFunctionAdapter<Iterator<Tuple>, Tuple> {
        private POCollectedGroup poCollectedGroup;
        public long current_val;

        private CollectedGroupFunction(POCollectedGroup poCollectedGroup) {
            this.poCollectedGroup = poCollectedGroup;
            this.current_val = 0L;
        }

        @Override
        public Iterator<Tuple> call(Iterator<Tuple> input) {
            return new OutputConsumerIterator(input){

                @Override
                protected void attach(Tuple tuple) {
                    poCollectedGroup.setInputs(null);
                    poCollectedGroup.attachInput(tuple);
                }

                @Override
                protected Result getNextResult() throws ExecException {
                    return poCollectedGroup.getNextTuple();
                }

                @Override
                protected void endOfInput() {
                    poCollectedGroup.setEndOfInput(true);
                }
            };
        }
    }
}

