/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.spark;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.pig.backend.hadoop.executionengine.spark.FlatMapFunctionAdapter;
import org.apache.pig.backend.hadoop.executionengine.spark.PairFlatMapFunctionAdapter;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.util.UDFContext;
import org.apache.pig.tools.pigstats.PigStats;
import org.apache.pig.tools.pigstats.spark.SparkJobStats;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.api.java.function.PairFlatMapFunction;
import org.apache.spark.executor.TaskMetrics;
import org.apache.spark.rdd.RDD;
import org.apache.spark.scheduler.SparkListener;

public abstract class SparkShims
implements Serializable {
    private static final Log LOG = LogFactory.getLog(SparkShims.class);
    public static final String SPARK_VERSION = "pig.spark.version";
    private static SparkShims sparkShims;

    private static SparkShims loadShims(String sparkVersion) throws ReflectiveOperationException {
        Class<?> sparkShimsClass;
        if ("2".equals(sparkVersion)) {
            LOG.info((Object)"Initializing shims for Spark 2.x");
            sparkShimsClass = Class.forName("org.apache.pig.backend.hadoop.executionengine.spark.Spark2Shims");
        } else {
            LOG.info((Object)"Initializing shims for Spark 1.x");
            sparkShimsClass = Class.forName("org.apache.pig.backend.hadoop.executionengine.spark.Spark1Shims");
        }
        Constructor<?> c = sparkShimsClass.getConstructor(new Class[0]);
        return (SparkShims)c.newInstance(new Object[0]);
    }

    public static SparkShims getInstance() {
        if (sparkShims == null) {
            String sparkVersion = UDFContext.getUDFContext().isFrontend() ? SparkContext.getOrCreate().version() : UDFContext.getUDFContext().getJobConf().get(SPARK_VERSION, "");
            LOG.info((Object)("Initializing SparkShims for Spark version: " + sparkVersion));
            String sparkMajorVersion = SparkShims.getSparkMajorVersion(sparkVersion);
            try {
                sparkShims = SparkShims.loadShims(sparkMajorVersion);
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException(e);
            }
        }
        return sparkShims;
    }

    private static String getSparkMajorVersion(String sparkVersion) {
        return sparkVersion.startsWith("2") ? "2" : "1";
    }

    public abstract <T, R> FlatMapFunction<T, R> flatMapFunction(FlatMapFunctionAdapter<T, R> var1);

    public abstract <T, K, V> PairFlatMapFunction<T, K, V> pairFlatMapFunction(PairFlatMapFunctionAdapter<T, K, V> var1);

    public abstract RDD<Tuple> coalesce(RDD<Tuple> var1, int var2, boolean var3);

    public abstract SparkJobStats sparkJobStats(int var1, PigStats.JobGraph var2, Configuration var3);

    public abstract SparkJobStats sparkJobStats(String var1, PigStats.JobGraph var2, Configuration var3);

    public abstract <T> OptionalWrapper<T> wrapOptional(T var1);

    public abstract SparkListener getJobMetricsListener(Map<Integer, int[]> var1, Map<Integer, Integer> var2, Map<Integer, Map<String, List<TaskMetrics>>> var3, Set<Integer> var4);

    public abstract void addSparkListener(SparkContext var1, SparkListener var2);

    public static interface OptionalWrapper<T> {
        public boolean isPresent();

        public T get();
    }
}

