/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.mstor.data;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.fortuna.mstor.data.MessageAppender;
import net.fortuna.mstor.data.MessageInputStream;
import net.fortuna.mstor.util.CacheAdapter;
import net.fortuna.mstor.util.CapabilityHints;
import net.fortuna.mstor.util.Configurator;
import net.fortuna.mstor.util.EhCacheAdapter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MboxFile {
    public static final String KEY_BUFFER_STRATEGY = "mstor.mbox.bufferStrategy";
    public static final String READ_ONLY = "r";
    public static final String READ_WRITE = "rw";
    private static final String TEMP_FILE_EXTENSION = ".tmp";
    public static final String FROM__PREFIX = "From ";
    private static final Pattern VALID_MBOX_PATTERN = Pattern.compile("^From .*", 32);
    private static final Pattern FROM__LINE_PATTERN = Pattern.compile("(\\A|\\n{2}|(\\r\\n){2})^From .*$", 8);
    private static final Pattern RELAXED_FROM__LINE_PATTERN = Pattern.compile("^(From .*)|(\\u0010\\u0010\\u0010\\u0010\\u0010\\u0010\\u0010\\u0011\\u0011\\u0011\\u0011\\u0011\\u0011\\u0053)$", 8);
    private static final int DEFAULT_BUFFER_SIZE = 8192;
    private static Charset charset = Charset.forName(Configurator.getProperty("mstor.mbox.encoding", "ISO-8859-1"));
    private Log log = LogFactory.getLog(MboxFile.class);
    private CharsetDecoder decoder = charset.newDecoder();
    private CharsetEncoder encoder = charset.newEncoder();
    private File file;
    private String mode;
    private RandomAccessFile raf;
    private FileChannel channel;
    private Long[] messagePositions;
    private CacheAdapter cacheAdapter;

    public MboxFile(File file) throws FileNotFoundException {
        this(file, READ_ONLY);
    }

    public MboxFile(File file, String mode) {
        this.encoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
        this.file = file;
        this.mode = mode;
    }

    private RandomAccessFile getRaf() throws FileNotFoundException {
        if (this.raf == null) {
            this.raf = new RandomAccessFile(this.file, this.mode);
        }
        return this.raf;
    }

    private FileChannel getChannel() throws FileNotFoundException {
        if (this.channel == null) {
            this.channel = this.getRaf().getChannel();
        }
        return this.channel;
    }

    private ByteBuffer read(long position, int size) throws IOException {
        ByteBuffer buffer = null;
        try {
            BufferStrategy bufferStrategy = null;
            if (Configurator.getProperty(KEY_BUFFER_STRATEGY) != null) {
                bufferStrategy = BufferStrategy.valueOf(Configurator.getProperty(KEY_BUFFER_STRATEGY).toUpperCase());
            }
            if (BufferStrategy.MAPPED.equals((Object)bufferStrategy)) {
                buffer = this.getChannel().map(FileChannel.MapMode.READ_ONLY, position, size);
            } else {
                if (BufferStrategy.DIRECT.equals((Object)bufferStrategy)) {
                    buffer = ByteBuffer.allocateDirect(size);
                } else if (BufferStrategy.DEFAULT.equals((Object)bufferStrategy) || bufferStrategy == null) {
                    buffer = ByteBuffer.allocate(size);
                } else {
                    throw new IllegalArgumentException("Unrecognised buffer strategy: " + Configurator.getProperty(KEY_BUFFER_STRATEGY));
                }
                this.getChannel().position(position);
                this.getChannel().read(buffer);
                buffer.flip();
            }
        }
        catch (IOException ioe) {
            this.log.warn((Object)"Error reading bytes using nio", (Throwable)ioe);
            this.getRaf().seek(position);
            byte[] buf = new byte[size];
            this.getRaf().read(buf);
            buffer = ByteBuffer.wrap(buf);
        }
        return buffer;
    }

    private Long[] getMessagePositions() throws IOException {
        if (this.messagePositions == null) {
            ArrayList<Long> posList = new ArrayList<Long>();
            this.log.debug((Object)("Channel size [" + this.getChannel().size() + "] bytes"));
            int bufferSize = (int)Math.min(this.getChannel().size(), 8192L);
            CharBuffer cs = null;
            ByteBuffer buffer = this.read(0L, bufferSize);
            cs = this.decoder.decode(buffer);
            this.log.debug((Object)("Buffer [" + cs + "]"));
            long offset = 0L;
            while (true) {
                Matcher matcher = null;
                matcher = CapabilityHints.isHintEnabled("mstor.mbox.parsing.relaxed") ? RELAXED_FROM__LINE_PATTERN.matcher(cs) : FROM__LINE_PATTERN.matcher(cs);
                while (matcher.find()) {
                    this.log.debug((Object)("Found match at [" + (offset + (long)matcher.start()) + "]"));
                    posList.add(offset + (long)matcher.start());
                }
                if (offset + (long)bufferSize >= this.getChannel().size()) break;
                bufferSize = (int)Math.min(this.getChannel().size() - (offset += (long)(bufferSize - FROM__PREFIX.length() - 2)), 8192L);
                buffer = this.read(offset, bufferSize);
                cs = this.decoder.decode(buffer);
            }
            this.messagePositions = posList.toArray(new Long[posList.size()]);
        }
        return this.messagePositions;
    }

    public final int getMessageCount() throws IOException {
        return this.getMessagePositions().length;
    }

    public final InputStream getMessageAsStream(int index) throws IOException {
        ByteBuffer buffer = null;
        if (CapabilityHints.isHintEnabled("mstor.mbox.cacheBuffers")) {
            buffer = this.retrieveBufferFromCache(index);
        }
        if (buffer == null) {
            long position = this.getMessagePositions()[index];
            long size = index < this.getMessagePositions().length - 1 ? this.getMessagePositions()[index + 1] - this.getMessagePositions()[index] : this.getChannel().size() - this.getMessagePositions()[index];
            buffer = this.read(position, (int)size);
            if (CapabilityHints.isHintEnabled("mstor.mbox.cacheBuffers")) {
                this.putBufferInCache(index, buffer);
            }
        }
        return new MessageInputStream(buffer);
    }

    public final byte[] getMessage(int index) throws IOException {
        int read;
        InputStream in = this.getMessageAsStream(index);
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        while ((read = in.read()) != -1) {
            bout.write(read);
        }
        return bout.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void appendMessage(byte[] message) throws IOException {
        File file = this.file;
        synchronized (file) {
            MessageAppender appender = new MessageAppender(this.getChannel());
            long newMessagePosition = appender.appendMessage(message);
            if (this.messagePositions != null) {
                Long[] newMessagePositions = new Long[this.messagePositions.length + 1];
                System.arraycopy(this.messagePositions, 0, newMessagePositions, 0, this.messagePositions.length);
                newMessagePositions[newMessagePositions.length - 1] = newMessagePosition;
                this.messagePositions = newMessagePositions;
            }
        }
        this.clearBufferCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void purge(int[] msgnums) throws IOException {
        File newFile = new File(System.getProperty("java.io.tmpdir"), this.file.getName() + TEMP_FILE_EXTENSION);
        FileOutputStream newOut = new FileOutputStream(newFile);
        FileChannel newChannel = newOut.getChannel();
        MessageAppender appender = new MessageAppender(newChannel);
        File file = this.file;
        synchronized (file) {
            block3: for (int i = 0; i < this.getMessagePositions().length; ++i) {
                for (int j = 0; j < msgnums.length; ++j) {
                    if (msgnums[j] == i) continue block3;
                }
                appender.appendMessage(this.getMessage(i));
            }
            newOut.close();
            this.close();
            File tempFile = new File(System.getProperty("java.io.tmpdir"), this.file.getName() + "." + System.currentTimeMillis());
            if (!this.renameTo(this.file, tempFile)) {
                throw new IOException("Unable to rename existing file");
            }
            tempFile.deleteOnExit();
            this.renameTo(newFile, this.file);
        }
    }

    private boolean renameTo(File source, File dest) {
        boolean success;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Renaming [" + source + "] to [" + dest + "]"));
        }
        if (dest.exists()) {
            dest.delete();
        }
        if (!(success = source.renameTo(dest))) {
            try {
                int length;
                FileInputStream in = new FileInputStream(source);
                FileOutputStream out = new FileOutputStream(dest);
                byte[] buffer = new byte[8192];
                while ((length = ((InputStream)in).read(buffer)) >= 0) {
                    ((OutputStream)out).write(buffer, 0, length);
                }
                ((InputStream)in).close();
                ((OutputStream)out).close();
                try {
                    success = source.delete();
                }
                catch (Exception e) {
                    this.log.warn((Object)"Error cleaning up", (Throwable)e);
                }
            }
            catch (IOException ioe) {
                this.log.error((Object)("Failed to rename [" + source + "] to [" + dest + "]"), (Throwable)ioe);
            }
        }
        return success;
    }

    public final void close() throws IOException {
        if (this.messagePositions != null) {
            this.messagePositions = null;
        }
        if (this.raf != null) {
            this.raf.close();
            this.raf = null;
            this.channel = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isValid(File file) {
        Log log;
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(file));
            String line = reader.readLine();
            boolean bl = line == null || VALID_MBOX_PATTERN.matcher(line).matches();
            return bl;
        }
        catch (Exception e) {
            log = LogFactory.getLog(MboxFile.class);
            log.info((Object)("Not a valid mbox file [" + file + "]"), (Throwable)e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException ioe) {
                    log = LogFactory.getLog(MboxFile.class);
                    log.info((Object)("Error closing stream [" + file + "]"), (Throwable)ioe);
                }
            }
        }
        return false;
    }

    private void putBufferInCache(int index, ByteBuffer buffer) {
        this.getCacheAdapter().putObjectIntoCache(index, buffer);
    }

    private void clearBufferCache() {
        this.getCacheAdapter().clearCache();
    }

    private ByteBuffer retrieveBufferFromCache(int index) {
        return (ByteBuffer)this.getCacheAdapter().retrieveObjectFromCache(index);
    }

    private CacheAdapter getCacheAdapter() {
        if (this.cacheAdapter == null) {
            this.cacheAdapter = Configurator.getProperty("mstor.cache.disabled", "false").equals("true") ? new CacheAdapter() : new EhCacheAdapter("mstor.mbox." + this.file.getAbsolutePath().hashCode());
        }
        return this.cacheAdapter;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BufferStrategy {
        DEFAULT,
        MAPPED,
        DIRECT;

    }
}

