/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.regionserver.Chunk;
import org.apache.hadoop.hbase.regionserver.ChunkCreator;
import org.apache.hadoop.hbase.regionserver.MemStoreLABImpl;
import org.apache.hadoop.hbase.util.ReflectionUtils;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public interface MemStoreLAB {
    public static final String USEMSLAB_KEY = "hbase.hregion.memstore.mslab.enabled";
    public static final boolean USEMSLAB_DEFAULT = true;
    public static final String MSLAB_CLASS_NAME = "hbase.regionserver.mslab.class";
    public static final String CHUNK_SIZE_KEY = "hbase.hregion.memstore.mslab.chunksize";
    public static final int CHUNK_SIZE_DEFAULT = 0x200000;
    public static final String INDEX_CHUNK_PERCENTAGE_KEY = "hbase.hregion.memstore.mslab.indexchunksize";
    public static final float INDEX_CHUNK_PERCENTAGE_DEFAULT = 0.1f;
    public static final String MAX_ALLOC_KEY = "hbase.hregion.memstore.mslab.max.allocation";
    public static final int MAX_ALLOC_DEFAULT = 262144;
    public static final String CHUNK_POOL_MAXSIZE_KEY = "hbase.hregion.memstore.chunkpool.maxsize";
    public static final String CHUNK_POOL_INITIALSIZE_KEY = "hbase.hregion.memstore.chunkpool.initialsize";
    public static final float POOL_MAX_SIZE_DEFAULT = 1.0f;
    public static final float POOL_INITIAL_SIZE_DEFAULT = 0.0f;

    public Cell copyCellInto(Cell var1);

    public Cell forceCopyOfBigCellInto(Cell var1);

    public void close();

    public void incScannerCount();

    public void decScannerCount();

    public Chunk getNewExternalChunk(ChunkCreator.ChunkType var1);

    public Chunk getNewExternalChunk(int var1);

    public static MemStoreLAB newInstance(Configuration conf) {
        MemStoreLAB memStoreLAB = null;
        if (MemStoreLAB.isEnabled(conf)) {
            String className = conf.get(MSLAB_CLASS_NAME, MemStoreLABImpl.class.getName());
            memStoreLAB = (MemStoreLAB)ReflectionUtils.instantiateWithCustomCtor((String)className, (Class[])new Class[]{Configuration.class}, (Object[])new Object[]{conf});
        }
        return memStoreLAB;
    }

    public static boolean isEnabled(Configuration conf) {
        return conf.getBoolean(USEMSLAB_KEY, true);
    }

    public boolean isOnHeap();

    public boolean isOffHeap();
}

