/*
 * Decompiled with CFR 0.152.
 */
package org.h2.tools;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.zip.CRC32;
import org.h2.compress.CompressLZF;
import org.h2.constant.SysProperties;
import org.h2.engine.MetaRecord;
import org.h2.message.DbException;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.result.SimpleRow;
import org.h2.security.SHA256;
import org.h2.store.Data;
import org.h2.store.DataHandler;
import org.h2.store.DataReader;
import org.h2.store.FileLister;
import org.h2.store.FileStore;
import org.h2.store.FileStoreInputStream;
import org.h2.store.LobStorage;
import org.h2.store.PageFreeList;
import org.h2.store.PageLog;
import org.h2.store.PageStore;
import org.h2.util.IOUtils;
import org.h2.util.IntArray;
import org.h2.util.MathUtils;
import org.h2.util.New;
import org.h2.util.SmallLRUCache;
import org.h2.util.StatementBuilder;
import org.h2.util.TempFileDeleter;
import org.h2.util.Tool;
import org.h2.util.Utils;
import org.h2.value.Value;
import org.h2.value.ValueLob;
import org.h2.value.ValueLob2;
import org.h2.value.ValueLong;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Recover
extends Tool
implements DataHandler {
    private String databaseName;
    private int block;
    private int storageId;
    private String storageName;
    private int recordLength;
    private int valueId;
    private boolean trace;
    private ArrayList<MetaRecord> schema;
    private HashSet<Integer> objectIdSet;
    private HashMap<Integer, String> tableMap;
    private boolean remove;
    private long pageDataEmpty;
    private int pageDataRows;
    private int pageDataHead;
    private int pageSize;
    private FileStore store;
    private int[] parents;

    public static void main(String ... stringArray) throws SQLException {
        new Recover().runTool(stringArray);
    }

    @Override
    public void runTool(String ... stringArray) throws SQLException {
        String string = ".";
        String string2 = null;
        for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
            String string3 = stringArray[i];
            if ("-dir".equals(string3)) {
                string = stringArray[++i];
                continue;
            }
            if ("-db".equals(string3)) {
                string2 = stringArray[++i];
                continue;
            }
            if ("-removePassword".equals(string3)) {
                this.remove = true;
                continue;
            }
            if ("-trace".equals(string3)) {
                this.trace = true;
                continue;
            }
            if (string3.equals("-help") || string3.equals("-?")) {
                this.showUsage();
                return;
            }
            this.throwUnsupportedOption(string3);
        }
        this.process(string, string2);
    }

    public static Reader readClob(String string) throws IOException {
        return new BufferedReader(new InputStreamReader(Recover.readBlob(string), "UTF-8"));
    }

    public static InputStream readBlob(String string) throws IOException {
        return new BufferedInputStream(IOUtils.openFileInputStream(string));
    }

    public static Reader readClobDb(Connection connection, long l) throws IOException {
        return new BufferedReader(new InputStreamReader(Recover.readBlobDb(connection, l), "UTF-8"));
    }

    public static InputStream readBlobDb(Connection connection, long l) throws IOException {
        return new BufferedInputStream(new LobStorage.LobInputStream(connection, l));
    }

    private void trace(String string) {
        if (this.trace) {
            this.out.println(string);
        }
    }

    private void traceError(String string, Throwable throwable) {
        this.out.println(string + ": " + throwable.toString());
        if (this.trace) {
            throwable.printStackTrace(this.out);
        }
    }

    public static void execute(String string, String string2) throws SQLException {
        try {
            new Recover().process(string, string2);
        }
        catch (DbException dbException) {
            throw DbException.toSQLException(dbException);
        }
    }

    private void process(String string, String string2) {
        ArrayList<String> arrayList = FileLister.getDatabaseFiles(string, string2, true);
        if (arrayList.size() == 0) {
            this.printNoDatabaseFilesFound(string, string2);
        }
        for (String string3 : arrayList) {
            if (string3.endsWith(".h2.db")) {
                this.dumpPageStore(string3);
                continue;
            }
            if (!string3.endsWith(".lob.db")) continue;
            this.dumpLob(string3, true);
            this.dumpLob(string3, false);
        }
    }

    private PrintWriter getWriter(String string, String string2) {
        string = string.substring(0, string.length() - 3);
        String string3 = string + string2;
        this.trace("Created file: " + string3);
        return new PrintWriter(IOUtils.getWriter(IOUtils.openFileOutputStream(string3, false)));
    }

    private void writeDataError(PrintWriter printWriter, String string, byte[] byArray) {
        int n;
        int n2;
        printWriter.println("-- ERROR: " + string + " block: " + this.block + " storageId: " + this.storageId + " recordLength: " + this.recordLength + " valueId: " + this.valueId);
        StringBuilder stringBuilder = new StringBuilder();
        for (n2 = 0; n2 < byArray.length; ++n2) {
            n = byArray[n2] & 0xFF;
            if (n >= 32 && n < 128) {
                stringBuilder.append((char)n);
                continue;
            }
            stringBuilder.append('?');
        }
        printWriter.println("-- dump: " + stringBuilder.toString());
        stringBuilder = new StringBuilder();
        for (n2 = 0; n2 < byArray.length; ++n2) {
            n = byArray[n2] & 0xFF;
            stringBuilder.append(' ');
            if (n < 16) {
                stringBuilder.append('0');
            }
            stringBuilder.append(Integer.toHexString(n));
        }
        printWriter.println("-- dump: " + stringBuilder.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void dumpLob(String string, boolean bl) {
        OutputStream outputStream = null;
        FileStore fileStore = null;
        int n = 0;
        String string2 = string + (bl ? ".comp" : "") + ".txt";
        BufferedInputStream bufferedInputStream = null;
        try {
            int n2;
            outputStream = IOUtils.openFileOutputStream(string2, false);
            fileStore = FileStore.open(null, string, "r");
            fileStore.init();
            bufferedInputStream = new BufferedInputStream(new FileStoreInputStream(fileStore, this, bl, false));
            byte[] byArray = new byte[4096];
            while ((n2 = ((InputStream)bufferedInputStream).read(byArray)) >= 0) {
                outputStream.write(byArray, 0, n2);
                n += n2;
            }
            outputStream.close();
        }
        catch (Throwable throwable) {
            IOUtils.closeSilently(outputStream);
            IOUtils.closeSilently(bufferedInputStream);
            this.closeSilently(fileStore);
            catch (Throwable throwable2) {
                IOUtils.closeSilently(outputStream);
                IOUtils.closeSilently(bufferedInputStream);
                this.closeSilently(fileStore);
                throw throwable2;
            }
        }
        IOUtils.closeSilently(outputStream);
        IOUtils.closeSilently(bufferedInputStream);
        this.closeSilently(fileStore);
        if (n == 0) {
            try {
                IOUtils.delete(string2);
            }
            catch (Exception exception) {
                this.traceError(string2, exception);
            }
        }
    }

    private String getSQL(Value value) {
        ValueLob2 valueLob2;
        byte[] byArray;
        if (value instanceof ValueLob) {
            ValueLob valueLob = (ValueLob)value;
            byte[] byArray2 = valueLob.getSmall();
            if (byArray2 == null) {
                String string = valueLob.getFileName();
                if (valueLob.getType() == 15) {
                    return "READ_BLOB('" + string + ".txt')";
                }
                return "READ_CLOB('" + string + ".txt')";
            }
        } else if (value instanceof ValueLob2 && (byArray = (valueLob2 = (ValueLob2)value).getSmall()) == null) {
            long l = valueLob2.getLobId();
            if (valueLob2.getType() == 15) {
                return "READ_BLOB_DB(" + l + ")";
            }
            return "READ_CLOB_DB(" + l + ")";
        }
        return value.getSQL();
    }

    private void setDatabaseName(String string) {
        this.databaseName = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpPageStore(String string) {
        this.setDatabaseName(string.substring(0, string.length() - ".h2.db".length()));
        PrintWriter printWriter = null;
        int[] nArray = new int[10];
        int n = 0;
        this.pageDataEmpty = 0L;
        this.pageDataRows = 0;
        this.pageDataHead = 0;
        try {
            int n2;
            int n3;
            int n4;
            int n5;
            int n6;
            printWriter = this.getWriter(string, ".sql");
            printWriter.println("CREATE ALIAS IF NOT EXISTS READ_CLOB FOR \"" + this.getClass().getName() + ".readClob\";");
            printWriter.println("CREATE ALIAS IF NOT EXISTS READ_BLOB FOR \"" + this.getClass().getName() + ".readBlob\";");
            printWriter.println("CREATE ALIAS IF NOT EXISTS READ_CLOB_DB FOR \"" + this.getClass().getName() + ".readClobDb\";");
            printWriter.println("CREATE ALIAS IF NOT EXISTS READ_BLOB_DB FOR \"" + this.getClass().getName() + ".readBlobDb\";");
            this.resetSchema();
            this.store = FileStore.open(null, string, this.remove ? "rw" : "r");
            long l = this.store.length();
            try {
                this.store.init();
            }
            catch (Exception exception) {
                this.writeError(printWriter, exception);
            }
            Data data = Data.create((DataHandler)this, 128);
            this.store.seek(0L);
            this.store.readFully(data.getBytes(), 0, 128);
            data.setPos(48);
            this.pageSize = data.readInt();
            int n7 = data.readByte();
            int n8 = data.readByte();
            printWriter.println("-- pageSize: " + this.pageSize + " writeVersion: " + n7 + " readVersion: " + n8);
            if (this.pageSize < 64 || this.pageSize > 32768) {
                this.pageSize = SysProperties.PAGE_SIZE;
                printWriter.println("-- ERROR: page size; using " + this.pageSize);
            }
            int n9 = (int)(l / (long)this.pageSize);
            this.parents = new int[n9];
            data = Data.create((DataHandler)this, this.pageSize);
            for (n6 = 3; n6 < n9; ++n6) {
                data.reset();
                this.store.seek(n6 * this.pageSize);
                this.store.readFully(data.getBytes(), 0, 32);
                data.readByte();
                data.readShortInt();
                this.parents[n6] = data.readInt();
            }
            n6 = 0;
            int n10 = 0;
            int n11 = 0;
            for (n5 = 1; n5 != 3; ++n5) {
                data.reset();
                this.store.seek(n5 * this.pageSize);
                this.store.readFully(data.getBytes(), 0, this.pageSize);
                CRC32 cRC32 = new CRC32();
                cRC32.update(data.getBytes(), 4, this.pageSize - 4);
                n4 = (int)cRC32.getValue();
                n3 = data.readInt();
                long l2 = data.readLong();
                n2 = data.readInt();
                int n12 = data.readInt();
                int n13 = data.readInt();
                if (n4 == n3) {
                    n6 = n2;
                    n10 = n12;
                    n11 = n13;
                }
                printWriter.println("-- head " + n5 + ": writeCounter: " + l2 + " log key: " + n2 + " trunk: " + n12 + "/" + n13 + " crc expected " + n4 + " got " + n3 + " (" + (n4 == n3 ? "ok" : "different") + ")");
            }
            printWriter.println("-- firstTrunkPage: " + n10 + " firstDataPage: " + n11);
            data = Data.create((DataHandler)this, this.pageSize);
            n5 = 0;
            block23: for (int i = 3; i < n9; ++i) {
                data = Data.create((DataHandler)this, this.pageSize);
                this.store.seek(i * this.pageSize);
                this.store.readFully(data.getBytes(), 0, this.pageSize);
                n4 = data.readByte();
                switch (n4) {
                    case 0: {
                        int n14 = n4;
                        nArray[n14] = nArray[n14] + 1;
                        ++n;
                        continue block23;
                    }
                    default: {
                        n3 = (n4 & 0x10) != 0 ? 1 : 0;
                        n4 &= 0xFFFFFFEF;
                        if (!PageStore.checksumTest(data.getBytes(), i, this.pageSize)) {
                            printWriter.println("-- ERROR: page " + i + " checksum mismatch type: " + n4);
                        }
                        data.readShortInt();
                        switch (n4) {
                            case 1: {
                                int n15 = n4;
                                nArray[n15] = nArray[n15] + 1;
                                int n16 = data.readInt();
                                this.setStorage(data.readVarInt());
                                int n17 = data.readVarInt();
                                n2 = data.readShortInt();
                                printWriter.println("-- page " + i + ": data leaf " + (n3 != 0 ? "(last)" : "") + " parent: " + n16 + " table: " + this.storageId + " entries: " + n2 + " columns: " + n17);
                                this.dumpPageDataLeaf(printWriter, data, n3 != 0, i, n17, n2);
                                continue block23;
                            }
                            case 2: {
                                int n18 = n4;
                                nArray[n18] = nArray[n18] + 1;
                                int n16 = data.readInt();
                                this.setStorage(data.readVarInt());
                                int n17 = data.readInt();
                                n2 = data.readShortInt();
                                printWriter.println("-- page " + i + ": data node " + (n3 != 0 ? "(last)" : "") + " parent: " + n16 + " entries: " + n2 + " rowCount: " + n17);
                                this.dumpPageDataNode(printWriter, data, i, n2);
                                continue block23;
                            }
                            case 3: {
                                int n19 = n4;
                                nArray[n19] = nArray[n19] + 1;
                                printWriter.println("-- page " + i + ": data overflow " + (n3 != 0 ? "(last)" : ""));
                                continue block23;
                            }
                            case 4: {
                                int n20 = n4;
                                nArray[n20] = nArray[n20] + 1;
                                int n16 = data.readInt();
                                this.setStorage(data.readVarInt());
                                int n17 = data.readShortInt();
                                printWriter.println("-- page " + i + ": b-tree leaf " + (n3 != 0 ? "(last)" : "") + " parent: " + n16 + " index: " + this.storageId + " entries: " + n17);
                                if (!this.trace) continue block23;
                                this.dumpPageBtreeLeaf(printWriter, data, n17, n3 == 0);
                                continue block23;
                            }
                            case 5: {
                                int n21 = n4;
                                nArray[n21] = nArray[n21] + 1;
                                int n16 = data.readInt();
                                this.setStorage(data.readVarInt());
                                printWriter.println("-- page " + i + ": b-tree node" + (n3 != 0 ? "(last)" : "") + " parent: " + n16 + " index: " + this.storageId);
                                this.dumpPageBtreeNode(printWriter, data, i, n3 == 0);
                                continue block23;
                            }
                            case 6: {
                                int n22 = n4;
                                nArray[n22] = nArray[n22] + 1;
                                printWriter.println("-- page " + i + ": free list " + (n3 != 0 ? "(last)" : ""));
                                n5 += this.dumpPageFreeList(printWriter, data, i, n9);
                                continue block23;
                            }
                            case 7: {
                                int n23 = n4;
                                nArray[n23] = nArray[n23] + 1;
                                printWriter.println("-- page " + i + ": log trunk");
                                continue block23;
                            }
                            case 8: {
                                int n24 = n4;
                                nArray[n24] = nArray[n24] + 1;
                                printWriter.println("-- page " + i + ": log data");
                                continue block23;
                            }
                            default: {
                                printWriter.println("-- ERROR page " + i + " unknown type " + n4);
                            }
                        }
                    }
                }
            }
            this.writeSchema(printWriter);
            try {
                this.dumpPageLogStream(printWriter, n6, n10, n11);
            }
            catch (EOFException eOFException) {
                // empty catch block
            }
            printWriter.println("---- Statistics ----------");
            printWriter.println("-- page count: " + n9 + " empty: " + n + " free: " + n5);
            printWriter.println("-- page data head: " + this.pageDataHead + " empty: " + this.pageDataEmpty + " rows: " + this.pageDataRows);
            for (int i = 0; i < nArray.length; ++i) {
                n4 = nArray[i];
                if (n4 <= 0) continue;
                printWriter.println("-- page count type: " + i + " " + 100 * n4 / n9 + "% count: " + n4);
            }
            printWriter.close();
        }
        catch (Throwable throwable) {
            try {
                this.writeError(printWriter, throwable);
            }
            catch (Throwable throwable2) {
                IOUtils.closeSilently(printWriter);
                this.closeSilently(this.store);
                throw throwable2;
            }
            IOUtils.closeSilently(printWriter);
            this.closeSilently(this.store);
        }
        IOUtils.closeSilently(printWriter);
        this.closeSilently(this.store);
    }

    private void dumpPageLogStream(PrintWriter printWriter, int n, int n2, int n3) throws IOException {
        byte by;
        Data data = Data.create((DataHandler)this, this.pageSize);
        DataReader dataReader = new DataReader(new PageInputStream(printWriter, this, this.store, n, n2, n3, this.pageSize));
        printWriter.println("---- Transaction log ----------");
        CompressLZF compressLZF = new CompressLZF();
        while ((by = dataReader.read()) >= 0) {
            int n4;
            if (by == 0) continue;
            if (by == 1) {
                Object object;
                n4 = dataReader.readVarInt();
                int n5 = dataReader.readVarInt();
                byte[] byArray = new byte[this.pageSize];
                if (n5 == 0) {
                    dataReader.readFully(byArray, 0, this.pageSize);
                } else if (n5 != 1) {
                    object = new byte[n5];
                    dataReader.readFully((byte[])object, 0, n5);
                    compressLZF.expand((byte[])object, 0, n5, byArray, 0, this.pageSize);
                }
                object = "";
                int n6 = byArray[0];
                boolean bl = (n6 & 0x10) != 0;
                switch (n6 &= 0xFFFFFFEF) {
                    case 0: {
                        object = "empty";
                        break;
                    }
                    case 1: {
                        object = "data leaf " + (bl ? "(last)" : "");
                        break;
                    }
                    case 2: {
                        object = "data node " + (bl ? "(last)" : "");
                        break;
                    }
                    case 3: {
                        object = "data overflow " + (bl ? "(last)" : "");
                        break;
                    }
                    case 4: {
                        object = "b-tree leaf " + (bl ? "(last)" : "");
                        break;
                    }
                    case 5: {
                        object = "b-tree node " + (bl ? "(last)" : "");
                        break;
                    }
                    case 6: {
                        object = "free list " + (bl ? "(last)" : "");
                        break;
                    }
                    case 7: {
                        object = "log trunk";
                        break;
                    }
                    case 8: {
                        object = "log data";
                        break;
                    }
                    default: {
                        object = "ERROR: unknown type " + n6;
                    }
                }
                printWriter.println("-- undo page " + n4 + " " + (String)object);
                continue;
            }
            if (by == 5) {
                n4 = dataReader.readVarInt();
                this.setStorage(dataReader.readVarInt());
                Row row = PageLog.readRow(dataReader, data);
                printWriter.println("-- session " + n4 + " table " + this.storageId + " add " + row.toString());
                continue;
            }
            if (by == 6) {
                n4 = dataReader.readVarInt();
                this.setStorage(dataReader.readVarInt());
                long l = dataReader.readVarLong();
                printWriter.println("-- session " + n4 + " table " + this.storageId + " remove " + l);
                continue;
            }
            if (by == 7) {
                n4 = dataReader.readVarInt();
                this.setStorage(dataReader.readVarInt());
                printWriter.println("-- session " + n4 + " table " + this.storageId + " truncate");
                continue;
            }
            if (by == 2) {
                n4 = dataReader.readVarInt();
                printWriter.println("-- commit " + n4);
                continue;
            }
            if (by == 4) {
                n4 = dataReader.readVarInt();
                printWriter.println("-- rollback " + n4);
                continue;
            }
            if (by == 3) {
                n4 = dataReader.readVarInt();
                String string = dataReader.readString();
                printWriter.println("-- prepare commit " + n4 + " " + string);
                continue;
            }
            if (by == 0) continue;
            if (by == 8) {
                printWriter.println("-- checkpoint");
                continue;
            }
            if (by == 9) {
                n4 = dataReader.readVarInt();
                StringBuilder stringBuilder = new StringBuilder("-- free");
                for (int i = 0; i < n4; ++i) {
                    stringBuilder.append(' ').append(dataReader.readVarInt());
                }
                printWriter.println(stringBuilder);
                continue;
            }
            printWriter.println("-- ERROR: unknown operation " + by);
            break;
        }
    }

    private String setStorage(int n) {
        this.storageId = n;
        this.storageName = "O_" + String.valueOf(n).replace('-', 'M');
        return this.storageName;
    }

    private void dumpPageBtreeNode(PrintWriter printWriter, Data data, int n, boolean bl) {
        int n2;
        int n3;
        int n4 = data.readInt();
        int n5 = data.readShortInt();
        int[] nArray = new int[n5 + 1];
        int[] nArray2 = new int[n5];
        nArray[n5] = data.readInt();
        this.checkParent(printWriter, n, nArray, n5);
        int n6 = Integer.MAX_VALUE;
        for (n3 = 0; n3 < n5; ++n3) {
            nArray[n3] = data.readInt();
            this.checkParent(printWriter, n, nArray, n3);
            n2 = data.readShortInt();
            n6 = Math.min(n2, n6);
            nArray2[n3] = n2;
        }
        n6 -= data.length();
        if (!this.trace) {
            return;
        }
        printWriter.println("--   empty: " + n6);
        for (n3 = 0; n3 < n5; ++n3) {
            Value value;
            n2 = nArray2[n3];
            data.setPos(n2);
            long l = data.readVarLong();
            if (bl) {
                value = ValueLong.get(l);
            } else {
                try {
                    value = data.readValue();
                }
                catch (Throwable throwable) {
                    this.writeDataError(printWriter, "exception " + throwable, data.getBytes());
                    continue;
                }
            }
            printWriter.println("-- [" + n3 + "] child: " + nArray[n3] + " key: " + l + " data: " + value);
        }
        printWriter.println("-- [" + n5 + "] child: " + nArray[n5] + " rowCount: " + n4);
    }

    private int dumpPageFreeList(PrintWriter printWriter, Data data, long l, long l2) {
        int n;
        int n2 = PageFreeList.getPagesAddressed(this.pageSize);
        BitSet bitSet = new BitSet();
        for (n = 0; n < n2; n += 8) {
            int n3 = data.readByte() & 0xFF;
            for (int i = 0; i < 8; ++i) {
                if ((n3 & 1 << i) == 0) continue;
                bitSet.set(n + i);
            }
        }
        n = 0;
        long l3 = 0L;
        for (long i = l; l3 < (long)n2 && i < l2; ++l3, ++i) {
            if (l3 == 0L || i % 100L == 0L) {
                if (l3 > 0L) {
                    printWriter.println();
                }
                printWriter.print("-- " + i + " ");
            } else if (i % 20L == 0L) {
                printWriter.print(" - ");
            } else if (i % 10L == 0L) {
                printWriter.print(' ');
            }
            printWriter.print(bitSet.get((int)l3) ? (char)'1' : '0');
            if (bitSet.get((int)l3)) continue;
            ++n;
        }
        printWriter.println();
        return n;
    }

    private void dumpPageBtreeLeaf(PrintWriter printWriter, Data data, int n, boolean bl) {
        int n2;
        int n3;
        int[] nArray = new int[n];
        int n4 = Integer.MAX_VALUE;
        for (n3 = 0; n3 < n; ++n3) {
            n2 = data.readShortInt();
            n4 = Math.min(n2, n4);
            nArray[n3] = n2;
        }
        printWriter.println("--   empty: " + (n4 -= data.length()));
        for (n3 = 0; n3 < n; ++n3) {
            Value value;
            n2 = nArray[n3];
            data.setPos(n2);
            long l = data.readVarLong();
            if (bl) {
                value = ValueLong.get(l);
            } else {
                try {
                    value = data.readValue();
                }
                catch (Throwable throwable) {
                    this.writeDataError(printWriter, "exception " + throwable, data.getBytes());
                    continue;
                }
            }
            printWriter.println("-- [" + n3 + "] key: " + l + " data: " + value);
        }
    }

    private void checkParent(PrintWriter printWriter, long l, int[] nArray, int n) {
        int n2 = nArray[n];
        if (n2 < 0 || n2 >= this.parents.length) {
            printWriter.println("-- ERROR [" + l + "] child[" + n + "]: " + n2 + " >= page count: " + this.parents.length);
        } else if ((long)this.parents[n2] != l) {
            printWriter.println("-- ERROR [" + l + "] child[" + n + "]: " + n2 + " parent: " + this.parents[n2]);
        }
    }

    private void dumpPageDataNode(PrintWriter printWriter, Data data, long l, int n) {
        int n2;
        int[] nArray = new int[n + 1];
        long[] lArray = new long[n];
        nArray[n] = data.readInt();
        this.checkParent(printWriter, l, nArray, n);
        for (n2 = 0; n2 < n; ++n2) {
            nArray[n2] = data.readInt();
            this.checkParent(printWriter, l, nArray, n2);
            lArray[n2] = data.readVarLong();
        }
        if (!this.trace) {
            return;
        }
        for (n2 = 0; n2 < n; ++n2) {
            printWriter.println("-- [" + n2 + "] child: " + nArray[n2] + " key: " + lArray[n2]);
        }
        printWriter.println("-- [" + n + "] child: " + nArray[n]);
    }

    private void dumpPageDataLeaf(PrintWriter printWriter, Data data, boolean bl, long l, int n, int n2) {
        int n3;
        int n4;
        int[] nArray;
        long[] lArray;
        block11: {
            lArray = new long[n2];
            nArray = new int[n2];
            long l2 = 0L;
            if (!bl) {
                l2 = data.readInt();
                printWriter.println("--   next: " + l2);
            }
            int n5 = this.pageSize;
            for (n4 = 0; n4 < n2; ++n4) {
                lArray[n4] = data.readVarLong();
                int n6 = data.readShortInt();
                n5 = Math.min(n6, n5);
                nArray[n4] = n6;
            }
            this.pageDataRows += this.pageSize - n5;
            this.pageDataHead += data.length();
            this.pageDataEmpty += (long)(n5 -= data.length());
            if (this.trace) {
                printWriter.println("--   empty: " + n5);
            }
            if (!bl) {
                Data data2 = Data.create((DataHandler)this, this.pageSize);
                data.setPos(this.pageSize);
                long l3 = l;
                while (true) {
                    int n7;
                    this.checkParent(printWriter, l3, new int[]{(int)l2}, 0);
                    l3 = l2;
                    this.store.seek((long)this.pageSize * l2);
                    this.store.readFully(data2.getBytes(), 0, this.pageSize);
                    data2.reset();
                    n3 = data2.readByte();
                    data2.readShortInt();
                    data2.readInt();
                    if (n3 == 19) {
                        n7 = data2.readShortInt();
                        printWriter.println("-- chain: " + l2 + " type: " + n3 + " size: " + n7);
                        data.checkCapacity(n7);
                        data.write(data2.getBytes(), data2.length(), n7);
                        break block11;
                    }
                    if (n3 != 3) break;
                    l2 = data2.readInt();
                    if (l2 == 0L) {
                        this.writeDataError(printWriter, "next:0", data2.getBytes());
                        break block11;
                    }
                    n7 = this.pageSize - data2.length();
                    printWriter.println("-- chain: " + l2 + " type: " + n3 + " size: " + n7 + " next: " + l2);
                    data.checkCapacity(n7);
                    data.write(data2.getBytes(), data2.length(), n7);
                }
                this.writeDataError(printWriter, "type: " + n3, data2.getBytes());
            }
        }
        for (n4 = 0; n4 < n2; ++n4) {
            int n8;
            String string;
            long l4 = lArray[n4];
            n3 = nArray[n4];
            if (this.trace) {
                printWriter.println("-- [" + n4 + "] storage: " + this.storageId + " key: " + l4 + " off: " + n3);
            }
            data.setPos(n3);
            Value[] valueArray = this.createRecord(printWriter, data, n);
            if (valueArray == null) continue;
            this.createTemporaryTable(printWriter);
            this.writeRow(printWriter, data, valueArray);
            if (!this.remove || this.storageId != 0 || !(string = valueArray[3].getString()).startsWith("CREATE USER ") || (n8 = Utils.indexOf(data.getBytes(), "SALT ".getBytes(), n3)) < 0) continue;
            String string2 = string.substring("CREATE USER ".length(), string.indexOf("SALT ") - 1);
            if (string2.startsWith("\"")) {
                string2 = string2.substring(1, string2.length() - 1);
            }
            SHA256 sHA256 = new SHA256();
            byte[] byArray = sHA256.getKeyPasswordHash(string2, "".toCharArray());
            byte[] byArray2 = MathUtils.secureRandomBytes(8);
            byte[] byArray3 = sHA256.getHashWithSalt(byArray, byArray2);
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("SALT '").append(Utils.convertBytesToString(byArray2)).append("' HASH '").append(Utils.convertBytesToString(byArray3)).append('\'');
            byte[] byArray4 = stringBuilder.toString().getBytes();
            System.arraycopy(byArray4, 0, data.getBytes(), n8, byArray4.length);
            this.store.seek((long)this.pageSize * l);
            this.store.write(data.getBytes(), 0, this.pageSize);
            if (this.trace) {
                this.out.println("User: " + string2);
            }
            this.remove = false;
        }
    }

    private Value[] createRecord(PrintWriter printWriter, Data data, int n) {
        Value[] valueArray;
        this.recordLength = n;
        if (n <= 0) {
            this.writeDataError(printWriter, "columnCount<0", data.getBytes());
            return null;
        }
        try {
            valueArray = new Value[n];
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.writeDataError(printWriter, "out of memory", data.getBytes());
            return null;
        }
        return valueArray;
    }

    private void writeRow(PrintWriter printWriter, Data data, Value[] valueArray) {
        Object object;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("INSERT INTO " + this.storageName + " VALUES(");
        this.valueId = 0;
        while (this.valueId < this.recordLength) {
            try {
                object = data.readValue();
                valueArray[this.valueId] = object;
                if (this.valueId > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(this.getSQL((Value)object));
            }
            catch (Exception exception) {
                this.writeDataError(printWriter, "exception " + exception, data.getBytes());
            }
            catch (OutOfMemoryError outOfMemoryError) {
                this.writeDataError(printWriter, "out of memory", data.getBytes());
            }
            ++this.valueId;
        }
        stringBuilder.append(");");
        printWriter.println(stringBuilder.toString());
        if (this.storageId == 0) {
            try {
                object = new SimpleRow(valueArray);
                MetaRecord metaRecord = new MetaRecord((SearchRow)object);
                this.schema.add(metaRecord);
                if (metaRecord.getObjectType() == 0) {
                    String string = valueArray[3].getString();
                    String string2 = this.extractTableOrViewName(string);
                    this.tableMap.put(metaRecord.getId(), string2);
                }
            }
            catch (Throwable throwable) {
                this.writeError(printWriter, throwable);
            }
        }
    }

    private void resetSchema() {
        this.schema = New.arrayList();
        this.objectIdSet = New.hashSet();
        this.tableMap = New.hashMap();
    }

    private void writeSchema(PrintWriter printWriter) {
        Object object;
        printWriter.println("---- Schema ----------");
        Collections.sort(this.schema);
        for (MetaRecord object2 : this.schema) {
            object = object2.getSQL();
            if (!((String)object).startsWith("CREATE ")) continue;
            printWriter.println((String)object + ";");
        }
        for (Map.Entry entry : this.tableMap.entrySet()) {
            object = (Integer)entry.getKey();
            String string = (String)entry.getValue();
            if (!this.objectIdSet.contains(object)) continue;
            this.setStorage((Integer)object);
            printWriter.println("INSERT INTO " + string + " SELECT * FROM " + this.storageName + ";");
        }
        for (Integer n : this.objectIdSet) {
            this.setStorage(n);
            printWriter.println("DROP TABLE " + this.storageName + ";");
        }
        printWriter.println("DROP ALIAS READ_CLOB;");
        printWriter.println("DROP ALIAS READ_BLOB;");
        printWriter.println("DROP ALIAS READ_CLOB_DB;");
        printWriter.println("DROP ALIAS READ_BLOB_DB;");
        for (MetaRecord metaRecord : this.schema) {
            object = metaRecord.getSQL();
            if (((String)object).startsWith("CREATE ")) continue;
            printWriter.println((String)object + ";");
        }
    }

    private void createTemporaryTable(PrintWriter printWriter) {
        if (!this.objectIdSet.contains(this.storageId)) {
            this.objectIdSet.add(this.storageId);
            StatementBuilder statementBuilder = new StatementBuilder("CREATE TABLE ");
            statementBuilder.append(this.storageName).append('(');
            for (int i = 0; i < this.recordLength; ++i) {
                statementBuilder.appendExceptFirst(", ");
                statementBuilder.append('C').append(i).append(" VARCHAR");
            }
            printWriter.println(statementBuilder.append(");").toString());
            printWriter.flush();
        }
    }

    private String extractTableOrViewName(String string) {
        int n = string.indexOf(" TABLE ");
        int n2 = string.indexOf(" VIEW ");
        if (n > 0 && n2 > 0) {
            if (n < n2) {
                n2 = -1;
            } else {
                n = -1;
            }
        }
        if (n2 > 0) {
            string = string.substring(n2 + " VIEW ".length());
        } else if (n > 0) {
            string = string.substring(n + " TABLE ".length());
        } else {
            return "UNKNOWN";
        }
        boolean bl = false;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\"') {
                bl = !bl;
                continue;
            }
            if (bl || c > ' ' && c != '(') continue;
            string = string.substring(0, i);
            return string;
        }
        return "UNKNOWN";
    }

    private void closeSilently(FileStore fileStore) {
        if (fileStore != null) {
            fileStore.closeSilently();
        }
    }

    private void writeError(PrintWriter printWriter, Throwable throwable) {
        if (printWriter != null) {
            printWriter.println("// error: " + throwable);
        }
        this.traceError("Error", throwable);
    }

    @Override
    public String getDatabasePath() {
        return this.databaseName;
    }

    @Override
    public FileStore openFile(String string, String string2, boolean bl) {
        return FileStore.open(this, string, "rw");
    }

    @Override
    public void checkPowerOff() {
    }

    @Override
    public void checkWritingAllowed() {
    }

    @Override
    public void freeUpDiskSpace() {
    }

    @Override
    public int getMaxLengthInplaceLob() {
        throw DbException.throwInternalError();
    }

    @Override
    public String getLobCompressionAlgorithm(int n) {
        return null;
    }

    @Override
    public Object getLobSyncObject() {
        return this;
    }

    @Override
    public SmallLRUCache<String, String[]> getLobFileListCache() {
        return null;
    }

    @Override
    public TempFileDeleter getTempFileDeleter() {
        return TempFileDeleter.getInstance();
    }

    @Override
    public LobStorage getLobStorage() {
        return null;
    }

    static class PageInputStream
    extends InputStream {
        private final PrintWriter writer;
        private final FileStore store;
        private final Data page;
        private final int pageSize;
        private int trunkPage;
        private int dataPage;
        private IntArray dataPages = new IntArray();
        private boolean endOfFile;
        private int remaining;
        private int logKey;

        public PageInputStream(PrintWriter printWriter, DataHandler dataHandler, FileStore fileStore, int n, int n2, int n3, int n4) {
            this.writer = printWriter;
            this.store = fileStore;
            this.pageSize = n4;
            this.logKey = n - 1;
            this.trunkPage = n2;
            this.dataPage = n3;
            this.page = Data.create(dataHandler, n4);
        }

        public int read() {
            byte[] byArray = new byte[1];
            int n = this.read(byArray);
            return n < 0 ? -1 : byArray[0] & 0xFF;
        }

        public int read(byte[] byArray) {
            return this.read(byArray, 0, byArray.length);
        }

        public int read(byte[] byArray, int n, int n2) {
            int n3;
            if (n2 == 0) {
                return 0;
            }
            int n4 = 0;
            while (n2 > 0 && (n3 = this.readBlock(byArray, n, n2)) >= 0) {
                n4 += n3;
                n += n3;
                n2 -= n3;
            }
            return n4 == 0 ? -1 : n4;
        }

        private int readBlock(byte[] byArray, int n, int n2) {
            this.fillBuffer();
            if (this.endOfFile) {
                return -1;
            }
            int n3 = Math.min(this.remaining, n2);
            this.page.read(byArray, n, n3);
            this.remaining -= n3;
            return n3;
        }

        private void fillBuffer() {
            int n;
            int n2;
            int n3;
            int n4;
            if (this.remaining > 0 || this.endOfFile) {
                return;
            }
            while (this.dataPages.size() == 0) {
                if (this.trunkPage == 0) {
                    this.endOfFile = true;
                    return;
                }
                this.store.seek((long)this.trunkPage * (long)this.pageSize);
                this.store.readFully(this.page.getBytes(), 0, this.pageSize);
                this.page.reset();
                if (!PageStore.checksumTest(this.page.getBytes(), this.trunkPage, this.pageSize)) {
                    this.writer.println("-- ERROR: checksum mismatch page: " + this.trunkPage);
                    this.endOfFile = true;
                    return;
                }
                n4 = this.page.readByte();
                this.page.readShortInt();
                if (n4 != 7) {
                    this.writer.println("-- eof  page: " + this.trunkPage + " type: " + n4 + " expected type: " + 7);
                    this.endOfFile = true;
                    return;
                }
                this.page.readInt();
                n3 = this.page.readInt();
                ++this.logKey;
                if (n3 != this.logKey) {
                    this.writer.println("-- eof  page: " + this.trunkPage + " type: " + n4 + " expected key: " + this.logKey + " got: " + n3);
                }
                this.trunkPage = this.page.readInt();
                n2 = this.page.readShortInt();
                for (n = 0; n < n2; ++n) {
                    int n5 = this.page.readInt();
                    if (this.dataPage != 0) {
                        if (n5 != this.dataPage) continue;
                        this.dataPage = 0;
                    }
                    this.dataPages.add(n5);
                }
            }
            if (this.dataPages.size() > 0) {
                this.page.reset();
                n4 = this.dataPages.get(0);
                this.dataPages.remove(0);
                this.store.seek((long)n4 * (long)this.pageSize);
                this.store.readFully(this.page.getBytes(), 0, this.pageSize);
                this.page.reset();
                n3 = this.page.readByte();
                if (n3 != 0 && !PageStore.checksumTest(this.page.getBytes(), n4, this.pageSize)) {
                    this.writer.println("-- ERROR: checksum mismatch page: " + n4);
                    this.endOfFile = true;
                    return;
                }
                this.page.readShortInt();
                n2 = this.page.readInt();
                n = this.page.readInt();
                if (n3 != 8) {
                    this.writer.println("-- eof  page: " + n4 + " type: " + n3 + " parent: " + n2 + " expected type: " + 8);
                    this.endOfFile = true;
                    return;
                }
                if (n != this.logKey) {
                    this.writer.println("-- eof  page: " + n4 + " type: " + n3 + " parent: " + n2 + " expected key: " + this.logKey + " got: " + n);
                    this.endOfFile = true;
                    return;
                }
                this.remaining = this.pageSize - this.page.length();
            }
        }
    }
}

