/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.www;

import java.util.List;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.core.xml.XMLHandler;
import org.w3c.dom.Node;

public class SlaveSequence {
    public static final String XML_TAG = "sequence";
    private String name;
    private long startValue;
    private DatabaseMeta databaseMeta;
    private String schemaName;
    private String tableName;
    private String sequenceNameField;
    private String valueField;

    public SlaveSequence() {
        this.startValue = 1L;
    }

    public SlaveSequence(String name, long startValue, DatabaseMeta databaseMeta, String schemaName, String tableName, String sequenceNameField, String valueField) {
        this.name = name;
        this.startValue = startValue;
        this.databaseMeta = databaseMeta;
        this.schemaName = schemaName;
        this.tableName = tableName;
        this.sequenceNameField = sequenceNameField;
        this.valueField = valueField;
    }

    public synchronized long getNextValue(LoggingObjectInterface log, long incrementValue) throws KettleException {
        Database db = null;
        try {
            long value;
            db = new Database(log, this.databaseMeta);
            db.connect();
            String schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(this.schemaName, this.tableName);
            String seqField = this.databaseMeta.quoteField(this.sequenceNameField);
            String valField = this.databaseMeta.quoteField(this.valueField);
            boolean update = false;
            String sql = "SELECT " + valField + " FROM " + schemaTable + " WHERE " + seqField + " = ?";
            RowMetaAndData param = new RowMetaAndData();
            param.addValue(seqField, 2, (Object)this.name);
            RowMetaAndData row = db.getOneRow(sql, param.getRowMeta(), param.getData());
            if (row != null && row.getData() != null) {
                update = true;
                Long longValue = row.getInteger(0);
                value = longValue == null ? this.startValue : longValue;
            } else {
                value = this.startValue;
            }
            long maximum = value + incrementValue;
            if (update) {
                sql = "UPDATE " + schemaTable + " SET " + valField + "= ? WHERE " + seqField + "= ? ";
                param = new RowMetaAndData();
                param.addValue(valField, 5, (Object)maximum);
                param.addValue(seqField, 2, (Object)this.name);
            } else {
                sql = "INSERT INTO " + schemaTable + "(" + seqField + ", " + valField + ") VALUES( ? , ? )";
                param = new RowMetaAndData();
                param.addValue(seqField, 2, (Object)this.name);
                param.addValue(valField, 5, (Object)maximum);
            }
            db.execStatement(sql, param.getRowMeta(), param.getData());
            long l = value;
            return l;
        }
        catch (Exception e) {
            throw new KettleException("Unable to get next value for slave sequence '" + this.name + "' on database '" + this.databaseMeta.getName() + "'", (Throwable)e);
        }
        finally {
            db.disconnect();
        }
    }

    public SlaveSequence(Node node, List<DatabaseMeta> databases) throws KettleXMLException {
        this.name = XMLHandler.getTagValue((Node)node, (String)"name");
        this.startValue = Const.toInt((String)XMLHandler.getTagValue((Node)node, (String)"start"), (int)0);
        this.databaseMeta = DatabaseMeta.findDatabase(databases, (String)XMLHandler.getTagValue((Node)node, (String)"connection"));
        this.schemaName = XMLHandler.getTagValue((Node)node, (String)"schema");
        this.tableName = XMLHandler.getTagValue((Node)node, (String)"table");
        this.sequenceNameField = XMLHandler.getTagValue((Node)node, (String)"sequence_field");
        this.valueField = XMLHandler.getTagValue((Node)node, (String)"value_field");
    }

    public String getXML() {
        StringBuilder xml = new StringBuilder(100);
        xml.append(XMLHandler.addTagValue((String)"name", (String)this.name));
        xml.append(XMLHandler.addTagValue((String)"start", (long)this.startValue));
        xml.append(XMLHandler.addTagValue((String)"connection", (String)(this.databaseMeta == null ? "" : this.databaseMeta.getName())));
        xml.append(XMLHandler.addTagValue((String)"schema", (String)this.schemaName));
        xml.append(XMLHandler.addTagValue((String)"table", (String)this.tableName));
        xml.append(XMLHandler.addTagValue((String)"sequence_field", (String)this.sequenceNameField));
        xml.append(XMLHandler.addTagValue((String)"value_field", (String)this.valueField));
        return xml.toString();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public long getStartValue() {
        return this.startValue;
    }

    public void setStartValue(long startValue) {
        this.startValue = startValue;
    }

    public DatabaseMeta getDatabaseMeta() {
        return this.databaseMeta;
    }

    public void setDatabaseMeta(DatabaseMeta databaseMeta) {
        this.databaseMeta = databaseMeta;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getSequenceNameField() {
        return this.sequenceNameField;
    }

    public void setSequenceNameField(String sequenceNameField) {
        this.sequenceNameField = sequenceNameField;
    }

    public String getValueField() {
        return this.valueField;
    }

    public void setValueField(String valueField) {
        this.valueField = valueField;
    }

    public static SlaveSequence findSlaveSequence(String name, List<SlaveSequence> slaveSequences) {
        for (SlaveSequence slaveSequence : slaveSequences) {
            if (!slaveSequence.getName().equalsIgnoreCase(name)) continue;
            return slaveSequence;
        }
        return null;
    }
}

