/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.webservices;

import java.util.ArrayList;
import java.util.List;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaFactory;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.webservices.WebService;
import org.pentaho.di.trans.steps.webservices.WebServiceData;
import org.pentaho.di.trans.steps.webservices.WebServiceField;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

public class WebServiceMeta
extends BaseStepMeta
implements StepMetaInterface {
    public static final String XSD_NS_URI = "http://www.w3.org/2001/XMLSchema";
    public static final int DEFAULT_STEP = 1000;
    private List<WebServiceField> fieldsIn = new ArrayList<WebServiceField>();
    private List<WebServiceField> fieldsOut = new ArrayList<WebServiceField>();
    private String url;
    private String operationName;
    private String operationRequestName;
    private String operationNamespace;
    private String inFieldContainerName;
    private String inFieldArgumentName;
    private String outFieldContainerName;
    private String outFieldArgumentName;
    private String proxyHost;
    private String proxyPort;
    private String httpLogin;
    private String httpPassword;
    private boolean passingInputData;
    private int callStep = 1000;
    private boolean compatible;
    private String repeatingElementName;
    private boolean returningReplyAsString;

    public WebServiceMeta() {
    }

    public WebServiceMeta(Node stepnode, List<DatabaseMeta> databases, IMetaStore metaStore) throws KettleXMLException {
        this();
        this.loadXML(stepnode, databases, metaStore);
    }

    public WebServiceMeta(Repository rep, IMetaStore metaStore, ObjectId id_step, List<DatabaseMeta> databases) throws KettleException {
        this();
        this.readRep(rep, metaStore, id_step, databases);
    }

    @Override
    public void getFields(RowMetaInterface r, String name, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space, Repository repository, IMetaStore metaStore) throws KettleStepException {
        if (!this.isPassingInputData()) {
            r.clear();
        }
        for (WebServiceField field : this.getFieldsOut()) {
            int valueType = field.getType();
            if (field.getType() == 0) {
                valueType = 2;
            }
            try {
                ValueMetaInterface vValue = ValueMetaFactory.createValueMeta((String)field.getName(), (int)valueType);
                vValue.setOrigin(name);
                r.addValueMeta(vValue);
            }
            catch (Exception e) {
                throw new KettleStepException((Throwable)e);
            }
        }
    }

    @Override
    public WebServiceMeta clone() {
        WebServiceMeta retval = (WebServiceMeta)super.clone();
        retval.fieldsIn = new ArrayList<WebServiceField>();
        for (WebServiceField field : this.fieldsIn) {
            retval.fieldsIn.add(field.clone());
        }
        retval.fieldsOut = new ArrayList<WebServiceField>();
        for (WebServiceField field : this.fieldsOut) {
            retval.fieldsOut.add(field.clone());
        }
        return retval;
    }

    @Override
    public void setDefault() {
        this.passingInputData = true;
    }

    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info, VariableSpace space, Repository repository, IMetaStore metaStore) {
        CheckResult cr;
        if (prev == null || prev.size() == 0) {
            cr = new CheckResult(3, "Not receiving any fields from previous steps!", (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(1, "Step is connected to previous one, receiving " + prev.size() + " fields", (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        if (input.length > 0) {
            cr = new CheckResult(1, "Step is receiving info from other steps.", (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else if (this.getInFieldArgumentName() != null || this.getInFieldContainerName() != null) {
            cr = new CheckResult(4, "No input received from other steps!", (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
    }

    @Override
    public String getXML() {
        WebServiceField vField;
        int i;
        StringBuilder retval = new StringBuilder();
        retval.append("    " + XMLHandler.addTagValue((String)"wsURL", (String)this.getUrl()));
        retval.append("    " + XMLHandler.addTagValue((String)"wsOperation", (String)this.getOperationName()));
        retval.append("    " + XMLHandler.addTagValue((String)"wsOperationRequest", (String)this.getOperationRequestName()));
        retval.append("    " + XMLHandler.addTagValue((String)"wsOperationNamespace", (String)this.getOperationNamespace()));
        retval.append("    " + XMLHandler.addTagValue((String)"wsInFieldContainer", (String)this.getInFieldContainerName()));
        retval.append("    " + XMLHandler.addTagValue((String)"wsInFieldArgument", (String)this.getInFieldArgumentName()));
        retval.append("    " + XMLHandler.addTagValue((String)"wsOutFieldContainer", (String)this.getOutFieldContainerName()));
        retval.append("    " + XMLHandler.addTagValue((String)"wsOutFieldArgument", (String)this.getOutFieldArgumentName()));
        retval.append("    " + XMLHandler.addTagValue((String)"proxyHost", (String)this.getProxyHost()));
        retval.append("    " + XMLHandler.addTagValue((String)"proxyPort", (String)this.getProxyPort()));
        retval.append("    " + XMLHandler.addTagValue((String)"httpLogin", (String)this.getHttpLogin()));
        retval.append("    " + XMLHandler.addTagValue((String)"httpPassword", (String)this.getHttpPassword()));
        retval.append("    " + XMLHandler.addTagValue((String)"callStep", (int)this.getCallStep()));
        retval.append("    " + XMLHandler.addTagValue((String)"passingInputData", (boolean)this.isPassingInputData()));
        retval.append("    " + XMLHandler.addTagValue((String)"compatible", (boolean)this.isCompatible()));
        retval.append("    " + XMLHandler.addTagValue((String)"repeating_element", (String)this.getRepeatingElementName()));
        retval.append("    " + XMLHandler.addTagValue((String)"reply_as_string", (boolean)this.isReturningReplyAsString()));
        retval.append("    <fieldsIn>" + Const.CR);
        for (i = 0; i < this.getFieldsIn().size(); ++i) {
            vField = this.getFieldsIn().get(i);
            retval.append("    <field>" + Const.CR);
            retval.append("        " + XMLHandler.addTagValue((String)"name", (String)vField.getName()));
            retval.append("        " + XMLHandler.addTagValue((String)"wsName", (String)vField.getWsName()));
            retval.append("        " + XMLHandler.addTagValue((String)"xsdType", (String)vField.getXsdType()));
            retval.append("    </field>" + Const.CR);
        }
        retval.append("      </fieldsIn>" + Const.CR);
        retval.append("    <fieldsOut>" + Const.CR);
        for (i = 0; i < this.getFieldsOut().size(); ++i) {
            vField = this.getFieldsOut().get(i);
            retval.append("    <field>" + Const.CR);
            retval.append("        " + XMLHandler.addTagValue((String)"name", (String)vField.getName()));
            retval.append("        " + XMLHandler.addTagValue((String)"wsName", (String)vField.getWsName()));
            retval.append("        " + XMLHandler.addTagValue((String)"xsdType", (String)vField.getXsdType()));
            retval.append("    </field>" + Const.CR);
        }
        retval.append("      </fieldsOut>" + Const.CR);
        return retval.toString();
    }

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, IMetaStore metaStore) throws KettleXMLException {
        WebServiceField field;
        Node fnode;
        int i;
        this.setUrl(XMLHandler.getTagValue((Node)stepnode, (String)"wsURL"));
        this.setOperationName(XMLHandler.getTagValue((Node)stepnode, (String)"wsOperation"));
        this.setOperationRequestName(XMLHandler.getTagValue((Node)stepnode, (String)"wsOperationRequest"));
        this.setOperationNamespace(XMLHandler.getTagValue((Node)stepnode, (String)"wsOperationNamespace"));
        this.setInFieldContainerName(XMLHandler.getTagValue((Node)stepnode, (String)"wsInFieldContainer"));
        this.setInFieldArgumentName(XMLHandler.getTagValue((Node)stepnode, (String)"wsInFieldArgument"));
        this.setOutFieldContainerName(XMLHandler.getTagValue((Node)stepnode, (String)"wsOutFieldContainer"));
        this.setOutFieldArgumentName(XMLHandler.getTagValue((Node)stepnode, (String)"wsOutFieldArgument"));
        this.setProxyHost(XMLHandler.getTagValue((Node)stepnode, (String)"proxyHost"));
        this.setProxyPort(XMLHandler.getTagValue((Node)stepnode, (String)"proxyPort"));
        this.setHttpLogin(XMLHandler.getTagValue((Node)stepnode, (String)"httpLogin"));
        this.setHttpPassword(XMLHandler.getTagValue((Node)stepnode, (String)"httpPassword"));
        this.setCallStep(Const.toInt((String)XMLHandler.getTagValue((Node)stepnode, (String)"callStep"), (int)1000));
        this.setPassingInputData("Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"passingInputData")));
        String compat = XMLHandler.getTagValue((Node)stepnode, (String)"compatible");
        this.setCompatible(Utils.isEmpty((CharSequence)compat) || "Y".equalsIgnoreCase(compat));
        this.setRepeatingElementName(XMLHandler.getTagValue((Node)stepnode, (String)"repeating_element"));
        this.setReturningReplyAsString("Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"reply_as_string")));
        this.getFieldsIn().clear();
        Node fields = XMLHandler.getSubNode((Node)stepnode, (String)"fieldsIn");
        int nrfields = XMLHandler.countNodes((Node)fields, (String)"field");
        for (i = 0; i < nrfields; ++i) {
            fnode = XMLHandler.getSubNodeByNr((Node)fields, (String)"field", (int)i);
            field = new WebServiceField();
            field.setName(XMLHandler.getTagValue((Node)fnode, (String)"name"));
            field.setWsName(XMLHandler.getTagValue((Node)fnode, (String)"wsName"));
            field.setXsdType(XMLHandler.getTagValue((Node)fnode, (String)"xsdType"));
            this.getFieldsIn().add(field);
        }
        this.getFieldsOut().clear();
        fields = XMLHandler.getSubNode((Node)stepnode, (String)"fieldsOut");
        nrfields = XMLHandler.countNodes((Node)fields, (String)"field");
        for (i = 0; i < nrfields; ++i) {
            fnode = XMLHandler.getSubNodeByNr((Node)fields, (String)"field", (int)i);
            field = new WebServiceField();
            field.setName(XMLHandler.getTagValue((Node)fnode, (String)"name"));
            field.setWsName(XMLHandler.getTagValue((Node)fnode, (String)"wsName"));
            field.setXsdType(XMLHandler.getTagValue((Node)fnode, (String)"xsdType"));
            this.getFieldsOut().add(field);
        }
    }

    @Override
    public void readRep(Repository rep, IMetaStore metaStore, ObjectId id_step, List<DatabaseMeta> databases) throws KettleException {
        WebServiceField field;
        int i;
        this.setUrl(rep.getStepAttributeString(id_step, "wsUrl"));
        this.setOperationName(rep.getStepAttributeString(id_step, "wsOperation"));
        this.setOperationRequestName(rep.getStepAttributeString(id_step, "wsOperationRequest"));
        this.setOperationNamespace(rep.getStepAttributeString(id_step, "wsOperationNamespace"));
        this.setInFieldContainerName(rep.getStepAttributeString(id_step, "wsInFieldContainer"));
        this.setInFieldArgumentName(rep.getStepAttributeString(id_step, "wsInFieldArgument"));
        this.setOutFieldContainerName(rep.getStepAttributeString(id_step, "wsOutFieldContainer"));
        this.setOutFieldArgumentName(rep.getStepAttributeString(id_step, "wsOutFieldArgument"));
        this.setProxyHost(rep.getStepAttributeString(id_step, "proxyHost"));
        this.setProxyPort(rep.getStepAttributeString(id_step, "proxyPort"));
        this.setHttpLogin(rep.getStepAttributeString(id_step, "httpLogin"));
        this.setHttpPassword(rep.getStepAttributeString(id_step, "httpPassword"));
        this.setCallStep((int)rep.getStepAttributeInteger(id_step, "callStep"));
        this.setPassingInputData(rep.getStepAttributeBoolean(id_step, "passingInputData"));
        this.setCompatible(rep.getStepAttributeBoolean(id_step, 0, "compatible", true));
        this.setRepeatingElementName(rep.getStepAttributeString(id_step, "repeating_element"));
        this.setReturningReplyAsString(rep.getStepAttributeBoolean(id_step, 0, "reply_as_string"));
        int nb = rep.countNrStepAttributes(id_step, "fieldIn_ws_name");
        this.getFieldsIn().clear();
        for (i = 0; i < nb; ++i) {
            field = new WebServiceField();
            field.setName(rep.getStepAttributeString(id_step, i, "fieldIn_name"));
            field.setWsName(rep.getStepAttributeString(id_step, i, "fieldIn_ws_name"));
            field.setXsdType(rep.getStepAttributeString(id_step, i, "fieldIn_xsd_type"));
            this.getFieldsIn().add(field);
        }
        nb = rep.countNrStepAttributes(id_step, "fieldOut_ws_name");
        this.getFieldsOut().clear();
        for (i = 0; i < nb; ++i) {
            field = new WebServiceField();
            field.setName(rep.getStepAttributeString(id_step, i, "fieldOut_name"));
            field.setWsName(rep.getStepAttributeString(id_step, i, "fieldOut_ws_name"));
            field.setXsdType(rep.getStepAttributeString(id_step, i, "fieldOut_xsd_type"));
            this.getFieldsOut().add(field);
        }
    }

    @Override
    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        WebServiceField vField;
        int i;
        rep.saveStepAttribute(id_transformation, id_step, "wsUrl", this.getUrl());
        rep.saveStepAttribute(id_transformation, id_step, "wsOperation", this.getOperationName());
        rep.saveStepAttribute(id_transformation, id_step, "wsOperationRequest", this.getOperationRequestName());
        rep.saveStepAttribute(id_transformation, id_step, "wsOperationNamespace", this.getOperationNamespace());
        rep.saveStepAttribute(id_transformation, id_step, "wsInFieldContainer", this.getInFieldContainerName());
        rep.saveStepAttribute(id_transformation, id_step, "wsInFieldArgument", this.getInFieldArgumentName());
        rep.saveStepAttribute(id_transformation, id_step, "wsOutFieldContainer", this.getOutFieldContainerName());
        rep.saveStepAttribute(id_transformation, id_step, "wsOutFieldArgument", this.getOutFieldArgumentName());
        rep.saveStepAttribute(id_transformation, id_step, "proxyHost", this.getProxyHost());
        rep.saveStepAttribute(id_transformation, id_step, "proxyPort", this.getProxyPort());
        rep.saveStepAttribute(id_transformation, id_step, "httpLogin", this.getHttpLogin());
        rep.saveStepAttribute(id_transformation, id_step, "httpPassword", this.getHttpPassword());
        rep.saveStepAttribute(id_transformation, id_step, "callStep", this.getCallStep());
        rep.saveStepAttribute(id_transformation, id_step, "passingInputData", this.isPassingInputData());
        rep.saveStepAttribute(id_transformation, id_step, "compatible", this.isCompatible());
        rep.saveStepAttribute(id_transformation, id_step, "repeating_element", this.getRepeatingElementName());
        rep.saveStepAttribute(id_transformation, id_step, "reply_as_string", this.isReturningReplyAsString());
        for (i = 0; i < this.getFieldsIn().size(); ++i) {
            vField = this.getFieldsIn().get(i);
            rep.saveStepAttribute(id_transformation, id_step, i, "fieldIn_name", vField.getName());
            rep.saveStepAttribute(id_transformation, id_step, i, "fieldIn_ws_name", vField.getWsName());
            rep.saveStepAttribute(id_transformation, id_step, i, "fieldIn_xsd_type", vField.getXsdType());
        }
        for (i = 0; i < this.getFieldsOut().size(); ++i) {
            vField = this.getFieldsOut().get(i);
            rep.saveStepAttribute(id_transformation, id_step, i, "fieldOut_name", vField.getName());
            rep.saveStepAttribute(id_transformation, id_step, i, "fieldOut_ws_name", vField.getWsName());
            rep.saveStepAttribute(id_transformation, id_step, i, "fieldOut_xsd_type", vField.getXsdType());
        }
    }

    public String getOperationName() {
        return this.operationName;
    }

    public void setOperationName(String operationName) {
        this.operationName = operationName;
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta transMeta, Trans disp) {
        return new WebService(stepMeta, stepDataInterface, cnr, transMeta, disp);
    }

    @Override
    public StepDataInterface getStepData() {
        return new WebServiceData();
    }

    public WebServiceField getFieldInFromName(String name) {
        WebServiceField param = null;
        for (WebServiceField paramCour : this.getFieldsIn()) {
            if (!name.equals(paramCour.getName())) continue;
            param = paramCour;
            break;
        }
        return param;
    }

    public WebServiceField getFieldOutFromWsName(String wsName, boolean ignoreWsNsPrefix) {
        WebServiceField param = null;
        if (Utils.isEmpty((CharSequence)wsName)) {
            return param;
        }
        if (ignoreWsNsPrefix) {
            String[] wsNameParsed = wsName.split(":");
            wsName = wsNameParsed[wsNameParsed.length - 1];
        }
        for (WebServiceField paramCour : this.getFieldsOut()) {
            if (!paramCour.getWsName().equals(wsName)) continue;
            param = paramCour;
            break;
        }
        return param;
    }

    public List<WebServiceField> getFieldsIn() {
        return this.fieldsIn;
    }

    public void setFieldsIn(List<WebServiceField> fieldsIn) {
        this.fieldsIn = fieldsIn;
    }

    public boolean hasFieldsIn() {
        return this.fieldsIn != null && !this.fieldsIn.isEmpty();
    }

    public void addFieldIn(WebServiceField field) {
        this.fieldsIn.add(field);
    }

    public List<WebServiceField> getFieldsOut() {
        return this.fieldsOut;
    }

    public void setFieldsOut(List<WebServiceField> fieldsOut) {
        this.fieldsOut = fieldsOut;
    }

    public void addFieldOut(WebServiceField field) {
        this.fieldsOut.add(field);
    }

    public String getInFieldArgumentName() {
        return this.inFieldArgumentName;
    }

    public void setInFieldArgumentName(String inFieldArgumentName) {
        this.inFieldArgumentName = inFieldArgumentName;
    }

    public String getOutFieldArgumentName() {
        return this.outFieldArgumentName;
    }

    public void setOutFieldArgumentName(String outFieldArgumentName) {
        this.outFieldArgumentName = outFieldArgumentName;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public int getCallStep() {
        return this.callStep;
    }

    public void setCallStep(int callStep) {
        this.callStep = callStep;
    }

    public String getOperationNamespace() {
        return this.operationNamespace;
    }

    public void setOperationNamespace(String operationNamespace) {
        this.operationNamespace = operationNamespace;
    }

    public String getHttpLogin() {
        return this.httpLogin;
    }

    public void setHttpLogin(String httpLogin) {
        this.httpLogin = httpLogin;
    }

    public String getHttpPassword() {
        return this.httpPassword;
    }

    public void setHttpPassword(String httpPassword) {
        this.httpPassword = httpPassword;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public String getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(String proxyPort) {
        this.proxyPort = proxyPort;
    }

    public String getInFieldContainerName() {
        return this.inFieldContainerName;
    }

    public void setInFieldContainerName(String inFieldContainerName) {
        this.inFieldContainerName = inFieldContainerName;
    }

    public String getOutFieldContainerName() {
        return this.outFieldContainerName;
    }

    public void setOutFieldContainerName(String outFieldContainerName) {
        this.outFieldContainerName = outFieldContainerName;
    }

    public boolean isPassingInputData() {
        return this.passingInputData;
    }

    public void setPassingInputData(boolean passingInputData) {
        this.passingInputData = passingInputData;
    }

    public boolean isCompatible() {
        return this.compatible;
    }

    public void setCompatible(boolean compatible) {
        this.compatible = compatible;
    }

    public String getRepeatingElementName() {
        return this.repeatingElementName;
    }

    public void setRepeatingElementName(String repeatingElementName) {
        this.repeatingElementName = repeatingElementName;
    }

    public boolean isReturningReplyAsString() {
        return this.returningReplyAsString;
    }

    public void setReturningReplyAsString(boolean returningReplyAsString) {
        this.returningReplyAsString = returningReplyAsString;
    }

    public String getOperationRequestName() {
        return this.operationRequestName;
    }

    public void setOperationRequestName(String operationRequestName) {
        this.operationRequestName = operationRequestName;
    }
}

