/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.pgbulkloader;

import com.google.common.annotations.VisibleForTesting;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.pgbulkloader.PGBulkLoaderData;
import org.pentaho.di.trans.steps.pgbulkloader.PGBulkLoaderMeta;
import org.postgresql.PGConnection;
import org.postgresql.copy.PGCopyOutputStream;

public class PGBulkLoader
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = PGBulkLoaderMeta.class;
    private Charset clientEncoding = Charset.defaultCharset();
    private PGBulkLoaderMeta meta;
    private PGBulkLoaderData data;
    private PGCopyOutputStream pgCopyOut;

    public PGBulkLoader(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    public String getCopyCommand() throws KettleException {
        DatabaseMeta dm = this.meta.getDatabaseMeta();
        StringBuilder contents = new StringBuilder(500);
        String tableName = dm.getQuotedSchemaTableCombination(this.environmentSubstitute(this.meta.getSchemaName()), this.environmentSubstitute(this.meta.getTableName()));
        contents.append("COPY ");
        contents.append(tableName);
        contents.append(" ( ");
        String[] streamFields = this.meta.getFieldStream();
        String[] tableFields = this.meta.getFieldTable();
        if (streamFields == null || streamFields.length == 0) {
            throw new KettleException("No fields defined to load to database");
        }
        for (int i = 0; i < streamFields.length; ++i) {
            if (i != 0) {
                contents.append(", ");
            }
            contents.append(dm.quoteField(tableFields[i]));
        }
        contents.append(" ) ");
        contents.append(" FROM STDIN");
        contents.append(" WITH CSV DELIMITER AS '").append(this.environmentSubstitute(this.meta.getDelimiter())).append("' QUOTE AS '").append(this.environmentSubstitute(this.meta.getEnclosure())).append("'");
        contents.append(";").append(Const.CR);
        return contents.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkClientEncoding() throws Exception {
        Connection connection = this.data.db.getConnection();
        try (Statement statement = connection.createStatement();
             ResultSet rs = statement.executeQuery("show client_encoding");){
            if (!rs.next() || rs.getMetaData().getColumnCount() != 1) {
                this.logBasic("Cannot detect client_encoding, using system default encoding");
                return;
            }
            String clientEncodingStr = rs.getString(1);
            this.logBasic("Detect client_encoding: " + clientEncodingStr);
            this.clientEncoding = Charset.forName(clientEncodingStr);
        }
    }

    private void do_copy(PGBulkLoaderMeta meta, boolean wait) throws KettleException {
        this.data.db = this.getDatabase(this, meta);
        String copyCmd = this.getCopyCommand();
        try {
            this.connect();
            this.checkClientEncoding();
            this.processTruncate();
            this.logBasic("Launching command: " + copyCmd);
            this.pgCopyOut = new PGCopyOutputStream((PGConnection)this.data.db.getConnection(), copyCmd);
        }
        catch (Exception ex) {
            throw new KettleException("Error while preparing the COPY " + copyCmd, (Throwable)ex);
        }
    }

    @VisibleForTesting
    Database getDatabase(LoggingObjectInterface parentObject, PGBulkLoaderMeta pgBulkLoaderMeta) {
        DatabaseMeta dbMeta = pgBulkLoaderMeta.getDatabaseMeta();
        String dbNameOverride = this.environmentSubstitute(pgBulkLoaderMeta.getDbNameOverride());
        if (!Utils.isEmpty((CharSequence)dbNameOverride)) {
            dbMeta = (DatabaseMeta)pgBulkLoaderMeta.getDatabaseMeta().clone();
            dbMeta.setDBName(dbNameOverride.trim());
            this.logDebug("DB name overridden to the value: " + dbNameOverride);
        }
        return new Database(parentObject, dbMeta);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void connect() throws KettleException {
        if (this.getTransMeta().isUsingUniqueConnections()) {
            Trans trans = this.getTrans();
            synchronized (trans) {
                this.data.db.connect(this.getTrans().getTransactionId(), this.getPartitionID());
            }
        } else {
            this.data.db.connect(this.getPartitionID());
        }
    }

    void processTruncate() throws Exception {
        Connection connection = this.data.db.getConnection();
        String loadAction = this.environmentSubstitute(this.meta.getLoadAction());
        if (loadAction.equalsIgnoreCase("truncate")) {
            DatabaseMeta dm = this.meta.getDatabaseMeta();
            String tableName = dm.getQuotedSchemaTableCombination(this.environmentSubstitute(this.meta.getSchemaName()), this.environmentSubstitute(this.meta.getTableName()));
            this.logBasic("Launching command: TRUNCATE " + tableName);
            try (Statement statement = connection.createStatement();){
                statement.executeUpdate("TRUNCATE " + tableName);
            }
        }
    }

    @Override
    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        this.meta = (PGBulkLoaderMeta)smi;
        this.data = (PGBulkLoaderData)sdi;
        try {
            Object[] r = this.getRow();
            if (r == null) {
                this.setOutputDone();
                if (this.data != null && this.pgCopyOut != null) {
                    this.pgCopyOut.flush();
                    this.pgCopyOut.endCopy();
                }
                return false;
            }
            if (this.first) {
                this.first = false;
                this.data.keynrs = new int[this.meta.getFieldStream().length];
                for (int i = 0; i < this.data.keynrs.length; ++i) {
                    this.data.keynrs[i] = this.getInputRowMeta().indexOfValue(this.meta.getFieldStream()[i]);
                }
                this.do_copy(this.meta, true);
            }
            this.writeRowToPostgres(this.getInputRowMeta(), r);
            this.putRow(this.getInputRowMeta(), r);
            this.incrementLinesOutput();
            return true;
        }
        catch (Exception e) {
            this.logError(BaseMessages.getString(PKG, (String)"GPBulkLoader.Log.ErrorInStep", (String[])new String[0]), e);
            this.setErrors(1L);
            this.stopAll();
            this.setOutputDone();
            return false;
        }
    }

    private void writeRowToPostgres(RowMetaInterface rowMeta, Object[] r) throws KettleException {
        try {
            block21: for (int i = 0; i < this.data.keynrs.length; ++i) {
                if (i > 0) {
                    this.pgCopyOut.write(this.data.separator);
                }
                int index = this.data.keynrs[i];
                ValueMetaInterface valueMeta = rowMeta.getValueMeta(index);
                Object valueData = r[index];
                if (valueData == null) continue;
                switch (valueMeta.getType()) {
                    case 2: {
                        this.pgCopyOut.write(this.data.quote);
                        String quoteStr = new String(this.data.quote);
                        String escapedString = valueMeta.getString(valueData).replace(quoteStr, quoteStr + quoteStr);
                        this.pgCopyOut.write(escapedString.getBytes(this.clientEncoding));
                        this.pgCopyOut.write(this.data.quote);
                        continue block21;
                    }
                    case 5: {
                        if (valueMeta.isStorageBinaryString()) {
                            this.pgCopyOut.write((byte[])valueData);
                            continue block21;
                        }
                        this.pgCopyOut.write(Long.toString(valueMeta.getInteger(valueData)).getBytes(this.clientEncoding));
                        continue block21;
                    }
                    case 3: {
                        String dateTimeString;
                        String dateString;
                        switch (this.data.dateFormatChoices[i]) {
                            case 0: {
                                if (valueMeta.isStorageBinaryString()) {
                                    this.pgCopyOut.write((byte[])valueData);
                                    continue block21;
                                }
                                dateString = valueMeta.getString(valueData);
                                if (dateString == null) continue block21;
                                this.pgCopyOut.write(dateString.getBytes(this.clientEncoding));
                                continue block21;
                            }
                            case 1: {
                                dateString = this.data.dateMeta.getString((Object)valueMeta.getDate(valueData));
                                if (dateString == null) continue block21;
                                this.pgCopyOut.write(dateString.getBytes(this.clientEncoding));
                                continue block21;
                            }
                            case 2: {
                                dateTimeString = this.data.dateTimeMeta.getString((Object)valueMeta.getDate(valueData));
                                if (dateTimeString == null) continue block21;
                                this.pgCopyOut.write(dateTimeString.getBytes(this.clientEncoding));
                                continue block21;
                            }
                            default: {
                                throw new KettleException("PGBulkLoader doesn't know how to handle date (neither passthrough, nor date or datetime for field " + valueMeta.getName());
                            }
                        }
                    }
                    case 9: {
                        String dateTimeString;
                        String dateString;
                        switch (this.data.dateFormatChoices[i]) {
                            case 0: {
                                if (valueMeta.isStorageBinaryString()) {
                                    this.pgCopyOut.write((byte[])valueData);
                                    continue block21;
                                }
                                dateString = valueMeta.getString(valueData);
                                if (dateString == null) continue block21;
                                this.pgCopyOut.write(dateString.getBytes(this.clientEncoding));
                                continue block21;
                            }
                            case 1: {
                                dateString = this.data.dateMeta.getString((Object)valueMeta.getDate(valueData));
                                if (dateString == null) continue block21;
                                this.pgCopyOut.write(dateString.getBytes(this.clientEncoding));
                                continue block21;
                            }
                            case 2: {
                                dateTimeString = this.data.dateTimeMeta.getString((Object)valueMeta.getDate(valueData));
                                if (dateTimeString == null) continue block21;
                                this.pgCopyOut.write(dateTimeString.getBytes(this.clientEncoding));
                                continue block21;
                            }
                            default: {
                                throw new KettleException("PGBulkLoader doesn't know how to handle timestamp (neither passthrough, nor date or datetime for field " + valueMeta.getName());
                            }
                        }
                    }
                    case 4: {
                        if (valueMeta.isStorageBinaryString()) {
                            this.pgCopyOut.write((byte[])valueData);
                            continue block21;
                        }
                        this.pgCopyOut.write(Double.toString(valueMeta.getNumber(valueData)).getBytes(this.clientEncoding));
                        continue block21;
                    }
                    case 1: {
                        if (valueMeta.isStorageBinaryString()) {
                            this.pgCopyOut.write((byte[])valueData);
                            continue block21;
                        }
                        this.pgCopyOut.write(Double.toString(valueMeta.getNumber(valueData)).getBytes(this.clientEncoding));
                        continue block21;
                    }
                    case 6: {
                        if (valueMeta.isStorageBinaryString()) {
                            this.pgCopyOut.write((byte[])valueData);
                            continue block21;
                        }
                        BigDecimal big = valueMeta.getBigNumber(valueData);
                        if (big == null) continue block21;
                        this.pgCopyOut.write(big.toString().getBytes(this.clientEncoding));
                        continue block21;
                    }
                    default: {
                        throw new KettleException("PGBulkLoader doesn't handle the type " + valueMeta.getTypeDesc());
                    }
                }
            }
            this.pgCopyOut.write(this.data.newline);
        }
        catch (Exception e) {
            throw new KettleException("Error serializing rows of data to the COPY command", (Throwable)e);
        }
    }

    protected void verifyDatabaseConnection() throws KettleException {
        if (this.meta.getDatabaseMeta() == null) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"PGBulkLoaderMeta.GetSQL.NoConnectionDefined", (String[])new String[0]));
        }
    }

    @Override
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (PGBulkLoaderMeta)smi;
        this.data = (PGBulkLoaderData)sdi;
        String enclosure = this.environmentSubstitute(this.meta.getEnclosure());
        String separator = this.environmentSubstitute(this.meta.getDelimiter());
        if (super.init(smi, sdi)) {
            try {
                this.verifyDatabaseConnection();
            }
            catch (KettleException ex) {
                this.logError(ex.getMessage());
                return false;
            }
            this.data.quote = enclosure != null ? enclosure.getBytes() : new byte[0];
            this.data.separator = separator != null ? separator.getBytes() : new byte[0];
            this.data.newline = Const.CR.getBytes();
            this.data.dateFormatChoices = new int[this.meta.getFieldStream().length];
            for (int i = 0; i < this.data.dateFormatChoices.length; ++i) {
                this.data.dateFormatChoices[i] = Utils.isEmpty((CharSequence)this.meta.getDateMask()[i]) ? 0 : (this.meta.getDateMask()[i].equalsIgnoreCase("DATE") ? 1 : (this.meta.getDateMask()[i].equalsIgnoreCase("DATETIME") ? 2 : 0));
            }
            return true;
        }
        return false;
    }
}

