/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.httppost;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.auth.AuthScheme;
import org.apache.http.client.AuthCache;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.json.simple.JSONObject;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.util.HttpClientManager;
import org.pentaho.di.core.util.StringUtil;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.httppost.HTTPPOSTData;
import org.pentaho.di.trans.steps.httppost.HTTPPOSTMeta;

public class HTTPPOST
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = HTTPPOSTMeta.class;
    private static final String CONTENT_TYPE = "Content-type";
    private static final String CONTENT_TYPE_TEXT_XML = "text/xml";
    private HTTPPOSTMeta meta;
    private HTTPPOSTData data;

    public HTTPPOST(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object[] callHTTPPOST(Object[] rowData) throws KettleException {
        Object[] objectArray;
        block49: {
            HttpClientManager.HttpClientBuilderFacade clientBuilder = HttpClientManager.getInstance().createBuilder();
            if (this.data.realConnectionTimeout > -1) {
                clientBuilder.setConnectionTimeout(this.data.realConnectionTimeout);
            }
            if (this.data.realSocketTimeout > -1) {
                clientBuilder.setSocketTimeout(this.data.realSocketTimeout);
            }
            if (StringUtils.isNotBlank((String)this.data.realHttpLogin)) {
                clientBuilder.setCredentials(this.data.realHttpLogin, this.data.realHttpPassword);
            }
            if (StringUtils.isNotBlank((String)this.data.realProxyHost)) {
                clientBuilder.setProxy(this.data.realProxyHost, this.data.realProxyPort);
            }
            CloseableHttpClient httpClient = clientBuilder.build();
            if (this.meta.isUrlInField()) {
                this.data.realUrl = this.data.inputRowMeta.getString(rowData, this.data.indexOfUrlField);
            }
            FileInputStream fis = null;
            try {
                int i;
                if (this.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"HTTPPOST.Log.ConnectingToURL", (String[])new String[]{this.data.realUrl}));
                }
                URIBuilder uriBuilder = new URIBuilder(this.data.realUrl);
                HttpPost post = new HttpPost(uriBuilder.build());
                if (!this.data.contentTypeHeaderOverwrite) {
                    if (Utils.isEmpty((CharSequence)this.data.realEncoding)) {
                        post.setHeader(CONTENT_TYPE, CONTENT_TYPE_TEXT_XML);
                        if (this.isDebug()) {
                            this.logDebug(BaseMessages.getString(PKG, (String)"HTTPPOST.Log.HeaderValue", (String[])new String[]{CONTENT_TYPE, CONTENT_TYPE_TEXT_XML}));
                        }
                    } else {
                        post.setHeader(CONTENT_TYPE, "text/xml; " + this.data.realEncoding);
                        if (this.isDebug()) {
                            this.logDebug(BaseMessages.getString(PKG, (String)"HTTPPOST.Log.HeaderValue", (String[])new String[]{CONTENT_TYPE, "text/xml; " + this.data.realEncoding}));
                        }
                    }
                }
                if (this.data.useHeaderParameters) {
                    for (i = 0; i < this.data.header_parameters_nrs.length; ++i) {
                        post.addHeader(this.data.headerParameters[i].getName(), this.data.inputRowMeta.getString(rowData, this.data.header_parameters_nrs[i]));
                        if (!this.isDebug()) continue;
                        this.logDebug(BaseMessages.getString(PKG, (String)"HTTPPOST.Log.HeaderValue", (String[])new String[]{this.data.headerParameters[i].getName(), this.data.inputRowMeta.getString(rowData, this.data.header_parameters_nrs[i])}));
                    }
                }
                if (this.data.useBodyParameters) {
                    for (i = 0; i < this.data.body_parameters_nrs.length; ++i) {
                        String bodyParameterName = this.data.bodyParameters[i].getName();
                        String bodyParameterValue = this.data.inputRowMeta.getString(rowData, this.data.body_parameters_nrs[i]);
                        this.data.bodyParameters[i] = new BasicNameValuePair(bodyParameterName, bodyParameterValue);
                        if (!this.isDebug()) continue;
                        this.logDebug(BaseMessages.getString(PKG, (String)"HTTPPOST.Log.BodyValue", (String[])new String[]{bodyParameterName, bodyParameterValue}));
                    }
                    String bodyParams = this.getRequestBodyParamsAsStr(this.data.bodyParameters, this.data.realEncoding);
                    post.setEntity((HttpEntity)new StringEntity(bodyParams, ContentType.TEXT_XML.withCharset("US-ASCII")));
                }
                if (this.data.useQueryParameters) {
                    for (i = 0; i < this.data.query_parameters_nrs.length; ++i) {
                        String queryParameterName = this.data.queryParameters[i].getName();
                        String queryParameterValue = this.data.inputRowMeta.getString(rowData, this.data.query_parameters_nrs[i]);
                        this.data.queryParameters[i] = new BasicNameValuePair(queryParameterName, queryParameterValue);
                        if (!this.isDebug()) continue;
                        this.logDebug(BaseMessages.getString(PKG, (String)"HTTPPOST.Log.QueryValue", (String[])new String[]{queryParameterName, queryParameterValue}));
                    }
                    post.setEntity((HttpEntity)new UrlEncodedFormEntity(Arrays.asList(this.data.queryParameters)));
                }
                if (this.data.indexOfRequestEntity >= 0) {
                    String tmp = this.data.inputRowMeta.getString(rowData, this.data.indexOfRequestEntity);
                    if (this.meta.isPostAFile()) {
                        File input = new File(tmp);
                        fis = new FileInputStream(input);
                        post.setEntity((HttpEntity)new InputStreamEntity((InputStream)fis, input.length()));
                    } else {
                        byte[] bytes = this.data.realEncoding != null && this.data.realEncoding.length() > 0 ? tmp.getBytes(this.data.realEncoding) : tmp.getBytes();
                        post.setEntity((HttpEntity)new ByteArrayEntity(bytes));
                    }
                }
                Object[] newRow = null;
                if (rowData != null) {
                    newRow = (Object[])rowData.clone();
                }
                CloseableHttpResponse httpResponse = null;
                try {
                    String body;
                    long startTime = System.currentTimeMillis();
                    if (StringUtils.isNotBlank((String)this.data.realProxyHost)) {
                        HttpHost target = new HttpHost(this.data.realProxyHost, this.data.realProxyPort, "http");
                        BasicAuthCache authCache = new BasicAuthCache();
                        BasicScheme basicAuth = new BasicScheme();
                        authCache.put(target, (AuthScheme)basicAuth);
                        HttpClientContext localContext = HttpClientContext.create();
                        localContext.setAuthCache((AuthCache)authCache);
                        httpResponse = httpClient.execute(target, (HttpRequest)post, (HttpContext)localContext);
                    } else {
                        httpResponse = httpClient.execute((HttpUriRequest)post);
                    }
                    int statusCode = this.requestStatusCode((HttpResponse)httpResponse);
                    long responseTime = System.currentTimeMillis() - startTime;
                    if (this.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"HTTPPOST.Log.ResponseTime", (Object[])new Object[]{responseTime, this.data.realUrl}));
                    }
                    if (this.isDebug()) {
                        this.logDebug(BaseMessages.getString(PKG, (String)"HTTPPOST.Log.ResponseCode", (String[])new String[]{String.valueOf(statusCode)}));
                    }
                    String headerString = "";
                    switch (statusCode) {
                        case 401: {
                            throw new KettleStepException(BaseMessages.getString(PKG, (String)"HTTPPOST.Exception.Authentication", (String[])new String[]{this.data.realUrl}));
                        }
                        case -1: {
                            throw new KettleStepException(BaseMessages.getString(PKG, (String)"HTTPPOST.Exception.IllegalStatusCode", (String[])new String[]{this.data.realUrl}));
                        }
                        case 204: {
                            body = "";
                            break;
                        }
                        default: {
                            HttpEntity entity = httpResponse.getEntity();
                            body = entity != null ? EntityUtils.toString((HttpEntity)entity) : "";
                            Header[] headers = this.searchForHeaders((HttpResponse)httpResponse);
                            JSONObject json = new JSONObject();
                            for (Header header : headers) {
                                ArrayList<String> list;
                                Object previousValue = json.get((Object)header.getName());
                                if (previousValue == null) {
                                    json.put((Object)header.getName(), (Object)header.getValue());
                                    continue;
                                }
                                if (previousValue instanceof List) {
                                    list = (ArrayList<String>)previousValue;
                                    list.add(header.getValue());
                                    continue;
                                }
                                list = new ArrayList<String>();
                                list.add((String)previousValue);
                                list.add(header.getValue());
                                json.put((Object)header.getName(), list);
                            }
                            headerString = json.toJSONString();
                        }
                    }
                    if (this.isDebug()) {
                        this.logDebug(BaseMessages.getString(PKG, (String)"HTTPPOST.Log.ResponseBody", (String[])new String[]{body}));
                    }
                    int returnFieldsOffset = this.data.inputRowMeta.size();
                    if (!Utils.isEmpty((CharSequence)this.meta.getFieldName())) {
                        newRow = RowDataUtil.addValueData((Object[])newRow, (int)returnFieldsOffset, (Object)body);
                        ++returnFieldsOffset;
                    }
                    if (!Utils.isEmpty((CharSequence)this.meta.getResultCodeFieldName())) {
                        newRow = RowDataUtil.addValueData((Object[])newRow, (int)returnFieldsOffset, (Object)new Long(statusCode));
                        ++returnFieldsOffset;
                    }
                    if (!Utils.isEmpty((CharSequence)this.meta.getResponseTimeFieldName())) {
                        newRow = RowDataUtil.addValueData((Object[])newRow, (int)returnFieldsOffset, (Object)new Long(responseTime));
                        ++returnFieldsOffset;
                    }
                    if (!Utils.isEmpty((CharSequence)this.meta.getResponseHeaderFieldName())) {
                        newRow = RowDataUtil.addValueData((Object[])newRow, (int)returnFieldsOffset, (Object)headerString);
                    }
                }
                finally {
                    post.releaseConnection();
                    if (httpResponse != null) {
                        httpResponse.close();
                    }
                }
                objectArray = newRow;
                if (fis == null) break block49;
            }
            catch (UnknownHostException uhe) {
                try {
                    throw new KettleException(BaseMessages.getString(PKG, (String)"HTTPPOST.Error.UnknownHostException", (String[])new String[]{uhe.getMessage()}));
                    catch (Exception e) {
                        throw new KettleException(BaseMessages.getString(PKG, (String)"HTTPPOST.Error.CanNotReadURL", (String[])new String[]{this.data.realUrl}), (Throwable)e);
                    }
                }
                catch (Throwable throwable) {
                    if (fis != null) {
                        BaseStep.closeQuietly(fis);
                    }
                    throw throwable;
                }
            }
            BaseStep.closeQuietly(fis);
        }
        return objectArray;
    }

    protected int requestStatusCode(HttpResponse httpResponse) {
        return httpResponse.getStatusLine().getStatusCode();
    }

    protected InputStreamReader openStream(String encoding, HttpResponse httpResponse) throws Exception {
        if (!Utils.isEmpty((CharSequence)encoding)) {
            return new InputStreamReader(httpResponse.getEntity().getContent(), encoding);
        }
        return new InputStreamReader(httpResponse.getEntity().getContent());
    }

    protected Header[] searchForHeaders(HttpResponse response) {
        return response.getAllHeaders();
    }

    @Override
    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        block22: {
            this.meta = (HTTPPOSTMeta)smi;
            this.data = (HTTPPOSTData)sdi;
            Object[] r = this.getRow();
            if (r == null) {
                this.setOutputDone();
                return false;
            }
            if (this.first) {
                int nrQuery;
                int nrargs;
                this.first = false;
                this.data.inputRowMeta = this.getInputRowMeta();
                this.data.outputRowMeta = this.getInputRowMeta().clone();
                this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, this, this.repository, this.metaStore);
                if (this.meta.isUrlInField()) {
                    if (Utils.isEmpty((CharSequence)this.meta.getUrlField())) {
                        this.logError(BaseMessages.getString(PKG, (String)"HTTPPOST.Log.NoField", (String[])new String[0]));
                        throw new KettleException(BaseMessages.getString(PKG, (String)"HTTPPOST.Log.NoField", (String[])new String[0]));
                    }
                    if (this.data.indexOfUrlField < 0) {
                        String realUrlfieldName = this.environmentSubstitute(this.meta.getUrlField());
                        this.data.indexOfUrlField = this.data.inputRowMeta.indexOfValue(realUrlfieldName);
                        if (this.data.indexOfUrlField < 0) {
                            this.logError(BaseMessages.getString(PKG, (String)"HTTPPOST.Log.ErrorFindingField", (String[])new String[]{realUrlfieldName}));
                            throw new KettleException(BaseMessages.getString(PKG, (String)"HTTPPOST.Exception.ErrorFindingField", (String[])new String[]{realUrlfieldName}));
                        }
                    }
                } else {
                    this.data.realUrl = this.environmentSubstitute(this.meta.getUrl());
                }
                if ((nrargs = this.meta.getArgumentField().length) > 0) {
                    this.data.useBodyParameters = false;
                    this.data.useHeaderParameters = false;
                    this.data.contentTypeHeaderOverwrite = false;
                    int nrheader = 0;
                    int nrbody = 0;
                    for (int i = 0; i < nrargs; ++i) {
                        if (this.meta.getArgumentHeader()[i]) {
                            this.data.useHeaderParameters = true;
                            ++nrheader;
                            continue;
                        }
                        this.data.useBodyParameters = true;
                        ++nrbody;
                    }
                    this.data.header_parameters_nrs = new int[nrheader];
                    this.data.headerParameters = new NameValuePair[nrheader];
                    this.data.body_parameters_nrs = new int[nrbody];
                    this.data.bodyParameters = new NameValuePair[nrbody];
                    int posHeader = 0;
                    int posBody = 0;
                    for (int i = 0; i < nrargs; ++i) {
                        int fieldIndex = this.data.inputRowMeta.indexOfValue(this.meta.getArgumentField()[i]);
                        if (fieldIndex < 0) {
                            this.logError(BaseMessages.getString(PKG, (String)"HTTPPOST.Log.ErrorFindingField", (String[])new String[0]) + this.meta.getArgumentField()[i] + "]");
                            throw new KettleStepException(BaseMessages.getString(PKG, (String)"HTTPPOST.Exception.CouldnotFindField", (String[])new String[]{this.meta.getArgumentField()[i]}));
                        }
                        if (this.meta.getArgumentHeader()[i]) {
                            this.data.header_parameters_nrs[posHeader] = fieldIndex;
                            this.data.headerParameters[posHeader] = new BasicNameValuePair(this.environmentSubstitute(this.meta.getArgumentParameter()[i]), this.data.outputRowMeta.getString(r, this.data.header_parameters_nrs[posHeader]));
                            ++posHeader;
                            if (!CONTENT_TYPE.equalsIgnoreCase(this.meta.getArgumentParameter()[i])) continue;
                            this.data.contentTypeHeaderOverwrite = true;
                            continue;
                        }
                        this.data.body_parameters_nrs[posBody] = fieldIndex;
                        this.data.bodyParameters[posBody] = new BasicNameValuePair(this.environmentSubstitute(this.meta.getArgumentParameter()[i]), this.data.outputRowMeta.getString(r, this.data.body_parameters_nrs[posBody]));
                        ++posBody;
                    }
                }
                if ((nrQuery = this.meta.getQueryField().length) > 0) {
                    this.data.useQueryParameters = true;
                    this.data.query_parameters_nrs = new int[nrQuery];
                    this.data.queryParameters = new NameValuePair[nrQuery];
                    for (int i = 0; i < nrQuery; ++i) {
                        this.data.query_parameters_nrs[i] = this.data.inputRowMeta.indexOfValue(this.meta.getQueryField()[i]);
                        if (this.data.query_parameters_nrs[i] < 0) {
                            this.logError(BaseMessages.getString(PKG, (String)"HTTPPOST.Log.ErrorFindingField", (String[])new String[0]) + this.meta.getQueryField()[i] + "]");
                            throw new KettleStepException(BaseMessages.getString(PKG, (String)"HTTPPOST.Exception.CouldnotFindField", (String[])new String[]{this.meta.getQueryField()[i]}));
                        }
                        this.data.queryParameters[i] = new BasicNameValuePair(this.environmentSubstitute(this.meta.getQueryParameter()[i]), this.data.outputRowMeta.getString(r, this.data.query_parameters_nrs[i]));
                    }
                }
                if (!Utils.isEmpty((CharSequence)this.meta.getRequestEntity())) {
                    this.data.indexOfRequestEntity = this.data.inputRowMeta.indexOfValue(this.environmentSubstitute(this.meta.getRequestEntity()));
                    if (this.data.indexOfRequestEntity < 0) {
                        throw new KettleStepException(BaseMessages.getString(PKG, (String)"HTTPPOST.Exception.CouldnotFindRequestEntityField", (String[])new String[]{this.meta.getRequestEntity()}));
                    }
                }
                this.data.realEncoding = this.environmentSubstitute(this.meta.getEncoding());
            }
            try {
                Object[] outputRowData = this.callHTTPPOST(r);
                this.putRow(this.data.outputRowMeta, outputRowData);
                if (this.checkFeedback(this.getLinesRead()) && this.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"HTTPPOST.LineNumber", (String[])new String[0]) + this.getLinesRead());
                }
            }
            catch (KettleException e) {
                boolean sendToErrorRow = false;
                String errorMessage = null;
                if (!this.getStepMeta().isDoingErrorHandling()) {
                    this.logError(BaseMessages.getString(PKG, (String)"HTTPPOST.ErrorInStepRunning", (String[])new String[0]) + e.getMessage());
                    this.setErrors(1L);
                    this.logError(Const.getStackTracker((Throwable)e));
                    this.stopAll();
                    this.setOutputDone();
                    return false;
                }
                sendToErrorRow = true;
                errorMessage = e.toString();
                if (!sendToErrorRow) break block22;
                this.putError(this.getInputRowMeta(), r, 1L, errorMessage, null, "HTTPPOST001");
            }
        }
        return true;
    }

    @VisibleForTesting
    String getRequestBodyParamsAsStr(NameValuePair[] pairs, String charset) throws KettleException {
        StringBuffer buf = new StringBuffer();
        try {
            for (int i = 0; i < pairs.length; ++i) {
                NameValuePair pair = pairs[i];
                if (pair.getName() == null) continue;
                if (i > 0) {
                    buf.append("&");
                }
                buf.append(URLEncoder.encode(pair.getName(), !StringUtil.isEmpty((String)charset) ? charset : "UTF-8"));
                buf.append("=");
                if (pair.getValue() == null) continue;
                buf.append(URLEncoder.encode(pair.getValue(), !StringUtil.isEmpty((String)charset) ? charset : "UTF-8"));
            }
            return buf.toString();
        }
        catch (UnsupportedEncodingException e) {
            throw new KettleException(e.getMessage(), e.getCause());
        }
    }

    @Override
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (HTTPPOSTMeta)smi;
        this.data = (HTTPPOSTData)sdi;
        if (super.init(smi, sdi)) {
            this.data.realProxyHost = this.environmentSubstitute(this.meta.getProxyHost());
            this.data.realProxyPort = Const.toInt((String)this.environmentSubstitute(this.meta.getProxyPort()), (int)8080);
            this.data.realHttpLogin = this.environmentSubstitute(this.meta.getHttpLogin());
            this.data.realHttpPassword = Utils.resolvePassword((VariableSpace)this.variables, (String)this.meta.getHttpPassword());
            this.data.realSocketTimeout = Const.toInt((String)this.environmentSubstitute(this.meta.getSocketTimeout()), (int)-1);
            this.data.realConnectionTimeout = Const.toInt((String)this.environmentSubstitute(this.meta.getSocketTimeout()), (int)-1);
            this.data.realcloseIdleConnectionsTime = Const.toInt((String)this.environmentSubstitute(this.meta.getCloseIdleConnectionsTime()), (int)-1);
            return true;
        }
        return false;
    }

    @Override
    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (HTTPPOSTMeta)smi;
        this.data = (HTTPPOSTData)sdi;
        super.dispose(smi, sdi);
    }
}

