/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.databaselookup.readallcache;

import java.util.BitSet;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.trans.steps.databaselookup.readallcache.Index;
import org.pentaho.di.trans.steps.databaselookup.readallcache.SearchingContext;

class LtIndex
extends Index {
    private final boolean isMatchingGreaterOrEqual;

    static Index greaterOrEqualCache(int column, ValueMetaInterface valueMeta, int rowsAmount) {
        return new LtIndex(column, valueMeta, rowsAmount, true);
    }

    LtIndex(int column, ValueMetaInterface valueMeta, int rowsAmount) {
        this(column, valueMeta, rowsAmount, false);
    }

    private LtIndex(int column, ValueMetaInterface valueMeta, int rowsAmount, boolean isMatchingGreaterOrEqual) {
        super(column, valueMeta, rowsAmount);
        this.isMatchingGreaterOrEqual = isMatchingGreaterOrEqual;
    }

    @Override
    void doApply(SearchingContext context, ValueMetaInterface lookupMeta, Object lookupValue) {
        int firstValue = this.findInsertionPointOf(new Index.IndexedValue(lookupValue, -1));
        if (firstValue == 0) {
            if (this.isMatchingGreaterOrEqual) {
                return;
            }
            context.setEmpty();
        } else {
            int end;
            int start;
            BitSet bitSet = context.getWorkingSet();
            if (firstValue < this.values.length / 2) {
                start = 0;
                end = firstValue;
            } else {
                start = firstValue;
                end = this.values.length;
            }
            for (int i = start; i < end; ++i) {
                bitSet.set(this.values[i].row, true);
            }
            context.intersect(bitSet, start != 0 ^ this.isMatchingGreaterOrEqual);
        }
    }

    @Override
    int getRestrictionPower() {
        return -1000;
    }
}

