/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.databasejoin;

import java.sql.ResultSet;
import java.sql.Statement;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.databasejoin.DatabaseJoinData;
import org.pentaho.di.trans.steps.databasejoin.DatabaseJoinMeta;

public class DatabaseJoin
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = DatabaseJoinMeta.class;
    private DatabaseJoinMeta meta;
    private DatabaseJoinData data;

    public DatabaseJoin(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    private synchronized void lookupValues(RowMetaInterface rowMeta, Object[] rowData) throws KettleException {
        int i;
        int newIndex;
        Object[] newRow;
        if (this.first) {
            this.first = false;
            this.data.outputRowMeta = rowMeta.clone();
            this.meta.getFields(this.data.outputRowMeta, this.getStepname(), new RowMetaInterface[]{this.meta.getTableFields()}, null, this, this.repository, this.metaStore);
            this.data.lookupRowMeta = new RowMeta();
            if (this.log.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"DatabaseJoin.Log.CheckingRow", (String[])new String[0]) + rowMeta.getString(rowData));
            }
            this.data.keynrs = new int[this.meta.getParameterField().length];
            for (int i2 = 0; i2 < this.meta.getParameterField().length; ++i2) {
                this.data.keynrs[i2] = rowMeta.indexOfValue(this.meta.getParameterField()[i2]);
                if (this.data.keynrs[i2] < 0) {
                    throw new KettleStepException(BaseMessages.getString(PKG, (String)"DatabaseJoin.Exception.FieldNotFound", (String[])new String[]{this.meta.getParameterField()[i2]}));
                }
                this.data.lookupRowMeta.addValueMeta(rowMeta.getValueMeta(this.data.keynrs[i2]).clone());
            }
        }
        Object[] lookupRowData = new Object[this.data.lookupRowMeta.size()];
        for (int i3 = 0; i3 < this.data.keynrs.length; ++i3) {
            lookupRowData[i3] = rowData[this.data.keynrs[i3]];
        }
        ResultSet rs = this.data.db.openQuery(this.data.pstmt, this.data.lookupRowMeta, lookupRowData);
        Object[] add = this.data.db.getRow(rs);
        RowMetaInterface addMeta = this.data.db.getReturnRowMeta();
        this.incrementLinesInput();
        int counter = 0;
        while (add != null && (this.meta.getRowLimit() == 0 || counter < this.meta.getRowLimit())) {
            ++counter;
            newRow = RowDataUtil.resizeArray((Object[])rowData, (int)this.data.outputRowMeta.size());
            newIndex = rowMeta.size();
            for (i = 0; i < addMeta.size(); ++i) {
                newRow[newIndex++] = add[i];
            }
            this.putRow(this.data.outputRowMeta, this.data.outputRowMeta.cloneRow(newRow));
            if (this.log.isRowLevel()) {
                this.logRowlevel(BaseMessages.getString(PKG, (String)"DatabaseJoin.Log.PutoutRow", (String[])new String[0]) + this.data.outputRowMeta.getString(newRow));
            }
            if (this.meta.getRowLimit() != 0 && counter >= this.meta.getRowLimit()) continue;
            add = this.data.db.getRow(rs);
            this.incrementLinesInput();
        }
        if (counter == 0 && this.meta.isOuterJoin()) {
            if (this.data.notfound == null) {
                this.data.notfound = new Object[this.data.db.getReturnRowMeta().size()];
            }
            newRow = RowDataUtil.resizeArray((Object[])rowData, (int)this.data.outputRowMeta.size());
            newIndex = rowMeta.size();
            for (i = 0; i < this.data.notfound.length; ++i) {
                newRow[newIndex++] = this.data.notfound[i];
            }
            this.putRow(this.data.outputRowMeta, newRow);
        }
        this.data.db.closeQuery(rs);
    }

    @Override
    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        block5: {
            this.meta = (DatabaseJoinMeta)smi;
            this.data = (DatabaseJoinData)sdi;
            boolean sendToErrorRow = false;
            String errorMessage = null;
            Object[] r = this.getRow();
            if (r == null) {
                this.setOutputDone();
                return false;
            }
            try {
                this.lookupValues(this.getInputRowMeta(), r);
                if (this.checkFeedback(this.getLinesRead()) && this.log.isBasic()) {
                    this.logBasic(BaseMessages.getString(PKG, (String)"DatabaseJoin.Log.LineNumber", (String[])new String[0]) + this.getLinesRead());
                }
            }
            catch (KettleException e) {
                if (!this.getStepMeta().isDoingErrorHandling()) {
                    this.logError(BaseMessages.getString(PKG, (String)"DatabaseJoin.Log.ErrorInStepRunning", (String[])new String[0]) + e.getMessage(), e);
                    this.setErrors(1L);
                    this.stopAll();
                    this.setOutputDone();
                    return false;
                }
                sendToErrorRow = true;
                errorMessage = e.toString();
                if (!sendToErrorRow) break block5;
                this.putError(this.getInputRowMeta(), r, 1L, errorMessage, null, "DBJOIN001");
            }
        }
        return true;
    }

    @Override
    public synchronized void stopRunning(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        if (this.isStopped() || sdi.isDisposed()) {
            return;
        }
        this.meta = (DatabaseJoinMeta)smi;
        this.data = (DatabaseJoinData)sdi;
        if (this.data.db != null && this.data.db.getConnection() != null && !this.data.isCanceled) {
            this.data.db.cancelStatement((Statement)this.data.pstmt);
            this.setStopped(true);
            this.data.isCanceled = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        block12: {
            this.meta = (DatabaseJoinMeta)smi;
            this.data = (DatabaseJoinData)sdi;
            if (super.init(smi, sdi)) {
                if (this.meta.getDatabaseMeta() == null) {
                    this.logError(BaseMessages.getString(PKG, (String)"DatabaseJoin.Init.ConnectionMissing", (String[])new String[]{this.getStepname()}));
                    return false;
                }
                this.data.db = new Database((LoggingObjectInterface)this, this.meta.getDatabaseMeta());
                this.data.db.shareVariablesWith((VariableSpace)this);
                try {
                    if (this.getTransMeta().isUsingUniqueConnections()) {
                        Trans trans = this.getTrans();
                        synchronized (trans) {
                            this.data.db.connect(this.getTrans().getTransactionId(), this.getPartitionID());
                        }
                    } else {
                        this.data.db.connect(this.getPartitionID());
                    }
                    if (this.log.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"DatabaseJoin.Log.ConnectedToDB", (String[])new String[0]));
                    }
                    String sql = this.meta.getSql();
                    if (this.meta.isVariableReplace()) {
                        sql = this.environmentSubstitute(sql);
                    }
                    this.data.pstmt = this.data.db.prepareSQL(sql);
                    if (this.log.isDebug()) {
                        this.logDebug(BaseMessages.getString(PKG, (String)"DatabaseJoin.Log.SQLStatement", (String[])new String[]{sql}));
                    }
                    this.data.db.setQueryLimit(this.meta.getRowLimit());
                    return true;
                }
                catch (KettleException e) {
                    this.logError(BaseMessages.getString(PKG, (String)"DatabaseJoin.Log.DatabaseError", (String[])new String[0]) + e.getMessage(), e);
                    if (this.data.db == null) break block12;
                    this.data.db.disconnect();
                }
            }
        }
        return false;
    }

    @Override
    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (DatabaseJoinMeta)smi;
        this.data = (DatabaseJoinData)sdi;
        if (this.data.db != null) {
            this.data.db.disconnect();
        }
        super.dispose(smi, sdi);
    }
}

