/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.ael.adapters;

import com.google.common.base.Throwables;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.engine.api.model.Operation;
import org.pentaho.di.engine.model.Transformation;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.RepositoryDirectoryInterface;
import org.pentaho.di.resource.ResourceEntry;
import org.pentaho.di.trans.TransHopMeta;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.csvinput.CsvInputMeta;
import org.pentaho.di.trans.steps.tableinput.TableInputMeta;
import org.pentaho.di.workarounds.ResolvableResource;

public class TransMetaConverter {
    public static final String TRANS_META_CONF_KEY = "TransMeta";
    public static final String TRANS_META_NAME_CONF_KEY = "TransMetaName";
    public static final String SUB_TRANSFORMATIONS_KEY = "SubTransformations";
    public static final String STEP_META_CONF_KEY = "StepMeta";
    public static final String TRANS_DEFAULT_NAME = "No Name";

    public static org.pentaho.di.engine.api.model.Transformation convert(TransMeta transMeta) {
        Transformation transformation = new Transformation(TransMetaConverter.createTransformationId(transMeta));
        try {
            TransMeta copyTransMeta = (TransMeta)transMeta.realClone(false);
            TransMetaConverter.cleanupDisabledHops(copyTransMeta);
            TransMetaConverter.disableLazyConversion(copyTransMeta);
            TransMetaConverter.resolveStepMetaResources(copyTransMeta);
            copyTransMeta.getSteps().forEach(TransMetaConverter.createOperation(transformation));
            TransMetaConverter.findHops(copyTransMeta, hop -> true).forEach(TransMetaConverter.createHop(transformation));
            transformation.setConfig(TRANS_META_CONF_KEY, (Serializable)((Object)copyTransMeta.getXML()));
            transformation.setConfig(TRANS_META_NAME_CONF_KEY, (Serializable)((Object)Optional.ofNullable(transMeta.getName()).orElse(TRANS_DEFAULT_NAME)));
            Map<String, org.pentaho.di.engine.api.model.Transformation> subTransformations = copyTransMeta.getResourceDependencies().stream().flatMap(resourceReference -> resourceReference.getEntries().stream()).filter(entry -> ResourceEntry.ResourceType.ACTIONFILE.equals((Object)entry.getResourcetype())).collect(Collectors.toMap(ResourceEntry::getResource, entry -> {
                try {
                    Repository repository = copyTransMeta.getRepository();
                    if (repository != null) {
                        Path path = Paths.get(entry.getResource(), new String[0]);
                        RepositoryDirectoryInterface directory = repository.findDirectory(path.getParent().toString().replace(File.separator, "/"));
                        return TransMetaConverter.convert(repository.loadTransformation(path.getFileName().toString(), directory, null, true, null));
                    }
                    return TransMetaConverter.convert(new TransMeta(entry.getResource(), copyTransMeta.getParentVariableSpace()));
                }
                catch (KettleException e) {
                    throw new RuntimeException(e);
                }
            }));
            transformation.setConfig(SUB_TRANSFORMATIONS_KEY, (Serializable)((Object)subTransformations));
        }
        catch (KettleException e) {
            Throwables.propagate((Throwable)e);
        }
        return transformation;
    }

    private static void disableLazyConversion(TransMeta transMeta) {
        transMeta.getSteps().stream().filter(step -> "CsvInput".equals(step.getStepID())).forEach(step -> ((CsvInputMeta)step.getStepMetaInterface()).setLazyConversionActive(false));
        transMeta.getSteps().stream().filter(step -> "TableInput".equals(step.getStepID())).forEach(step -> ((TableInputMeta)step.getStepMetaInterface()).setLazyConversionActive(false));
    }

    private static String createTransformationId(TransMeta transMeta) {
        String filename = transMeta.getFilename();
        if (!Utils.isEmpty((CharSequence)filename)) {
            return filename;
        }
        return transMeta.getPathAndName();
    }

    private static Consumer<StepMeta> createOperation(Transformation transformation) {
        return stepMeta -> {
            org.pentaho.di.engine.model.Operation operation = transformation.createOperation(stepMeta.getName());
            try {
                operation.setConfig(STEP_META_CONF_KEY, (Serializable)((Object)stepMeta.getXML()));
            }
            catch (KettleException e) {
                Throwables.propagate((Throwable)e);
            }
        };
    }

    private static Consumer<TransHopMeta> createHop(Transformation transformation) {
        return hop -> {
            try {
                Operation from = TransMetaConverter.getOp(transformation, hop.getFromStep());
                Operation to = TransMetaConverter.getOp(transformation, hop.getToStep());
                transformation.createHop(from, to, hop.isErrorHop() ? "ERROR" : "NORMAL");
            }
            catch (KettleException e) {
                Throwables.propagate((Throwable)e);
            }
        };
    }

    private static Operation getOp(Transformation transformation, StepMeta step) throws KettleException {
        return transformation.getOperations().stream().filter(op -> step.getName().equals(op.getId())).findFirst().orElseThrow(() -> new KettleException("Could not find operation: " + step.getName()));
    }

    private static void cleanupDisabledHops(TransMeta transMeta) {
        TransMetaConverter.removeDisabledInputs(transMeta);
        TransMetaConverter.removeInactivePaths(transMeta, null);
    }

    private static void removeInactivePaths(TransMeta trans, List<StepMeta> steps) {
        if (steps == null) {
            List<TransHopMeta> disabledHops = TransMetaConverter.findHops(trans, hop -> !hop.isEnabled());
            List<StepMeta> disabledSteps = disabledHops.stream().map(hop -> hop.getToStep()).collect(Collectors.toList());
            TransMetaConverter.removeInactivePaths(trans, disabledSteps);
        } else {
            for (StepMeta step : steps) {
                List<TransHopMeta> enabledInHops = TransMetaConverter.findHops(trans, hop -> hop.getToStep().equals(step) && hop.isEnabled());
                List<TransHopMeta> disabledInHops = TransMetaConverter.findHops(trans, hop -> hop.getToStep().equals(step) && !hop.isEnabled());
                if (enabledInHops.size() == 0) {
                    List<StepMeta> nextSteps = TransMetaConverter.findHops(trans, hop -> hop.getFromStep().equals(step)).stream().map(TransHopMeta::getToStep).collect(Collectors.toList());
                    TransMetaConverter.findHops(trans, hop -> hop.getToStep().equals(step) || hop.getFromStep().equals(step)).forEach(trans::removeTransHop);
                    trans.getSteps().remove(step);
                    TransMetaConverter.removeInactivePaths(trans, nextSteps);
                    continue;
                }
                disabledInHops.forEach(trans::removeTransHop);
            }
        }
    }

    private static void removeDisabledInputs(TransMeta transMeta) {
        List unusedInputs = TransMetaConverter.findHops(transMeta, hop -> !hop.isEnabled()).stream().map(hop -> hop.getFromStep()).filter(step -> TransMetaConverter.isUnusedInput(transMeta, step)).collect(Collectors.toList());
        for (StepMeta unusedInput : unusedInputs) {
            List<TransHopMeta> outHops = transMeta.findAllTransHopFrom(unusedInput);
            List<StepMeta> subsequentSteps = outHops.stream().map(hop -> hop.getToStep()).collect(Collectors.toList());
            outHops.forEach(transMeta::removeTransHop);
            transMeta.getSteps().remove(unusedInput);
            TransMetaConverter.removeInactivePaths(transMeta, subsequentSteps);
        }
    }

    private static List<TransHopMeta> findHops(TransMeta trans, Predicate<TransHopMeta> condition) {
        return IntStream.range(0, trans.nrTransHops()).mapToObj(trans::getTransHop).filter(condition).collect(Collectors.toList());
    }

    private static boolean isUnusedInput(TransMeta trans, StepMeta step) {
        int nrEnabledOutHops = TransMetaConverter.findHops(trans, hop -> hop.getFromStep().equals(step) && hop.isEnabled()).size();
        int nrDisabledOutHops = TransMetaConverter.findHops(trans, hop -> hop.getFromStep().equals(step) && !hop.isEnabled()).size();
        int nrInputHops = TransMetaConverter.findHops(trans, hop -> hop.getToStep().equals(step)).size();
        return nrEnabledOutHops == 0 && nrDisabledOutHops > 0 && nrInputHops == 0;
    }

    private static void resolveStepMetaResources(TransMeta transMeta) {
        for (StepMeta stepMeta : transMeta.getSteps()) {
            StepMetaInterface smi = stepMeta.getStepMetaInterface();
            if (!(smi instanceof ResolvableResource)) continue;
            ResolvableResource resolvableMeta = (ResolvableResource)((Object)smi);
            resolvableMeta.resolve();
        }
    }
}

