/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.kitchen;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.pentaho.di.base.CommandExecutorCodes;
import org.pentaho.di.base.Params;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.KettleClientEnvironment;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettlePluginException;
import org.pentaho.di.core.logging.FileLoggingEventListener;
import org.pentaho.di.core.logging.KettleLogStore;
import org.pentaho.di.core.logging.KettleLoggingEventListener;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.logging.LogLevel;
import org.pentaho.di.core.parameters.NamedParams;
import org.pentaho.di.core.parameters.NamedParamsDefault;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.plugins.PluginTypeInterface;
import org.pentaho.di.core.plugins.RepositoryPluginType;
import org.pentaho.di.core.util.EnvUtil;
import org.pentaho.di.core.util.ExecutorUtil;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.kitchen.KitchenCommandExecutor;
import org.pentaho.di.metastore.MetaStoreConst;
import org.pentaho.di.pan.CommandLineOption;
import org.pentaho.metastore.stores.delegate.DelegatingMetaStore;

public class Kitchen {
    private static Class<?> PKG = Kitchen.class;
    public static final String STRING_KITCHEN = "Kitchen";
    private static KitchenCommandExecutor commandExecutor;
    private static FileLoggingEventListener fileAppender;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] a) throws Exception {
        Map.Entry<KettlePluginException, Future<KettleException>> repositoryRegisterResults;
        KettlePluginException repositoryRegisterException;
        final ExecutorService executor = ExecutorUtil.getExecutor();
        final RepositoryPluginType repositoryPluginType = RepositoryPluginType.getInstance();
        Future<Map.Entry<KettlePluginException, Future<KettleException>>> repositoryRegisterFuture = executor.submit(new Callable<Map.Entry<KettlePluginException, Future<KettleException>>>(){

            @Override
            public Map.Entry<KettlePluginException, Future<KettleException>> call() throws Exception {
                PluginRegistry.addPluginType((PluginTypeInterface)repositoryPluginType);
                try {
                    KettleClientEnvironment.getInstance().setClient(KettleClientEnvironment.ClientType.KITCHEN);
                    KettleClientEnvironment.init();
                }
                catch (KettlePluginException e) {
                    return new AbstractMap.SimpleImmutableEntry<KettlePluginException, Object>(e, null);
                }
                Future<KettleException> kettleEnvironmentInitFuture = executor.submit(new Callable<KettleException>(){

                    @Override
                    public KettleException call() throws Exception {
                        try {
                            KettleClientEnvironment.getInstance().setClient(KettleClientEnvironment.ClientType.KITCHEN);
                            KettleEnvironment.init();
                        }
                        catch (KettleException e) {
                            return e;
                        }
                        return null;
                    }
                });
                return new AbstractMap.SimpleImmutableEntry<Object, Future<KettleException>>(null, kettleEnvironmentInitFuture);
            }
        });
        ArrayList<String> args = new ArrayList<String>();
        for (int i = 0; i < a.length; ++i) {
            if (a[i].length() <= 0) continue;
            args.add(a[i]);
        }
        DelegatingMetaStore metaStore = new DelegatingMetaStore();
        metaStore.addMetaStore(MetaStoreConst.openLocalPentahoMetaStore());
        metaStore.setActiveMetaStoreName(metaStore.getName());
        NamedParamsDefault optionParams = new NamedParamsDefault();
        NamedParamsDefault customOptions = new NamedParamsDefault();
        CommandLineOption maxLogLinesOption = new CommandLineOption("maxloglines", BaseMessages.getString(PKG, (String)"Kitchen.CmdLine.MaxLogLines", (String[])new String[0]), new StringBuilder());
        CommandLineOption maxLogTimeoutOption = new CommandLineOption("maxlogtimeout", BaseMessages.getString(PKG, (String)"Kitchen.CmdLine.MaxLogTimeout", (String[])new String[0]), new StringBuilder());
        CommandLineOption[] commandLineOptionArray = new CommandLineOption[23];
        StringBuilder optionRepname = new StringBuilder();
        commandLineOptionArray[0] = new CommandLineOption("rep", BaseMessages.getString(PKG, (String)"Kitchen.CmdLine.RepName", (String[])new String[0]), optionRepname);
        StringBuilder optionUsername = new StringBuilder();
        commandLineOptionArray[1] = new CommandLineOption("user", BaseMessages.getString(PKG, (String)"Kitchen.CmdLine.RepUsername", (String[])new String[0]), optionUsername);
        StringBuilder optionTrustUser = new StringBuilder();
        commandLineOptionArray[2] = new CommandLineOption("trustuser", BaseMessages.getString(PKG, (String)"Kitchen.ComdLine.RepUsername", (String[])new String[0]), optionTrustUser);
        StringBuilder optionPassword = new StringBuilder();
        commandLineOptionArray[3] = new CommandLineOption("pass", BaseMessages.getString(PKG, (String)"Kitchen.CmdLine.RepPassword", (String[])new String[0]), optionPassword);
        StringBuilder optionJobname = new StringBuilder();
        commandLineOptionArray[4] = new CommandLineOption("job", BaseMessages.getString(PKG, (String)"Kitchen.CmdLine.RepJobName", (String[])new String[0]), optionJobname);
        StringBuilder optionDirname = new StringBuilder();
        commandLineOptionArray[5] = new CommandLineOption("dir", BaseMessages.getString(PKG, (String)"Kitchen.CmdLine.RepDir", (String[])new String[0]), optionDirname);
        StringBuilder optionFilename = new StringBuilder();
        commandLineOptionArray[6] = new CommandLineOption("file", BaseMessages.getString(PKG, (String)"Kitchen.CmdLine.XMLJob", (String[])new String[0]), optionFilename);
        StringBuilder optionLoglevel = new StringBuilder();
        commandLineOptionArray[7] = new CommandLineOption("level", BaseMessages.getString(PKG, (String)"Kitchen.CmdLine.LogLevel", (String[])new String[0]), optionLoglevel);
        StringBuilder optionLogfile = new StringBuilder();
        commandLineOptionArray[8] = new CommandLineOption("logfile", BaseMessages.getString(PKG, (String)"Kitchen.CmdLine.LogFile", (String[])new String[0]), optionLogfile);
        StringBuilder optionLogfileOld = new StringBuilder();
        commandLineOptionArray[9] = new CommandLineOption("log", BaseMessages.getString(PKG, (String)"Kitchen.CmdLine.LogFileOld", (String[])new String[0]), optionLogfileOld, false, true);
        StringBuilder optionListdir = new StringBuilder();
        commandLineOptionArray[10] = new CommandLineOption("listdir", BaseMessages.getString(PKG, (String)"Kitchen.CmdLine.ListDir", (String[])new String[0]), optionListdir, true, false);
        StringBuilder optionListjobs = new StringBuilder();
        commandLineOptionArray[11] = new CommandLineOption("listjobs", BaseMessages.getString(PKG, (String)"Kitchen.CmdLine.ListJobsDir", (String[])new String[0]), optionListjobs, true, false);
        StringBuilder optionListrep = new StringBuilder();
        commandLineOptionArray[12] = new CommandLineOption("listrep", BaseMessages.getString(PKG, (String)"Kitchen.CmdLine.ListAvailableReps", (String[])new String[0]), optionListrep, true, false);
        StringBuilder optionNorep = new StringBuilder();
        commandLineOptionArray[13] = new CommandLineOption("norep", BaseMessages.getString(PKG, (String)"Kitchen.CmdLine.NoRep", (String[])new String[0]), optionNorep, true, false);
        StringBuilder optionVersion = new StringBuilder();
        commandLineOptionArray[14] = new CommandLineOption("version", BaseMessages.getString(PKG, (String)"Kitchen.CmdLine.Version", (String[])new String[0]), optionVersion, true, false);
        commandLineOptionArray[15] = new CommandLineOption("param", BaseMessages.getString(PKG, (String)"Kitchen.ComdLine.Param", (String[])new String[0]), (NamedParams)optionParams, false);
        StringBuilder optionListParam = new StringBuilder();
        commandLineOptionArray[16] = new CommandLineOption("listparam", BaseMessages.getString(PKG, (String)"Kitchen.ComdLine.ListParam", (String[])new String[0]), optionListParam, true, false);
        StringBuilder optionExport = new StringBuilder();
        commandLineOptionArray[17] = new CommandLineOption("export", BaseMessages.getString(PKG, (String)"Kitchen.ComdLine.Export", (String[])new String[0]), optionExport, true, false);
        StringBuilder initialDir = new StringBuilder();
        commandLineOptionArray[18] = new CommandLineOption("initialDir", null, initialDir, false, true);
        StringBuilder optionBase64Zip = new StringBuilder();
        commandLineOptionArray[19] = new CommandLineOption("zip", "Base64Zip", optionBase64Zip, false, true);
        commandLineOptionArray[20] = new CommandLineOption("custom", BaseMessages.getString(PKG, (String)"Kitchen.ComdLine.Custom", (String[])new String[0]), (NamedParams)customOptions, false);
        commandLineOptionArray[21] = maxLogLinesOption;
        commandLineOptionArray[22] = maxLogTimeoutOption;
        CommandLineOption[] options = commandLineOptionArray;
        if (args.size() == 2) {
            CommandLineOption.printUsage(options);
            Kitchen.exitJVM(9);
        }
        LogChannel log = new LogChannel((Object)STRING_KITCHEN);
        CommandLineOption.parseArguments(args, options, (LogChannelInterface)log);
        Kitchen.configureLogging(maxLogLinesOption, maxLogTimeoutOption);
        String kettleRepname = Const.getEnvironmentVariable((String)"KETTLE_REPOSITORY", null);
        String kettleUsername = Const.getEnvironmentVariable((String)"KETTLE_USER", null);
        String kettlePassword = Const.getEnvironmentVariable((String)"KETTLE_PASSWORD", null);
        if (!Utils.isEmpty((CharSequence)kettleRepname)) {
            optionRepname = new StringBuilder(kettleRepname);
        }
        if (!Utils.isEmpty((CharSequence)kettleUsername)) {
            optionUsername = new StringBuilder(kettleUsername);
        }
        if (!Utils.isEmpty((CharSequence)kettlePassword)) {
            optionPassword = new StringBuilder(kettlePassword);
        }
        if (Utils.isEmpty((CharSequence)optionLogfile) && !Utils.isEmpty((CharSequence)optionLogfileOld)) {
            optionLogfile = optionLogfileOld;
        }
        if ((repositoryRegisterException = (repositoryRegisterResults = repositoryRegisterFuture.get()).getKey()) != null) {
            throw repositoryRegisterException;
        }
        Future<KettleException> kettleInitFuture = repositoryRegisterResults.getValue();
        if (!Utils.isEmpty((CharSequence)optionLogfile)) {
            fileAppender = new FileLoggingEventListener(optionLogfile.toString(), true);
            KettleLogStore.getAppender().addLoggingEventListener((KettleLoggingEventListener)fileAppender);
        } else {
            fileAppender = null;
        }
        if (!Utils.isEmpty((CharSequence)optionLoglevel)) {
            log.setLogLevel(LogLevel.getLogLevelForCode((String)optionLoglevel.toString()));
            log.logMinimal(BaseMessages.getString(PKG, (String)"Kitchen.Log.LogLevel", (String[])new String[]{log.getLogLevel().getDescription()}));
        }
        Result result = new Result();
        try {
            if (Kitchen.getCommandExecutor() == null) {
                Kitchen.setCommandExecutor(new KitchenCommandExecutor(PKG, (LogChannelInterface)log, kettleInitFuture));
            }
            if (!Utils.isEmpty((CharSequence)optionVersion)) {
                Kitchen.getCommandExecutor().printVersion();
                if (a.length == 1) {
                    Kitchen.exitJVM(CommandExecutorCodes.Pan.KETTLE_VERSION_PRINT.getCode());
                }
            }
            Params jobParams = new Params.Builder().blockRepoConns(optionNorep.toString()).repoName(optionRepname.toString()).repoUsername(optionUsername.toString()).trustRepoUser(optionTrustUser.toString()).repoPassword(optionPassword.toString()).inputDir(optionDirname.toString()).inputFile(optionJobname.toString()).listRepoFiles(optionListjobs.toString()).listRepoDirs(optionListdir.toString()).exportRepo(optionExport.toString()).localFile(optionFilename.toString()).localJarFile("").localInitialDir(initialDir.toString()).listRepos(optionListrep.toString()).listFileParams(optionListParam.toString()).logLevel("").maxLogLines("").maxLogTimeout("").logFile("").oldLogFile("").version("").resultSetStepName("").resultSetCopyNumber("").base64Zip(optionBase64Zip.toString()).namedParams((NamedParams)optionParams).customNamedParams((NamedParams)customOptions).build();
            result = Kitchen.getCommandExecutor().execute(jobParams);
        }
        catch (Throwable t) {
            t.printStackTrace();
            result.setExitStatus(CommandExecutorCodes.Pan.UNEXPECTED_ERROR.getCode());
        }
        finally {
            if (fileAppender != null) {
                fileAppender.close();
                KettleLogStore.getAppender().removeLoggingEventListener((KettleLoggingEventListener)fileAppender);
            }
        }
        Kitchen.exitJVM(result.getExitStatus());
    }

    private static <T extends Throwable> void blockAndThrow(Future<T> future) throws T {
        try {
            Throwable e = (Throwable)future.get();
            if (e != null) {
                throw e;
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public static void configureLogging(CommandLineOption maxLogLinesOption, CommandLineOption maxLogTimeoutOption) throws KettleException {
        int maxLogLines = Kitchen.parseIntArgument(maxLogLinesOption, 0);
        if (Utils.isEmpty((CharSequence)maxLogLinesOption.getArgument())) {
            maxLogLines = Const.toInt((String)EnvUtil.getSystemProperty((String)"KETTLE_MAX_LOG_SIZE_IN_LINES"), (int)5000);
        }
        int maxLogTimeout = Kitchen.parseIntArgument(maxLogTimeoutOption, 0);
        if (Utils.isEmpty((CharSequence)maxLogTimeoutOption.getArgument())) {
            maxLogTimeout = Const.toInt((String)EnvUtil.getSystemProperty((String)"KETTLE_MAX_LOG_TIMEOUT_IN_MINUTES"), (int)1440);
        }
        KettleLogStore.init((int)maxLogLines, (int)maxLogTimeout);
    }

    protected static int parseIntArgument(CommandLineOption option, int def) throws KettleException {
        if (!Utils.isEmpty((CharSequence)option.getArgument())) {
            try {
                return Integer.parseInt(option.getArgument().toString());
            }
            catch (NumberFormatException ex) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"Kitchen.Error.InvalidNumberArgument", (Object[])new Object[]{option.getOption(), option.getArgument()}));
            }
        }
        return def;
    }

    private static final void exitJVM(int status) {
        System.exit(status);
    }

    public static KitchenCommandExecutor getCommandExecutor() {
        return commandExecutor;
    }

    public static void setCommandExecutor(KitchenCommandExecutor commandExecutor) {
        Kitchen.commandExecutor = commandExecutor;
    }
}

