/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entries.ftpsget.ftp4che;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.ftp4che.FTPConnection;
import org.ftp4che.commands.Command;
import org.ftp4che.exception.ConfigurationException;
import org.ftp4che.exception.FtpIOException;
import org.ftp4che.exception.FtpWorkflowException;
import org.ftp4che.impl.SecureFTPConnection;
import org.ftp4che.util.ftpfile.FTPFile;

public class SecureDataFTPConnection
extends SecureFTPConnection {
    public SecureDataFTPConnection(FTPConnection conn, String password, int timeout) throws ConfigurationException {
        this.setConnectionType(conn.getConnectionType());
        this.setAddress(conn.getAddress());
        this.setUser(conn.getUser());
        this.setPassword(password);
        this.setAccount(conn.getAccount());
        this.setPassiveMode(conn.isPassiveMode());
        this.setTryResume(conn.isTryResume());
        this.setProxy(conn.getProxy());
    }

    public List<FTPFile> getDirectoryListing(String directory) throws IOException, FtpWorkflowException, FtpIOException {
        this.setDataProtIfImplicit();
        return super.getDirectoryListing(directory);
    }

    public void uploadFile(FTPFile fromFile, FTPFile toFile) throws IOException, FtpWorkflowException, FtpIOException {
        this.setDataProtIfImplicit();
        super.uploadFile(fromFile, toFile);
    }

    public void uploadStream(InputStream upStream, FTPFile toFile) throws IOException, FtpWorkflowException, FtpIOException {
        this.setDataProtIfImplicit();
        super.uploadStream(upStream, toFile);
    }

    protected void setDataProtIfImplicit() throws IOException {
        int connectionType = this.getConnectionType();
        if (connectionType == 7 || connectionType == 6) {
            this.setConnectionStatusLock(1);
            this.setConnectionStatus(1010);
            Command pbsz = new Command("PBSZ", new String[]{"0"});
            this.sendCommand(pbsz).dumpReply();
            Command prot = new Command("PROT", new String[]{"P"});
            this.sendCommand(prot).dumpReply();
            this.setConnectionStatus(1003);
            this.setConnectionStatusLock(0);
        }
    }
}

