/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.trans.steps.streamlookup;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaFactory;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDialogInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.step.errorhandling.StreamInterface;
import org.pentaho.di.trans.steps.streamlookup.StreamLookupMeta;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.core.widget.ColumnInfo;
import org.pentaho.di.ui.core.widget.TableView;
import org.pentaho.di.ui.trans.step.BaseStepDialog;

public class StreamLookupDialog
extends BaseStepDialog
implements StepDialogInterface {
    private static Class<?> PKG = StreamLookupMeta.class;
    private Label wlStep;
    private CCombo wStep;
    private FormData fdlStep;
    private FormData fdStep;
    private Label wlKey;
    private TableView wKey;
    private FormData fdlKey;
    private FormData fdKey;
    private Label wlReturn;
    private TableView wReturn;
    private FormData fdlReturn;
    private FormData fdReturn;
    private Label wlPreserveMemory;
    private Button wPreserveMemory;
    private FormData fdlPreserveMemory;
    private FormData fdPreserveMemory;
    private Label wlSortedList;
    private Button wSortedList;
    private FormData fdlSortedList;
    private FormData fdSortedList;
    private Label wlIntegerPair;
    private Button wIntegerPair;
    private FormData fdlIntegerPair;
    private FormData fdIntegerPair;
    private StreamLookupMeta input;
    private Button wGetLU;
    private Listener lsGetLU;
    private ColumnInfo[] ciKey;
    private ColumnInfo[] ciReturn;

    public StreamLookupDialog(Shell parent, Object in, TransMeta transMeta, String sname) {
        super(parent, (BaseStepMeta)in, transMeta, sname);
        this.input = (StreamLookupMeta)in;
    }

    public String open() {
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, (StepMetaInterface)this.input);
        ModifyListener lsMod = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                StreamLookupDialog.this.input.setChanged();
            }
        };
        SelectionAdapter lsSelection = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StreamLookupDialog.this.input.setChanged();
                StreamLookupDialog.this.setComboBoxesLookup();
            }
        };
        this.changed = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"StreamLookupDialog.Shell.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = 4;
        this.wlStepname = new Label((Composite)this.shell, 131072);
        this.wlStepname.setText(BaseMessages.getString(PKG, (String)"StreamLookupDialog.Stepname.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlStepname);
        this.fdlStepname = new FormData();
        this.fdlStepname.left = new FormAttachment(0, 0);
        this.fdlStepname.right = new FormAttachment(middle, -margin);
        this.fdlStepname.top = new FormAttachment(0, margin);
        this.wlStepname.setLayoutData((Object)this.fdlStepname);
        this.wStepname = new Text((Composite)this.shell, 18436);
        this.wStepname.setText(this.stepname);
        this.props.setLook((Control)this.wStepname);
        this.wStepname.addModifyListener(lsMod);
        this.fdStepname = new FormData();
        this.fdStepname.left = new FormAttachment(middle, 0);
        this.fdStepname.top = new FormAttachment(0, margin);
        this.fdStepname.right = new FormAttachment(100, 0);
        this.wStepname.setLayoutData((Object)this.fdStepname);
        this.wlStep = new Label((Composite)this.shell, 131072);
        this.wlStep.setText(BaseMessages.getString(PKG, (String)"StreamLookupDialog.LookupStep.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlStep);
        this.fdlStep = new FormData();
        this.fdlStep.left = new FormAttachment(0, 0);
        this.fdlStep.right = new FormAttachment(middle, -margin);
        this.fdlStep.top = new FormAttachment((Control)this.wStepname, margin * 2);
        this.wlStep.setLayoutData((Object)this.fdlStep);
        this.wStep = new CCombo((Composite)this.shell, 18436);
        this.props.setLook((Control)this.wStep);
        List previousSteps = this.transMeta.findPreviousSteps(this.stepMeta, true);
        for (StepMeta previousStep : previousSteps) {
            this.wStep.add(previousStep.getName());
        }
        this.wStep.addModifyListener(lsMod);
        this.wStep.addSelectionListener((SelectionListener)lsSelection);
        this.fdStep = new FormData();
        this.fdStep.left = new FormAttachment(middle, 0);
        this.fdStep.top = new FormAttachment((Control)this.wStepname, margin * 2);
        this.fdStep.right = new FormAttachment(100, 0);
        this.wStep.setLayoutData((Object)this.fdStep);
        this.wlKey = new Label((Composite)this.shell, 0);
        this.wlKey.setText(BaseMessages.getString(PKG, (String)"StreamLookupDialog.Key.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlKey);
        this.fdlKey = new FormData();
        this.fdlKey.left = new FormAttachment(0, 0);
        this.fdlKey.top = new FormAttachment((Control)this.wStep, margin);
        this.wlKey.setLayoutData((Object)this.fdlKey);
        int nrKeyCols = 2;
        int nrKeyRows = this.input.getKeystream() != null ? this.input.getKeystream().length : 1;
        this.ciKey = new ColumnInfo[nrKeyCols];
        this.ciKey[0] = new ColumnInfo(BaseMessages.getString(PKG, (String)"StreamLookupDialog.ColumnInfo.Field", (String[])new String[0]), 2, new String[]{""}, false);
        this.ciKey[1] = new ColumnInfo(BaseMessages.getString(PKG, (String)"StreamLookupDialog.ColumnInfo.LookupField", (String[])new String[0]), 2, new String[]{""}, false);
        this.wKey = new TableView((VariableSpace)this.transMeta, (Composite)this.shell, 68354, this.ciKey, nrKeyRows, lsMod, this.props);
        this.fdKey = new FormData();
        this.fdKey.left = new FormAttachment(0, 0);
        this.fdKey.top = new FormAttachment((Control)this.wlKey, margin);
        this.fdKey.right = new FormAttachment(100, 0);
        this.fdKey.bottom = new FormAttachment((Control)this.wlKey, 180);
        this.wKey.setLayoutData(this.fdKey);
        this.wlReturn = new Label((Composite)this.shell, 0);
        this.wlReturn.setText(BaseMessages.getString(PKG, (String)"StreamLookupDialog.ReturnFields.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlReturn);
        this.fdlReturn = new FormData();
        this.fdlReturn.left = new FormAttachment(0, 0);
        this.fdlReturn.top = new FormAttachment((Control)this.wKey, margin);
        this.wlReturn.setLayoutData((Object)this.fdlReturn);
        int UpInsCols = 4;
        int UpInsRows = this.input.getValue() != null ? this.input.getValue().length : 1;
        this.ciReturn = new ColumnInfo[UpInsCols];
        this.ciReturn[0] = new ColumnInfo(BaseMessages.getString(PKG, (String)"StreamLookupDialog.ColumnInfo.FieldReturn", (String[])new String[0]), 2, new String[]{""}, false);
        this.ciReturn[1] = new ColumnInfo(BaseMessages.getString(PKG, (String)"StreamLookupDialog.ColumnInfo.NewName", (String[])new String[0]), 1, false);
        this.ciReturn[2] = new ColumnInfo(BaseMessages.getString(PKG, (String)"StreamLookupDialog.ColumnInfo.Default", (String[])new String[0]), 1, false);
        this.ciReturn[3] = new ColumnInfo(BaseMessages.getString(PKG, (String)"StreamLookupDialog.ColumnInfo.Type", (String[])new String[0]), 2, ValueMetaFactory.getValueMetaNames());
        this.wReturn = new TableView((VariableSpace)this.transMeta, (Composite)this.shell, 68354, this.ciReturn, UpInsRows, lsMod, this.props);
        this.fdReturn = new FormData();
        this.fdReturn.left = new FormAttachment(0, 0);
        this.fdReturn.top = new FormAttachment((Control)this.wlReturn, margin);
        this.fdReturn.right = new FormAttachment(100, 0);
        this.fdReturn.bottom = new FormAttachment(100, -125);
        this.wReturn.setLayoutData(this.fdReturn);
        this.wlPreserveMemory = new Label((Composite)this.shell, 131072);
        this.wlPreserveMemory.setText(BaseMessages.getString(PKG, (String)"StreamLookupDialog.PreserveMemory.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlPreserveMemory);
        this.fdlPreserveMemory = new FormData();
        this.fdlPreserveMemory.left = new FormAttachment(0, 0);
        this.fdlPreserveMemory.top = new FormAttachment((Control)this.wReturn, margin);
        this.fdlPreserveMemory.right = new FormAttachment(middle, -margin);
        this.wlPreserveMemory.setLayoutData((Object)this.fdlPreserveMemory);
        this.wPreserveMemory = new Button((Composite)this.shell, 32);
        this.props.setLook((Control)this.wPreserveMemory);
        this.fdPreserveMemory = new FormData();
        this.fdPreserveMemory.left = new FormAttachment(middle, 0);
        this.fdPreserveMemory.top = new FormAttachment((Control)this.wReturn, margin);
        this.fdPreserveMemory.right = new FormAttachment(100, 0);
        this.wPreserveMemory.setLayoutData((Object)this.fdPreserveMemory);
        this.wPreserveMemory.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StreamLookupDialog.this.input.setChanged();
            }
        });
        this.wlIntegerPair = new Label((Composite)this.shell, 131072);
        this.wlIntegerPair.setText(BaseMessages.getString(PKG, (String)"StreamLookupDialog.IntegerPair.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlIntegerPair);
        this.fdlIntegerPair = new FormData();
        this.fdlIntegerPair.left = new FormAttachment(0, 0);
        this.fdlIntegerPair.top = new FormAttachment((Control)this.wPreserveMemory, margin);
        this.fdlIntegerPair.right = new FormAttachment(middle, -margin);
        this.wlIntegerPair.setLayoutData((Object)this.fdlIntegerPair);
        this.wIntegerPair = new Button((Composite)this.shell, 16);
        this.wIntegerPair.setEnabled(false);
        this.props.setLook((Control)this.wIntegerPair);
        this.fdIntegerPair = new FormData();
        this.fdIntegerPair.left = new FormAttachment(middle, 0);
        this.fdIntegerPair.top = new FormAttachment((Control)this.wPreserveMemory, margin);
        this.fdIntegerPair.right = new FormAttachment(100, 0);
        this.wIntegerPair.setLayoutData((Object)this.fdIntegerPair);
        this.wIntegerPair.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StreamLookupDialog.this.input.setChanged();
            }
        });
        this.wlSortedList = new Label((Composite)this.shell, 131072);
        this.wlSortedList.setText(BaseMessages.getString(PKG, (String)"StreamLookupDialog.SortedList.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlSortedList);
        this.fdlSortedList = new FormData();
        this.fdlSortedList.left = new FormAttachment(0, 0);
        this.fdlSortedList.top = new FormAttachment((Control)this.wIntegerPair, margin);
        this.fdlSortedList.right = new FormAttachment(middle, -margin);
        this.wlSortedList.setLayoutData((Object)this.fdlSortedList);
        this.wSortedList = new Button((Composite)this.shell, 16);
        this.wSortedList.setEnabled(false);
        this.props.setLook((Control)this.wSortedList);
        this.fdSortedList = new FormData();
        this.fdSortedList.left = new FormAttachment(middle, 0);
        this.fdSortedList.top = new FormAttachment((Control)this.wIntegerPair, margin);
        this.fdSortedList.right = new FormAttachment(100, 0);
        this.wSortedList.setLayoutData((Object)this.fdSortedList);
        this.wSortedList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StreamLookupDialog.this.input.setChanged();
            }
        });
        this.wPreserveMemory.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                boolean selection = StreamLookupDialog.this.wPreserveMemory.getSelection();
                StreamLookupDialog.this.wSortedList.setEnabled(selection);
                StreamLookupDialog.this.wIntegerPair.setEnabled(selection);
            }
        });
        this.wOK = new Button((Composite)this.shell, 8);
        this.wOK.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wGet = new Button((Composite)this.shell, 8);
        this.wGet.setText(BaseMessages.getString(PKG, (String)"StreamLookupDialog.GetFields.Button", (String[])new String[0]));
        this.wGetLU = new Button((Composite)this.shell, 8);
        this.wGetLU.setText(BaseMessages.getString(PKG, (String)"StreamLookupDialog.GetLookupFields.Button", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.setButtonPositions(new Button[]{this.wOK, this.wCancel, this.wGet, this.wGetLU}, margin, null);
        this.lsOK = new Listener(){

            public void handleEvent(Event e) {
                StreamLookupDialog.this.ok();
            }
        };
        this.lsGet = new Listener(){

            public void handleEvent(Event e) {
                StreamLookupDialog.this.get();
            }
        };
        this.lsGetLU = new Listener(){

            public void handleEvent(Event e) {
                StreamLookupDialog.this.getlookup();
            }
        };
        this.lsCancel = new Listener(){

            public void handleEvent(Event e) {
                StreamLookupDialog.this.cancel();
            }
        };
        this.wOK.addListener(13, this.lsOK);
        this.wGet.addListener(13, this.lsGet);
        this.wGetLU.addListener(13, this.lsGetLU);
        this.wCancel.addListener(13, this.lsCancel);
        this.lsDef = new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                StreamLookupDialog.this.ok();
            }
        };
        this.wStepname.addSelectionListener((SelectionListener)this.lsDef);
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                StreamLookupDialog.this.cancel();
            }
        });
        this.setSize();
        this.getData();
        this.setComboBoxes();
        this.setComboBoxesLookup();
        this.input.setChanged(this.changed);
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.stepname;
    }

    protected void setComboBoxes() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                StepMeta stepMeta = StreamLookupDialog.this.transMeta.findStep(StreamLookupDialog.this.stepname);
                if (stepMeta != null) {
                    try {
                        RowMetaInterface row = StreamLookupDialog.this.transMeta.getPrevStepFields(stepMeta);
                        HashMap<String, Integer> prevFields = new HashMap<String, Integer>();
                        for (int i = 0; i < row.size(); ++i) {
                            prevFields.put(row.getValueMeta(i).getName(), i);
                        }
                        HashMap<String, Integer> fields = new HashMap<String, Integer>();
                        fields.putAll(prevFields);
                        Set keySet = fields.keySet();
                        ArrayList entries = new ArrayList(keySet);
                        String[] fieldNames = entries.toArray(new String[entries.size()]);
                        Const.sortStrings((String[])fieldNames);
                        StreamLookupDialog.this.ciKey[0].setComboValues(fieldNames);
                    }
                    catch (KettleException e) {
                        StreamLookupDialog.this.logError(BaseMessages.getString((Class)PKG, (String)"System.Dialog.GetFieldsFailed.Message", (String[])new String[0]));
                    }
                }
            }
        };
        new Thread(runnable).start();
    }

    protected void setComboBoxesLookup() {
        Runnable fieldLoader = new Runnable(){

            @Override
            public void run() {
                StepMeta lookupStepMeta = StreamLookupDialog.this.transMeta.findStep(StreamLookupDialog.this.wStep.getText());
                if (lookupStepMeta != null) {
                    try {
                        RowMetaInterface row = StreamLookupDialog.this.transMeta.getStepFields(lookupStepMeta);
                        HashMap<String, Integer> lookupFields = new HashMap<String, Integer>();
                        for (int i = 0; i < row.size(); ++i) {
                            lookupFields.put(row.getValueMeta(i).getName(), i);
                        }
                        HashMap<String, Integer> fields = new HashMap<String, Integer>();
                        fields.putAll(lookupFields);
                        Set keySet = fields.keySet();
                        ArrayList entries = new ArrayList(keySet);
                        String[] fieldNames = entries.toArray(new String[entries.size()]);
                        Const.sortStrings((String[])fieldNames);
                        StreamLookupDialog.this.ciReturn[0].setComboValues(fieldNames);
                        StreamLookupDialog.this.ciKey[1].setComboValues(fieldNames);
                    }
                    catch (KettleException e) {
                        StreamLookupDialog.this.logError("It was not possible to retrieve the list of fields for step [" + StreamLookupDialog.this.wStep.getText() + "]!");
                    }
                }
            }
        };
        this.shell.getDisplay().asyncExec(fieldLoader);
    }

    public void getData() {
        TableItem item;
        int i;
        if (this.log.isDebug()) {
            this.logDebug(BaseMessages.getString(PKG, (String)"StreamLookupDialog.Log.GettingKeyInfo", (String[])new String[0]));
        }
        if (this.input.getKeystream() != null) {
            for (i = 0; i < this.input.getKeystream().length; ++i) {
                item = this.wKey.table.getItem(i);
                if (this.input.getKeystream()[i] != null) {
                    item.setText(1, this.input.getKeystream()[i]);
                }
                if (this.input.getKeylookup()[i] == null) continue;
                item.setText(2, this.input.getKeylookup()[i]);
            }
        }
        if (this.input.getValue() != null) {
            for (i = 0; i < this.input.getValue().length; ++i) {
                item = this.wReturn.table.getItem(i);
                if (this.input.getValue()[i] != null) {
                    item.setText(1, this.input.getValue()[i]);
                }
                if (this.input.getValueName()[i] != null && !this.input.getValueName()[i].equals(this.input.getValue()[i])) {
                    item.setText(2, this.input.getValueName()[i]);
                }
                if (this.input.getValueDefault()[i] != null) {
                    item.setText(3, this.input.getValueDefault()[i]);
                }
                item.setText(4, ValueMetaFactory.getValueMetaName((int)this.input.getValueDefaultType()[i]));
            }
        }
        StreamInterface infoStream = (StreamInterface)this.input.getStepIOMeta().getInfoStreams().get(0);
        this.wStep.setText(Const.NVL((String)infoStream.getStepname(), (String)""));
        boolean isPreserveMemory = this.input.isMemoryPreservationActive();
        this.wPreserveMemory.setSelection(isPreserveMemory);
        if (isPreserveMemory) {
            this.wSortedList.setEnabled(true);
            this.wIntegerPair.setEnabled(true);
        }
        this.wSortedList.setSelection(this.input.isUsingSortedList());
        this.wIntegerPair.setSelection(this.input.isUsingIntegerPair());
        this.wKey.setRowNums();
        this.wKey.optWidth(true);
        this.wReturn.setRowNums();
        this.wReturn.optWidth(true);
        this.wStepname.selectAll();
        this.wStepname.setFocus();
    }

    private void cancel() {
        this.stepname = null;
        this.input.setChanged(this.changed);
        this.dispose();
    }

    private void ok() {
        TableItem item;
        int i;
        if (Utils.isEmpty((CharSequence)this.wStepname.getText())) {
            return;
        }
        int nrkeys = this.wKey.nrNonEmpty();
        int nrvalues = this.wReturn.nrNonEmpty();
        this.input.allocate(nrkeys, nrvalues);
        this.input.setMemoryPreservationActive(this.wPreserveMemory.getSelection());
        this.input.setUsingSortedList(this.wSortedList.getSelection());
        this.input.setUsingIntegerPair(this.wIntegerPair.getSelection());
        if (this.log.isDebug()) {
            this.logDebug(BaseMessages.getString(PKG, (String)"StreamLookupDialog.Log.FoundKeys", (String[])new String[]{nrkeys + ""}));
        }
        for (i = 0; i < nrkeys; ++i) {
            item = this.wKey.getNonEmpty(i);
            this.input.getKeystream()[i] = item.getText(1);
            this.input.getKeylookup()[i] = item.getText(2);
        }
        if (this.log.isDebug()) {
            this.logDebug(BaseMessages.getString(PKG, (String)"StreamLookupDialog.Log.FoundFields", (String[])new String[]{nrvalues + ""}));
        }
        for (i = 0; i < nrvalues; ++i) {
            item = this.wReturn.getNonEmpty(i);
            this.input.getValue()[i] = item.getText(1);
            this.input.getValueName()[i] = item.getText(2);
            if (this.input.getValueName()[i] == null || this.input.getValueName()[i].length() == 0) {
                this.input.getValueName()[i] = this.input.getValue()[i];
            }
            this.input.getValueDefault()[i] = item.getText(3);
            this.input.getValueDefaultType()[i] = ValueMetaFactory.getIdForValueMeta((String)item.getText(4));
        }
        StreamInterface infoStream = (StreamInterface)this.input.getStepIOMeta().getInfoStreams().get(0);
        infoStream.setStepMeta(this.transMeta.findStep(this.wStep.getText()));
        if (infoStream.getStepMeta() == null) {
            MessageBox mb = new MessageBox(this.shell, 33);
            if (Utils.isEmpty((CharSequence)this.wStep.getText())) {
                mb.setMessage(BaseMessages.getString(PKG, (String)"StreamLookupDialog.NotStepSpecified.DialogMessage", (String[])new String[]{this.wStep.getText()}));
            } else {
                mb.setMessage(BaseMessages.getString(PKG, (String)"StreamLookupDialog.StepCanNotFound.DialogMessage", (String[])new String[]{this.wStep.getText()}));
            }
            mb.setText(BaseMessages.getString(PKG, (String)"StreamLookupDialog.StepCanNotFound.DialogTitle", (String[])new String[0]));
            mb.open();
        }
        this.stepname = this.wStepname.getText();
        this.dispose();
    }

    private void get() {
        if (this.transMeta.findStep(this.wStep.getText()) == null) {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setMessage(BaseMessages.getString(PKG, (String)"StreamLookupDialog.PleaseSelectAStepToReadFrom.DialogMessage", (String[])new String[0]));
            mb.setText(BaseMessages.getString(PKG, (String)"StreamLookupDialog.PleaseSelectAStepToReadFrom.DialogTitle", (String[])new String[0]));
            mb.open();
            return;
        }
        try {
            RowMetaInterface r = this.transMeta.getPrevStepFields(this.stepname);
            if (r != null && !r.isEmpty()) {
                BaseStepDialog.getFieldsFromPrevious(r, this.wKey, 1, new int[]{1, 2}, new int[0], -1, -1, null);
            } else {
                String stepFrom = this.wStep.getText();
                if (!Utils.isEmpty((CharSequence)stepFrom)) {
                    r = this.transMeta.getStepFields(stepFrom);
                    if (r != null) {
                        BaseStepDialog.getFieldsFromPrevious(r, this.wKey, 2, new int[]{1, 2}, new int[0], -1, -1, null);
                    } else {
                        MessageBox mb = new MessageBox(this.shell, 33);
                        mb.setMessage(BaseMessages.getString(PKG, (String)"StreamLookupDialog.CouldNotFindFields.DialogMessage", (String[])new String[0]));
                        mb.setText(BaseMessages.getString(PKG, (String)"StreamLookupDialog.CouldNotFindFields.DialogTitle", (String[])new String[0]));
                        mb.open();
                    }
                } else {
                    MessageBox mb = new MessageBox(this.shell, 33);
                    mb.setMessage(BaseMessages.getString(PKG, (String)"StreamLookupDialog.StepNameRequired.DialogMessage", (String[])new String[0]));
                    mb.setText(BaseMessages.getString(PKG, (String)"StreamLookupDialog.StepNameRequired.DialogTitle", (String[])new String[0]));
                    mb.open();
                }
            }
        }
        catch (KettleException ke) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"StreamLookupDialog.FailedToGetFields.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"StreamLookupDialog.FailedToGetFields.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
        }
    }

    private void getlookup() {
        try {
            String stepFrom = this.wStep.getText();
            if (!Utils.isEmpty((CharSequence)stepFrom)) {
                RowMetaInterface r = this.transMeta.getStepFields(stepFrom);
                if (r != null && !r.isEmpty()) {
                    BaseStepDialog.getFieldsFromPrevious(r, this.wReturn, 1, new int[]{1}, new int[]{4}, -1, -1, null);
                } else {
                    MessageBox mb = new MessageBox(this.shell, 33);
                    mb.setMessage(BaseMessages.getString(PKG, (String)"StreamLookupDialog.CouldNotFindFields.DialogMessage", (String[])new String[0]));
                    mb.setText(BaseMessages.getString(PKG, (String)"StreamLookupDialog.CouldNotFindFields.DialogTitle", (String[])new String[0]));
                    mb.open();
                }
            } else {
                MessageBox mb = new MessageBox(this.shell, 33);
                mb.setMessage(BaseMessages.getString(PKG, (String)"StreamLookupDialog.StepNameRequired.DialogMessage", (String[])new String[0]));
                mb.setText(BaseMessages.getString(PKG, (String)"StreamLookupDialog.StepNameRequired.DialogTitle", (String[])new String[0]));
                mb.open();
            }
        }
        catch (KettleException ke) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"StreamLookupDialog.FailedToGetFields.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"StreamLookupDialog.FailedToGetFields.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
        }
    }
}

