/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.trans.step.common;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.plugins.PluginInterface;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.plugins.StepPluginType;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.TransPreviewFactory;
import org.pentaho.di.trans.step.StepDialogInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.ui.core.FormDataBuilder;
import org.pentaho.di.ui.core.dialog.BaseDialog;
import org.pentaho.di.ui.core.dialog.EnterNumberDialog;
import org.pentaho.di.ui.core.dialog.PreviewRowsDialog;
import org.pentaho.di.ui.core.dialog.SimpleMessageDialog;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.di.ui.trans.dialog.TransPreviewProgressDialog;
import org.pentaho.di.ui.trans.step.BaseStepDialog;
import org.pentaho.di.ui.trans.step.common.CommonStepMeta;

public abstract class CommonStepDialog<StepMetaType extends CommonStepMeta>
extends BaseStepDialog
implements StepDialogInterface {
    protected static final int MARGIN_SIZE = 15;
    protected static final int LABEL_SPACING = 5;
    protected static final int ELEMENT_SPACING = 10;
    protected static final int MEDIUM_FIELD = 250;
    protected static final int MEDIUM_SMALL_FIELD = 150;
    protected static final int SMALL_FIELD = 50;
    protected static final int SHELL_WIDTH_OFFSET = 16;
    protected static final int VAR_ICON_WIDTH = BaseDialog.VAR_ICON_WIDTH;
    protected static final int VAR_ICON_HEIGHT = BaseDialog.VAR_ICON_HEIGHT;
    private static final int SHELL_WIDTH = 610;
    private static Class<?> PKG = StepInterface.class;
    protected final StepMetaType meta;
    protected Label footerSpacer;
    protected Label headerSpacer;
    protected ModifyListener lsMod;
    protected CTabFolder m_wTabFolder;

    public CommonStepDialog(Shell parent, Object meta, TransMeta tr, String sname) {
        super(parent, (StepMetaInterface)meta, tr, sname);
        this.meta = (CommonStepMeta)((Object)meta);
    }

    private void initListeners() {
        this.lsOK = new Listener(){

            public void handleEvent(Event e) {
                CommonStepDialog.this.ok();
            }
        };
        this.lsCancel = new Listener(){

            public void handleEvent(Event e) {
                CommonStepDialog.this.cancel();
            }
        };
        this.lsDef = new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                CommonStepDialog.this.ok();
            }
        };
        this.lsMod = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CommonStepDialog.this.meta.setChanged();
            }
        };
        this.lsPreview = new Listener(){

            public void handleEvent(Event e) {
                CommonStepDialog.this.preview();
            }
        };
        this.initListenersImpl();
    }

    protected void initListenersImpl() {
    }

    private Display prepareLayout() {
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, (StepMetaInterface)this.meta);
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                CommonStepDialog.this.cancel();
            }
        });
        this.changed = this.meta.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 15;
        formLayout.marginHeight = 15;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(this.getTitle());
        return display;
    }

    public String open() {
        Display display = this.prepareLayout();
        this.initListeners();
        this.buildHeader();
        this.buildBody();
        this.buildFooter();
        this.open(display);
        return this.stepname;
    }

    private void open(Display display) {
        this.shell.pack();
        int height = this.shell.computeSize((int)610, (int)-1).y;
        this.shell.setMinimumSize(626, height);
        this.shell.setSize(626, height);
        this.getData(this.meta);
        this.meta.setChanged(this.changed);
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    private void buildHeader() {
        this.buildPreHeader();
        Label wicon = new Label((Composite)this.shell, 131072);
        wicon.setImage(this.getImage());
        wicon.setLayoutData((Object)new FormDataBuilder().top(0, -5).right(100, 0).result());
        this.props.setLook((Control)wicon);
        this.wlStepname = new Label((Composite)this.shell, 131072);
        this.wlStepname.setText(BaseMessages.getString(PKG, (String)"CommonStepDialog.Stepname.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlStepname);
        this.fdlStepname = new FormDataBuilder().left(0, 0).top(0, -5).result();
        this.wlStepname.setLayoutData((Object)this.fdlStepname);
        this.wStepname = new Text((Composite)this.shell, 18436);
        this.wStepname.setText(this.stepname);
        this.props.setLook((Control)this.wStepname);
        this.wStepname.addModifyListener(this.lsMod);
        this.wStepname.addSelectionListener((SelectionListener)this.lsDef);
        this.fdStepname = new FormDataBuilder().width(250).left(0, 0).top((Control)this.wlStepname, 5).result();
        this.wStepname.setLayoutData((Object)this.fdStepname);
        this.headerSpacer = new Label((Composite)this.shell, 258);
        this.props.setLook((Control)this.headerSpacer);
        this.headerSpacer.setLayoutData((Object)new FormDataBuilder().left().right(100, 0).top((Control)this.wStepname, 15).width(580).result());
        this.buildPostHeader();
    }

    protected void buildPreHeader() {
    }

    protected void buildPostHeader() {
    }

    protected abstract void buildBody();

    private void buildFooter() {
        this.buildPreFooter();
        this.buildCancelButton();
        this.buildOkButton();
        this.footerSpacer = new Label((Composite)this.shell, 258);
        this.footerSpacer.setLayoutData((Object)new FormDataBuilder().left().bottom((Control)this.wCancel, -15).right(100, 0).result());
        this.buildPostFooter();
    }

    protected void buildPreFooter() {
    }

    protected void buildPostFooter() {
    }

    protected Button buildPreviewButton() {
        this.wPreview = new Button((Composite)this.shell, 0x1000008);
        this.updatePreviewButtonStatus();
        this.wPreview.setText(BaseMessages.getString(PKG, (String)"System.Button.Preview", (String[])new String[0]));
        this.wPreview.pack();
        this.props.setLook((Control)this.wPreview);
        this.wPreview.setLayoutData((Object)new FormDataBuilder().bottom().left(50, -(this.wPreview.getBounds().width / 2)).result());
        this.wPreview.addListener(13, this.lsPreview);
        return this.wPreview;
    }

    protected Button buildGetFieldsButton(Composite parent, SelectionAdapter listener) {
        this.wGet = new Button(parent, 8);
        this.updateGetFieldsButtonStatus();
        this.wGet.setText(BaseMessages.getString(PKG, (String)"CommonStepDialog.Button.GetFields", (String[])new String[0]));
        this.props.setLook((Control)this.wGet);
        this.wGet.setLayoutData((Object)new FormDataBuilder().right(100, 0).bottom(100, 0).result());
        this.wGet.addSelectionListener((SelectionListener)listener);
        return this.wGet;
    }

    protected Button buildCancelButton() {
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.wCancel.setLayoutData((Object)new FormDataBuilder().bottom().right(100, 0).result());
        this.wCancel.addListener(13, this.lsCancel);
        return this.wCancel;
    }

    protected Button buildOkButton() {
        this.wOK = new Button((Composite)this.shell, 8);
        this.wOK.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wOK.setLayoutData((Object)new FormDataBuilder().bottom().right((Control)this.wCancel, Const.isOSX() ? 0 : -5).result());
        this.wOK.addListener(13, this.lsOK);
        return this.wOK;
    }

    protected boolean fieldsExist() {
        return true;
    }

    private void preview() {
        if (!this.fieldsExist()) {
            this.openNoFieldsDialog();
            return;
        }
        StepMetaType populatedMeta = this.getPopulatedMeta();
        TransMeta previewMeta = TransPreviewFactory.generatePreviewTransformation((VariableSpace)this.transMeta, populatedMeta, (String)this.wStepname.getText());
        EnterNumberDialog numberDialog = new EnterNumberDialog(this.shell, this.props.getDefaultPreviewSize(), BaseMessages.getString(PKG, (String)"CommonStepDialog.PreviewSize.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"CommonStepDialog.PreviewSize.DialogMessage", (String[])new String[0]));
        int previewSize = numberDialog.open();
        if (previewSize > 0) {
            TransPreviewProgressDialog progressDialog = new TransPreviewProgressDialog(this.shell, previewMeta, new String[]{this.wStepname.getText()}, new int[]{previewSize});
            progressDialog.open(false);
            Trans trans = progressDialog.getTrans();
            String loggingText = progressDialog.getLoggingText();
            if (!progressDialog.isCancelled() && trans.getResult() != null && trans.getResult().getNrErrors() > 0L) {
                this.openPreviewError();
                return;
            }
            List<Object[]> previewRows = progressDialog.getPreviewRows(this.wStepname.getText());
            if (previewRows == null || previewRows.size() == 0) {
                this.openNoRowsToPreviewError();
            } else {
                PreviewRowsDialog prd = new PreviewRowsDialog(this.shell, (VariableSpace)this.transMeta, 0, this.wStepname.getText(), progressDialog.getPreviewRowsMeta(this.wStepname.getText()), previewRows, loggingText);
                prd.open();
            }
        }
    }

    protected void updatePreviewButtonStatus() {
    }

    protected void updateGetFieldsButtonStatus() {
    }

    protected void ok() {
        if (StringUtils.isEmpty((String)this.wStepname.getText().trim())) {
            return;
        }
        this.stepname = this.wStepname.getText();
        this.populateMeta(this.meta);
        this.dispose();
    }

    protected void cancel() {
        this.stepname = null;
        this.meta.setChanged(this.changed);
        this.dispose();
    }

    protected Image getImage() {
        PluginInterface plugin = PluginRegistry.getInstance().getPlugin(StepPluginType.class, (Object)this.stepMeta.getStepMetaInterface());
        String id = plugin.getIds()[0];
        if (id != null) {
            return GUIResource.getInstance().getImagesSteps().get(id).getAsBitmapForSize((Device)this.shell.getDisplay(), 48, 48);
        }
        return null;
    }

    protected abstract StepMetaType getPopulatedMeta();

    protected abstract void populateMeta(StepMetaType var1);

    protected abstract String getTitle();

    public abstract void getData(StepMetaType var1);

    protected CTabFolder buildTabFolder() {
        this.m_wTabFolder = new CTabFolder((Composite)this.shell, 2048);
        this.props.setLook((Control)this.m_wTabFolder, 5);
        this.m_wTabFolder.setSimple(false);
        return this.m_wTabFolder;
    }

    protected void layoutTabFolder() {
        this.m_wTabFolder.setSelection(0);
        this.m_wTabFolder.setLayoutData((Object)new FormDataBuilder().left().top((Control)this.headerSpacer, 15).right(100, 0).bottom(new FormAttachment((Control)this.footerSpacer, -15)).result());
    }

    protected void openDialog(String title, String message, int dialogType) {
        SimpleMessageDialog dialog = new SimpleMessageDialog(this.shell, title, message, dialogType);
        dialog.open();
    }

    protected void openPreviewError() {
        this.openDialog(BaseMessages.getString(PKG, (String)"CommonStepDialog.ErrorMessage.PreviewError.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"CommonStepDialog.ErrorMessage.PreviewError.Message", (String[])new String[0]), 1);
    }

    protected void openNoRowsToPreviewError() {
        this.openDialog(BaseMessages.getString(PKG, (String)"CommonStepDialog.WarningMessage.NoPreview.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"CommonStepDialog.WarningMessage.NoPreview.Message", (String[])new String[0]), 4);
    }

    protected void openNoFieldsDialog() {
        this.openDialog(BaseMessages.getString(PKG, (String)"CommonStepDialog.WarningMessage.GetFieldsNoFields.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"CommonStepDialog.WarningMessage.GetFieldsNoFields.Message", (String[])new String[0]), 4);
    }

    protected void openFieldsErrorDialog() {
        this.openDialog(BaseMessages.getString(PKG, (String)"CommonStepDialog.ErrorMessage.GetFieldsError.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"CommonStepDialog.ErrorMessage.GetFieldsError.Message", (String[])new String[0]), 1);
    }
}

