/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.spoon.tree.provider;

import org.pentaho.di.base.AbstractMeta;
import org.pentaho.di.cluster.ClusterSchema;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.di.ui.core.widget.tree.TreeNode;
import org.pentaho.di.ui.spoon.Spoon;
import org.pentaho.di.ui.spoon.tree.TreeFolderProvider;

public class ClustersFolderProvider
extends TreeFolderProvider {
    private static Class<?> PKG = Spoon.class;
    public static final String STRING_CLUSTERS = BaseMessages.getString(PKG, (String)"Spoon.STRING_CLUSTERS", (String[])new String[0]);
    private GUIResource guiResource;

    public ClustersFolderProvider(GUIResource guiResource) {
        this.guiResource = guiResource;
    }

    public ClustersFolderProvider() {
        this(GUIResource.getInstance());
    }

    @Override
    public void refresh(AbstractMeta meta, TreeNode treeNode, String filter) {
        TransMeta transMeta = (TransMeta)meta;
        for (ClusterSchema clusterSchema : transMeta.getClusterSchemas()) {
            if (!this.filterMatch(clusterSchema.getName(), filter)) continue;
            TreeNode childTreeNode = this.createTreeNode(treeNode, clusterSchema.toString(), this.guiResource.getImageClusterMedium());
            if (!clusterSchema.isShared()) continue;
            childTreeNode.setFont(GUIResource.getInstance().getFontBold());
        }
    }

    @Override
    public String getTitle() {
        return STRING_CLUSTERS;
    }

    @Override
    public Class getType() {
        return ClusterSchema.class;
    }
}

