/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.spoon.dialog;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.pentaho.di.core.ProgressMonitorAdapter;
import org.pentaho.di.core.ProgressMonitorListener;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepMeta;

public class SearchFieldsProgressDialog
implements IRunnableWithProgress {
    private static Class<?> PKG = SearchFieldsProgressDialog.class;
    private StepMeta stepInfo;
    private boolean before;
    private TransMeta transMeta;
    private RowMetaInterface fields;

    public SearchFieldsProgressDialog(TransMeta transMeta, StepMeta stepMeta, boolean before) {
        this.transMeta = transMeta;
        this.stepInfo = stepMeta;
        this.before = before;
        this.fields = null;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        int size = this.transMeta.findNrPrevSteps(this.stepInfo);
        try {
            if (this.before) {
                monitor.beginTask(BaseMessages.getString(PKG, (String)"SearchFieldsProgressDialog.Dialog.SearchInputFields.Message", (String[])new String[0]), size);
                this.fields = this.transMeta.getPrevStepFields(this.stepInfo, (ProgressMonitorListener)new ProgressMonitorAdapter(monitor));
            } else {
                monitor.beginTask(BaseMessages.getString(PKG, (String)"SearchFieldsProgressDialog.Dialog.SearchOutputFields.Message", (String[])new String[0]), size);
                this.fields = this.transMeta.getStepFields(this.stepInfo, (ProgressMonitorListener)new ProgressMonitorAdapter(monitor));
            }
        }
        catch (KettleStepException kse) {
            throw new InvocationTargetException(kse, BaseMessages.getString(PKG, (String)"SearchFieldsProgressDialog.Log.UnableToGetFields", (String[])new String[]{this.stepInfo.toString(), kse.getMessage()}));
        }
        monitor.done();
    }

    public boolean isBefore() {
        return this.before;
    }

    public void setBefore(boolean before) {
        this.before = before;
    }

    public RowMetaInterface getFields() {
        return this.fields;
    }

    public void setFields(RowMetaInterface fields) {
        this.fields = fields;
    }

    public StepMeta getStepInfo() {
        return this.stepInfo;
    }

    public void setStepInfo(StepMeta stepInfo) {
        this.stepInfo = stepInfo;
    }

    public TransMeta getTransMeta() {
        return this.transMeta;
    }

    public void setTransMeta(TransMeta transMeta) {
        this.transMeta = transMeta;
    }
}

