/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.job.entries.job;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.vfs2.FileObject;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.ObjectLocationSpecificationMethod;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.extension.ExtensionPointHandler;
import org.pentaho.di.core.extension.KettleExtensionPoint;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.logging.LogLevel;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.JobExecutionConfiguration;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entries.job.JobEntryJob;
import org.pentaho.di.job.entry.JobEntryBase;
import org.pentaho.di.job.entry.JobEntryDialogInterface;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.RepositoryElementMetaInterface;
import org.pentaho.di.repository.RepositoryObject;
import org.pentaho.di.repository.RepositoryObjectType;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.core.gui.WindowProperty;
import org.pentaho.di.ui.core.widget.ComboVar;
import org.pentaho.di.ui.job.dialog.JobDialog;
import org.pentaho.di.ui.job.entries.trans.JobEntryBaseDialog;
import org.pentaho.di.ui.spoon.Spoon;
import org.pentaho.di.ui.trans.step.BaseStepDialog;
import org.pentaho.di.ui.util.DialogHelper;
import org.pentaho.di.ui.util.DialogUtils;
import org.pentaho.di.ui.util.SwtSvgImageUtil;

public class JobEntryJobDialog
extends JobEntryBaseDialog
implements JobEntryDialogInterface {
    private static Class<?> PKG = JobEntryJob.class;
    protected JobEntryJob jobEntry;
    protected Button wPassExport;
    protected Button wExpandRemote;
    private static final String[] FILE_FILTERLOGNAMES = new String[]{BaseMessages.getString(PKG, (String)"JobJob.Fileformat.TXT", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JobJob.Fileformat.LOG", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JobJob.Fileformat.All", (String[])new String[0])};

    public JobEntryJobDialog(Shell parent, JobEntryInterface jobEntryInt, Repository rep, JobMeta jobMeta) {
        super(parent, jobEntryInt, rep, jobMeta);
        this.jobEntry = (JobEntryJob)jobEntryInt;
    }

    public JobEntryInterface open() {
        Shell parent = this.getParent();
        this.display = parent.getDisplay();
        this.shell = new Shell(parent, this.props.getJobsDialogStyle());
        this.props.setLook((Control)this.shell);
        JobDialog.setShellImage(this.shell, (JobEntryInterface)this.jobEntry);
        this.backupChanged = this.jobEntry.hasChanged();
        this.createElements();
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                JobEntryJobDialog.this.cancel();
            }
        });
        this.getData();
        this.setActive();
        BaseStepDialog.setSize(this.shell);
        int width = 750;
        int height = Const.isWindows() ? 730 : 718;
        this.shell.setSize(width, height);
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (this.display.readAndDispatch()) continue;
            this.display.sleep();
        }
        return this.jobEntry;
    }

    @Override
    protected void createElements() {
        super.createElements();
        this.shell.setText(BaseMessages.getString(PKG, (String)"JobJob.Header", (String[])new String[0]));
        this.wlPath.setText(BaseMessages.getString(PKG, (String)"JobJob.JobStep.Job.Label", (String[])new String[0]));
        this.wPassParams.setText(BaseMessages.getString(PKG, (String)"JobJob.PassAllParameters.Label", (String[])new String[0]));
        this.wPassExport = new Button((Composite)this.gExecution, 32);
        this.wPassExport.setText(BaseMessages.getString(PKG, (String)"JobJob.PassExportToSlave.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wPassExport);
        FormData fdPassExport = new FormData();
        fdPassExport.left = new FormAttachment(0, 0);
        fdPassExport.top = new FormAttachment((Control)this.wEveryRow, 10);
        fdPassExport.right = new FormAttachment(100, 0);
        this.wPassExport.setLayoutData((Object)fdPassExport);
        this.wExpandRemote = new Button((Composite)this.gExecution, 32);
        this.wExpandRemote.setText(BaseMessages.getString(PKG, (String)"JobEntryJobDialog.ExpandRemoteOnSlave.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wExpandRemote);
        FormData fdExpandRemote = new FormData();
        fdExpandRemote.top = new FormAttachment((Control)this.wPassExport, 10);
        fdExpandRemote.left = new FormAttachment(0, 0);
        this.wExpandRemote.setLayoutData((Object)fdExpandRemote);
        this.wWaitingToFinish = new Button((Composite)this.gExecution, 32);
        this.props.setLook((Control)this.wWaitingToFinish);
        this.wWaitingToFinish.setText(BaseMessages.getString(PKG, (String)"JobJob.WaitToFinish.Label", (String[])new String[0]));
        FormData fdWait = new FormData();
        fdWait.top = new FormAttachment((Control)this.wExpandRemote, 10);
        fdWait.left = new FormAttachment(0, 0);
        this.wWaitingToFinish.setLayoutData((Object)fdWait);
        this.wFollowingAbortRemotely = new Button((Composite)this.gExecution, 32);
        this.props.setLook((Control)this.wFollowingAbortRemotely);
        this.wFollowingAbortRemotely.setText(BaseMessages.getString(PKG, (String)"JobJob.AbortRemote.Label", (String[])new String[0]));
        FormData fdFollow = new FormData();
        fdFollow.top = new FormAttachment((Control)this.wWaitingToFinish, 10);
        fdFollow.left = new FormAttachment(0, 0);
        this.wFollowingAbortRemotely.setLayoutData((Object)fdFollow);
        Composite cRunConfiguration = new Composite(this.wOptions, 0);
        cRunConfiguration.setLayout((Layout)new FormLayout());
        this.props.setLook((Control)cRunConfiguration);
        FormData fdLocal = new FormData();
        fdLocal.top = new FormAttachment(0);
        fdLocal.right = new FormAttachment(100);
        fdLocal.left = new FormAttachment(0);
        cRunConfiguration.setBackground(this.shell.getBackground());
        cRunConfiguration.setLayoutData((Object)fdLocal);
        Label wlRunConfiguration = new Label(cRunConfiguration, 16384);
        this.props.setLook((Control)wlRunConfiguration);
        wlRunConfiguration.setText("Run configuration:");
        FormData fdlRunConfiguration = new FormData();
        fdlRunConfiguration.top = new FormAttachment(0);
        fdlRunConfiguration.left = new FormAttachment(0);
        wlRunConfiguration.setLayoutData((Object)fdlRunConfiguration);
        this.wRunConfiguration = new ComboVar((VariableSpace)this.jobMeta, cRunConfiguration, 2048);
        this.props.setLook((Control)this.wRunConfiguration);
        FormData fdRunConfiguration = new FormData();
        fdRunConfiguration.width = 200;
        fdRunConfiguration.top = new FormAttachment((Control)wlRunConfiguration, 5);
        fdRunConfiguration.left = new FormAttachment(0);
        this.wRunConfiguration.setLayoutData(fdRunConfiguration);
        this.wRunConfiguration.addModifyListener(new JobEntryBaseDialog.RunConfigurationModifyListener());
        this.fdgExecution.top = new FormAttachment((Control)cRunConfiguration, 10);
        this.wbGetParams.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                JobEntryJobDialog.this.getParameters(null);
            }
        });
        this.wbBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (JobEntryJobDialog.this.rep != null) {
                    JobEntryJobDialog.this.selectJob();
                } else {
                    JobEntryJobDialog.this.pickFileVFS();
                }
            }
        });
        this.wbLogFilename.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JobEntryJobDialog.this.selectLogFile(FILE_FILTERLOGNAMES);
            }
        });
    }

    @Override
    protected JobEntryBase getJobEntry() {
        return this.jobEntry;
    }

    @Override
    protected Image getImage() {
        return SwtSvgImageUtil.getImage(this.shell.getDisplay(), ((Object)((Object)this)).getClass().getClassLoader(), "JOB.svg", 48, 48);
    }

    @Override
    protected boolean getArgFromPrev() {
        return this.jobEntry.argFromPrevious;
    }

    @Override
    protected String[] getArguments() {
        return this.jobEntry.arguments;
    }

    @Override
    protected String[] getParamters() {
        return this.jobEntry.parameters;
    }

    protected void getParameters(JobMeta inputJobMeta) {
        try {
            if (inputJobMeta == null) {
                JobEntryJob jej = new JobEntryJob();
                this.getInfo(jej);
                inputJobMeta = jej.getJobMeta(this.rep, this.metaStore, (VariableSpace)this.jobMeta);
            }
            String[] parameters = inputJobMeta.listParameters();
            String[] existing = this.wParameters.getItems(1);
            for (int i = 0; i < parameters.length; ++i) {
                if (Const.indexOfString((String)parameters[i], (String[])existing) >= 0) continue;
                TableItem item = new TableItem(this.wParameters.table, 0);
                item.setText(1, parameters[i]);
            }
            this.wParameters.removeEmptyRows();
            this.wParameters.setRowNums();
            this.wParameters.optWidth(true);
        }
        catch (Exception e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"JobEntryJobDialog.Exception.UnableToLoadJob.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JobEntryJobDialog.Exception.UnableToLoadJob.Message", (String[])new String[0]), e);
        }
    }

    private void selectJob() {
        RepositoryObject repositoryObject = DialogHelper.selectRepositoryObject("*.kjb", this.log);
        if (repositoryObject != null) {
            String path = DialogUtils.getPath(this.jobMeta.getRepositoryDirectory().getPath(), repositoryObject.getRepositoryDirectory().getPath());
            String fullPath = (path.equals("/") ? "/" : path + "/") + repositoryObject.getName();
            this.wPath.setText(fullPath);
        }
    }

    private void updateByReferenceField(RepositoryElementMetaInterface element) {
        String path = this.getPathOf(element);
        if (path == null) {
            path = "";
        }
        this.wByReference.setText(path);
    }

    protected void pickFileVFS() {
        String fname;
        FileDialog dialog = new FileDialog(this.shell, 4096);
        dialog.setFilterExtensions(Const.STRING_JOB_FILTER_EXT);
        dialog.setFilterNames(Const.getJobFilterNames());
        String prevName = this.jobMeta.environmentSubstitute(this.getPath());
        String parentFolder = null;
        try {
            parentFolder = KettleVFS.getFilename((FileObject)KettleVFS.getFileObject((String)this.jobMeta.environmentSubstitute(this.jobMeta.getFilename())).getParent());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!Utils.isEmpty((CharSequence)prevName)) {
            try {
                if (KettleVFS.fileExists((String)prevName)) {
                    dialog.setFilterPath(KettleVFS.getFilename((FileObject)KettleVFS.getFileObject((String)prevName).getParent()));
                } else {
                    if (!prevName.endsWith(".kjb")) {
                        prevName = this.getEntryName(Const.trim((String)this.getPath()) + ".kjb");
                    }
                    if (KettleVFS.fileExists((String)prevName)) {
                        this.wPath.setText(prevName);
                        this.specificationMethod = ObjectLocationSpecificationMethod.FILENAME;
                        return;
                    }
                    MessageBox mb = new MessageBox(this.shell, 196);
                    mb.setMessage(BaseMessages.getString(PKG, (String)"JobJob.Dialog.CreateJobQuestion.Message", (String[])new String[0]));
                    mb.setText(BaseMessages.getString(PKG, (String)"JobJob.Dialog.CreateJobQuestion.Title", (String[])new String[0]));
                    int answer = mb.open();
                    if (answer == 64) {
                        Spoon spoon = Spoon.getInstance();
                        spoon.newJobFile();
                        JobMeta newJobMeta = spoon.getActiveJob();
                        newJobMeta.initializeVariablesFrom((VariableSpace)this.jobEntry);
                        newJobMeta.setFilename(this.jobMeta.environmentSubstitute(prevName));
                        this.wPath.setText(prevName);
                        this.specificationMethod = ObjectLocationSpecificationMethod.FILENAME;
                        spoon.saveFile();
                        return;
                    }
                }
            }
            catch (Exception e) {
                dialog.setFilterPath(parentFolder);
            }
        } else if (!Utils.isEmpty(parentFolder)) {
            dialog.setFilterPath(parentFolder);
        }
        if ((fname = dialog.open()) != null) {
            File file = new File(fname);
            String name = file.getName();
            String parentFolderSelection = file.getParentFile().toString();
            if (!Utils.isEmpty((CharSequence)parentFolder) && parentFolder.equals(parentFolderSelection)) {
                this.wPath.setText(this.getEntryName(name));
            } else {
                this.wPath.setText(fname);
            }
        }
    }

    String getEntryName(String name) {
        return "${Internal.Entry.Current.Directory}/" + name;
    }

    public void dispose() {
        WindowProperty winprop = new WindowProperty(this.shell);
        this.props.setScreen(winprop);
        this.shell.dispose();
    }

    @Override
    public void setActive() {
        super.setActive();
    }

    public void getData() {
        TableItem ti;
        this.wName.setText(Const.NVL((String)this.jobEntry.getName(), (String)""));
        this.specificationMethod = this.jobEntry.getSpecificationMethod();
        switch (this.specificationMethod) {
            case FILENAME: {
                this.wPath.setText(Const.NVL((String)this.jobEntry.getFilename(), (String)""));
                break;
            }
            case REPOSITORY_BY_NAME: {
                String dirPath = Const.NVL((String)this.jobEntry.getDirectory(), (String)"");
                String transPath = Const.NVL((String)this.jobEntry.getJobName(), (String)"");
                String fullPath = (StringUtils.isBlank((String)dirPath) ? "" : dirPath + "/") + transPath;
                this.wPath.setText(fullPath);
                break;
            }
            case REPOSITORY_BY_REFERENCE: {
                this.referenceObjectId = this.jobEntry.getJobObjectId();
                if (this.rep == null) break;
                this.getByReferenceData(this.referenceObjectId);
                break;
            }
        }
        if (this.jobEntry.arguments != null) {
            for (int i = 0; i < this.jobEntry.arguments.length; ++i) {
                ti = this.wFields.table.getItem(i);
                if (this.jobEntry.arguments[i] == null) continue;
                ti.setText(1, this.jobEntry.arguments[i]);
            }
            this.wFields.setRowNums();
            this.wFields.optWidth(true);
        }
        if (this.jobEntry.parameters != null) {
            for (int i = 0; i < this.jobEntry.parameters.length; ++i) {
                ti = this.wParameters.table.getItem(i);
                if (Utils.isEmpty((CharSequence)this.jobEntry.parameters[i])) continue;
                ti.setText(1, Const.NVL((String)this.jobEntry.parameters[i], (String)""));
                ti.setText(2, Const.NVL((String)this.jobEntry.parameterFieldNames[i], (String)""));
                ti.setText(3, Const.NVL((String)this.jobEntry.parameterValues[i], (String)""));
            }
            this.wParameters.setRowNums();
            this.wParameters.optWidth(true);
        }
        this.wPassParams.setSelection(this.jobEntry.isPassingAllParameters());
        this.wPrevious.setSelection(this.jobEntry.argFromPrevious);
        this.wPrevToParams.setSelection(this.jobEntry.paramsFromPrevious);
        this.wEveryRow.setSelection(this.jobEntry.execPerRow);
        this.wSetLogfile.setSelection(this.jobEntry.setLogfile);
        if (this.jobEntry.logfile != null) {
            this.wLogfile.setText(this.jobEntry.logfile);
        }
        if (this.jobEntry.logext != null) {
            this.wLogext.setText(this.jobEntry.logext);
        }
        this.wAddDate.setSelection(this.jobEntry.addDate);
        this.wAddTime.setSelection(this.jobEntry.addTime);
        this.wPassExport.setSelection(this.jobEntry.isPassingExport());
        if (this.jobEntry.logFileLevel != null) {
            this.wLoglevel.select(this.jobEntry.logFileLevel.getLevel());
        } else {
            this.wLoglevel.select(JobEntryJob.DEFAULT_LOG_LEVEL.getLevel());
        }
        this.wAppendLogfile.setSelection(this.jobEntry.setAppendLogfile);
        this.wCreateParentFolder.setSelection(this.jobEntry.createParentFolder);
        this.wWaitingToFinish.setSelection(this.jobEntry.isWaitingToFinish());
        this.wFollowingAbortRemotely.setSelection(this.jobEntry.isFollowingAbortRemotely());
        this.wExpandRemote.setSelection(this.jobEntry.isExpandingRemoteJob());
        ArrayList runConfigurations = new ArrayList();
        try {
            ExtensionPointHandler.callExtensionPoint((LogChannelInterface)Spoon.getInstance().getLog(), (String)KettleExtensionPoint.SpoonRunConfiguration.id, (Object)new Object[]{runConfigurations, "job"});
        }
        catch (KettleException kettleException) {
            // empty catch block
        }
        this.wRunConfiguration.setItems(runConfigurations.toArray(new String[0]));
        if (Utils.isEmpty((CharSequence)this.jobEntry.getRunConfiguration())) {
            this.wRunConfiguration.select(0);
        } else {
            this.wRunConfiguration.setText(this.jobEntry.getRunConfiguration());
        }
        this.wName.selectAll();
        this.wName.setFocus();
    }

    private void getByReferenceData(ObjectId referenceObjectId) {
        try {
            RepositoryObject jobInf = this.rep.getObjectInformation(referenceObjectId, RepositoryObjectType.JOB);
            String path = DialogUtils.getPath(this.jobMeta.getRepositoryDirectory().getPath(), jobInf.getRepositoryDirectory().getPath());
            String fullPath = Const.NVL((String)path, (String)"") + "/" + Const.NVL((String)jobInf.getName(), (String)"");
            this.wPath.setText(fullPath);
        }
        catch (KettleException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"JobEntryJobDialog.Exception.UnableToReferenceObjectId.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JobEntryJobDialog.Exception.UnableToReferenceObjectId.Message", (String[])new String[0]), (Exception)((Object)e));
        }
    }

    @Override
    protected void cancel() {
        this.jobEntry.setChanged(this.backupChanged);
        this.jobEntry = null;
        this.dispose();
    }

    @VisibleForTesting
    protected void getInfo(JobEntryJob jej) {
        String param;
        String arg;
        int i;
        String jobPath = this.getPath();
        jej.setName(this.getName());
        switch (this.specificationMethod) {
            case FILENAME: {
                jej.setFileName(jobPath);
                jej.setDirectory(null);
                jej.setJobName(null);
                jej.setJobObjectId(null);
                break;
            }
            case REPOSITORY_BY_NAME: {
                String jobName = jobPath = this.getPath();
                String directory = "";
                int index = jobPath.lastIndexOf("/");
                if (index != -1) {
                    jobName = jobPath.substring(index + 1);
                    directory = index == 0 ? "/" : jobPath.substring(0, index);
                }
                jej.setDirectory(directory);
                jej.setJobName(jobName);
                jej.setFileName(null);
                jej.setJobObjectId(null);
                break;
            }
        }
        int nritems = this.wFields.nrNonEmpty();
        int nr = 0;
        for (i = 0; i < nritems; ++i) {
            arg = this.wFields.getNonEmpty(i).getText(1);
            if (arg == null || arg.length() == 0) continue;
            ++nr;
        }
        jej.arguments = new String[nr];
        nr = 0;
        for (i = 0; i < nritems; ++i) {
            arg = this.wFields.getNonEmpty(i).getText(1);
            if (arg == null || arg.length() == 0) continue;
            jej.arguments[nr] = arg;
            ++nr;
        }
        nritems = this.wParameters.nrNonEmpty();
        nr = 0;
        for (i = 0; i < nritems; ++i) {
            param = this.wParameters.getNonEmpty(i).getText(1);
            if (param == null || param.length() == 0) continue;
            ++nr;
        }
        jej.parameters = new String[nr];
        jej.parameterFieldNames = new String[nr];
        jej.parameterValues = new String[nr];
        nr = 0;
        for (i = 0; i < nritems; ++i) {
            param = this.wParameters.getNonEmpty(i).getText(1);
            String fieldName = this.wParameters.getNonEmpty(i).getText(2);
            String value = this.wParameters.getNonEmpty(i).getText(3);
            jej.parameters[nr] = param;
            jej.parameterFieldNames[nr] = !Utils.isEmpty((CharSequence)Const.trim((String)fieldName)) ? fieldName : "";
            jej.parameterValues[nr] = !Utils.isEmpty((CharSequence)Const.trim((String)value)) ? value : "";
            ++nr;
        }
        jej.setPassingAllParameters(this.wPassParams.getSelection());
        jej.setLogfile = this.wSetLogfile.getSelection();
        jej.addDate = this.wAddDate.getSelection();
        jej.addTime = this.wAddTime.getSelection();
        jej.logfile = this.wLogfile.getText();
        jej.logext = this.wLogext.getText();
        jej.logFileLevel = this.wLoglevel.getSelectionIndex() >= 0 ? LogLevel.values()[this.wLoglevel.getSelectionIndex()] : LogLevel.BASIC;
        jej.argFromPrevious = this.wPrevious.getSelection();
        jej.paramsFromPrevious = this.wPrevToParams.getSelection();
        jej.execPerRow = this.wEveryRow.getSelection();
        jej.setPassingExport(this.wPassExport.getSelection());
        jej.setAppendLogfile = this.wAppendLogfile.getSelection();
        jej.setWaitingToFinish(this.wWaitingToFinish.getSelection());
        jej.createParentFolder = this.wCreateParentFolder.getSelection();
        jej.setFollowingAbortRemotely(this.wFollowingAbortRemotely.getSelection());
        jej.setExpandingRemoteJob(this.wExpandRemote.getSelection());
        jej.setRunConfiguration(this.wRunConfiguration.getText());
        JobExecutionConfiguration executionConfiguration = new JobExecutionConfiguration();
        executionConfiguration.setRunConfiguration(jej.getRunConfiguration());
        try {
            ExtensionPointHandler.callExtensionPoint((LogChannelInterface)this.jobEntry.getLogChannel(), (String)KettleExtensionPoint.SpoonTransBeforeStart.id, (Object)new Object[]{executionConfiguration, this.jobMeta, this.jobMeta, null});
        }
        catch (KettleException kettleException) {
            // empty catch block
        }
        try {
            ExtensionPointHandler.callExtensionPoint((LogChannelInterface)this.jobEntry.getLogChannel(), (String)KettleExtensionPoint.JobEntryTransSave.id, (Object)new Object[]{this.jobMeta, jej.getRunConfiguration()});
        }
        catch (KettleException kettleException) {
            // empty catch block
        }
        if (executionConfiguration.getRemoteServer() != null) {
            jej.setRemoteSlaveServerName(executionConfiguration.getRemoteServer().getName());
        }
    }

    @Override
    public void ok() {
        if (Utils.isEmpty((CharSequence)this.getName())) {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setText(BaseMessages.getString(PKG, (String)"System.StepJobEntryNameMissing.Title", (String[])new String[0]));
            mb.setMessage(BaseMessages.getString(PKG, (String)"System.JobEntryNameMissing.Msg", (String[])new String[0]));
            mb.open();
            return;
        }
        this.getSpecificationPath(this.jobEntry);
        this.getInfo(this.jobEntry);
        this.jobEntry.setChanged();
        this.dispose();
    }

    @VisibleForTesting
    protected String getName() {
        return this.wName.getText();
    }

    @VisibleForTesting
    protected String getPath() {
        return this.wPath.getText();
    }

    @VisibleForTesting
    protected void getSpecificationPath(JobEntryJob jej) {
        String jobPath = this.getPath();
        this.specificationMethod = this.rep == null || jobPath.startsWith("file://") || jobPath.startsWith("zip:file://") || jobPath.startsWith("hdfs://") ? ObjectLocationSpecificationMethod.FILENAME : ObjectLocationSpecificationMethod.REPOSITORY_BY_NAME;
        jej.setSpecificationMethod(this.specificationMethod);
    }
}

