/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.core.widget;

import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;

public class TreeUtil {
    public static final void setOptimalWidthOnColumns(Tree tree) {
        TreeColumn treeColumn;
        int i;
        int nrCols = tree.getColumnCount();
        int[] max = new int[nrCols];
        Image image = new Image((Device)tree.getDisplay(), 10, 10);
        GC gc = new GC((Drawable)image);
        for (i = 0; i < max.length; ++i) {
            treeColumn = tree.getColumn(i);
            Point point = gc.textExtent(treeColumn.getText());
            max[i] = point.x;
        }
        TreeUtil.getMaxWidths(tree.getItems(), max, gc);
        gc.dispose();
        image.dispose();
        for (i = 0; i < max.length; ++i) {
            treeColumn = tree.getColumn(i);
            treeColumn.setWidth(max[i] + 30);
        }
    }

    private static final void getMaxWidths(TreeItem[] items, int[] max, GC gc) {
        for (int i = 0; i < items.length; ++i) {
            for (int c = 0; c < max.length; ++c) {
                String string = items[i].getText(c);
                Point point = gc.textExtent(string);
                if (point.x <= max[c]) continue;
                max[c] = point.x;
            }
            TreeUtil.getMaxWidths(items[i].getItems(), max, gc);
        }
    }

    public static final TreeItem findTreeItem(Tree tree, String[] path) {
        TreeItem[] items = tree.getItems();
        for (int i = 0; i < items.length; ++i) {
            TreeItem treeItem = TreeUtil.findTreeItem(items[i], path, 0);
            if (treeItem == null) continue;
            return treeItem;
        }
        return null;
    }

    private static final TreeItem findTreeItem(TreeItem treeItem, String[] path, int level) {
        if (treeItem.getText().equals(path[level])) {
            if (level == path.length - 1) {
                return treeItem;
            }
            TreeItem[] items = treeItem.getItems();
            for (int i = 0; i < items.length; ++i) {
                TreeItem found = TreeUtil.findTreeItem(items[i], path, level + 1);
                if (found == null) continue;
                return found;
            }
        }
        return null;
    }
}

