/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.core.widget;

import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.ui.core.FormDataBuilder;
import org.pentaho.di.ui.core.PropsUI;
import org.pentaho.di.ui.core.WidgetUtils;
import org.pentaho.di.ui.core.widget.ComboVar;
import org.pentaho.di.ui.core.widget.TextVar;
import org.pentaho.di.ui.util.SwtSvgImageUtil;

public class TopicSelection
extends Composite {
    private final PropsUI props;
    private final TransMeta transMeta;
    private final BaseStepMeta stepMeta;
    private final ModifyListener lsMod;
    private final boolean topicInField;
    private final String topicGroupLabel;
    private final String fieldTopicLabel;
    private final String fieldTopicErrorToolTip;
    private final String textTopicLabel;
    private final String textTopicRadioLabel;
    private final String fieldTopicRadioLabel;
    private final boolean displayTopicErrorIcon;
    private Group wTopicGroup;
    private Button wTopicFromField;
    private Button wTopicFromText;
    private Label wlTopic;
    private Label wlConnectionError;
    private boolean isTopicTextCombo;
    private TextVar wTopicText;
    private ComboVar wTopicTextCombo;
    private ComboVar wTopicField;

    private TopicSelection(Builder builder) {
        super(builder.composite, builder.style);
        this.props = builder.props;
        this.transMeta = builder.transMeta;
        this.stepMeta = builder.stepMeta;
        this.lsMod = builder.lsMod;
        this.topicInField = builder.topicInField;
        this.topicGroupLabel = builder.topicGroupLabel;
        this.fieldTopicLabel = builder.fieldTopicLabel;
        this.fieldTopicErrorToolTip = builder.fieldTopicErrorToolTip;
        this.textTopicLabel = builder.textTopicLabel;
        this.textTopicRadioLabel = builder.textTopicRadioLabel;
        this.fieldTopicRadioLabel = builder.fieldTopicRadioLabel;
        this.isTopicTextCombo = builder.isTopicTextCombo;
        this.displayTopicErrorIcon = builder.displayTopicErrorIcon;
        this.layoutUI();
    }

    private void layoutUI() {
        FormLayout topicSelectionLayout = new FormLayout();
        this.setLayout((Layout)topicSelectionLayout);
        this.wTopicGroup = new Group((Composite)this, 16);
        this.props.setLook((Control)this.wTopicGroup);
        this.wTopicGroup.setText(this.topicGroupLabel);
        FormLayout topicGroupLayout = new FormLayout();
        topicGroupLayout.marginHeight = 15;
        topicGroupLayout.marginWidth = 15;
        this.wTopicGroup.setLayout((Layout)topicGroupLayout);
        this.wTopicGroup.setLayoutData((Object)new FormDataBuilder().top(0, 10).fullWidth().bottom().result());
        this.wTopicFromText = new Button((Composite)this.wTopicGroup, 16);
        this.wTopicFromField = new Button((Composite)this.wTopicGroup, 16);
        this.props.setLook((Control)this.wTopicFromText);
        this.props.setLook((Control)this.wTopicFromField);
        SelectionAdapter selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                super.widgetSelected(selectionEvent);
                TopicSelection.this.setTopicWidgetVisibility(TopicSelection.this.wTopicFromField);
            }
        };
        this.wTopicFromField.addSelectionListener((SelectionListener)selectionListener);
        this.wTopicFromText.addSelectionListener((SelectionListener)selectionListener);
        this.wTopicFromField.setSelection(this.topicInField);
        this.wTopicFromText.setSelection(!this.topicInField);
        this.wTopicFromText.setText(this.textTopicRadioLabel);
        this.wTopicFromField.setText(this.fieldTopicRadioLabel);
        this.wTopicFromText.setLayoutData((Object)new FormDataBuilder().left().top().result());
        this.wTopicFromField.setLayoutData((Object)new FormDataBuilder().left().top((Control)this.wTopicFromText).result());
        this.wTopicFromField.addSelectionListener((SelectionListener)selectionListener);
        this.wTopicFromText.addSelectionListener((SelectionListener)selectionListener);
        Label separator = new Label((Composite)this.wTopicGroup, 514);
        separator.setLayoutData((Object)new FormDataBuilder().top().left((Control)this.wTopicFromField, 15).bottom().result());
        this.wlTopic = new Label((Composite)this.wTopicGroup, 16384);
        this.props.setLook((Control)this.wlTopic);
        if (this.displayTopicErrorIcon) {
            this.wlTopic.setLayoutData((Object)new FormDataBuilder().top().left((Control)separator, 15).result());
            this.wlConnectionError = new Label((Composite)this.wTopicGroup, 16384);
            this.wlConnectionError.setToolTipText(this.fieldTopicErrorToolTip);
            this.wlConnectionError.setImage(SwtSvgImageUtil.getImage(this.getDisplay(), ((Object)((Object)this)).getClass().getClassLoader(), "error.svg", 16, 16));
            this.props.setLook((Control)this.wlConnectionError);
            this.wlConnectionError.setLayoutData((Object)new FormDataBuilder().top().left((Control)this.wlTopic, 4).result());
            this.wlConnectionError.setVisible(false);
        } else {
            this.wlTopic.setLayoutData((Object)new FormDataBuilder().top().left((Control)separator, 15).right().result());
        }
        FormData fdTopic = new FormDataBuilder().top((Control)this.wlTopic).left((Control)separator, 15).right().result();
        this.wTopicTextCombo = new ComboVar((VariableSpace)this.transMeta, (Composite)this.wTopicGroup, 18436);
        this.props.setLook((Control)this.wTopicTextCombo);
        this.wTopicTextCombo.setLayoutData(fdTopic);
        this.wTopicTextCombo.addModifyListener(this.lsMod);
        this.wTopicText = new TextVar((VariableSpace)this.transMeta, (Composite)this.wTopicGroup, 18436);
        this.props.setLook((Control)this.wTopicText);
        this.wTopicText.setLayoutData(fdTopic);
        this.wTopicText.addModifyListener(this.lsMod);
        this.wTopicField = WidgetUtils.createFieldDropDown((Composite)this.wTopicGroup, this.props, this.stepMeta, fdTopic);
        this.props.setLook((Control)this.wTopicField);
        this.wTopicField.setLayoutData(fdTopic);
        this.setTopicWidgetVisibility(this.wTopicFromField);
        this.wTopicField.addModifyListener(this.lsMod);
    }

    private void setTopicWidgetVisibility(Button topicComesFromField) {
        this.stepMeta.setChanged(this.stepMeta.hasChanged() || this.topicInField != topicComesFromField.getSelection());
        this.wTopicField.setVisible(topicComesFromField.getSelection());
        if (topicComesFromField.getSelection()) {
            this.wlTopic.setText(this.fieldTopicLabel);
            this.wTopicTextCombo.setVisible(false);
            this.wTopicText.setVisible(false);
            if (this.displayTopicErrorIcon) {
                this.wlConnectionError.setVisible(false);
            }
        } else {
            this.wlTopic.setText(this.textTopicLabel);
            this.toggleTopicTextComboVisible(this.isTopicTextCombo);
        }
    }

    public void setIsTopicTextCombo(boolean isCombo) {
        this.isTopicTextCombo = isCombo;
    }

    public void toggleTopicTextComboVisible(boolean isComboVisible) {
        if (!this.wTopicFromField.getSelection()) {
            if (this.displayTopicErrorIcon) {
                this.wlConnectionError.setVisible(!isComboVisible);
            }
            this.wTopicTextCombo.setVisible(isComboVisible);
            this.wTopicText.setVisible(!isComboVisible);
        }
    }

    public String getTopicText() {
        return this.isTopicTextCombo ? this.wTopicTextCombo.getText() : this.wTopicText.getText();
    }

    public String getTopicFieldText() {
        return this.wTopicField.getText();
    }

    public void setTopicFieldText(String selectedTopicFieldText) {
        this.wTopicField.setText(selectedTopicFieldText);
    }

    public void setTopicText(String topicText) {
        this.wTopicTextCombo.setText(topicText);
        this.wTopicText.setText(topicText);
    }

    public void setTopicInField(boolean topicInField) {
        this.wTopicFromField.setSelection(topicInField);
        this.wTopicFromText.setSelection(!topicInField);
        this.setTopicWidgetVisibility(this.wTopicFromField);
    }

    public boolean isTopicInField() {
        return this.wTopicFromField.getSelection();
    }

    public void setEnabled(boolean enabled) {
        this.wTopicGroup.setEnabled(enabled);
        this.wTopicFromField.setEnabled(enabled);
        this.wTopicFromText.setEnabled(enabled);
        this.wlTopic.setEnabled(enabled);
        if (this.isTopicTextCombo) {
            this.wTopicTextCombo.setEnabled(enabled);
            this.wTopicTextCombo.setEditable(enabled);
        } else {
            this.wTopicText.setEnabled(enabled);
            this.wTopicText.setEditable(enabled);
        }
        this.wTopicField.setEnabled(enabled);
        this.wTopicField.setEditable(enabled);
    }

    public ComboVar getTopicTextCombo() {
        return this.wTopicTextCombo;
    }

    public TextVar getTopicTextComponent() {
        return this.wTopicText;
    }

    public static final class Builder {
        private Composite composite;
        private int style;
        private PropsUI props;
        private TransMeta transMeta;
        private BaseStepMeta stepMeta;
        private ModifyListener lsMod;
        private boolean topicInField;
        private String topicGroupLabel;
        private String fieldTopicLabel;
        private String fieldTopicErrorToolTip;
        private String textTopicLabel;
        private String textTopicRadioLabel;
        private String fieldTopicRadioLabel;
        private boolean isTopicTextCombo;
        private boolean displayTopicErrorIcon = false;

        public Builder setComposite(Composite composite) {
            this.composite = composite;
            return this;
        }

        public Builder setStyle(int style) {
            this.style = style;
            return this;
        }

        public Builder setProps(PropsUI props) {
            this.props = props;
            return this;
        }

        public Builder setTransMeta(TransMeta transMeta) {
            this.transMeta = transMeta;
            return this;
        }

        public Builder setStepMeta(BaseStepMeta stepMeta) {
            this.stepMeta = stepMeta;
            return this;
        }

        public Builder setLsMod(ModifyListener lsMod) {
            this.lsMod = lsMod;
            return this;
        }

        public Builder setTopicInField(boolean topicInField) {
            this.topicInField = topicInField;
            return this;
        }

        public Builder setTopicGroupLabel(String topicGroupLabel) {
            this.topicGroupLabel = topicGroupLabel;
            return this;
        }

        public Builder setFieldTopicLabel(String fieldTopicLabel) {
            this.fieldTopicLabel = fieldTopicLabel;
            return this;
        }

        public Builder setTextTopicLabel(String textTopicLabel) {
            this.textTopicLabel = textTopicLabel;
            return this;
        }

        public Builder setFieldTopicErrorToolTip(String fieldTopicErrorToolTip) {
            this.fieldTopicErrorToolTip = fieldTopicErrorToolTip;
            return this;
        }

        public Builder isDisplayTopicErrorIcon(boolean displayTopicErrorIcon) {
            this.displayTopicErrorIcon = displayTopicErrorIcon;
            return this;
        }

        public Builder setTextTopicRadioLabel(String textTopicRadioLabel) {
            this.textTopicRadioLabel = textTopicRadioLabel;
            return this;
        }

        public Builder setFieldTopicRadioLabel(String fieldTopicRadioLabel) {
            this.fieldTopicRadioLabel = fieldTopicRadioLabel;
            return this;
        }

        public Builder isFieldTextCombo(boolean isCombo) {
            this.isTopicTextCombo = isCombo;
            return this;
        }

        public TopicSelection build() {
            return new TopicSelection(this);
        }
    }
}

