/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.core.widget;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.pentaho.di.ui.core.FormDataBuilder;
import org.pentaho.di.ui.core.PropsUI;

public class LabeledControl {
    private final int controlWidth;
    private Label label;
    private final Control control;
    private boolean visible = true;
    private static final int SPACING = 15;

    private LabeledControl(Composite parentComp, String labelText, Control control, int controlWidth, PropsUI props) {
        this.label = new Label(parentComp, 131072);
        this.label.setText(labelText);
        this.controlWidth = controlWidth;
        this.control = control;
        props.setLook((Control)this.label);
        props.setLook(control);
    }

    public static LabeledControl labeledControl(Composite parentComp, String labelText, Control control, int controlWidth, PropsUI props) {
        return new LabeledControl(parentComp, labelText, control, controlWidth, props);
    }

    private Control control() {
        return this.control;
    }

    public void attachBelow(Control control) {
        this.attachBelow(control, 0);
    }

    public void attachBelow(Control control, int left) {
        int leftPos;
        int n = leftPos = left > 0 ? left : 4;
        if (control == null) {
            this.label.setLayoutData((Object)new FormDataBuilder().left(0, leftPos).top(0, 4).result());
        } else {
            this.label.setLayoutData((Object)new FormDataBuilder().left(0, leftPos).top(control, 15).result());
        }
        this.control.setLayoutData((Object)new FormDataBuilder().left(0, leftPos).top((Control)this.label, 5).width(this.controlWidth).result());
    }

    public static class Series {
        private final List<LabeledControl> labeledControlSequence;
        private final Control prevControl;
        private final Map<Control, LabeledControl> lookup;
        private final Composite parent;

        public Series(Composite parent, Control prevControl, List<String> labelTexts, List<Control> controls, List<Integer> controlWidths, PropsUI props) {
            Preconditions.checkState((labelTexts.size() == controls.size() && labelTexts.size() == controlWidths.size() ? 1 : 0) != 0);
            this.prevControl = prevControl;
            this.parent = parent;
            this.labeledControlSequence = IntStream.range(0, labelTexts.size()).mapToObj(i -> new LabeledControl(parent, (String)labelTexts.get(i), (Control)controls.get(i), (Integer)controlWidths.get(i), props)).collect(Collectors.toList());
            this.lookup = this.labeledControlSequence.stream().collect(Collectors.toMap(rec$ -> ((LabeledControl)rec$).control(), lc -> lc));
            this.layout();
        }

        public void hideAll() {
            this.labeledControlSequence.forEach(this::hideLabeledControl);
        }

        public void hide(Control control) {
            this.hideLabeledControl(this.lookup.get(control));
        }

        public void show(Control control) {
            this.showLabeledControl(this.lookup.get(control));
        }

        public void layout() {
            Control next = this.prevControl;
            for (LabeledControl labeledControl : this.labeledControlSequence) {
                if (!labeledControl.visible) continue;
                labeledControl.attachBelow(next);
                next = labeledControl.control;
            }
            this.parent.layout();
        }

        public void layout(int height, int width, int numcols) {
            int labeledControlHeight = 25;
            int colwidth = width / numcols;
            int numrows = height / 25;
            LabeledControl[][] grid = this.getLayoutGrid(numcols, colwidth, numrows);
            ArrayList<LabeledControl> addedControls = new ArrayList<LabeledControl>();
            for (int column = 0; column < numcols; ++column) {
                for (int row = 0; row < numrows; ++row) {
                    LabeledControl curcontrol = grid[row][column];
                    if (curcontrol == null || addedControls.contains(curcontrol)) continue;
                    addedControls.add(curcontrol);
                    Control above = row == 0 ? null : grid[row - 1][column].control;
                    curcontrol.attachBelow(above, column * colwidth);
                }
            }
            this.parent.layout();
        }

        private LabeledControl[][] getLayoutGrid(int numcols, int colwidth, int numrows) {
            LabeledControl[][] grid = new LabeledControl[numrows][numcols];
            int curcolumn = 0;
            int currow = 0;
            for (LabeledControl lc : this.labeledControlSequence) {
                if (!lc.visible) continue;
                int numberOfColumnsWide = Math.floorDiv(lc.controlWidth, colwidth) + 1;
                int lastColumnForControl = Math.min(curcolumn + numberOfColumnsWide, numcols);
                for (int i = curcolumn; i < lastColumnForControl; ++i) {
                    while (currow < numrows && grid[currow][i] != null) {
                        ++currow;
                    }
                    if (currow >= numrows) {
                        throw new IllegalStateException(String.format("Control [%s] does not fit in column %s", lc.label.getText(), i));
                    }
                    grid[currow][i] = lc;
                }
                if (++currow < numrows) continue;
                ++curcolumn;
                currow = 0;
            }
            return grid;
        }

        public boolean containsControl(Control control) {
            return this.lookup.containsKey(control);
        }

        private void showLabeledControl(LabeledControl lc) {
            lc.control.setVisible(true);
            lc.label.setVisible(true);
            lc.visible = true;
        }

        private void hideLabeledControl(LabeledControl lc) {
            lc.control.setVisible(false);
            lc.label.setVisible(false);
            lc.visible = false;
        }
    }
}

