/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.core.dialog;

import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;

public class ThinDialog
extends Dialog {
    protected Shell parent;
    protected int width;
    protected int height;
    protected Browser browser;
    protected Shell dialog;
    protected Display display;

    public ThinDialog(Shell shell, int width, int height) {
        super(shell);
        this.width = width;
        this.height = height;
    }

    public void createDialog(String title, String url, int options, Image logo) {
        Shell parent = this.getParent();
        this.display = parent.getDisplay();
        this.dialog = new Shell(parent, options);
        this.dialog.setText(title);
        this.dialog.setImage(logo);
        this.dialog.setSize(this.width, this.height);
        this.dialog.setLayout((Layout)new FillLayout());
        this.dialog.addListener(31, new Listener(){

            public void handleEvent(Event e) {
                if (e.detail == 2) {
                    e.doit = false;
                }
            }
        });
        try {
            this.browser = new Browser((Composite)this.dialog, 0);
            this.browser.setUrl(url);
            this.browser.addCloseWindowListener(event -> {
                Browser browser = (Browser)event.widget;
                Shell shell = browser.getShell();
                shell.close();
            });
        }
        catch (Exception e) {
            MessageBox messageBox = new MessageBox(this.dialog, 33);
            messageBox.setMessage("Browser cannot be initialized.");
            messageBox.setText("Exit");
            messageBox.open();
        }
        this.setPosition();
        this.dialog.open();
    }

    protected void setPosition() {
        Rectangle shellBounds = this.getParent().getBounds();
        Point dialogSize = this.dialog.getSize();
        this.dialog.setLocation(shellBounds.x + (shellBounds.width - dialogSize.x) / 2, shellBounds.y + (shellBounds.height - dialogSize.y) / 2);
    }
}

