/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.core.dialog;

import java.util.List;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.SQLStatement;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.core.logging.LoggingObjectType;
import org.pentaho.di.core.logging.SimpleLoggingObject;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.ui.core.PropsUI;
import org.pentaho.di.ui.core.dialog.EnterTextDialog;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.di.ui.core.gui.WindowProperty;
import org.pentaho.di.ui.core.widget.ColumnInfo;
import org.pentaho.di.ui.core.widget.TableView;
import org.pentaho.di.ui.trans.step.BaseStepDialog;

public class SQLStatementsDialog
extends Dialog {
    private static Class<?> PKG = SQLStatementsDialog.class;
    public static final LoggingObjectInterface loggingObject = new SimpleLoggingObject("SQL Statements Dialog", LoggingObjectType.SPOON, null);
    private List<SQLStatement> stats;
    private TableView wFields;
    private FormData fdFields;
    private Button wClose;
    private Button wView;
    private Button wEdit;
    private Button wExec;
    private FormData fdClose;
    private FormData fdView;
    private FormData fdEdit;
    private FormData fdExec;
    private Listener lsClose;
    private Listener lsView;
    private Listener lsEdit;
    private Listener lsExec;
    private Shell shell;
    private PropsUI props;
    private Color red;
    private String stepname;
    private VariableSpace variables;

    public SQLStatementsDialog(Shell parent, VariableSpace space, int style, List<SQLStatement> stats) {
        super(parent, style);
        this.stats = stats;
        this.props = PropsUI.getInstance();
        this.variables = space;
        this.stepname = null;
    }

    public String open() {
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.red = display.getSystemColor(3);
        this.shell = new Shell(parent, 3184);
        this.props.setLook((Control)this.shell);
        this.shell.setImage(GUIResource.getInstance().getImageConnection());
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"SQLStatementDialog.Title", (String[])new String[0]));
        int margin = 4;
        int FieldsCols = 4;
        int FieldsRows = this.stats.size();
        ColumnInfo[] colinf = new ColumnInfo[FieldsCols];
        colinf[0] = new ColumnInfo(BaseMessages.getString(PKG, (String)"SQLStatementDialog.TableCol.Stepname", (String[])new String[0]), 1, false, true);
        colinf[1] = new ColumnInfo(BaseMessages.getString(PKG, (String)"SQLStatementDialog.TableCol.Connection", (String[])new String[0]), 1, false, true);
        colinf[2] = new ColumnInfo(BaseMessages.getString(PKG, (String)"SQLStatementDialog.TableCol.SQL", (String[])new String[0]), 1, false, true);
        colinf[3] = new ColumnInfo(BaseMessages.getString(PKG, (String)"SQLStatementDialog.TableCol.Error", (String[])new String[0]), 1, false, true);
        this.wFields = new TableView(this.variables, (Composite)this.shell, 67586, colinf, FieldsRows, true, null, this.props);
        this.fdFields = new FormData();
        this.fdFields.left = new FormAttachment(0, 0);
        this.fdFields.top = new FormAttachment(0, 0);
        this.fdFields.right = new FormAttachment(100, 0);
        this.fdFields.bottom = new FormAttachment(100, -50);
        this.wFields.setLayoutData(this.fdFields);
        this.wClose = new Button((Composite)this.shell, 8);
        this.wClose.setText(BaseMessages.getString(PKG, (String)"System.Button.Close", (String[])new String[0]));
        this.fdClose = new FormData();
        this.fdClose.left = new FormAttachment(25, 0);
        this.fdClose.bottom = new FormAttachment(100, 0);
        this.wClose.setLayoutData((Object)this.fdClose);
        this.wView = new Button((Composite)this.shell, 8);
        this.wView.setText(BaseMessages.getString(PKG, (String)"SQLStatementDialog.Button.ViewSQL", (String[])new String[0]));
        this.fdView = new FormData();
        this.fdView.left = new FormAttachment((Control)this.wClose, margin);
        this.fdView.bottom = new FormAttachment(100, 0);
        this.wView.setLayoutData((Object)this.fdView);
        this.wExec = new Button((Composite)this.shell, 8);
        this.wExec.setText(BaseMessages.getString(PKG, (String)"SQLStatementDialog.Button.ExecSQL", (String[])new String[0]));
        this.fdExec = new FormData();
        this.fdExec.left = new FormAttachment((Control)this.wView, margin);
        this.fdExec.bottom = new FormAttachment(100, 0);
        this.wExec.setLayoutData((Object)this.fdExec);
        this.wEdit = new Button((Composite)this.shell, 8);
        this.wEdit.setText(BaseMessages.getString(PKG, (String)"SQLStatementDialog.Button.EditStep", (String[])new String[0]));
        this.fdEdit = new FormData();
        this.fdEdit.left = new FormAttachment((Control)this.wExec, margin);
        this.fdEdit.bottom = new FormAttachment(100, 0);
        this.wEdit.setLayoutData((Object)this.fdEdit);
        this.lsClose = new Listener(){

            public void handleEvent(Event e) {
                SQLStatementsDialog.this.close();
            }
        };
        this.lsView = new Listener(){

            public void handleEvent(Event e) {
                SQLStatementsDialog.this.view();
            }
        };
        this.lsExec = new Listener(){

            public void handleEvent(Event e) {
                SQLStatementsDialog.this.exec();
            }
        };
        this.lsEdit = new Listener(){

            public void handleEvent(Event e) {
                SQLStatementsDialog.this.edit();
            }
        };
        this.wClose.addListener(13, this.lsClose);
        this.wView.addListener(13, this.lsView);
        this.wExec.addListener(13, this.lsExec);
        this.wEdit.addListener(13, this.lsEdit);
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                SQLStatementsDialog.this.close();
            }
        });
        this.getData();
        BaseStepDialog.setSize(this.shell);
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.stepname;
    }

    public void dispose() {
        this.props.setScreen(new WindowProperty(this.shell));
        this.shell.dispose();
    }

    public void getData() {
        for (int i = 0; i < this.stats.size(); ++i) {
            SQLStatement stat = this.stats.get(i);
            TableItem ti = this.wFields.table.getItem(i);
            String name = stat.getStepname();
            DatabaseMeta dbinfo = stat.getDatabase();
            String sql = stat.getSQL();
            String error = stat.getError();
            if (name != null) {
                ti.setText(1, name);
            }
            if (dbinfo != null) {
                ti.setText(2, dbinfo.getName());
            }
            if (sql != null) {
                ti.setText(3, sql);
            }
            if (error != null) {
                ti.setText(4, error);
            }
            Color col = ti.getBackground();
            if (stat.hasError()) {
                col = this.red;
            }
            ti.setBackground(col);
        }
        this.wFields.setRowNums();
        this.wFields.optWidth(true);
    }

    private String getSQL() {
        int i;
        StringBuilder sql = new StringBuilder();
        int[] idx = this.wFields.table.getSelectionIndices();
        if (idx.length == 0) {
            idx = new int[this.stats.size()];
            for (i = 0; i < this.stats.size(); ++i) {
                idx[i] = i;
            }
        }
        for (i = 0; i < idx.length; ++i) {
            SQLStatement stat = this.stats.get(idx[i]);
            DatabaseMeta di = stat.getDatabase();
            if (i > 0) {
                sql.append("-------------------------------------------------------------------------------------------").append(Const.CR);
            }
            sql.append(BaseMessages.getString(PKG, (String)"SQLStatementDialog.Log.Step", (String[])new String[]{stat.getStepname()}));
            sql.append(BaseMessages.getString(PKG, (String)"SQLStatementDialog.Log.Connection", (String[])new String[]{di != null ? di.getName() : BaseMessages.getString(PKG, (String)"SQLStatementDialog.Log.Undefined", (String[])new String[0])}));
            if (stat.hasSQL()) {
                sql.append("-- SQL                  : ");
                sql.append(stat.getSQL()).append(Const.CR);
            }
            if (!stat.hasError()) continue;
            sql.append(BaseMessages.getString(PKG, (String)"SQLStatementDialog.Log.Error", (String[])new String[]{stat.getError()}));
        }
        return sql.toString();
    }

    private void view() {
        String sql = this.getSQL();
        EnterTextDialog etd = new EnterTextDialog(this.shell, BaseMessages.getString(PKG, (String)"SQLStatementDialog.ViewSQL.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SQLStatementDialog.ViewSQL.Message", (String[])new String[0]), sql, true);
        etd.setReadOnly();
        etd.open();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exec() {
        SQLStatement stat;
        int i;
        int[] idx = this.wFields.table.getSelectionIndices();
        if (idx.length == 0) {
            idx = new int[this.stats.size()];
            for (int i2 = 0; i2 < this.stats.size(); ++i2) {
                idx[i2] = i2;
            }
        }
        int errors = 0;
        for (i = 0; i < idx.length; ++i) {
            stat = this.stats.get(idx[i]);
            if (!stat.hasError()) continue;
            ++errors;
        }
        if (errors == 0) {
            for (i = 0; i < idx.length; ++i) {
                stat = this.stats.get(idx[i]);
                DatabaseMeta di = stat.getDatabase();
                if (di == null || stat.hasError()) continue;
                Database db = new Database(loggingObject, di);
                try {
                    db.connect();
                    try {
                        db.execStatements(stat.getSQL());
                    }
                    catch (KettleDatabaseException dbe) {
                        ++errors;
                        new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"SQLStatementDialog.Error.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SQLStatementDialog.Error.CouldNotExec", (String[])new String[]{stat.getSQL()}), (Exception)((Object)dbe));
                    }
                    continue;
                }
                catch (KettleDatabaseException dbe) {
                    new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"SQLStatementDialog.Error.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SQLStatementDialog.Error.CouldNotConnect", (String[])new String[]{di == null ? "" : di.getName()}), (Exception)((Object)dbe));
                    continue;
                }
                finally {
                    db.disconnect();
                }
            }
            if (errors == 0) {
                MessageBox mb = new MessageBox(this.shell, 34);
                mb.setMessage(BaseMessages.getString(PKG, (String)"SQLStatementDialog.Success.Message", (String[])new String[]{Integer.toString(idx.length)}));
                mb.setText(BaseMessages.getString(PKG, (String)"SQLStatementDialog.Success.Title", (String[])new String[0]));
                mb.open();
            }
        } else {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setMessage(BaseMessages.getString(PKG, (String)"SQLStatementDialog.Error.Message", (String[])new String[]{Integer.toString(errors)}));
            mb.setText(BaseMessages.getString(PKG, (String)"SQLStatementDialog.Error.Title", (String[])new String[0]));
            mb.open();
        }
    }

    private void edit() {
        int idx = this.wFields.table.getSelectionIndex();
        if (idx >= 0) {
            this.stepname = this.wFields.table.getItem(idx).getText(1);
            this.dispose();
        } else {
            this.stepname = null;
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setText(BaseMessages.getString(PKG, (String)"StepFieldsDialog.OriginStep.Title", (String[])new String[0]));
            mb.setMessage(BaseMessages.getString(PKG, (String)"StepFieldsDialog.OriginStep.Message", (String[])new String[0]));
            mb.open();
        }
    }

    private void close() {
        this.dispose();
    }
}

