/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.core.dialog;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.ui.core.PropsUI;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.di.ui.core.widget.ColumnInfo;
import org.pentaho.di.ui.core.widget.TableView;
import org.pentaho.di.ui.trans.step.BaseStepDialog;

public class PropertiesDialog
extends Dialog {
    private static final Class<?> PKG = PropertiesDialog.class;
    private Shell parent;
    private Shell shell;
    private TableView propertiesTable;
    private Button wCancel;
    private Button wOK;
    private TransMeta transMeta;
    private Map<String, String> properties;
    private String title;

    public PropertiesDialog(Shell shell, TransMeta transMeta, Map<String, String> properties, String title) {
        super(shell, 0);
        this.title = title;
        this.parent = shell;
        this.transMeta = transMeta;
        this.properties = properties;
    }

    public Map<String, String> open() {
        PropsUI props = PropsUI.getInstance();
        Display display = this.parent.getDisplay();
        this.shell = new Shell(this.parent, 2160);
        props.setLook((Control)this.shell);
        this.shell.setImage(GUIResource.getInstance().getImageSpoon());
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(this.title);
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        FormData fdCancel = new FormData();
        fdCancel.right = new FormAttachment(100, 0);
        fdCancel.bottom = new FormAttachment(100, 0);
        this.wCancel.setLayoutData((Object)fdCancel);
        this.wCancel.addListener(13, e -> this.close());
        this.wOK = new Button((Composite)this.shell, 8);
        this.wOK.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        FormData fdOk = new FormData();
        fdOk.right = new FormAttachment((Control)this.wCancel, -5);
        fdOk.bottom = new FormAttachment(100, 0);
        this.wOK.setLayoutData((Object)fdOk);
        this.wOK.addListener(13, e -> this.ok());
        ColumnInfo[] columns = new ColumnInfo[]{new ColumnInfo("name", 1), new ColumnInfo("value", 1)};
        this.propertiesTable = new TableView((VariableSpace)this.transMeta, (Composite)this.shell, 67586, columns, 10, false, null, props, false);
        this.propertiesTable.setSortable(false);
        this.propertiesTable.getTable().addListener(11, event -> {
            Table table = (Table)event.widget;
            table.getColumn(1).setWidth(220);
            table.getColumn(2).setWidth(220);
        });
        this.populateData();
        FormData fdData = new FormData();
        fdData.left = new FormAttachment(0, 0);
        fdData.top = new FormAttachment(0, 0);
        fdData.right = new FormAttachment(100, 0);
        fdData.bottom = new FormAttachment((Control)this.wOK, 0);
        this.propertiesTable.setLayoutData(fdData);
        BaseStepDialog.setSize(this.shell);
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.properties;
    }

    private void populateData() {
        if (null == this.properties) {
            return;
        }
        int rowIndex = 0;
        for (Map.Entry<String, String> entry : this.properties.entrySet()) {
            TableItem tableItem = this.propertiesTable.getTable().getItem(rowIndex++);
            tableItem.setText(1, entry.getKey());
            tableItem.setText(2, entry.getValue());
        }
    }

    private Map<String, String> retrieveProperties() {
        HashMap<String, String> enteredProperties = new HashMap<String, String>();
        for (TableItem row : this.propertiesTable.getTable().getItems()) {
            String config = row.getText(1);
            String value = row.getText(2);
            if (StringUtils.isBlank((String)config) || enteredProperties.containsKey(config)) continue;
            enteredProperties.put(config, value);
        }
        return enteredProperties;
    }

    private void close() {
        this.properties = null;
        this.dispose();
    }

    private void ok() {
        this.properties = this.retrieveProperties();
        this.dispose();
    }

    public void dispose() {
        this.shell.dispose();
    }
}

