/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.core;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaBase;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.ui.core.FormDataBuilder;
import org.pentaho.di.ui.core.PropsUI;
import org.pentaho.di.ui.core.widget.ComboVar;

public abstract class WidgetUtils {
    private WidgetUtils() {
    }

    public static void setFormLayout(Composite composite, int margin) {
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = margin;
        formLayout.marginHeight = margin;
        composite.setLayout((Layout)formLayout);
    }

    public static ComboVar createFieldDropDown(Composite parentComposite, PropsUI props, BaseStepMeta stepMeta, FormData formData) {
        TransMeta transMeta = stepMeta.getParentStepMeta().getParentTransMeta();
        ComboVar fieldDropDownCombo = new ComboVar((VariableSpace)transMeta, parentComposite, 18436);
        props.setLook((Control)fieldDropDownCombo);
        fieldDropDownCombo.addModifyListener(e -> stepMeta.setChanged());
        fieldDropDownCombo.setLayoutData(formData);
        Listener focusListener = e -> {
            String current = fieldDropDownCombo.getText();
            fieldDropDownCombo.getCComboWidget().removeAll();
            fieldDropDownCombo.setText(current);
            try {
                RowMetaInterface rmi = transMeta.getPrevStepFields(stepMeta.getParentStepMeta().getName());
                List ls = rmi.getValueMetaList();
                for (Object l : ls) {
                    ValueMetaBase vmb = (ValueMetaBase)l;
                    fieldDropDownCombo.add(vmb.getName());
                }
            }
            catch (KettleStepException ex) {
                stepMeta.logDebug(ex.getMessage(), new Object[]{ex});
            }
        };
        fieldDropDownCombo.getCComboWidget().addListener(15, focusListener);
        return fieldDropDownCombo;
    }

    public static FormData formDataBelow(Control anchorControl, int width, int pixelsBetweenAnchor) {
        FormData fdMessageField = new FormData();
        fdMessageField.left = new FormAttachment(0, 0);
        fdMessageField.top = new FormAttachment(anchorControl, pixelsBetweenAnchor);
        fdMessageField.right = new FormAttachment(0, width);
        return fdMessageField;
    }

    public static CTabFolder createTabFolder(Composite composite, FormData fd, String ... titles) {
        Composite container = new Composite(composite, 0);
        WidgetUtils.setFormLayout(container, 0);
        container.setLayoutData((Object)fd);
        CTabFolder tabFolder = new CTabFolder(container, 0);
        tabFolder.setLayoutData((Object)new FormDataBuilder().fullSize().result());
        for (String title : titles) {
            if (title.length() < 8) {
                title = StringUtils.rightPad((String)title, (int)8);
            }
            Composite tab = new Composite((Composite)tabFolder, 0);
            WidgetUtils.setFormLayout(tab, 10);
            CTabItem tabItem = new CTabItem(tabFolder, 0);
            tabItem.setText(title);
            tabItem.setControl((Control)tab);
        }
        tabFolder.setSelection(0);
        return tabFolder;
    }

    public static FormData firstColumn(Control top) {
        return new FormDataBuilder().top(top, 10).percentWidth(47).result();
    }

    public static FormData secondColumn(Control top) {
        return new FormDataBuilder().top(top, 10).right().left(53, 0).result();
    }
}

