/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metaverse.api.analyzer.kettle.step;

import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import org.apache.commons.collections4.CollectionUtils;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.steps.rowsfromresult.RowsFromResultMeta;
import org.pentaho.di.trans.steps.rowstoresult.RowsToResultMeta;
import org.pentaho.metaverse.api.IComponentDescriptor;
import org.pentaho.metaverse.api.IMetaverseNode;
import org.pentaho.metaverse.api.MetaverseComponentDescriptor;
import org.pentaho.metaverse.api.analyzer.kettle.step.StepAnalyzer;
import org.pentaho.metaverse.api.messages.Messages;
import org.pentaho.metaverse.api.model.BaseMetaverseBuilder;
import org.slf4j.Logger;

public class SubtransAnalyzer<T extends BaseStepMeta> {
    private StepAnalyzer<T> stepAnalyzer;
    private Logger log;

    public SubtransAnalyzer(StepAnalyzer<T> stepAnalyzer, Logger log) {
        this.stepAnalyzer = stepAnalyzer;
        this.log = log;
    }

    public void linkUsedFieldToSubTrans(IMetaverseNode originalFieldNode, TransMeta subTransMeta, IMetaverseNode subTransNode, IComponentDescriptor descriptor) {
        this.linkUsedFieldToSubTrans(originalFieldNode, subTransMeta, subTransNode, descriptor, fieldName -> originalFieldNode.getName().equals(fieldName));
    }

    public void linkUsedFieldToSubTrans(IMetaverseNode originalFieldNode, TransMeta subTransMeta, IMetaverseNode subTransNode, IComponentDescriptor descriptor, Predicate<String> fieldPredicate) {
        List steps = subTransMeta.getSteps();
        if (!CollectionUtils.isEmpty((Collection)steps)) {
            for (StepMeta step : steps) {
                MetaverseComponentDescriptor stepDescriptor;
                IMetaverseNode subTransStepNode;
                RowsFromResultMeta rfrm;
                if (!(step.getStepMetaInterface() instanceof RowsFromResultMeta) || !this.linkUsedFieldToStepField(originalFieldNode, subTransMeta, descriptor, fieldPredicate, step, rfrm = (RowsFromResultMeta)step.getStepMetaInterface(), subTransStepNode = this.stepAnalyzer.createNodeFromDescriptor(stepDescriptor = new MetaverseComponentDescriptor("_none_", "Transformation Step", subTransNode, descriptor.getContext())))) continue;
                return;
            }
        }
    }

    private boolean linkUsedFieldToStepField(IMetaverseNode originalFieldNode, TransMeta subTransMeta, IComponentDescriptor descriptor, Predicate<String> fieldPredicate, StepMeta step, RowsFromResultMeta rfrm, IMetaverseNode subTransStepNode) {
        try {
            RowMetaInterface rowMetaInterface = rfrm.getParentStepMeta().getParentTransMeta().getStepFields(step);
            for (int i = 0; i < rowMetaInterface.getFieldNames().length; ++i) {
                String field = rowMetaInterface.getFieldNames()[i];
                if (!fieldPredicate.test(field)) continue;
                MetaverseComponentDescriptor stepFieldDescriptor = new MetaverseComponentDescriptor(field, "Transformation Stream field", subTransStepNode, descriptor.getContext());
                IMetaverseNode subTransField = this.stepAnalyzer.createFieldNode((IComponentDescriptor)stepFieldDescriptor, rowMetaInterface.getValueMeta(i), step.getName(), false);
                this.stepAnalyzer.getMetaverseBuilder().addLink(originalFieldNode, "derives", subTransField);
                return true;
            }
        }
        catch (KettleStepException e) {
            this.log.warn(Messages.getString("WARN.SubtransAnalyzer.RowsFromResultNotFound", subTransMeta.getName()), (Throwable)e);
        }
        return false;
    }

    public void linkResultFieldToSubTrans(IMetaverseNode streamFieldNode, TransMeta subTransMeta, IMetaverseNode subTransNode, IComponentDescriptor descriptor) {
        this.linkResultFieldToSubTrans(streamFieldNode, subTransMeta, subTransNode, descriptor, null);
    }

    public void linkResultFieldToSubTrans(IMetaverseNode streamFieldNode, TransMeta subTransMeta, IMetaverseNode subTransNode, IComponentDescriptor descriptor, String resultStepName) {
        List steps = subTransMeta.getSteps();
        if (!CollectionUtils.isEmpty((Collection)steps)) {
            for (StepMeta step : steps) {
                if ((null == resultStepName || !step.getName().equals(resultStepName)) && (null != resultStepName || !(step.getStepMetaInterface() instanceof RowsToResultMeta))) continue;
                BaseStepMeta baseStepMeta = (BaseStepMeta)step.getStepMetaInterface();
                MetaverseComponentDescriptor stepDescriptor = new MetaverseComponentDescriptor(step.getName(), "Transformation Step", subTransNode, descriptor.getContext());
                IMetaverseNode subTransStepNode = this.stepAnalyzer.createNodeFromDescriptor(stepDescriptor);
                this.linkResultFieldToStepField(streamFieldNode, subTransMeta, descriptor, resultStepName, step, baseStepMeta, subTransStepNode);
            }
        }
    }

    private void linkResultFieldToStepField(IMetaverseNode streamFieldNode, TransMeta subTransMeta, IComponentDescriptor descriptor, String resultStepName, StepMeta step, BaseStepMeta baseStepMeta, IMetaverseNode subTransStepNode) {
        try {
            RowMetaInterface rowMetaInterface = baseStepMeta.getParentStepMeta().getParentTransMeta().getStepFields(step);
            for (int i = 0; i < rowMetaInterface.getFieldNames().length; ++i) {
                String field = rowMetaInterface.getFieldNames()[i];
                if (!streamFieldNode.getName().equals(field)) continue;
                MetaverseComponentDescriptor stepFieldDescriptor = new MetaverseComponentDescriptor(field, "Transformation Stream field", subTransStepNode, descriptor.getContext());
                ValueMetaInterface fieldValueMeta = rowMetaInterface.getValueMeta(i);
                IMetaverseNode subTransField = this.getNodeForField(subTransMeta, resultStepName, step, fieldValueMeta, stepFieldDescriptor);
                this.stepAnalyzer.getMetaverseBuilder().addLink(subTransField, "derives", streamFieldNode);
            }
        }
        catch (KettleStepException e) {
            this.log.warn(Messages.getString("WARN.SubtransAnalyzer.StepNotFound", resultStepName, subTransMeta.getName()), (Throwable)e);
        }
    }

    private IMetaverseNode getNodeForField(TransMeta subTransMeta, String resultStepName, StepMeta step, ValueMetaInterface fieldValueMeta, IComponentDescriptor stepFieldDescriptor) {
        IMetaverseNode subTransField = null;
        List nextSteps = subTransMeta.findNextSteps(step);
        for (StepMeta nextStep : nextSteps) {
            subTransField = this.stepAnalyzer.createFieldNode(stepFieldDescriptor, fieldValueMeta, nextStep.getName(), false);
            if (null != ((BaseMetaverseBuilder)this.stepAnalyzer.getMetaverseBuilder()).getVertexForNode(subTransField)) break;
            subTransField = null;
        }
        if (null == subTransField) {
            if (!nextSteps.isEmpty()) {
                this.log.warn(Messages.getString("WARN.SubtransAnalyzer.FieldNotFound", resultStepName, subTransMeta.getName()));
            }
            subTransField = this.stepAnalyzer.createFieldNode(stepFieldDescriptor, fieldValueMeta, "_none_", false);
        }
        return subTransField;
    }
}

