/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metaverse.api.analyzer.kettle.annotations;

import com.google.common.base.Strings;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Stream;
import org.pentaho.di.core.injection.InjectionDeep;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.metaverse.api.analyzer.kettle.annotations.AnnotatedClassField;
import org.pentaho.metaverse.api.analyzer.kettle.annotations.Metaverse;

public class AnnotatedClassFields {
    private final BaseStepMeta meta;

    public AnnotatedClassFields(BaseStepMeta meta) {
        this.meta = meta;
    }

    Stream<AnnotatedClassField<Metaverse.Node>> nodes() {
        return this.recurseObjectTree(this.meta, Metaverse.Node.class);
    }

    Optional<AnnotatedClassField<Metaverse.Node>> node(String nodeName) {
        return this.nodes().filter(n -> ((Metaverse.Node)n.annotation).name().equals(nodeName)).findFirst();
    }

    Stream<AnnotatedClassField<Metaverse.NodeLink>> links() {
        return this.recurseObjectTree(this.meta, Metaverse.NodeLink.class);
    }

    Stream<AnnotatedClassField<Metaverse.Property>> props() {
        return this.recurseObjectTree(this.meta, Metaverse.Property.class);
    }

    private <T extends Annotation> Stream<AnnotatedClassField<T>> recurseObjectTree(Object object, Class<T> anno) {
        return Stream.concat(Arrays.stream(object.getClass().getFields()), Arrays.stream(object.getClass().getMethods())).flatMap(field -> this.getAnnotatedFieldStream(object, anno, (AccessibleObject)field));
    }

    public boolean hasMetaverseAnnotations() {
        return this.props().count() > 0L || this.nodes().count() > 0L || this.links().count() > 0L;
    }

    private <T extends Annotation> Stream<? extends AnnotatedClassField<T>> getAnnotatedFieldStream(Object object, Class<T> annotation, AccessibleObject accessibleObject) {
        if (accessibleObject.isAnnotationPresent(InjectionDeep.class)) {
            try {
                return this.recurseObjectTree(this.accessibleValue(object, accessibleObject), annotation);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new IllegalStateException(e);
            }
        }
        if (accessibleObject.isAnnotationPresent(annotation)) {
            return Stream.of(new AnnotatedClassField<T>(accessibleObject.getAnnotation(annotation), this.getName(object, accessibleObject, annotation), this.getValue(object, accessibleObject)));
        }
        return Stream.empty();
    }

    private boolean isProperty(AccessibleObject accessibleObject) {
        return accessibleObject.isAnnotationPresent(Metaverse.Property.class);
    }

    private boolean isNode(AccessibleObject accessibleObject) {
        return accessibleObject.isAnnotationPresent(Metaverse.Node.class);
    }

    private String getValue(Object object, AccessibleObject field) {
        try {
            Object accessibleValue = this.accessibleValue(object, field);
            String value = accessibleValue.toString();
            return this.meta.getParentStepMeta().getParentTransMeta().environmentSubstitute(value);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
    }

    private Object accessibleValue(Object object, AccessibleObject accessibleObject) throws IllegalAccessException, InvocationTargetException {
        return accessibleObject instanceof Field ? ((Field)accessibleObject).get(object) : ((Method)accessibleObject).invoke(object, new Object[0]);
    }

    private String getName(Object object, AccessibleObject accessibleObject, Class<? extends Annotation> annotation) {
        if (this.isNode(accessibleObject) && annotation == Metaverse.Node.class) {
            if (((Metaverse.Node)accessibleObject.getAnnotation(annotation)).nameFromValue().equals("TRUE")) {
                return this.getNodeName(accessibleObject, object);
            }
            return ((Metaverse.Node)accessibleObject.getAnnotation(annotation)).name();
        }
        return this.deriveName(object, accessibleObject);
    }

    private String getNodeName(AccessibleObject accessibleObject, Object object) {
        String metaFieldValue = this.getValue(object, accessibleObject);
        if (Strings.isNullOrEmpty((String)metaFieldValue)) {
            metaFieldValue = this.deriveName(object, accessibleObject);
        }
        return metaFieldValue;
    }

    private String deriveName(Object object, AccessibleObject field) {
        String annotatedName = null;
        if (this.isProperty(field)) {
            annotatedName = field.getAnnotation(Metaverse.Property.class).name();
        }
        if (Strings.isNullOrEmpty(annotatedName)) {
            annotatedName = this.getValue(object, field);
        }
        if (Strings.isNullOrEmpty(annotatedName)) {
            String name = field instanceof Field ? ((Field)field).getName() : ((Method)field).getName();
            annotatedName = name.toLowerCase();
        }
        return annotatedName;
    }
}

