/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.osgi.blueprint.collection.utils;

import com.google.common.annotations.VisibleForTesting;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;

public class ServiceMap<T> {
    private final Map<String, MapItem<T>> map = new HashMap<String, MapItem<T>>();
    public static final String SERVICE_KEY_PROPERTY = "serviceMapKey";

    public T getItem(String key) {
        return this.map.get(key) != null ? (T)this.map.get(key).getItem() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void itemAdded(T item, Map config) {
        if (item == null) {
            return;
        }
        String key = this.getKeyFromConfig(config);
        Map<String, MapItem<T>> map = this.map;
        synchronized (map) {
            this.map.put(key, new MapItem<T>(key, item));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void itemRemoved(T item, Map config) {
        Map<String, MapItem<T>> map = this.map;
        synchronized (map) {
            try {
                this.map.remove(this.getKeyFromConfig(config));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    @VisibleForTesting
    String getToString(String key, T item) {
        return new MapItem<T>(key, item).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, T> getMap() {
        Map<String, MapItem<T>> map = this.map;
        synchronized (map) {
            Map<String, Object> m = this.map.values().stream().collect(Collectors.toMap(MapItem::getKey, MapItem::getItem));
            return Collections.unmodifiableMap(m);
        }
    }

    private String getKeyFromConfig(Map config) {
        String key = null;
        if (config != null && (key = (String)config.get(SERVICE_KEY_PROPERTY)) != null) {
            return key;
        }
        throw new IllegalArgumentException("serviceMapKey is null or undefined");
    }

    public class MapItem<T> {
        final String key;
        final T item;

        MapItem(String key, T item) {
            this.key = key;
            this.item = item;
        }

        String getKey() {
            return this.key;
        }

        T getItem() {
            return this.item;
        }

        public String toString() {
            return "(" + this.key + ") " + this.item;
        }
    }
}

